/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.ide.repositories;

import com.jetbrains.plugin.structure.ide.IntelliJPlatformProduct;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import com.jetbrains.pluginverifier.ide.AvailableIde;
import com.jetbrains.pluginverifier.ide.repositories.AndroidStudioFeedConnector;
import com.jetbrains.pluginverifier.ide.repositories.FeedEntry;
import com.jetbrains.pluginverifier.ide.repositories.IdeRepository;
import com.jetbrains.pluginverifier.repository.cache.MemoizerKt;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/pluginverifier/ide/repositories/AndroidStudioIdeRepository;", "Lcom/jetbrains/pluginverifier/ide/repositories/IdeRepository;", "feedUrl", "", "(Ljava/lang/String;)V", "feedConnector", "Lcom/jetbrains/pluginverifier/ide/repositories/AndroidStudioFeedConnector;", "getFeedConnector", "()Lcom/jetbrains/pluginverifier/ide/repositories/AndroidStudioFeedConnector;", "feedConnector$delegate", "Lkotlin/Lazy;", "indexCache", "Ljava/util/function/Supplier;", "", "Lcom/jetbrains/pluginverifier/ide/AvailableIde;", "fetchIndex", "getApproximateUploadDate", "Ljava/time/LocalDate;", "ideVersion", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "updateIndex", "verifier-repository"})
@SourceDebugExtension(value={"SMAP\nAndroidStudioIdeRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidStudioIdeRepository.kt\ncom/jetbrains/pluginverifier/ide/repositories/AndroidStudioIdeRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n774#2:96\n865#2,2:97\n1557#2:99\n1628#2,3:100\n*S KotlinDebug\n*F\n+ 1 AndroidStudioIdeRepository.kt\ncom/jetbrains/pluginverifier/ide/repositories/AndroidStudioIdeRepository\n*L\n33#1:96\n33#1:97,2\n34#1:99\n34#1:100,3\n*E\n"})
public final class AndroidStudioIdeRepository
implements IdeRepository {
    @NotNull
    private final String feedUrl;
    @NotNull
    private final Lazy feedConnector$delegate;
    @NotNull
    private final Supplier<List<AvailableIde>> indexCache;

    public AndroidStudioIdeRepository(@NotNull String feedUrl) {
        Intrinsics.checkNotNullParameter(feedUrl, "feedUrl");
        this.feedUrl = feedUrl;
        this.feedConnector$delegate = LazyKt.lazy((Function0)new Function0<AndroidStudioFeedConnector>(this){
            final /* synthetic */ AndroidStudioIdeRepository this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final AndroidStudioFeedConnector invoke() {
                return new AndroidStudioFeedConnector(AndroidStudioIdeRepository.access$getFeedUrl$p(this.this$0));
            }
        });
        this.indexCache = MemoizerKt.memoize$default(0L, new Function0<List<? extends AvailableIde>>(this){
            final /* synthetic */ AndroidStudioIdeRepository this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<AvailableIde> invoke() {
                return AndroidStudioIdeRepository.access$updateIndex(this.this$0);
            }
        }, 1, null);
    }

    public /* synthetic */ AndroidStudioIdeRepository(String string, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 1) != 0) {
            string = "https://download.jetbrains.com/toolbox/feeds";
        }
        this(string);
    }

    private final AndroidStudioFeedConnector getFeedConnector() {
        Lazy lazy = this.feedConnector$delegate;
        return (AndroidStudioFeedConnector)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final List<AvailableIde> updateIndex() {
        void $this$mapTo$iv$iv;
        FeedEntry it;
        Iterable $this$filterTo$iv$iv;
        List<FeedEntry> feedEntries = this.getFeedConnector().getFeed();
        Iterable $this$filter$iv = feedEntries;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (FeedEntry)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getPackageInfo().getOs(), "linux")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (FeedEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IdeVersion ideVersion = (IdeVersion)IdeVersion.createIdeVersion(it.getBuild()).setProductCodeIfAbsent("AI");
            Intrinsics.checkNotNullExpressionValue(ideVersion, "ideVersion");
            LocalDate uploadDate = this.getApproximateUploadDate(ideVersion);
            collection.add(new AvailableIde(ideVersion, it.getVersion(), it.getPackageInfo().getUrl(), uploadDate, IntelliJPlatformProduct.ANDROID_STUDIO));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public List<AvailableIde> fetchIndex() throws InterruptedException {
        List<AvailableIde> list = this.indexCache.get();
        Intrinsics.checkNotNullExpressionValue(list, "indexCache.get()");
        return list;
    }

    private final LocalDate getApproximateUploadDate(IdeVersion ideVersion) {
        int branch = ideVersion.getBaselineVersion();
        int year = 2000 + branch / 10;
        int month = 4 * (branch % 10) - 1;
        LocalDate localDate = LocalDate.of(year, month, 1);
        Intrinsics.checkNotNullExpressionValue(localDate, "of(year, month, 1)");
        return localDate;
    }

    public AndroidStudioIdeRepository() {
        this(null, 1, null);
    }

    public static final /* synthetic */ String access$getFeedUrl$p(AndroidStudioIdeRepository $this) {
        return $this.feedUrl;
    }

    public static final /* synthetic */ List access$updateIndex(AndroidStudioIdeRepository $this) {
        return $this.updateIndex();
    }
}

