/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.ide;

import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.plugin.structure.ide.Ide;
import com.jetbrains.plugin.structure.ide.IdeConfiguration;
import com.jetbrains.plugin.structure.ide.IdeManagersKt;
import com.jetbrains.plugin.structure.ide.classes.IdeResolverConfiguration;
import com.jetbrains.plugin.structure.ide.classes.IdeResolverCreator;
import com.jetbrains.plugin.structure.ide.layout.MissingLayoutFileMode;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import com.jetbrains.pluginverifier.jdk.DefaultJdkDescriptorProvider;
import com.jetbrains.pluginverifier.jdk.JdkDescriptor;
import com.jetbrains.pluginverifier.jdk.JdkDescriptorProvider;
import com.jetbrains.pluginverifier.jdk.JdkVersion;
import com.jetbrains.pluginverifier.repository.files.FileLock;
import java.io.Closeable;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 +2\u00020\u0001:\u0001+B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\tH\u00c6\u0003J3\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\b\u0010)\u001a\u00020*H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006,"}, d2={"Lcom/jetbrains/pluginverifier/ide/IdeDescriptor;", "Ljava/io/Closeable;", "ide", "Lcom/jetbrains/plugin/structure/ide/Ide;", "ideResolver", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "jdkDescriptor", "Lcom/jetbrains/pluginverifier/jdk/JdkDescriptor;", "ideFileLock", "Lcom/jetbrains/pluginverifier/repository/files/FileLock;", "(Lcom/jetbrains/plugin/structure/ide/Ide;Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;Lcom/jetbrains/pluginverifier/jdk/JdkDescriptor;Lcom/jetbrains/pluginverifier/repository/files/FileLock;)V", "getIde", "()Lcom/jetbrains/plugin/structure/ide/Ide;", "getIdeFileLock", "()Lcom/jetbrains/pluginverifier/repository/files/FileLock;", "getIdeResolver", "()Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "ideVersion", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "Lorg/jetbrains/annotations/NotNull;", "getIdeVersion", "()Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "getJdkDescriptor", "()Lcom/jetbrains/pluginverifier/jdk/JdkDescriptor;", "jdkVersion", "Lcom/jetbrains/pluginverifier/jdk/JdkVersion;", "getJdkVersion", "()Lcom/jetbrains/pluginverifier/jdk/JdkVersion;", "close", "", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Companion", "verifier-intellij"})
public final class IdeDescriptor
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Ide ide;
    @NotNull
    private final Resolver ideResolver;
    @NotNull
    private final JdkDescriptor jdkDescriptor;
    @Nullable
    private final FileLock ideFileLock;
    @NotNull
    private static final DefaultJdkDescriptorProvider jdkDescriptorProvider = new DefaultJdkDescriptorProvider();

    public IdeDescriptor(@NotNull Ide ide2, @NotNull Resolver ideResolver, @NotNull JdkDescriptor jdkDescriptor, @Nullable FileLock ideFileLock) {
        Intrinsics.checkNotNullParameter(ide2, "ide");
        Intrinsics.checkNotNullParameter(ideResolver, "ideResolver");
        Intrinsics.checkNotNullParameter(jdkDescriptor, "jdkDescriptor");
        this.ide = ide2;
        this.ideResolver = ideResolver;
        this.jdkDescriptor = jdkDescriptor;
        this.ideFileLock = ideFileLock;
    }

    @NotNull
    public final Ide getIde() {
        return this.ide;
    }

    @NotNull
    public final Resolver getIdeResolver() {
        return this.ideResolver;
    }

    @NotNull
    public final JdkDescriptor getJdkDescriptor() {
        return this.jdkDescriptor;
    }

    @Nullable
    public final FileLock getIdeFileLock() {
        return this.ideFileLock;
    }

    @NotNull
    public final IdeVersion getIdeVersion() {
        IdeVersion ideVersion = this.ide.getVersion();
        Intrinsics.checkNotNullExpressionValue(ideVersion, "ide.version");
        return ideVersion;
    }

    @NotNull
    public final JdkVersion getJdkVersion() {
        return this.jdkDescriptor.getJdkVersion();
    }

    @NotNull
    public String toString() {
        return this.getIdeVersion().toString();
    }

    @Override
    public void close() {
        LanguageUtilsKt.closeLogged((Closeable)this.ideResolver);
        LanguageUtilsKt.closeLogged((Closeable)this.jdkDescriptor);
        LanguageUtilsKt.closeLogged((Closeable)this.ideFileLock);
    }

    @NotNull
    public final Ide component1() {
        return this.ide;
    }

    @NotNull
    public final Resolver component2() {
        return this.ideResolver;
    }

    @NotNull
    public final JdkDescriptor component3() {
        return this.jdkDescriptor;
    }

    @Nullable
    public final FileLock component4() {
        return this.ideFileLock;
    }

    @NotNull
    public final IdeDescriptor copy(@NotNull Ide ide2, @NotNull Resolver ideResolver, @NotNull JdkDescriptor jdkDescriptor, @Nullable FileLock ideFileLock) {
        Intrinsics.checkNotNullParameter(ide2, "ide");
        Intrinsics.checkNotNullParameter(ideResolver, "ideResolver");
        Intrinsics.checkNotNullParameter(jdkDescriptor, "jdkDescriptor");
        return new IdeDescriptor(ide2, ideResolver, jdkDescriptor, ideFileLock);
    }

    public static /* synthetic */ IdeDescriptor copy$default(IdeDescriptor ideDescriptor, Ide ide2, Resolver resolver, JdkDescriptor jdkDescriptor, FileLock fileLock, int n, Object object) {
        if ((n & 1) != 0) {
            ide2 = ideDescriptor.ide;
        }
        if ((n & 2) != 0) {
            resolver = ideDescriptor.ideResolver;
        }
        if ((n & 4) != 0) {
            jdkDescriptor = ideDescriptor.jdkDescriptor;
        }
        if ((n & 8) != 0) {
            fileLock = ideDescriptor.ideFileLock;
        }
        return ideDescriptor.copy(ide2, resolver, jdkDescriptor, fileLock);
    }

    public int hashCode() {
        int result2 = this.ide.hashCode();
        result2 = result2 * 31 + this.ideResolver.hashCode();
        result2 = result2 * 31 + this.jdkDescriptor.hashCode();
        result2 = result2 * 31 + (this.ideFileLock == null ? 0 : this.ideFileLock.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IdeDescriptor)) {
            return false;
        }
        IdeDescriptor ideDescriptor = (IdeDescriptor)other;
        if (!Intrinsics.areEqual(this.ide, ideDescriptor.ide)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.ideResolver, ideDescriptor.ideResolver)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.jdkDescriptor, ideDescriptor.jdkDescriptor)) {
            return false;
        }
        return Intrinsics.areEqual(this.ideFileLock, ideDescriptor.ideFileLock);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/pluginverifier/ide/IdeDescriptor$Companion;", "", "()V", "jdkDescriptorProvider", "Lcom/jetbrains/pluginverifier/jdk/DefaultJdkDescriptorProvider;", "create", "Lcom/jetbrains/pluginverifier/ide/IdeDescriptor;", "idePath", "Ljava/nio/file/Path;", "defaultJdkPath", "ideFileLock", "Lcom/jetbrains/pluginverifier/repository/files/FileLock;", "missingLayoutClasspathFileMode", "Lcom/jetbrains/plugin/structure/ide/layout/MissingLayoutFileMode;", "verifier-intellij"})
    @SourceDebugExtension(value={"SMAP\nIdeDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeDescriptor.kt\ncom/jetbrains/pluginverifier/ide/IdeDescriptor$Companion\n+ 2 LanguageUtils.kt\ncom/jetbrains/plugin/structure/base/utils/LanguageUtilsKt\n*L\n1#1,93:1\n70#2,5:94\n*S KotlinDebug\n*F\n+ 1 IdeDescriptor.kt\ncom/jetbrains/pluginverifier/ide/IdeDescriptor$Companion\n*L\n84#1:94,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IdeDescriptor create(@NotNull Path idePath, @Nullable Path defaultJdkPath, @Nullable FileLock ideFileLock) {
            Intrinsics.checkNotNullParameter(idePath, "idePath");
            return this.create(idePath, defaultJdkPath, ideFileLock, MissingLayoutFileMode.SKIP_AND_WARN);
        }

        @NotNull
        public final IdeDescriptor create(@NotNull Path idePath, @Nullable Path defaultJdkPath, @Nullable FileLock ideFileLock, @NotNull MissingLayoutFileMode missingLayoutClasspathFileMode) {
            Intrinsics.checkNotNullParameter(idePath, "idePath");
            Intrinsics.checkNotNullParameter((Object)missingLayoutClasspathFileMode, "missingLayoutClasspathFileMode");
            IdeResolverConfiguration ideResolverConfiguration = new IdeResolverConfiguration(Resolver.ReadMode.FULL, missingLayoutClasspathFileMode, false, false, 12, null);
            Ide ide2 = IdeManagersKt.createIde((Function1<? super IdeConfiguration, Unit>)new Function1<IdeConfiguration, Unit>(idePath, missingLayoutClasspathFileMode){
                final /* synthetic */ Path $idePath;
                final /* synthetic */ MissingLayoutFileMode $missingLayoutClasspathFileMode;
                {
                    this.$idePath = $idePath;
                    this.$missingLayoutClasspathFileMode = $missingLayoutClasspathFileMode;
                    super(1);
                }

                public final void invoke(@NotNull IdeConfiguration $this$createIde) {
                    Intrinsics.checkNotNullParameter($this$createIde, "$this$createIde");
                    $this$createIde.setPath(this.$idePath);
                    $this$createIde.setMissingLayoutFileMode(this.$missingLayoutClasspathFileMode);
                }
            });
            Resolver ideResolver = IdeResolverCreator.createIdeResolver(ide2, ideResolverConfiguration);
            Closeable $this$closeOnException$iv = ideResolver;
            boolean $i$f$closeOnException = false;
            try {
                Resolver it = (Resolver)$this$closeOnException$iv;
                boolean bl = false;
                JdkDescriptorProvider.Result result2 = jdkDescriptorProvider.getJdkDescriptor(ide2, defaultJdkPath);
                if (result2 instanceof JdkDescriptorProvider.Result.Found) {
                    return new IdeDescriptor(ide2, ideResolver, ((JdkDescriptorProvider.Result.Found)result2).getJdkDescriptor(), ideFileLock);
                }
                throw new IllegalStateException("No suitable JDK was found");
            }
            catch (Throwable e$iv) {
                block3: {
                    Closeable closeable = $this$closeOnException$iv;
                    if (closeable == null) break block3;
                    LanguageUtilsKt.closeLogged(closeable);
                }
                throw e$iv;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

