/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.dependencies.resolution;

import com.jetbrains.plugin.structure.ide.Ide;
import com.jetbrains.plugin.structure.intellij.classes.plugin.ClassSearchContext;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.PluginArchiveManager;
import com.jetbrains.plugin.structure.intellij.plugin.PluginProvider;
import com.jetbrains.plugin.structure.intellij.plugin.PluginProvision;
import com.jetbrains.plugin.structure.intellij.plugin.PluginQuery;
import com.jetbrains.pluginverifier.dependencies.resolution.DependencyFinder;
import com.jetbrains.pluginverifier.dependencies.resolution.DependencyFindersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0015H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/pluginverifier/dependencies/resolution/DependencyFinderPluginProvider;", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginProvider;", "dependencyFinder", "Lcom/jetbrains/pluginverifier/dependencies/resolution/DependencyFinder;", "ide", "Lcom/jetbrains/plugin/structure/ide/Ide;", "archiveManager", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginArchiveManager;", "(Lcom/jetbrains/pluginverifier/dependencies/resolution/DependencyFinder;Lcom/jetbrains/plugin/structure/ide/Ide;Lcom/jetbrains/plugin/structure/intellij/plugin/PluginArchiveManager;)V", "getArchiveManager", "()Lcom/jetbrains/plugin/structure/intellij/plugin/PluginArchiveManager;", "classSearchContext", "Lcom/jetbrains/plugin/structure/intellij/classes/plugin/ClassSearchContext;", "findPluginById", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "pluginId", "", "findPluginByModule", "moduleId", "query", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginProvision;", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginQuery;", "verifier-intellij"})
public final class DependencyFinderPluginProvider
implements PluginProvider {
    @NotNull
    private final DependencyFinder dependencyFinder;
    @NotNull
    private final Ide ide;
    @NotNull
    private final PluginArchiveManager archiveManager;
    @NotNull
    private final ClassSearchContext classSearchContext;

    public DependencyFinderPluginProvider(@NotNull DependencyFinder dependencyFinder, @NotNull Ide ide2, @NotNull PluginArchiveManager archiveManager) {
        Intrinsics.checkNotNullParameter(dependencyFinder, "dependencyFinder");
        Intrinsics.checkNotNullParameter(ide2, "ide");
        Intrinsics.checkNotNullParameter(archiveManager, "archiveManager");
        this.dependencyFinder = dependencyFinder;
        this.ide = ide2;
        this.archiveManager = archiveManager;
        this.classSearchContext = new ClassSearchContext(this.archiveManager);
    }

    @NotNull
    public final PluginArchiveManager getArchiveManager() {
        return this.archiveManager;
    }

    @Override
    @Nullable
    public IdePlugin findPluginById(@NotNull String pluginId) {
        Intrinsics.checkNotNullParameter(pluginId, "pluginId");
        return DependencyFindersKt.resolvePlugin(this.dependencyFinder.findPluginDependency(pluginId, false), this.ide, this.classSearchContext);
    }

    @Override
    @Nullable
    public IdePlugin findPluginByModule(@NotNull String moduleId) {
        Intrinsics.checkNotNullParameter(moduleId, "moduleId");
        return DependencyFindersKt.resolvePlugin(this.dependencyFinder.findPluginDependency(moduleId, true), this.ide, this.classSearchContext);
    }

    @Override
    @NotNull
    public PluginProvision query(@NotNull PluginQuery query) {
        Intrinsics.checkNotNullParameter(query, "query");
        if (query.searchId()) {
            String string = query.getIdentifier();
            Intrinsics.checkNotNullExpressionValue(string, "query.identifier");
            IdePlugin idePlugin = this.findPluginById(string);
            if (idePlugin != null) {
                IdePlugin it = idePlugin;
                boolean bl = false;
                return new PluginProvision.Found(it, PluginProvision.Source.ID);
            }
        } else if (query.searchPluginAliases()) {
            String string = query.getIdentifier();
            Intrinsics.checkNotNullExpressionValue(string, "query.identifier");
            IdePlugin idePlugin = this.findPluginByModule(string);
            if (idePlugin != null) {
                IdePlugin it = idePlugin;
                boolean bl = false;
                return new PluginProvision.Found(it, PluginProvision.Source.ALIAS);
            }
        } else if (query.searchContentModuleId()) {
            String string = query.getIdentifier();
            Intrinsics.checkNotNullExpressionValue(string, "query.identifier");
            IdePlugin idePlugin = this.findPluginByModule(string);
            if (idePlugin != null) {
                IdePlugin it = idePlugin;
                boolean bl = false;
                return new PluginProvision.Found(it, PluginProvision.Source.CONTENT_MODULE_ID);
            }
        }
        return PluginProvision.NotFound.INSTANCE;
    }
}

