/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.analysis;

import com.jetbrains.pluginverifier.analysis.TypeGraph;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\u000e\u001a\u00020\nJ\u001a\u0010\u000f\u001a\u00020\u00102\n\u0010\r\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\u000e\u001a\u00020\nR$\u0010\u0005\u001a\u0018\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/pluginverifier/analysis/ReachabilityGraph;", "", "graph", "Lcom/jetbrains/pluginverifier/analysis/TypeGraph;", "(Lcom/jetbrains/pluginverifier/analysis/TypeGraph;)V", "classMarks", "", "", "Lcom/jetbrains/pluginverifier/analysis/ClassName;", "Ljava/util/EnumSet;", "Lcom/jetbrains/pluginverifier/analysis/ReachabilityGraph$ReachabilityMark;", "isClassReachableFromMark", "", "className", "mark", "markClass", "", "ReachabilityMark", "verifier-intellij"})
@SourceDebugExtension(value={"SMAP\nClassReachabilityAnalysis.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassReachabilityAnalysis.kt\ncom/jetbrains/pluginverifier/analysis/ReachabilityGraph\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,388:1\n372#2,7:389\n*S KotlinDebug\n*F\n+ 1 ClassReachabilityAnalysis.kt\ncom/jetbrains/pluginverifier/analysis/ReachabilityGraph\n*L\n56#1:389,7\n*E\n"})
public final class ReachabilityGraph {
    @NotNull
    private final TypeGraph graph;
    @NotNull
    private final Map<String, EnumSet<ReachabilityMark>> classMarks;

    public ReachabilityGraph(@NotNull TypeGraph graph) {
        Intrinsics.checkNotNullParameter(graph, "graph");
        this.graph = graph;
        this.classMarks = new HashMap();
    }

    public final void markClass(@NotNull String className, @NotNull ReachabilityMark mark) {
        EnumSet<ReachabilityMark> enumSet;
        Intrinsics.checkNotNullParameter(className, "className");
        Intrinsics.checkNotNullParameter((Object)mark, "mark");
        Map<String, EnumSet<ReachabilityMark>> $this$getOrPut$iv = this.classMarks;
        boolean $i$f$getOrPut = false;
        EnumSet<ReachabilityMark> value$iv = $this$getOrPut$iv.get(className);
        if (value$iv == null) {
            boolean bl = false;
            EnumSet<ReachabilityMark> enumSet2 = EnumSet.noneOf(ReachabilityMark.class);
            Intrinsics.checkNotNullExpressionValue(enumSet2, "noneOf(ReachabilityMark::class.java)");
            EnumSet<ReachabilityMark> answer$iv = enumSet2;
            $this$getOrPut$iv.put(className, answer$iv);
            enumSet = answer$iv;
        } else {
            enumSet = value$iv;
        }
        ((Collection)enumSet).add(mark);
    }

    public final boolean isClassReachableFromMark(@NotNull String className, @NotNull ReachabilityMark mark) {
        Intrinsics.checkNotNullParameter(className, "className");
        Intrinsics.checkNotNullParameter((Object)mark, "mark");
        HashSet<String> visitedClasses = new HashSet<String>();
        LinkedList<String> stack = new LinkedList<String>();
        LinkedList<String> way = new LinkedList<String>();
        ((Collection)stack).add(className);
        while (!((Collection)stack).isEmpty()) {
            String currentClass = (String)stack.peekFirst();
            if (!visitedClasses.add(currentClass)) {
                stack.pollFirst();
                way.pollLast();
                continue;
            }
            way.addLast(currentClass);
            Intrinsics.checkNotNullExpressionValue(currentClass, "currentClass");
            Set<String> referencingTypes = this.graph.getEdgesTo(currentClass);
            for (String typeName : referencingTypes) {
                EnumSet<ReachabilityMark> enumSet = this.classMarks.get(typeName);
                boolean bl = enumSet != null ? enumSet.contains((Object)mark) : false;
                if (bl) {
                    for (String name : way) {
                        Intrinsics.checkNotNullExpressionValue(name, "name");
                        this.markClass(name, mark);
                    }
                    return true;
                }
                if (visitedClasses.contains(typeName)) continue;
                stack.addFirst(typeName);
            }
        }
        return false;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/pluginverifier/analysis/ReachabilityGraph$ReachabilityMark;", "", "(Ljava/lang/String;I)V", "MAIN_PLUGIN", "OPTIONAL_PLUGIN", "verifier-intellij"})
    public static final class ReachabilityMark
    extends Enum<ReachabilityMark> {
        public static final /* enum */ ReachabilityMark MAIN_PLUGIN = new ReachabilityMark();
        public static final /* enum */ ReachabilityMark OPTIONAL_PLUGIN = new ReachabilityMark();
        private static final /* synthetic */ ReachabilityMark[] $VALUES;

        public static ReachabilityMark[] values() {
            return (ReachabilityMark[])$VALUES.clone();
        }

        public static ReachabilityMark valueOf(String value) {
            return Enum.valueOf(ReachabilityMark.class, value);
        }

        static {
            $VALUES = reachabilityMarkArray = new ReachabilityMark[]{ReachabilityMark.MAIN_PLUGIN, ReachabilityMark.OPTIONAL_PLUGIN};
        }
    }
}

