/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin.dependencies;

import com.jetbrains.plugin.structure.base.utils.FormatUtilsKt;
import com.jetbrains.plugin.structure.intellij.plugin.DependenciesModifier;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.PassThruDependenciesModifier;
import com.jetbrains.plugin.structure.intellij.plugin.PluginDependency;
import com.jetbrains.plugin.structure.intellij.plugin.PluginProvider;
import com.jetbrains.plugin.structure.intellij.plugin.PluginProvision;
import com.jetbrains.plugin.structure.intellij.plugin.PluginQuery;
import com.jetbrains.plugin.structure.intellij.plugin.dependencies.DefaultDependencyTreeResolution;
import com.jetbrains.plugin.structure.intellij.plugin.dependencies.DependenciesKt;
import com.jetbrains.plugin.structure.intellij.plugin.dependencies.Dependency;
import com.jetbrains.plugin.structure.intellij.plugin.dependencies.DependencyTree;
import com.jetbrains.plugin.structure.intellij.plugin.dependencies.DependencyTreeKt;
import com.jetbrains.plugin.structure.intellij.plugin.dependencies.DependencyTreeResolution;
import com.jetbrains.plugin.structure.intellij.plugin.dependencies.IdeModulePredicate;
import com.jetbrains.plugin.structure.intellij.plugin.dependencies.NegativeIdeModulePredicate;
import com.jetbrains.plugin.structure.intellij.plugin.dependencies.PluginAware;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003JKLB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J9\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\b2\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0014\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u0015J1\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0014\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u0016J`\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0016\u0010\u001a\u001a\u0012\u0012\b\u0012\u00060\bj\u0002`\t\u0012\u0004\u0012\u00020\n0\u001b2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u000e\u0010\u0007\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\tH\u0002J(\u0010\u0017\u001a\u0012\u0012\b\u0012\u00060\bj\u0002`\t\u0012\u0004\u0012\u00020\n0\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010%\u001a\u00020&J\u0018\u0010'\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u0011H\u0002J\u0018\u0010(\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010)\u001a\u00020\bH\u0002J\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020\n0+2\u0006\u0010\u0018\u001a\u00020\u0019J\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00020\n0+2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\"H\u0002J>\u0010*\u001a\b\u0012\u0004\u0012\u00020\n0+2\u0006\u0010\u0018\u001a\u00020\u00192\u001e\b\u0002\u0010-\u001a\u0018\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\u000e0.j\u0002`02\b\b\u0002\u0010%\u001a\u00020&J\u001c\u00101\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u000203022\u0006\u00104\u001a\u00020/H\u0002J\u0018\u00105\u001a\u0002032\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00104\u001a\u00020/H\u0002J\u0010\u00106\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u00107\u001a\u00020\n2\u0006\u00104\u001a\u00020/H\u0002J\u0012\u00108\u001a\u0004\u0018\u0001092\u0006\u0010:\u001a\u00020\bH\u0002J\u0016\u0010;\u001a\u0004\u0018\u0001092\n\u0010<\u001a\u00060\bj\u0002`\tH\u0002J\u000e\u0010=\u001a\u00020>2\u0006\u0010<\u001a\u00020\bJ\f\u0010?\u001a\u00020\n*\u00020\nH\u0002J.\u0010@\u001a\b\u0012\u0004\u0012\u00020\n0+*\u0012\u0012\b\u0012\u00060\bj\u0002`\t\u0012\u0004\u0012\u00020\n0\u001b2\n\u0010A\u001a\u00060\bj\u0002`\tH\u0002J@\u0010@\u001a\u00020\u000e*\u0012\u0012\b\u0012\u00060\bj\u0002`\t\u0012\u0004\u0012\u00020\n0\u001b2\n\u0010A\u001a\u00060\bj\u0002`\t2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\n0C2\b\b\u0002\u0010D\u001a\u00020\u0011H\u0002JN\u0010=\u001a\u00020\u000e*\u0012\u0012\b\u0012\u00060\bj\u0002`\t\u0012\u0004\u0012\u00020\n0\u001b2\n\u0010A\u001a\u00060\bj\u0002`\t2\u0006\u0010E\u001a\u00020\u00112\u0010\u0010F\u001a\f\u0012\b\u0012\u00060\bj\u0002`\t0C2\n\u0010G\u001a\u00060Hj\u0002`IH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\t*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006M"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/DependencyTree;", "", "pluginProvider", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginProvider;", "ideModulePredicate", "Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/IdeModulePredicate;", "(Lcom/jetbrains/plugin/structure/intellij/plugin/PluginProvider;Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/IdeModulePredicate;)V", "artifactId", "", "Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/PluginId;", "Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/Dependency;", "getArtifactId", "(Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/Dependency;)Ljava/lang/String;", "debugLog", "", "indent", "numericIndex", "", "message", "params", "", "(Ljava/lang/String;ILjava/lang/String;[Ljava/lang/Object;)V", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)V", "getDependencyGraph", "plugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "graph", "Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/DependencyTree$DiGraph;", "resolutionDepth", "dependencyIndex", "parentDependencyIndex", "missingDependencies", "Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/DependencyTree$MissingDependencies;", "context", "Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/DependencyTree$ResolutionContext;", "getDependencyTreeResolution", "Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/DependencyTreeResolution;", "dependenciesModifier", "Lcom/jetbrains/plugin/structure/intellij/plugin/DependenciesModifier;", "getIndent", "getNestedDependencyIndent", "dependencyNumber", "getTransitiveDependencies", "", "dependencyResolutionContext", "missingDependencyListener", "Lkotlin/Function2;", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDependency;", "Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/MissingDependencyListener;", "hasId", "Lkotlin/Function1;", "", "dependency", "ignore", "missingId", "resolve", "resolveModule", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginProvision$Found;", "moduleId", "resolvePlugin", "pluginId", "toDebugString", "", "asTransitive", "collectDependencies", "id", "dependencies", "", "layer", "indentSize", "visited", "printer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "DiGraph", "MissingDependencies", "ResolutionContext", "structure-intellij"})
@SourceDebugExtension(value={"SMAP\nDependencyTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyTree.kt\ncom/jetbrains/plugin/structure/intellij/plugin/dependencies/DependencyTree\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,361:1\n1#2:362\n1864#3,3:363\n1045#3:366\n1855#3,2:367\n*E\n*S KotlinDebug\n*F\n+ 1 DependencyTree.kt\ncom/jetbrains/plugin/structure/intellij/plugin/dependencies/DependencyTree\n*L\n113#1,3:363\n265#1:366\n266#1,2:367\n*E\n"})
public final class DependencyTree {
    @NotNull
    private final PluginProvider pluginProvider;
    @NotNull
    private final IdeModulePredicate ideModulePredicate;

    public DependencyTree(@NotNull PluginProvider pluginProvider, @NotNull IdeModulePredicate ideModulePredicate) {
        Intrinsics.checkNotNullParameter(pluginProvider, "pluginProvider");
        Intrinsics.checkNotNullParameter(ideModulePredicate, "ideModulePredicate");
        this.pluginProvider = pluginProvider;
        this.ideModulePredicate = ideModulePredicate;
    }

    public /* synthetic */ DependencyTree(PluginProvider pluginProvider, IdeModulePredicate ideModulePredicate, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 2) != 0) {
            ideModulePredicate = NegativeIdeModulePredicate.INSTANCE;
        }
        this(pluginProvider, ideModulePredicate);
    }

    @NotNull
    public final DependencyTreeResolution getDependencyTreeResolution(@NotNull IdePlugin plugin, @NotNull DependenciesModifier dependenciesModifier) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(dependenciesModifier, "dependenciesModifier");
        if (plugin.getPluginId() == null) {
            boolean $i$a$-requireNotNull-DependencyTree$getDependencyTreeResolution$22 = false;
            String $i$a$-requireNotNull-DependencyTree$getDependencyTreeResolution$22 = this.missingId(plugin);
            throw new IllegalArgumentException($i$a$-requireNotNull-DependencyTree$getDependencyTreeResolution$22.toString());
        }
        Map missingDependencies = new LinkedHashMap();
        Function2 missingDependencyListener2 = new Function2<IdePlugin, PluginDependency, Unit>((Map<IdePlugin, Set<PluginDependency>>)missingDependencies){
            final /* synthetic */ Map<IdePlugin, Set<PluginDependency>> $missingDependencies;
            {
                this.$missingDependencies = $missingDependencies;
                super(2);
            }

            public final void invoke(@NotNull IdePlugin idePlugin, @NotNull PluginDependency missingDependency) {
                Intrinsics.checkNotNullParameter(idePlugin, "idePlugin");
                Intrinsics.checkNotNullParameter(missingDependency, "missingDependency");
                Function2 function2 = getDependencyTreeResolution.missingDependencyListener.1.INSTANCE;
                this.$missingDependencies.merge(idePlugin, SetsKt.setOf(missingDependency), new BiFunction(function2){
                    private final /* synthetic */ Function2 function;
                    {
                        Intrinsics.checkNotNullParameter(function, "function");
                        this.function = function;
                    }

                    public final /* synthetic */ Object apply(Object p0, Object p1) {
                        return this.function.invoke(p0, p1);
                    }
                });
            }
        };
        ResolutionContext dependencyResolutionContext = new ResolutionContext(missingDependencyListener2, dependenciesModifier);
        DiGraph<String, Dependency> dependencyGraph = this.getDependencyGraph(plugin, dependencyResolutionContext);
        Set transitiveDependencies = new LinkedHashSet();
        dependencyGraph.forEachAdjacency$structure_intellij((Function2<String, List<Dependency>, Unit>)new Function2<String, List<? extends Dependency>, Unit>((Set<Dependency>)transitiveDependencies){
            final /* synthetic */ Set<Dependency> $transitiveDependencies;
            {
                this.$transitiveDependencies = $transitiveDependencies;
                super(2);
            }

            public final void invoke(@NotNull String pluginId, @NotNull List<? extends Dependency> dependencies) {
                Intrinsics.checkNotNullParameter(pluginId, "pluginId");
                Intrinsics.checkNotNullParameter(dependencies, "dependencies");
                CollectionsKt.addAll((Collection)this.$transitiveDependencies, (Iterable)dependencies);
            }
        });
        return new DefaultDependencyTreeResolution(plugin, transitiveDependencies, missingDependencies, dependencyGraph);
    }

    public static /* synthetic */ DependencyTreeResolution getDependencyTreeResolution$default(DependencyTree dependencyTree, IdePlugin idePlugin, DependenciesModifier dependenciesModifier, int n, Object object) {
        if ((n & 2) != 0) {
            dependenciesModifier = PassThruDependenciesModifier.INSTANCE;
        }
        return dependencyTree.getDependencyTreeResolution(idePlugin, dependenciesModifier);
    }

    @NotNull
    public final Set<Dependency> getTransitiveDependencies(@NotNull IdePlugin plugin) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        return this.getTransitiveDependencies(plugin, new ResolutionContext(null, null, 3, null));
    }

    @NotNull
    public final Set<Dependency> getTransitiveDependencies(@NotNull IdePlugin plugin, @NotNull Function2<? super IdePlugin, ? super PluginDependency, Unit> missingDependencyListener2, @NotNull DependenciesModifier dependenciesModifier) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(missingDependencyListener2, "missingDependencyListener");
        Intrinsics.checkNotNullParameter(dependenciesModifier, "dependenciesModifier");
        return this.getTransitiveDependencies(plugin, new ResolutionContext(missingDependencyListener2, dependenciesModifier));
    }

    public static /* synthetic */ Set getTransitiveDependencies$default(DependencyTree dependencyTree, IdePlugin idePlugin, Function2 function2, DependenciesModifier dependenciesModifier, int n, Object object) throws IllegalArgumentException {
        if ((n & 2) != 0) {
            function2 = DependencyTreeKt.access$getEMPTY_MISSING_DEPENDENCY_LISTENER$p();
        }
        if ((n & 4) != 0) {
            dependenciesModifier = PassThruDependenciesModifier.INSTANCE;
        }
        return dependencyTree.getTransitiveDependencies(idePlugin, function2, dependenciesModifier);
    }

    private final Set<Dependency> getTransitiveDependencies(IdePlugin plugin, ResolutionContext dependencyResolutionContext) throws IllegalArgumentException {
        String string = plugin.getPluginId();
        if (string == null) {
            boolean bl = false;
            String string2 = this.missingId(plugin);
            throw new IllegalArgumentException(string2.toString());
        }
        String pluginId = string;
        DiGraph<String, Dependency> graph = this.getDependencyGraph(plugin, dependencyResolutionContext);
        return this.collectDependencies(graph, pluginId);
    }

    private final DiGraph<String, Dependency> getDependencyGraph(IdePlugin plugin, ResolutionContext context) {
        DiGraph<String, Dependency> graph = new DiGraph<String, Dependency>();
        MissingDependencies missingDependencies = new MissingDependencies();
        this.getDependencyGraph(plugin, graph, 0, -1, -1, missingDependencies, context, DependenciesKt.getId(plugin));
        return graph;
    }

    /*
     * WARNING - void declaration
     */
    private final void getDependencyGraph(IdePlugin plugin, DiGraph<String, Dependency> graph, int resolutionDepth, int dependencyIndex, int parentDependencyIndex, MissingDependencies missingDependencies, ResolutionContext context, String artifactId) {
        IdePlugin $this$getDependencyGraph_u24lambda_u243 = plugin;
        boolean bl = false;
        List<PluginDependency> dependencies = context.getDependenciesModifier().apply($this$getDependencyGraph_u24lambda_u243, this.pluginProvider);
        String string = artifactId;
        if (string != null || (string = $this$getDependencyGraph_u24lambda_u243.getPluginId()) != null) {
            String pluginId = string;
            String number = dependencyIndex < 0 ? "" : dependencyIndex + 1 + ") ";
            String indent = this.getIndent(resolutionDepth, parentDependencyIndex);
            if (dependencies.isEmpty()) {
                Object[] objectArray = new Object[]{pluginId};
                this.debugLog(indent, number + "No dependencies for '{}'", objectArray);
            } else {
                Object[] objectArray = new Object[]{dependencies.size(), pluginId, CollectionsKt.joinToString$default(dependencies, null, null, null, 0, null, getDependencyGraph.1.1.INSTANCE, 31, null)};
                this.debugLog(indent, number + "Resolving {} " + FormatUtilsKt.pluralize("dependency", dependencies.size()) + " for '{}': {}", objectArray);
                String nestedIndent = this.getNestedDependencyIndent(indent, number);
                Iterable $this$forEachIndexed$iv = dependencies;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    Object[] objectArray2;
                    void dep;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    PluginDependency pluginDependency = (PluginDependency)item$iv;
                    int i = n;
                    boolean bl2 = false;
                    if (this.ignore(plugin, (PluginDependency)dep)) {
                        objectArray2 = new Object[]{dep};
                        this.debugLog(nestedIndent, i + 1, "Ignoring '{}'", objectArray2);
                        continue;
                    }
                    if (graph.contains(pluginId, this.hasId((PluginDependency)dep))) {
                        objectArray2 = new Object[]{dep.getId()};
                        this.debugLog(nestedIndent, i + 1, "Resolved cached dependency '{}'", objectArray2);
                        continue;
                    }
                    if (missingDependencies.contains((PluginDependency)dep)) {
                        objectArray2 = new Object[]{dep.getId()};
                        this.debugLog(nestedIndent, i + 1, "Skipping dependency '{}' as it is already marked missing", objectArray2);
                        continue;
                    }
                    Dependency dependencyPlugin = this.resolve((PluginDependency)dep);
                    if (dependencyPlugin instanceof Dependency.Module ? true : dependencyPlugin instanceof Dependency.Plugin) {
                        if (!(dependencyPlugin instanceof PluginAware) || dependencyPlugin.matches(pluginId)) continue;
                        graph.addEdge(pluginId, dependencyPlugin);
                        this.getDependencyGraph(((PluginAware)((Object)dependencyPlugin)).getPlugin(), graph, resolutionDepth + 1, i, dependencyIndex, missingDependencies, context, this.getArtifactId(dependencyPlugin));
                        continue;
                    }
                    if (!(dependencyPlugin instanceof Dependency.None)) continue;
                    context.notifyMissingDependency(plugin, (PluginDependency)dep);
                    missingDependencies.plusAssign((PluginDependency)dep);
                    Object[] objectArray3 = new Object[]{dep.getId()};
                    this.debugLog(nestedIndent, i + 1, "Skipping dependency '{}' as it is not available", objectArray3);
                }
            }
        }
    }

    private final Dependency resolve(PluginDependency dependency) {
        Dependency.Module module;
        Dependency dependency2;
        PluginProvision.Found provision;
        PluginDependency $this$resolve_u24lambda_u246 = dependency;
        boolean bl = false;
        if ($this$resolve_u24lambda_u246.isModule()) {
            PluginProvision.Found found = this.resolveModule($this$resolve_u24lambda_u246.getId());
            if (found != null) {
                provision = found;
                boolean bl2 = false;
                dependency2 = new Dependency.Module(provision.getPlugin(), $this$resolve_u24lambda_u246.getId(), false, 4, null);
            } else {
                dependency2 = null;
            }
        } else {
            PluginProvision.Found found = this.resolvePlugin($this$resolve_u24lambda_u246.getId());
            if (found != null) {
                provision = found;
                boolean bl3 = false;
                IdePlugin plugin = provision.getPlugin();
                dependency2 = this.ideModulePredicate.matches($this$resolve_u24lambda_u246.getId(), plugin) ? new Dependency.Module(plugin, $this$resolve_u24lambda_u246.getId(), false, 4, null) : (provision.getSource() == PluginProvision.Source.CONTENT_MODULE_ID ? new Dependency.Module(plugin, $this$resolve_u24lambda_u246.getId(), false, 4, null) : new Dependency.Plugin(plugin, false, 2, null));
            } else {
                dependency2 = module = null;
            }
        }
        return module == null ? (Dependency)Dependency.None.INSTANCE : (Dependency)module;
    }

    private final String getNestedDependencyIndent(String indent, String dependencyNumber) {
        String additionalIndent = StringsKt.repeat(" ", Math.max(dependencyNumber.length(), 3));
        return indent + additionalIndent;
    }

    private final String getIndent(int resolutionDepth, int parentDependencyIndex) {
        Object object;
        if (resolutionDepth <= 1) {
            object = "";
        } else {
            String suffix = parentDependencyIndex < 0 ? "" : StringsKt.repeat(" ", String.valueOf(parentDependencyIndex).length() - 1) + StringsKt.repeat(" ", resolutionDepth - 1);
            object = StringsKt.repeat("  ", resolutionDepth - 1) + suffix;
        }
        return object;
    }

    private final boolean ignore(IdePlugin plugin, PluginDependency dependency) {
        return dependency.isModule() && plugin.getDefinedModules().contains(dependency.getId());
    }

    private final String missingId(IdePlugin plugin) {
        String string = plugin.getPluginName();
        if (string == null) {
            string = "unknown name";
        }
        String name = string;
        Path path = plugin.getOriginalFile();
        Comparable originalFile = path != null ? (Comparable)path : (Comparable)((Object)"unknown plugin artifact path");
        return "Plugin must have an ID. Name: " + name + ". Path: " + originalFile;
    }

    private final String getArtifactId(Dependency $this$artifactId) {
        String string;
        Dependency dependency = $this$artifactId;
        if (dependency instanceof Dependency.Plugin) {
            string = DependenciesKt.getId($this$artifactId);
        } else if (dependency instanceof Dependency.Module) {
            string = ((Dependency.Module)$this$artifactId).getId();
        } else if (Intrinsics.areEqual(dependency, Dependency.None.INSTANCE)) {
            string = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final Set<Dependency> collectDependencies(DiGraph<String, Dependency> $this$collectDependencies, String id) {
        Set set;
        Set $this$collectDependencies_u24lambda_u247 = set = (Set)new LinkedHashSet();
        boolean bl = false;
        DependencyTree.collectDependencies$default(this, $this$collectDependencies, id, $this$collectDependencies_u24lambda_u247, 0, 4, null);
        return set;
    }

    private final void collectDependencies(DiGraph<String, Dependency> $this$collectDependencies, String id, Set<Dependency> dependencies, int layer) {
        for (Dependency dependency : $this$collectDependencies.get(id)) {
            String depId;
            if (!(dependency instanceof PluginAware)) continue;
            Intrinsics.checkNotNull(((PluginAware)((Object)dependency)).getPlugin().getPluginId());
            Dependency dep = layer == 0 ? dependency : this.asTransitive(dependency);
            if (dependencies.contains(dep)) continue;
            ((Collection)dependencies).add(dep);
            this.collectDependencies($this$collectDependencies, depId, dependencies, layer + 1);
        }
    }

    static /* synthetic */ void collectDependencies$default(DependencyTree dependencyTree, DiGraph diGraph, String string, Set set, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        dependencyTree.collectDependencies(diGraph, string, set, n);
    }

    private final PluginProvision.Found resolvePlugin(String pluginId) {
        PluginQuery it = PluginQuery.Builder.of(pluginId).inId().inName().inPluginAliases().inContentModuleId().build();
        boolean bl = false;
        PluginProvision pluginProvision = this.pluginProvider.query(it);
        return pluginProvision instanceof PluginProvision.Found ? (PluginProvision.Found)pluginProvision : null;
    }

    private final PluginProvision.Found resolveModule(String moduleId) {
        PluginQuery it = PluginQuery.Builder.of(moduleId).inId().inName().inPluginAliases().build();
        boolean bl = false;
        PluginProvision pluginProvision = this.pluginProvider.query(it);
        return pluginProvision instanceof PluginProvision.Found ? (PluginProvision.Found)pluginProvision : null;
    }

    /*
     * WARNING - void declaration
     */
    private final void toDebugString(DiGraph<String, Dependency> $this$toDebugString, String id, int indentSize, Set<String> visited, StringBuilder printer) {
        void $this$forEach$iv;
        Iterable $this$sortedBy$iv;
        String indent = StringsKt.repeat("  ", indentSize);
        Iterable iterable = $this$toDebugString.get(id);
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Dependency it = (Dependency)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)DependenciesKt.getId(it));
                it = (Dependency)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)DependenciesKt.getId(it)));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Dependency dep = (Dependency)element$iv;
            boolean bl = false;
            if (!(dep instanceof PluginAware)) continue;
            String depId = DependenciesKt.getId(dep);
            if (!visited.contains(depId)) {
                ((Collection)visited).add(depId);
                StringBuilder stringBuilder = printer.append(indent + "* " + dep);
                Intrinsics.checkNotNullExpressionValue(stringBuilder, "append(...)");
                Intrinsics.checkNotNullExpressionValue(stringBuilder.append('\n'), "append(...)");
                this.toDebugString($this$toDebugString, depId, indentSize + 1, visited, printer);
                continue;
            }
            StringBuilder stringBuilder = printer.append(indent + "* " + dep + " (already visited)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder, "append(...)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder.append('\n'), "append(...)");
        }
    }

    private final Dependency asTransitive(Dependency $this$asTransitive) {
        Dependency dependency;
        Dependency dependency2 = $this$asTransitive;
        if (dependency2 instanceof Dependency.Module) {
            dependency = Dependency.Module.copy$default((Dependency.Module)$this$asTransitive, null, null, true, 3, null);
        } else if (dependency2 instanceof Dependency.Plugin) {
            dependency = Dependency.Plugin.copy$default((Dependency.Plugin)$this$asTransitive, null, true, 1, null);
        } else if (dependency2 instanceof Dependency.None) {
            dependency = $this$asTransitive;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return dependency;
    }

    private final Function1<Dependency, Boolean> hasId(PluginDependency dependency) {
        return new Function1<Dependency, Boolean>(dependency){
            final /* synthetic */ PluginDependency $dependency;
            {
                this.$dependency = $dependency;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Dependency dep) {
                Intrinsics.checkNotNullParameter(dep, "dep");
                return dep.matches(this.$dependency.getId());
            }
        };
    }

    @NotNull
    public final CharSequence toDebugString(@NotNull String pluginId) {
        StringBuilder stringBuilder;
        block0: {
            Intrinsics.checkNotNullParameter(pluginId, "pluginId");
            ResolutionContext resolutionContext = new ResolutionContext(DependencyTreeKt.access$getEMPTY_MISSING_DEPENDENCY_LISTENER$p(), null, 2, null);
            StringBuilder $this$toDebugString_u24lambda_u2413 = stringBuilder = new StringBuilder();
            boolean bl = false;
            IdePlugin idePlugin = this.pluginProvider.findPluginById(pluginId);
            if (idePlugin == null) break block0;
            IdePlugin plugin = idePlugin;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue(plugin, "plugin");
            this.toDebugString(this.getDependencyGraph(plugin, resolutionContext), pluginId, 0, new LinkedHashSet(), $this$toDebugString_u24lambda_u2413);
        }
        return stringBuilder;
    }

    private final void debugLog(String indent, String message2, Object ... params) {
        this.debugLog(indent, 0, message2, Arrays.copyOf(params, params.length));
    }

    private final void debugLog(String indent, int numericIndex, String message2, Object ... params) {
        if (DependencyTreeKt.access$getLOG$p().isDebugEnabled()) {
            StringBuilder stringBuilder;
            StringBuilder $this$debugLog_u24lambda_u2414 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$debugLog_u24lambda_u2414.append(indent);
            if (numericIndex > 0) {
                $this$debugLog_u24lambda_u2414.append(numericIndex).append(") ");
            }
            $this$debugLog_u24lambda_u2414.append(message2);
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            String msg = string;
            DependencyTreeKt.access$getLOG$p().debug(msg, Arrays.copyOf(params, params.length));
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\rJ'\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00028\u00002\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u000f0\u0011\u00a2\u0006\u0002\u0010\u0012J\u001b\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0013J-\u0010\u0014\u001a\u00020\n2\u001e\u0010\u0015\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0017\u0012\u0004\u0012\u00020\n0\u0016H\u0000\u00a2\u0006\u0002\b\u0018J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00010\u00172\u0006\u0010\u000b\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u001aR6\u0010\u0005\u001a*\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u0006j\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/DependencyTree$DiGraph;", "I", "O", "", "()V", "adjacency", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "addEdge", "", "from", "to", "(Ljava/lang/Object;Ljava/lang/Object;)V", "contains", "", "toIdPredicate", "Lkotlin/Function1;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Z", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "forEachAdjacency", "action", "Lkotlin/Function2;", "", "forEachAdjacency$structure_intellij", "get", "(Ljava/lang/Object;)Ljava/util/List;", "structure-intellij"})
    @SourceDebugExtension(value={"SMAP\nDependencyTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyTree.kt\ncom/jetbrains/plugin/structure/intellij/plugin/dependencies/DependencyTree$DiGraph\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,361:1\n372#2,7:362\n1747#3,3:369\n*E\n*S KotlinDebug\n*F\n+ 1 DependencyTree.kt\ncom/jetbrains/plugin/structure/intellij/plugin/dependencies/DependencyTree$DiGraph\n*L\n325#1,7:362\n332#1,3:369\n*E\n"})
    public static final class DiGraph<I, O> {
        @NotNull
        private final HashMap<I, List<O>> adjacency = new HashMap();

        @NotNull
        public final List<O> get(I from) {
            List<Object> list = this.adjacency.get(from);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        public final void addEdge(I from, O to) {
            Object object;
            Map $this$getOrPut$iv = this.adjacency;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(from);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(from, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Collection)object).add(to);
        }

        public final boolean contains(I from, O to) {
            List<O> list = this.adjacency.get(from);
            return list != null ? list.contains(to) : false;
        }

        public final boolean contains(I from, @NotNull Function1<? super O, Boolean> toIdPredicate) {
            boolean bl;
            block5: {
                Intrinsics.checkNotNullParameter(toIdPredicate, "toIdPredicate");
                List<O> list = this.adjacency.get(from);
                if (list != null) {
                    List<O> adj = list;
                    boolean bl2 = false;
                    Iterable $this$any$iv = adj;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        Iterator iterator2 = $this$any$iv.iterator();
                        while (iterator2.hasNext()) {
                            Object element$iv;
                            Object it = element$iv = iterator2.next();
                            boolean bl3 = false;
                            if (!toIdPredicate.invoke(it).booleanValue()) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                } else {
                    bl = false;
                }
            }
            return bl;
        }

        public final void forEachAdjacency$structure_intellij(@NotNull Function2<? super I, ? super List<? extends O>, Unit> action) {
            Intrinsics.checkNotNullParameter(action, "action");
            Function2<? super I, ? super List<? extends O>, Unit> function2 = action;
            this.adjacency.forEach(new BiConsumer(function2){
                private final /* synthetic */ Function2 function;
                {
                    Intrinsics.checkNotNullParameter(function, "function");
                    this.function = function;
                }

                public final /* synthetic */ void accept(Object p0, Object p1) {
                    this.function.invoke(p0, p1);
                }
            });
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0086\u0002J\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0005H\u0086\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/DependencyTree$MissingDependencies;", "", "()V", "_missingDependencies", "", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDependency;", "contains", "", "dependency", "plusAssign", "", "structure-intellij"})
    public static final class MissingDependencies {
        @NotNull
        private final List<PluginDependency> _missingDependencies = new ArrayList();

        public final void plusAssign(@NotNull PluginDependency dependency) {
            Intrinsics.checkNotNullParameter(dependency, "dependency");
            ((Collection)this._missingDependencies).add(dependency);
        }

        public final boolean contains(@NotNull PluginDependency dependency) {
            Intrinsics.checkNotNullParameter(dependency, "dependency");
            return this._missingDependencies.contains(dependency);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B/\u0012\u001e\b\u0002\u0010\u0002\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003j\u0002`\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001f\u0010\u000f\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003j\u0002`\u0007H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\tH\u00c6\u0003J3\u0010\u0011\u001a\u00020\u00002\u001e\b\u0002\u0010\u0002\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003j\u0002`\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u0016\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0005J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR'\u0010\u0002\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/DependencyTree$ResolutionContext;", "", "missingDependencyListener", "Lkotlin/Function2;", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDependency;", "", "Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/MissingDependencyListener;", "dependenciesModifier", "Lcom/jetbrains/plugin/structure/intellij/plugin/DependenciesModifier;", "(Lkotlin/jvm/functions/Function2;Lcom/jetbrains/plugin/structure/intellij/plugin/DependenciesModifier;)V", "getDependenciesModifier", "()Lcom/jetbrains/plugin/structure/intellij/plugin/DependenciesModifier;", "getMissingDependencyListener", "()Lkotlin/jvm/functions/Function2;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "notifyMissingDependency", "plugin", "dependency", "toString", "", "structure-intellij"})
    private static final class ResolutionContext {
        @NotNull
        private final Function2<IdePlugin, PluginDependency, Unit> missingDependencyListener;
        @NotNull
        private final DependenciesModifier dependenciesModifier;

        public ResolutionContext(@NotNull Function2<? super IdePlugin, ? super PluginDependency, Unit> missingDependencyListener2, @NotNull DependenciesModifier dependenciesModifier) {
            Intrinsics.checkNotNullParameter(missingDependencyListener2, "missingDependencyListener");
            Intrinsics.checkNotNullParameter(dependenciesModifier, "dependenciesModifier");
            this.missingDependencyListener = missingDependencyListener2;
            this.dependenciesModifier = dependenciesModifier;
        }

        public /* synthetic */ ResolutionContext(Function2 function2, DependenciesModifier dependenciesModifier, int n, DefaultConstructorMarker defaultConstructorMarker2) {
            if ((n & 1) != 0) {
                function2 = DependencyTreeKt.access$getEMPTY_MISSING_DEPENDENCY_LISTENER$p();
            }
            if ((n & 2) != 0) {
                dependenciesModifier = PassThruDependenciesModifier.INSTANCE;
            }
            this(function2, dependenciesModifier);
        }

        @NotNull
        public final Function2<IdePlugin, PluginDependency, Unit> getMissingDependencyListener() {
            return this.missingDependencyListener;
        }

        @NotNull
        public final DependenciesModifier getDependenciesModifier() {
            return this.dependenciesModifier;
        }

        public final void notifyMissingDependency(@NotNull IdePlugin plugin, @NotNull PluginDependency dependency) {
            Intrinsics.checkNotNullParameter(plugin, "plugin");
            Intrinsics.checkNotNullParameter(dependency, "dependency");
            this.missingDependencyListener.invoke(plugin, dependency);
        }

        @NotNull
        public final Function2<IdePlugin, PluginDependency, Unit> component1() {
            return this.missingDependencyListener;
        }

        @NotNull
        public final DependenciesModifier component2() {
            return this.dependenciesModifier;
        }

        @NotNull
        public final ResolutionContext copy(@NotNull Function2<? super IdePlugin, ? super PluginDependency, Unit> missingDependencyListener2, @NotNull DependenciesModifier dependenciesModifier) {
            Intrinsics.checkNotNullParameter(missingDependencyListener2, "missingDependencyListener");
            Intrinsics.checkNotNullParameter(dependenciesModifier, "dependenciesModifier");
            return new ResolutionContext(missingDependencyListener2, dependenciesModifier);
        }

        public static /* synthetic */ ResolutionContext copy$default(ResolutionContext resolutionContext, Function2 function2, DependenciesModifier dependenciesModifier, int n, Object object) {
            if ((n & 1) != 0) {
                function2 = resolutionContext.missingDependencyListener;
            }
            if ((n & 2) != 0) {
                dependenciesModifier = resolutionContext.dependenciesModifier;
            }
            return resolutionContext.copy(function2, dependenciesModifier);
        }

        @NotNull
        public String toString() {
            return "ResolutionContext(missingDependencyListener=" + this.missingDependencyListener + ", dependenciesModifier=" + this.dependenciesModifier + ")";
        }

        public int hashCode() {
            int result2 = this.missingDependencyListener.hashCode();
            result2 = result2 * 31 + this.dependenciesModifier.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ResolutionContext)) {
                return false;
            }
            ResolutionContext resolutionContext = (ResolutionContext)other;
            if (!Intrinsics.areEqual(this.missingDependencyListener, resolutionContext.missingDependencyListener)) {
                return false;
            }
            return Intrinsics.areEqual(this.dependenciesModifier, resolutionContext.dependenciesModifier);
        }

        public ResolutionContext() {
            this(null, null, 3, null);
        }
    }
}

