/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.classes.plugin;

import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.plugin.structure.intellij.classes.locator.LocationKey;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0001H\u00c2\u0003J\u001b\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006H\u00c2\u0003J9\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00012\u001a\b\u0002\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u001d\u001a\u00020\u0007J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/plugin/structure/intellij/classes/plugin/IdePluginClassesLocations;", "Ljava/io/Closeable;", "idePlugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "allocatedResource", "locations", "", "Lcom/jetbrains/plugin/structure/intellij/classes/locator/LocationKey;", "", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "(Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;Ljava/io/Closeable;Ljava/util/Map;)V", "getIdePlugin", "()Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "isClosed", "", "locationKeys", "", "getLocationKeys", "()Ljava/util/Set;", "close", "", "component1", "component2", "component3", "copy", "equals", "other", "", "getResolvers", "key", "hashCode", "", "toString", "", "structure-intellij-classes"})
@SourceDebugExtension(value={"SMAP\nIdePluginClassesLocations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdePluginClassesLocations.kt\ncom/jetbrains/plugin/structure/intellij/classes/plugin/IdePluginClassesLocations\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,40:1\n1855#2,2:41\n*E\n*S KotlinDebug\n*F\n+ 1 IdePluginClassesLocations.kt\ncom/jetbrains/plugin/structure/intellij/classes/plugin/IdePluginClassesLocations\n*L\n30#1,2:41\n*E\n"})
public final class IdePluginClassesLocations
implements Closeable {
    @NotNull
    private final IdePlugin idePlugin;
    @NotNull
    private final Closeable allocatedResource;
    @NotNull
    private final Map<LocationKey, List<Resolver>> locations;
    private boolean isClosed;
    @NotNull
    private final Set<LocationKey> locationKeys;

    public IdePluginClassesLocations(@NotNull IdePlugin idePlugin, @NotNull Closeable allocatedResource, @NotNull Map<LocationKey, ? extends List<? extends Resolver>> locations) {
        Intrinsics.checkNotNullParameter(idePlugin, "idePlugin");
        Intrinsics.checkNotNullParameter(allocatedResource, "allocatedResource");
        Intrinsics.checkNotNullParameter(locations, "locations");
        this.idePlugin = idePlugin;
        this.allocatedResource = allocatedResource;
        this.locations = locations;
        this.locationKeys = this.locations.keySet();
    }

    @NotNull
    public final IdePlugin getIdePlugin() {
        return this.idePlugin;
    }

    @Override
    public synchronized void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            for (List<Resolver> resolvers : this.locations.values()) {
                Iterable $this$forEach$iv = resolvers;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Resolver it = (Resolver)element$iv;
                    boolean bl = false;
                    LanguageUtilsKt.closeLogged((Closeable)it);
                }
            }
            LanguageUtilsKt.closeLogged(this.allocatedResource);
        }
    }

    @NotNull
    public final List<Resolver> getResolvers(@NotNull LocationKey key) {
        Intrinsics.checkNotNullParameter(key, "key");
        List<Resolver> list = this.locations.get(key);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final Set<LocationKey> getLocationKeys() {
        return this.locationKeys;
    }

    @NotNull
    public final IdePlugin component1() {
        return this.idePlugin;
    }

    private final Closeable component2() {
        return this.allocatedResource;
    }

    private final Map<LocationKey, List<Resolver>> component3() {
        return this.locations;
    }

    @NotNull
    public final IdePluginClassesLocations copy(@NotNull IdePlugin idePlugin, @NotNull Closeable allocatedResource, @NotNull Map<LocationKey, ? extends List<? extends Resolver>> locations) {
        Intrinsics.checkNotNullParameter(idePlugin, "idePlugin");
        Intrinsics.checkNotNullParameter(allocatedResource, "allocatedResource");
        Intrinsics.checkNotNullParameter(locations, "locations");
        return new IdePluginClassesLocations(idePlugin, allocatedResource, locations);
    }

    public static /* synthetic */ IdePluginClassesLocations copy$default(IdePluginClassesLocations idePluginClassesLocations, IdePlugin idePlugin, Closeable closeable, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            idePlugin = idePluginClassesLocations.idePlugin;
        }
        if ((n & 2) != 0) {
            closeable = idePluginClassesLocations.allocatedResource;
        }
        if ((n & 4) != 0) {
            map = idePluginClassesLocations.locations;
        }
        return idePluginClassesLocations.copy(idePlugin, closeable, map);
    }

    @NotNull
    public String toString() {
        return "IdePluginClassesLocations(idePlugin=" + this.idePlugin + ", allocatedResource=" + this.allocatedResource + ", locations=" + this.locations + ")";
    }

    public int hashCode() {
        int result2 = this.idePlugin.hashCode();
        result2 = result2 * 31 + this.allocatedResource.hashCode();
        result2 = result2 * 31 + ((Object)this.locations).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IdePluginClassesLocations)) {
            return false;
        }
        IdePluginClassesLocations idePluginClassesLocations = (IdePluginClassesLocations)other;
        if (!Intrinsics.areEqual(this.idePlugin, idePluginClassesLocations.idePlugin)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.allocatedResource, idePluginClassesLocations.allocatedResource)) {
            return false;
        }
        return Intrinsics.areEqual(this.locations, idePluginClassesLocations.locations);
    }
}

