/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.utils;

import com.jetbrains.plugin.structure.base.decompress.Decompressor;
import com.jetbrains.plugin.structure.base.decompress.TarDecompressor;
import com.jetbrains.plugin.structure.base.decompress.ZipCompressor;
import com.jetbrains.plugin.structure.base.decompress.ZipDecompressor;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import java.io.Closeable;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a'\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006\u001a\u0012\u0010\u0007\u001a\u00020\b*\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001\u001a#\u0010\t\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\n"}, d2={"extractZip", "Ljava/nio/file/Path;", "pluginFile", "destination", "outputSizeLimit", "", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/lang/Long;)Ljava/nio/file/Path;", "archiveDirectoryTo", "", "extractTo", "structure-base"})
public final class ZipUtilKt {
    @NotNull
    public static final Path extractZip(@NotNull Path pluginFile, @NotNull Path destination, @Nullable Long outputSizeLimit) {
        Intrinsics.checkNotNullParameter(pluginFile, "pluginFile");
        Intrinsics.checkNotNullParameter(destination, "destination");
        FileUtilKt.createDir(destination);
        new ZipDecompressor(pluginFile, outputSizeLimit).extract(destination);
        return destination;
    }

    public static /* synthetic */ Path extractZip$default(Path path, Path path2, Long l, int n, Object object) {
        if ((n & 4) != 0) {
            l = null;
        }
        return ZipUtilKt.extractZip(path, path2, l);
    }

    @NotNull
    public static final Path extractTo(@NotNull Path $this$extractTo, @NotNull Path destination, @Nullable Long outputSizeLimit) {
        Decompressor decompressor;
        Intrinsics.checkNotNullParameter($this$extractTo, "<this>");
        Intrinsics.checkNotNullParameter(destination, "destination");
        if (StringsKt.endsWith$default(FileUtilKt.getSimpleName($this$extractTo), ".zip", false, 2, null) || StringsKt.endsWith$default(FileUtilKt.getSimpleName($this$extractTo), ".sit", false, 2, null)) {
            decompressor = new ZipDecompressor($this$extractTo, outputSizeLimit);
        } else if (StringsKt.endsWith$default(FileUtilKt.getSimpleName($this$extractTo), ".tar.gz", false, 2, null)) {
            decompressor = new TarDecompressor($this$extractTo, outputSizeLimit);
        } else {
            throw new IllegalArgumentException("Unknown type archive type: " + destination.getFileName());
        }
        Decompressor decompressor2 = decompressor;
        FileUtilKt.createDir(destination);
        decompressor2.extract(destination);
        return destination;
    }

    public static /* synthetic */ Path extractTo$default(Path path, Path path2, Long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = null;
        }
        return ZipUtilKt.extractTo(path, path2, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void archiveDirectoryTo(@NotNull Path $this$archiveDirectoryTo, @NotNull Path destination) {
        Intrinsics.checkNotNullParameter($this$archiveDirectoryTo, "<this>");
        Intrinsics.checkNotNullParameter(destination, "destination");
        if (!(Intrinsics.areEqual(FileUtilKt.getExtension(destination), "zip") || Intrinsics.areEqual(FileUtilKt.getExtension(destination), "jar") || Intrinsics.areEqual(FileUtilKt.getExtension(destination), "nupkg"))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        FileUtilKt.forceDeleteIfExists(destination);
        Closeable closeable = new ZipCompressor(destination);
        Throwable throwable = null;
        try {
            ZipCompressor zip2 = (ZipCompressor)closeable;
            boolean bl = false;
            zip2.addDirectory($this$archiveDirectoryTo);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }
}

