/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.verifiers.hierarchy;

import com.jetbrains.pluginverifier.results.hierarchy.ClassHierarchy;
import com.jetbrains.pluginverifier.verifiers.VerificationContext;
import com.jetbrains.pluginverifier.verifiers.hierarchy.ClassParentsVisitor;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassFile;
import com.jetbrains.pluginverifier.verifiers.resolution.ResolutionUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/pluginverifier/verifiers/hierarchy/ClassHierarchyBuilder;", "", "context", "Lcom/jetbrains/pluginverifier/verifiers/VerificationContext;", "(Lcom/jetbrains/pluginverifier/verifiers/VerificationContext;)V", "buildClassHierarchy", "Lcom/jetbrains/pluginverifier/results/hierarchy/ClassHierarchy;", "classFile", "Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFile;", "verifier-core"})
public final class ClassHierarchyBuilder {
    @NotNull
    private final VerificationContext context;

    public ClassHierarchyBuilder(@NotNull VerificationContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
    }

    @NotNull
    public final ClassHierarchy buildClassHierarchy(@NotNull ClassFile classFile) {
        Intrinsics.checkNotNullParameter(classFile, "classFile");
        HashMap<String, ClassHierarchy> className2Hierarchy = new HashMap<String, ClassHierarchy>();
        ClassParentsVisitor parentsVisitor2 = new ClassParentsVisitor(true, (Function2<? super ClassFile, ? super String, ? extends ClassFile>)new Function2<ClassFile, String, ClassFile>(this){
            final /* synthetic */ ClassHierarchyBuilder this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @Nullable
            public final ClassFile invoke(@NotNull ClassFile subclassFile, @NotNull String superName) {
                Intrinsics.checkNotNullParameter(subclassFile, "subclassFile");
                Intrinsics.checkNotNullParameter(superName, "superName");
                return ResolutionUtilKt.resolveClassChecked$default(ClassHierarchyBuilder.access$getContext$p(this.this$0).getClassResolver(), superName, subclassFile, ClassHierarchyBuilder.access$getContext$p(this.this$0), null, 8, null);
            }
        });
        parentsVisitor2.visitClass(classFile, true, (Function1<? super ClassFile, Boolean>)new Function1<ClassFile, Boolean>(className2Hierarchy){
            final /* synthetic */ HashMap<String, ClassHierarchy> $className2Hierarchy;
            {
                this.$className2Hierarchy = $className2Hierarchy;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ClassFile parent) {
                Intrinsics.checkNotNullParameter(parent, "parent");
                ((Map)this.$className2Hierarchy).put(parent.getName(), new ClassHierarchy(parent.getName(), parent.isInterface(), null, CollectionsKt.emptyList()));
                return true;
            }
        }, (Function1<? super ClassFile, Unit>)new Function1<ClassFile, Unit>(className2Hierarchy){
            final /* synthetic */ HashMap<String, ClassHierarchy> $className2Hierarchy;
            {
                this.$className2Hierarchy = $className2Hierarchy;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ClassFile parent) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Intrinsics.checkNotNullParameter(parent, "parent");
                ClassHierarchy classHierarchy = this.$className2Hierarchy.get(parent.getName());
                Intrinsics.checkNotNull(classHierarchy);
                ClassHierarchy classHierarchy2 = classHierarchy;
                String superName = parent.getSuperName();
                if (superName != null) {
                    classHierarchy2.setSuperClass(this.$className2Hierarchy.get(superName));
                }
                Iterable iterable = parent.getInterfaces();
                HashMap<String, ClassHierarchy> hashMap = this.$className2Hierarchy;
                ClassHierarchy classHierarchy3 = classHierarchy2;
                boolean $i$f$mapNotNull = false;
                void var7_8 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    ClassHierarchy it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    String it = (String)element$iv$iv;
                    boolean bl2 = false;
                    if (hashMap.get(it) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                classHierarchy3.setSuperInterfaces((List)destination$iv$iv);
            }
        });
        ClassHierarchy classHierarchy = className2Hierarchy.get(classFile.getName());
        Intrinsics.checkNotNull(classHierarchy);
        return classHierarchy;
    }

    public static final /* synthetic */ VerificationContext access$getContext$p(ClassHierarchyBuilder $this) {
        return $this.context;
    }
}

