/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.ide;

import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import com.jetbrains.pluginverifier.ide.AvailableIde;
import com.jetbrains.pluginverifier.ide.IdeDownloadProvider;
import com.jetbrains.pluginverifier.ide.IdeDownloader;
import com.jetbrains.pluginverifier.ide.repositories.IdeRepository;
import com.jetbrains.pluginverifier.repository.downloader.DownloadProvider;
import com.jetbrains.pluginverifier.repository.provider.ProvideResult;
import com.jetbrains.pluginverifier.repository.provider.ResourceProvider;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/pluginverifier/ide/IdeDownloadProvider;", "Lcom/jetbrains/pluginverifier/repository/provider/ResourceProvider;", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "Ljava/nio/file/Path;", "bankDirectory", "ideRepository", "Lcom/jetbrains/pluginverifier/ide/repositories/IdeRepository;", "(Ljava/nio/file/Path;Lcom/jetbrains/pluginverifier/ide/repositories/IdeRepository;)V", "downloadProvider", "Lcom/jetbrains/pluginverifier/repository/downloader/DownloadProvider;", "Lcom/jetbrains/pluginverifier/ide/AvailableIde;", "getIdeRepository", "()Lcom/jetbrains/pluginverifier/ide/repositories/IdeRepository;", "provide", "Lcom/jetbrains/pluginverifier/repository/provider/ProvideResult;", "key", "verifier-repository"})
final class IdeDownloadProvider
implements ResourceProvider<IdeVersion, Path> {
    @NotNull
    private final IdeRepository ideRepository;
    @NotNull
    private final DownloadProvider<AvailableIde> downloadProvider;

    public IdeDownloadProvider(@NotNull Path bankDirectory, @NotNull IdeRepository ideRepository) {
        Intrinsics.checkNotNullParameter(bankDirectory, "bankDirectory");
        Intrinsics.checkNotNullParameter(ideRepository, "ideRepository");
        this.ideRepository = ideRepository;
        this.downloadProvider = new DownloadProvider(bankDirectory, new IdeDownloader(), downloadProvider.1.INSTANCE);
    }

    @NotNull
    public final IdeRepository getIdeRepository() {
        return this.ideRepository;
    }

    @Override
    @NotNull
    public ProvideResult<Path> provide(@NotNull IdeVersion key) {
        AvailableIde availableIde;
        Intrinsics.checkNotNullParameter(key, "key");
        try {
            availableIde = this.ideRepository.fetchAvailableIde(key);
        }
        catch (Exception e) {
            LanguageUtilsKt.rethrowIfInterrupted(e);
            return new ProvideResult.Failed("Failed to find IDE " + key + " ", e);
        }
        AvailableIde availableIde2 = availableIde;
        if (availableIde2 == null) {
            return new ProvideResult.NotFound("IDE " + key + " is not available");
        }
        AvailableIde availableIde3 = availableIde2;
        return this.downloadProvider.provide(availableIde3);
    }
}

