/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.ide;

import com.jetbrains.plugin.structure.ide.IntelliJPlatformProduct;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import com.jetbrains.pluginverifier.ide.AvailableIde;
import com.jetbrains.pluginverifier.ide.repositories.Download;
import com.jetbrains.pluginverifier.ide.repositories.Product;
import com.jetbrains.pluginverifier.ide.repositories.Release;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0006H\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J!\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010H\u0000\u00a2\u0006\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/pluginverifier/ide/DataServicesIndexParser;", "", "()V", "getBuildDownload", "Lcom/jetbrains/pluginverifier/ide/repositories/Download;", "downloads", "", "", "getIntelliJProduct", "Lcom/jetbrains/plugin/structure/ide/IntelliJPlatformProduct;", "product", "Lcom/jetbrains/pluginverifier/ide/repositories/Product;", "getReleaseVersion", "release", "Lcom/jetbrains/pluginverifier/ide/repositories/Release;", "parseAvailableIdes", "", "Lcom/jetbrains/pluginverifier/ide/AvailableIde;", "products", "parseAvailableIdes$verifier_repository", "verifier-repository"})
public final class DataServicesIndexParser {
    @NotNull
    public final List<AvailableIde> parseAvailableIdes$verifier_repository(@NotNull List<Product> products) {
        Intrinsics.checkNotNullParameter(products, "products");
        ArrayList<AvailableIde> availableIdes = new ArrayList<AvailableIde>();
        for (Product product : products) {
            IntelliJPlatformProduct intelliJPlatformProduct = this.getIntelliJProduct(product);
            if (intelliJPlatformProduct == null) continue;
            for (Release release : product.getReleases()) {
                Download download;
                if (release.getDownloads() == null || (download = this.getBuildDownload(release.getDownloads())) == null || release.getBuild() == null) continue;
                URL downloadUrl = new URL(download.getLink());
                IdeVersion ideVersion = IdeVersion.createIdeVersionIfValid(release.getBuild());
                IdeVersion ideVersion2 = ideVersion != null ? (IdeVersion)ideVersion.setProductCodeIfAbsent(intelliJPlatformProduct.getProductCode()) : null;
                if (ideVersion2 == null) continue;
                String releaseVersion = this.getReleaseVersion(release);
                LocalDate uploadDate = LocalDate.parse(release.getDate());
                Intrinsics.checkNotNullExpressionValue(uploadDate, "uploadDate");
                AvailableIde availableIde = new AvailableIde(ideVersion2, releaseVersion, downloadUrl, uploadDate, intelliJPlatformProduct);
                availableIdes.add(availableIde);
            }
        }
        return availableIdes;
    }

    private final String getReleaseVersion(Release release) {
        return Intrinsics.areEqual(release.getType(), "release") ? release.getVersion() : null;
    }

    private final IntelliJPlatformProduct getIntelliJProduct(Product product) {
        return IntelliJPlatformProduct.Companion.fromProductCode(product.getCode());
    }

    private final Download getBuildDownload(Map<String, Download> downloads) {
        Download download = downloads.get("linux");
        if (download == null) {
            download = downloads.get("zip");
        }
        return download;
    }
}

