/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.dependencies;

import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.PluginDependency;
import com.jetbrains.plugin.structure.intellij.plugin.dependencies.DependenciesKt;
import com.jetbrains.plugin.structure.intellij.plugin.dependencies.Dependency;
import com.jetbrains.plugin.structure.intellij.plugin.dependencies.DependencyTreeResolution;
import com.jetbrains.pluginverifier.dependencies.DependenciesGraph;
import com.jetbrains.pluginverifier.dependencies.DependencyEdge;
import com.jetbrains.pluginverifier.dependencies.DependencyNode;
import com.jetbrains.pluginverifier.dependencies.MissingDependency;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\u00020\u000bH\u0002J\u001e\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0010*\u00020\u000bH\u0002J\u0012\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\r*\u00020\u000bH\u0002J\u0012\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\r*\u00020\u0015H\u0002J\f\u0010\u0016\u001a\u00020\u0007*\u00020\u0007H\u0002J\f\u0010\u0016\u001a\u00020\u0005*\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/pluginverifier/dependencies/DependenciesGraphProvider;", "", "()V", "dependencyNodeCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/jetbrains/pluginverifier/dependencies/DependencyNode;", "pluginDependencyCache", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDependency;", "getDependenciesGraph", "Lcom/jetbrains/pluginverifier/dependencies/DependenciesGraph;", "dependencyTreeResolution", "Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/DependencyTreeResolution;", "getEdges", "", "Lcom/jetbrains/pluginverifier/dependencies/DependencyEdge;", "getMissingDependencies", "", "", "Lcom/jetbrains/pluginverifier/dependencies/MissingDependency;", "getTransitiveDependencyVertices", "getVertices", "Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/Dependency$Module;", "intern", "verifier-intellij"})
@SourceDebugExtension(value={"SMAP\nDependenciesGraphProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependenciesGraphProvider.kt\ncom/jetbrains/pluginverifier/dependencies/DependenciesGraphProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,81:1\n1360#2:82\n1446#2,5:83\n1620#2,3:91\n1549#2:95\n1620#2,3:96\n125#3:88\n152#3,2:89\n154#3:94\n*S KotlinDebug\n*F\n+ 1 DependenciesGraphProvider.kt\ncom/jetbrains/pluginverifier/dependencies/DependenciesGraphProvider\n*L\n33#1:82\n33#1:83,5\n62#1:91,3\n74#1:95\n74#1:96,3\n60#1:88\n60#1:89,2\n60#1:94\n*E\n"})
public final class DependenciesGraphProvider {
    @NotNull
    private final ConcurrentHashMap<PluginDependency, PluginDependency> pluginDependencyCache = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<DependencyNode, DependencyNode> dependencyNodeCache = new ConcurrentHashMap();

    @NotNull
    public final DependenciesGraph getDependenciesGraph(@NotNull DependencyTreeResolution dependencyTreeResolution) {
        Intrinsics.checkNotNullParameter(dependencyTreeResolution, "dependencyTreeResolution");
        DependencyNode verifiedPlugin = new DependencyNode(DependenciesKt.getId(dependencyTreeResolution.getDependencyRoot()), "unknown version");
        List<DependencyNode> transitiveDependencyVertices = this.getTransitiveDependencyVertices(dependencyTreeResolution);
        List<DependencyNode> vertices = CollectionsKt.plus((Collection)transitiveDependencyVertices, verifiedPlugin);
        List<DependencyEdge> edges = this.getEdges(dependencyTreeResolution);
        Map<DependencyNode, Set<MissingDependency>> missingDependencies = this.getMissingDependencies(dependencyTreeResolution);
        return new DependenciesGraph(verifiedPlugin, vertices, edges, missingDependencies);
    }

    /*
     * WARNING - void declaration
     */
    private final List<DependencyNode> getTransitiveDependencyVertices(DependencyTreeResolution $this$getTransitiveDependencyVertices) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = $this$getTransitiveDependencyVertices.getTransitiveDependencies();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Collection collection;
            Dependency it = (Dependency)element$iv$iv;
            boolean bl = false;
            Dependency dependency = it;
            if (dependency instanceof Dependency.Module) {
                collection = this.getVertices((Dependency.Module)it);
            } else if (dependency instanceof Dependency.Plugin) {
                collection = SetsKt.setOf(new DependencyNode(DependenciesKt.getId(it), "unknown version"));
            } else if (Intrinsics.areEqual(dependency, Dependency.None.INSTANCE)) {
                collection = SetsKt.emptySet();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Iterable list$iv$iv = collection;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<DependencyEdge> getEdges(DependencyTreeResolution $this$getEdges) {
        List edges = new ArrayList();
        $this$getEdges.forEach((Function2<? super String, ? super PluginDependency, Unit>)new Function2<String, PluginDependency, Unit>((List<DependencyEdge>)edges, this){
            final /* synthetic */ List<DependencyEdge> $edges;
            final /* synthetic */ DependenciesGraphProvider this$0;
            {
                this.$edges = $edges;
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String id, @NotNull PluginDependency dependency) {
                Intrinsics.checkNotNullParameter(id, "id");
                Intrinsics.checkNotNullParameter(dependency, "dependency");
                ((Collection)this.$edges).add(new DependencyEdge(DependenciesGraphProvider.access$intern(this.this$0, new DependencyNode(id, "unknown version")), DependenciesGraphProvider.access$intern(this.this$0, new DependencyNode(dependency.getId(), "unknown version")), DependenciesGraphProvider.access$intern(this.this$0, dependency)));
            }
        });
        return edges;
    }

    private final PluginDependency intern(PluginDependency $this$intern) {
        PluginDependency pluginDependency = this.pluginDependencyCache.computeIfAbsent($this$intern, Function.identity());
        Intrinsics.checkNotNullExpressionValue(pluginDependency, "pluginDependencyCache.co\u2026his, Function.identity())");
        return pluginDependency;
    }

    private final DependencyNode intern(DependencyNode $this$intern) {
        DependencyNode dependencyNode = this.dependencyNodeCache.computeIfAbsent($this$intern, Function.identity());
        Intrinsics.checkNotNullExpressionValue(dependencyNode, "dependencyNodeCache.comp\u2026his, Function.identity())");
        return dependencyNode;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<DependencyNode, Set<MissingDependency>> getMissingDependencies(DependencyTreeResolution $this$getMissingDependencies) {
        void $this$mapTo$iv$iv;
        Map<IdePlugin, Set<PluginDependency>> $this$map$iv = $this$getMissingDependencies.getMissingDependencies();
        boolean $i$f$map = false;
        Map<IdePlugin, Set<PluginDependency>> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void destination$iv;
            void $this$mapTo$iv;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IdePlugin plugin = (IdePlugin)entry.getKey();
            Set dependencies = (Set)entry.getValue();
            DependencyNode pluginNode = new DependencyNode(DependenciesKt.getId(plugin), "unknown version");
            Iterable iterable = dependencies;
            Collection collection2 = new LinkedHashSet();
            boolean $i$f$mapTo2 = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                PluginDependency pluginDependency = (PluginDependency)item$iv;
                void var20_20 = destination$iv;
                boolean bl2 = false;
                var20_20.add(new MissingDependency((PluginDependency)it, "Unavailable"));
            }
            Set dependencyNodes = (Set)destination$iv;
            collection.add(TuplesKt.to(pluginNode, dependencyNodes));
        }
        return MapsKt.toMap((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final List<DependencyNode> getVertices(Dependency.Module $this$getVertices) {
        void $this$mapTo$iv$iv;
        List vertices = new ArrayList();
        ((Collection)vertices).add(new DependencyNode($this$getVertices.getId(), "unknown version"));
        ((Collection)vertices).add(new DependencyNode(DependenciesKt.getId($this$getVertices.getPlugin()), "unknown version"));
        Iterable $this$map$iv = $this$getVertices.getPlugin().getDefinedModules();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void alias;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            new DependencyNode((String)alias, "unknown version");
            collection.add(new DependencyNode($this$getVertices.getId(), "unknown version"));
        }
        List definedModuleNodes = (List)destination$iv$iv;
        CollectionsKt.addAll((Collection)vertices, definedModuleNodes);
        return vertices;
    }

    public static final /* synthetic */ DependencyNode access$intern(DependenciesGraphProvider $this, DependencyNode $receiver) {
        return $this.intern($receiver);
    }

    public static final /* synthetic */ PluginDependency access$intern(DependenciesGraphProvider $this, PluginDependency $receiver) {
        return $this.intern($receiver);
    }
}

