/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.jar;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.jetbrains.plugin.structure.jar.CachingJarFileSystemProvider;
import com.jetbrains.plugin.structure.jar.CachingJarFileSystemProviderKt;
import com.jetbrains.plugin.structure.jar.FsHandleFileSystem;
import com.jetbrains.plugin.structure.jar.JarFileSystemProvider;
import com.jetbrains.plugin.structure.jar.JarsKt;
import com.jetbrains.plugin.structure.jar.UriJarFileSystemProvider;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.AbstractList;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002:\u0001&B\u0019\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u0010H\u0002J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u0010H\u0002J\u0010\u0010%\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u0010H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rRN\u0010\u000e\u001aB\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00120\u0012 \u0011* \u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00120\u0012\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006'"}, d2={"Lcom/jetbrains/plugin/structure/jar/CachingJarFileSystemProvider;", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "Ljava/lang/AutoCloseable;", "retentionTimeInSeconds", "", "enableEventLogging", "", "(JZ)V", "delegateJarFileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/UriJarFileSystemProvider;", "eventLog", "Lcom/jetbrains/plugin/structure/jar/CachingJarFileSystemProvider$EventLog;", "getEventLog", "()Lcom/jetbrains/plugin/structure/jar/CachingJarFileSystemProvider$EventLog;", "fsCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "kotlin.jvm.PlatformType", "Lcom/jetbrains/plugin/structure/jar/FsHandleFileSystem;", "getRetentionTimeInSeconds", "()J", "close", "", "createFileSystem", "jarPath", "Ljava/nio/file/Path;", "jarUri", "Ljava/net/URI;", "getFileSystem", "Ljava/nio/file/FileSystem;", "configuration", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider$Configuration;", "expectedClients", "", "logCreatedFs", "uriString", "logRecreatedFs", "logReusedFs", "EventLog", "structure-base"})
public final class CachingJarFileSystemProvider
implements JarFileSystemProvider,
AutoCloseable {
    private final long retentionTimeInSeconds;
    private final boolean enableEventLogging;
    @NotNull
    private final UriJarFileSystemProvider delegateJarFileSystemProvider;
    private final Cache<String, FsHandleFileSystem> fsCache;
    @NotNull
    private final EventLog eventLog;

    public CachingJarFileSystemProvider(long retentionTimeInSeconds, boolean enableEventLogging) {
        this.retentionTimeInSeconds = retentionTimeInSeconds;
        this.enableEventLogging = enableEventLogging;
        this.delegateJarFileSystemProvider = new UriJarFileSystemProvider(delegateJarFileSystemProvider.1.INSTANCE);
        this.fsCache = Caffeine.newBuilder().maximumSize(128L).expireAfterAccess(this.retentionTimeInSeconds, TimeUnit.SECONDS).build();
        this.eventLog = new EventLog();
    }

    public /* synthetic */ CachingJarFileSystemProvider(long l, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 1) != 0) {
            Long l2;
            String string = System.getProperty("com.jetbrains.plugin.structure.jar.SingletonCachingJarFileSystemProvider.retentionTime");
            long l3 = l = string != null && (l2 = StringsKt.toLongOrNull(string)) != null ? l2 : 10L;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        this(l, bl);
    }

    public final long getRetentionTimeInSeconds() {
        return this.retentionTimeInSeconds;
    }

    @NotNull
    public final EventLog getEventLog() {
        return this.eventLog;
    }

    private final FsHandleFileSystem createFileSystem(Path jarPath, URI jarUri) {
        FileSystem fileSystem;
        FileSystem it = fileSystem = this.delegateJarFileSystemProvider.getFileSystem(jarPath);
        boolean bl = false;
        CachingJarFileSystemProviderKt.access$getLOG$p().debug("Creating a filesystem handler via delegate for <{}> (Cache size: {})", (Object)jarUri, (Object)this.fsCache.estimatedSize());
        FileSystem jarFs = fileSystem;
        return new FsHandleFileSystem(jarFs, this.delegateJarFileSystemProvider, jarPath);
    }

    @Override
    @NotNull
    public synchronized FileSystem getFileSystem(@NotNull Path jarPath) {
        Intrinsics.checkNotNullParameter(jarPath, "jarPath");
        return this.getFileSystem(jarPath, 1);
    }

    @Override
    @NotNull
    public synchronized FileSystem getFileSystem(@NotNull Path jarPath, @NotNull JarFileSystemProvider.Configuration configuration) {
        Intrinsics.checkNotNullParameter(jarPath, "jarPath");
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        return this.getFileSystem(jarPath, configuration.getExpectedClients());
    }

    private final synchronized FileSystem getFileSystem(Path jarPath, int expectedClients) {
        URI jarUri = JarsKt.toJarFileUri(jarPath);
        String string = jarUri.toString();
        Intrinsics.checkNotNullExpressionValue(string, "jarUri.toString()");
        String key = string;
        FsHandleFileSystem fs = this.fsCache.getIfPresent(key);
        if (fs != null) {
            if (fs.isOpen()) {
                fs.increment(expectedClients);
                this.logReusedFs(key);
            } else {
                FileSystem fileSystem;
                FileSystem it = fileSystem = this.delegateJarFileSystemProvider.getFileSystem(jarPath);
                boolean bl = false;
                CachingJarFileSystemProviderKt.access$getLOG$p().debug("Recreating an already closed a filesystem handler for <{}> (Cache size: {})", (Object)key, (Object)this.fsCache.estimatedSize());
                FileSystem jarFs = fileSystem;
                fs = new FsHandleFileSystem(jarFs, this.delegateJarFileSystemProvider, jarPath);
                this.fsCache.put(key, fs);
                this.logRecreatedFs(key);
            }
        } else {
            fs = this.createFileSystem(jarPath, jarUri);
            this.fsCache.put(key, fs);
            this.logCreatedFs(key);
        }
        return fs;
    }

    @Override
    public void close() {
        this.fsCache.invalidateAll();
    }

    private final void logCreatedFs(String uriString) {
        if (this.enableEventLogging) {
            this.eventLog.logCreated(uriString);
        }
    }

    private final void logReusedFs(String uriString) {
        CachingJarFileSystemProviderKt.access$getLOG$p().debug("Reusing filesystem handler for <{}> (Cache size: {})", (Object)uriString, (Object)this.fsCache.estimatedSize());
        if (this.enableEventLogging) {
            this.eventLog.logReused(uriString);
        }
    }

    private final void logRecreatedFs(String uriString) {
        if (this.enableEventLogging) {
            this.eventLog.logRecreated(uriString);
        }
    }

    public CachingJarFileSystemProvider() {
        this(0L, false, 3, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0011\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0007H\u0096\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/plugin/structure/jar/CachingJarFileSystemProvider$EventLog;", "Lkotlin/collections/AbstractList;", "Lcom/jetbrains/plugin/structure/jar/CachingJarFileSystemProvider$EventLog$Event;", "()V", "events", "", "size", "", "getSize", "()I", "get", "index", "logCreated", "", "key", "", "logRecreated", "logReused", "Event", "structure-base"})
    public static final class EventLog
    extends AbstractList<Event> {
        @NotNull
        private final List<Event> events = new ArrayList();

        public final void logCreated(@NotNull String key) {
            Intrinsics.checkNotNullParameter(key, "key");
            ((Collection)this.events).add(new Event.Created(key));
        }

        public final void logReused(@NotNull String key) {
            Intrinsics.checkNotNullParameter(key, "key");
            ((Collection)this.events).add(new Event.Reused(key));
        }

        public final void logRecreated(@NotNull String key) {
            Intrinsics.checkNotNullParameter(key, "key");
            ((Collection)this.events).add(new Event.Recreated(key));
        }

        @Override
        public int getSize() {
            return this.events.size();
        }

        @Override
        @NotNull
        public Event get(int index) {
            return this.events.get(index);
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/plugin/structure/jar/CachingJarFileSystemProvider$EventLog$Event;", "", "()V", "Created", "Recreated", "Reused", "Lcom/jetbrains/plugin/structure/jar/CachingJarFileSystemProvider$EventLog$Event$Created;", "Lcom/jetbrains/plugin/structure/jar/CachingJarFileSystemProvider$EventLog$Event$Recreated;", "Lcom/jetbrains/plugin/structure/jar/CachingJarFileSystemProvider$EventLog$Event$Reused;", "structure-base"})
        public static abstract class Event {
            private Event() {
            }

            public /* synthetic */ Event(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/plugin/structure/jar/CachingJarFileSystemProvider$EventLog$Event$Created;", "Lcom/jetbrains/plugin/structure/jar/CachingJarFileSystemProvider$EventLog$Event;", "key", "", "(Ljava/lang/String;)V", "getKey", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "structure-base"})
            public static final class Created
            extends Event {
                @NotNull
                private final String key;

                public Created(@NotNull String key) {
                    Intrinsics.checkNotNullParameter(key, "key");
                    super(null);
                    this.key = key;
                }

                @NotNull
                public final String getKey() {
                    return this.key;
                }

                @NotNull
                public final String component1() {
                    return this.key;
                }

                @NotNull
                public final Created copy(@NotNull String key) {
                    Intrinsics.checkNotNullParameter(key, "key");
                    return new Created(key);
                }

                public static /* synthetic */ Created copy$default(Created created, String string, int n, Object object) {
                    if ((n & 1) != 0) {
                        string = created.key;
                    }
                    return created.copy(string);
                }

                @NotNull
                public String toString() {
                    return "Created(key=" + this.key + ")";
                }

                public int hashCode() {
                    return this.key.hashCode();
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Created)) {
                        return false;
                    }
                    Created created = (Created)other;
                    return Intrinsics.areEqual(this.key, created.key);
                }
            }

            @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/plugin/structure/jar/CachingJarFileSystemProvider$EventLog$Event$Recreated;", "Lcom/jetbrains/plugin/structure/jar/CachingJarFileSystemProvider$EventLog$Event;", "key", "", "(Ljava/lang/String;)V", "getKey", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "structure-base"})
            public static final class Recreated
            extends Event {
                @NotNull
                private final String key;

                public Recreated(@NotNull String key) {
                    Intrinsics.checkNotNullParameter(key, "key");
                    super(null);
                    this.key = key;
                }

                @NotNull
                public final String getKey() {
                    return this.key;
                }

                @NotNull
                public final String component1() {
                    return this.key;
                }

                @NotNull
                public final Recreated copy(@NotNull String key) {
                    Intrinsics.checkNotNullParameter(key, "key");
                    return new Recreated(key);
                }

                public static /* synthetic */ Recreated copy$default(Recreated recreated, String string, int n, Object object) {
                    if ((n & 1) != 0) {
                        string = recreated.key;
                    }
                    return recreated.copy(string);
                }

                @NotNull
                public String toString() {
                    return "Recreated(key=" + this.key + ")";
                }

                public int hashCode() {
                    return this.key.hashCode();
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Recreated)) {
                        return false;
                    }
                    Recreated recreated = (Recreated)other;
                    return Intrinsics.areEqual(this.key, recreated.key);
                }
            }

            @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/plugin/structure/jar/CachingJarFileSystemProvider$EventLog$Event$Reused;", "Lcom/jetbrains/plugin/structure/jar/CachingJarFileSystemProvider$EventLog$Event;", "key", "", "(Ljava/lang/String;)V", "getKey", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "structure-base"})
            public static final class Reused
            extends Event {
                @NotNull
                private final String key;

                public Reused(@NotNull String key) {
                    Intrinsics.checkNotNullParameter(key, "key");
                    super(null);
                    this.key = key;
                }

                @NotNull
                public final String getKey() {
                    return this.key;
                }

                @NotNull
                public final String component1() {
                    return this.key;
                }

                @NotNull
                public final Reused copy(@NotNull String key) {
                    Intrinsics.checkNotNullParameter(key, "key");
                    return new Reused(key);
                }

                public static /* synthetic */ Reused copy$default(Reused reused, String string, int n, Object object) {
                    if ((n & 1) != 0) {
                        string = reused.key;
                    }
                    return reused.copy(string);
                }

                @NotNull
                public String toString() {
                    return "Reused(key=" + this.key + ")";
                }

                public int hashCode() {
                    return this.key.hashCode();
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Reused)) {
                        return false;
                    }
                    Reused reused = (Reused)other;
                    return Intrinsics.areEqual(this.key, reused.key);
                }
            }
        }
    }
}

