/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin;

import com.jetbrains.plugin.structure.intellij.plugin.PluginDependency;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class PluginDependencyImpl
implements PluginDependency {
    private final String myId;
    private boolean myIsOptional;
    private final boolean myIsModule;

    public PluginDependencyImpl(@NotNull String id, boolean isOptional, boolean isModule) {
        this.myId = id;
        this.myIsOptional = isOptional;
        this.myIsModule = isModule;
    }

    @Override
    @NotNull
    public String getId() {
        return this.myId;
    }

    @Override
    public boolean isOptional() {
        return this.myIsOptional;
    }

    @Override
    public boolean isModule() {
        return this.myIsModule;
    }

    public String toString() {
        return (this.myIsModule ? "module " : "") + this.myId + (this.myIsOptional ? " (optional)" : "");
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginDependencyImpl that = (PluginDependencyImpl)o;
        return this.myIsOptional == that.myIsOptional && this.myIsModule == that.myIsModule && Objects.equals(this.myId, that.myId);
    }

    public int hashCode() {
        return Objects.hash(this.myId, this.myIsOptional, this.myIsModule);
    }

    @Override
    @NotNull
    public PluginDependency asOptional() {
        return new PluginDependencyImpl(this.myId, true, this.myIsModule);
    }
}

