/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.classes.resolvers;

import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.base.zip.ZipHandler;
import com.jetbrains.plugin.structure.base.zip.ZipHandlerKt;
import com.jetbrains.plugin.structure.base.zip.ZipResource;
import com.jetbrains.plugin.structure.classes.resolvers.AbstractJarResolver;
import com.jetbrains.plugin.structure.classes.resolvers.FileOrigin;
import com.jetbrains.plugin.structure.classes.resolvers.InvalidClassFileException;
import com.jetbrains.plugin.structure.classes.resolvers.LazyJarResolver;
import com.jetbrains.plugin.structure.classes.resolvers.ResolutionResult;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.plugin.structure.classes.resolvers.ResourceBundleNameSet;
import com.jetbrains.plugin.structure.classes.utils.AsmUtil;
import com.jetbrains.plugin.structure.jar.Jar;
import com.jetbrains.plugin.structure.jar.JarFileSystemProvider;
import com.jetbrains.plugin.structure.jar.SingletonCachingJarFileSystemProvider;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.Set;
import java.util.zip.ZipEntry;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010%\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010@\u001a\u00020AH\u0016J\u0014\u0010B\u001a\u00020C2\n\u0010D\u001a\u00060\u0016j\u0002`\u0017H\u0016J\u0010\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\nH\u0017J\u0010\u0010E\u001a\u00020C2\u0006\u0010F\u001a\u00020\nH\u0016J\"\u0010G\u001a\u00020C2\u0018\u0010H\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020K0J\u0012\u0004\u0012\u00020C0IH\u0016J \u0010L\u001a\b\u0012\u0004\u0012\u00020K0J2\u0006\u0010D\u001a\u00020\u00162\n\u0010M\u001a\u00060\u0016j\u0002`NJ\u0012\u0010O\u001a\u0004\u0018\u00010P2\u0006\u0010Q\u001a\u00020\nH\u0014J\u001a\u0010R\u001a\b\u0012\u0004\u0012\u00020K0J2\n\u0010D\u001a\u00060\u0016j\u0002`\u0017H\u0016J\u0016\u0010R\u001a\b\u0012\u0004\u0012\u00020K0J2\u0006\u0010D\u001a\u00020\nH\u0017R\u001b\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R%\u0010\u0014\u001a\f\u0012\b\u0012\u00060\u0016j\u0002`\u00170\u00158VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0013\u001a\u0004\b\u0018\u0010\u0019R'\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u00158VX\u0097\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001f\u0010\u0013\u0012\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u0019R'\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\u00158VX\u0097\u0084\u0002\u00a2\u0006\u0012\n\u0004\b#\u0010\u0013\u0012\u0004\b!\u0010\u001d\u001a\u0004\b\"\u0010\u0019R&\u0010$\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0&0%8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010\u0007\u001a\u00020\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00150,8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010\u0013\u001a\u0004\b-\u0010(R\u001b\u0010/\u001a\u0002008BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b3\u0010\u0013\u001a\u0004\b1\u00102R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R!\u00108\u001a\b\u0012\u0004\u0012\u00020\n0\u00158VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b:\u0010\u0013\u001a\u0004\b9\u0010\u0019R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u0016\u0010=\u001a\n\u0012\u0006\b\u0001\u0012\u00020?0>X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lcom/jetbrains/plugin/structure/classes/resolvers/LazyJarResolver;", "Lcom/jetbrains/plugin/structure/classes/resolvers/AbstractJarResolver;", "Ljava/lang/AutoCloseable;", "jarPath", "Ljava/nio/file/Path;", "readMode", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "fileOrigin", "Lcom/jetbrains/plugin/structure/classes/resolvers/FileOrigin;", "name", "", "fileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "(Ljava/nio/file/Path;Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;Lcom/jetbrains/plugin/structure/classes/resolvers/FileOrigin;Ljava/lang/String;Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;)V", "allBundleNameSet", "Lcom/jetbrains/plugin/structure/classes/resolvers/ResourceBundleNameSet;", "getAllBundleNameSet", "()Lcom/jetbrains/plugin/structure/classes/resolvers/ResourceBundleNameSet;", "allBundleNameSet$delegate", "Lkotlin/Lazy;", "allClassNames", "", "", "Lcom/jetbrains/plugin/structure/base/BinaryClassName;", "getAllClassNames", "()Ljava/util/Set;", "allClassNames$delegate", "allClasses", "getAllClasses$annotations", "()V", "getAllClasses", "allClasses$delegate", "allPackages", "getAllPackages$annotations", "getAllPackages", "allPackages$delegate", "bundleNames", "", "", "getBundleNames", "()Ljava/util/Map;", "getFileOrigin", "()Lcom/jetbrains/plugin/structure/classes/resolvers/FileOrigin;", "implementedServiceProviders", "", "getImplementedServiceProviders", "implementedServiceProviders$delegate", "jar", "Lcom/jetbrains/plugin/structure/jar/Jar;", "getJar", "()Lcom/jetbrains/plugin/structure/jar/Jar;", "jar$delegate", "getJarPath", "()Ljava/nio/file/Path;", "getName", "()Ljava/lang/String;", "packages", "getPackages", "packages$delegate", "getReadMode", "()Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "zipHandler", "Lcom/jetbrains/plugin/structure/base/zip/ZipHandler;", "Lcom/jetbrains/plugin/structure/base/zip/ZipResource;", "close", "", "containsClass", "", "className", "containsPackage", "packageName", "processAllClasses", "processor", "Lkotlin/Function1;", "Lcom/jetbrains/plugin/structure/classes/resolvers/ResolutionResult;", "Lorg/objectweb/asm/tree/ClassNode;", "readClass", "classPath", "Lcom/jetbrains/plugin/structure/jar/PathInJar;", "readPropertyResourceBundle", "Ljava/util/PropertyResourceBundle;", "bundleResourceName", "resolveClass", "structure-classes"})
@SourceDebugExtension(value={"SMAP\nLazyJarResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyJarResolver.kt\ncom/jetbrains/plugin/structure/classes/resolvers/LazyJarResolver\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n453#2:106\n403#2:107\n1238#3,4:108\n*E\n*S KotlinDebug\n*F\n+ 1 LazyJarResolver.kt\ncom/jetbrains/plugin/structure/classes/resolvers/LazyJarResolver\n*L\n34#1:106\n34#1:107\n34#1,4:108\n*E\n"})
public final class LazyJarResolver
extends AbstractJarResolver
implements AutoCloseable {
    @NotNull
    private final Path jarPath;
    @NotNull
    private final Resolver.ReadMode readMode;
    @NotNull
    private final FileOrigin fileOrigin;
    @NotNull
    private final String name;
    @NotNull
    private final JarFileSystemProvider fileSystemProvider;
    @NotNull
    private final Lazy jar$delegate;
    @NotNull
    private final ZipHandler<? extends ZipResource> zipHandler;
    @NotNull
    private final Lazy allClasses$delegate;
    @NotNull
    private final Lazy allClassNames$delegate;
    @NotNull
    private final Lazy allPackages$delegate;
    @NotNull
    private final Lazy packages$delegate;
    @NotNull
    private final Lazy allBundleNameSet$delegate;
    @NotNull
    private final Lazy implementedServiceProviders$delegate;

    public LazyJarResolver(@NotNull Path jarPath, @NotNull Resolver.ReadMode readMode, @NotNull FileOrigin fileOrigin, @NotNull String name, @NotNull JarFileSystemProvider fileSystemProvider) {
        Intrinsics.checkNotNullParameter(jarPath, "jarPath");
        Intrinsics.checkNotNullParameter((Object)readMode, "readMode");
        Intrinsics.checkNotNullParameter(fileOrigin, "fileOrigin");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(fileSystemProvider, "fileSystemProvider");
        super(jarPath, readMode, fileOrigin, null, 8, null);
        this.jarPath = jarPath;
        this.readMode = readMode;
        this.fileOrigin = fileOrigin;
        this.name = name;
        this.fileSystemProvider = fileSystemProvider;
        this.jar$delegate = LazyKt.lazy((Function0)new Function0<Jar>(this){
            final /* synthetic */ LazyJarResolver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Jar invoke() {
                return new Jar(this.this$0.getJarPath(), LazyJarResolver.access$getFileSystemProvider$p(this.this$0), null, 4, null).init();
            }
        });
        this.zipHandler = ZipHandlerKt.newZipHandler(this.getJarPath());
        this.allClasses$delegate = LazyKt.lazy((Function0)new Function0<HashSet<String>>(this){
            final /* synthetic */ LazyJarResolver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final HashSet<String> invoke() {
                void var2_2;
                void $this$mapTo$iv;
                Iterable iterable = LazyJarResolver.access$getJar(this.this$0).getClasses();
                Collection destination$iv = new HashSet<E>();
                boolean $i$f$mapTo = false;
                for (T item$iv : $this$mapTo$iv) {
                    void it;
                    CharSequence charSequence = (CharSequence)item$iv;
                    Collection collection = destination$iv;
                    boolean bl = false;
                    collection.add(it.toString());
                }
                return (HashSet)var2_2;
            }
        });
        this.allClassNames$delegate = LazyKt.lazy((Function0)new Function0<Set<? extends CharSequence>>(this){
            final /* synthetic */ LazyJarResolver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Set<CharSequence> invoke() {
                return LazyJarResolver.access$getJar(this.this$0).getClasses();
            }
        });
        this.allPackages$delegate = LazyKt.lazy((Function0)new Function0<Set<? extends String>>(this){
            final /* synthetic */ LazyJarResolver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Set<String> invoke() {
                return LazyJarResolver.access$getJar(this.this$0).getPackages().getAll();
            }
        });
        this.packages$delegate = LazyKt.lazy((Function0)new Function0<Set<? extends String>>(this){
            final /* synthetic */ LazyJarResolver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Set<String> invoke() {
                return LazyJarResolver.access$getJar(this.this$0).getPackages().getEntries();
            }
        });
        this.allBundleNameSet$delegate = LazyKt.lazy((Function0)new Function0<ResourceBundleNameSet>(this){
            final /* synthetic */ LazyJarResolver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ResourceBundleNameSet invoke() {
                return new ResourceBundleNameSet(LazyJarResolver.access$getJar(this.this$0).getBundleNames());
            }
        });
        this.implementedServiceProviders$delegate = LazyKt.lazy((Function0)new Function0<Map<String, ? extends Set<? extends String>>>(this){
            final /* synthetic */ LazyJarResolver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Map<String, Set<String>> invoke() {
                return LazyJarResolver.access$getJar(this.this$0).getServiceProviders();
            }
        });
    }

    public /* synthetic */ LazyJarResolver(Path path, Resolver.ReadMode readMode, FileOrigin fileOrigin, String string, JarFileSystemProvider jarFileSystemProvider, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 8) != 0) {
            string = ((Object)path.getFileName()).toString();
        }
        if ((n & 0x10) != 0) {
            jarFileSystemProvider = SingletonCachingJarFileSystemProvider.INSTANCE;
        }
        this(path, readMode, fileOrigin, string, jarFileSystemProvider);
    }

    @Override
    @NotNull
    public Path getJarPath() {
        return this.jarPath;
    }

    @Override
    @NotNull
    public Resolver.ReadMode getReadMode() {
        return this.readMode;
    }

    @Override
    @NotNull
    protected FileOrigin getFileOrigin() {
        return this.fileOrigin;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    private final Jar getJar() {
        Lazy lazy = this.jar$delegate;
        return (Jar)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Map<String, Set<String>> getBundleNames() {
        void $this$mapValuesTo$iv$iv;
        Map<String, Set<String>> $this$mapValues$iv = this.getJar().getBundleNames();
        boolean $i$f$mapValues = false;
        Map<String, Set<String>> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Set set = CollectionsKt.toMutableSet((Iterable)it.getValue());
            map3.put(k, set);
        }
        return MapsKt.toMutableMap(destination$iv$iv);
    }

    @Override
    @NotNull
    public Set<String> getAllClasses() {
        Lazy lazy = this.allClasses$delegate;
        return (Set)lazy.getValue();
    }

    @Deprecated(message="Use 'allClassNames' property instead which is more efficient")
    public static /* synthetic */ void getAllClasses$annotations() {
    }

    @Override
    @NotNull
    public Set<CharSequence> getAllClassNames() {
        Lazy lazy = this.allClassNames$delegate;
        return (Set)lazy.getValue();
    }

    @Override
    @NotNull
    public Set<String> getAllPackages() {
        Lazy lazy = this.allPackages$delegate;
        return (Set)lazy.getValue();
    }

    @Deprecated(message="Use 'packages' property instead. This property may be slow on some file systems.")
    public static /* synthetic */ void getAllPackages$annotations() {
    }

    @Override
    @NotNull
    public Set<String> getPackages() {
        Lazy lazy = this.packages$delegate;
        return (Set)lazy.getValue();
    }

    @Override
    @NotNull
    public ResourceBundleNameSet getAllBundleNameSet() {
        Lazy lazy = this.allBundleNameSet$delegate;
        return (ResourceBundleNameSet)lazy.getValue();
    }

    @Override
    @NotNull
    public Map<String, Set<String>> getImplementedServiceProviders() {
        Lazy lazy = this.implementedServiceProviders$delegate;
        return (Map)lazy.getValue();
    }

    @Override
    @Deprecated(message="Use 'resolveClass(BinaryClassName)' instead")
    @NotNull
    public ResolutionResult<ClassNode> resolveClass(@NotNull String className) {
        Intrinsics.checkNotNullParameter(className, "className");
        ResolutionResult resolutionResult = (ResolutionResult)this.getJar().processClassPathInJar(className, (Function2)new Function2<String, CharSequence, ResolutionResult<? extends ClassNode>>(this){
            final /* synthetic */ LazyJarResolver this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final ResolutionResult<ClassNode> invoke(@NotNull String className, @NotNull CharSequence classFilePath) {
                Intrinsics.checkNotNullParameter(className, "className");
                Intrinsics.checkNotNullParameter(classFilePath, "classFilePath");
                return this.this$0.readClass((CharSequence)className, classFilePath);
            }
        });
        if (resolutionResult == null) {
            resolutionResult = ResolutionResult.NotFound.INSTANCE;
        }
        return resolutionResult;
    }

    @Override
    @NotNull
    public ResolutionResult<ClassNode> resolveClass(@NotNull CharSequence className) {
        Intrinsics.checkNotNullParameter(className, "className");
        return this.resolveClass(((Object)className).toString());
    }

    @Override
    public boolean processAllClasses(@NotNull Function1<? super ResolutionResult<? extends ClassNode>, Boolean> processor) {
        Intrinsics.checkNotNullParameter(processor, "processor");
        return this.getJar().processAllClasses((Function2<? super String, ? super Path, Boolean>)new Function2<String, Path, Boolean>(processor, this){
            final /* synthetic */ Function1<ResolutionResult<? extends ClassNode>, Boolean> $processor;
            final /* synthetic */ LazyJarResolver this$0;
            {
                this.$processor = $processor;
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull String className, @NotNull Path classFilePath) {
                Intrinsics.checkNotNullParameter(className, "className");
                Intrinsics.checkNotNullParameter(classFilePath, "classFilePath");
                return this.$processor.invoke(this.this$0.readClass((CharSequence)className, classFilePath));
            }
        });
    }

    @Override
    @Deprecated(message="Use 'containsClass(BinaryClassName)' instead")
    public boolean containsClass(@NotNull String className) {
        Intrinsics.checkNotNullParameter(className, "className");
        return this.getJar().containsClass(className);
    }

    @Override
    public boolean containsClass(@NotNull CharSequence className) {
        Intrinsics.checkNotNullParameter(className, "className");
        return this.containsClass(((Object)className).toString());
    }

    @Override
    public boolean containsPackage(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        return this.getJar().containsPackage(packageName);
    }

    @Override
    public void close() {
    }

    @NotNull
    public final ResolutionResult<ClassNode> readClass(@NotNull CharSequence className, @NotNull CharSequence classPath) {
        ResolutionResult resolutionResult;
        Intrinsics.checkNotNullParameter(className, "className");
        Intrinsics.checkNotNullParameter(classPath, "classPath");
        try {
            ResolutionResult.Found found = (ResolutionResult.Found)this.zipHandler.handleEntry(classPath, (Function2)new Function2<ZipEntry, ZipResource, ResolutionResult.Found<ClassNode>>(className, this){
                final /* synthetic */ CharSequence $className;
                final /* synthetic */ LazyJarResolver this$0;
                {
                    this.$className = $className;
                    this.this$0 = $receiver;
                    super(2);
                }

                @Nullable
                public final ResolutionResult.Found<ClassNode> invoke(@NotNull ZipEntry entry, @NotNull ZipResource entryResource) {
                    Intrinsics.checkNotNullParameter(entry, "entry");
                    Intrinsics.checkNotNullParameter(entryResource, "entryResource");
                    InputStream inputStream2 = entryResource.getInputStream(entry);
                    ClassNode classNode = AsmUtil.readClassNode(this.$className, inputStream2, this.this$0.getReadMode() == Resolver.ReadMode.FULL);
                    Intrinsics.checkNotNullExpressionValue(classNode, "readClassNode(className,\u2026eadMode == ReadMode.FULL)");
                    ClassNode classNode2 = classNode;
                    return new ResolutionResult.Found<ClassNode>(classNode2, this.this$0.getFileOrigin());
                }
            });
            resolutionResult = found != null ? (ResolutionResult)found : (ResolutionResult)ResolutionResult.NotFound.INSTANCE;
        }
        catch (InvalidClassFileException e) {
            resolutionResult = new ResolutionResult.Invalid(e.getMessage());
        }
        catch (Exception e) {
            LanguageUtilsKt.rethrowIfInterrupted(e);
            String string = e.getMessage();
            if (string == null) {
                string = e.getClass().getName();
            }
            Intrinsics.checkNotNullExpressionValue(string, "e.message ?: e.javaClass.name");
            resolutionResult = new ResolutionResult.FailedToRead(string);
        }
        return resolutionResult;
    }

    @Override
    @Nullable
    protected PropertyResourceBundle readPropertyResourceBundle(@NotNull String bundleResourceName) {
        Intrinsics.checkNotNullParameter(bundleResourceName, "bundleResourceName");
        return (PropertyResourceBundle)this.zipHandler.handleEntry(bundleResourceName, readPropertyResourceBundle.1.INSTANCE);
    }

    public static final /* synthetic */ JarFileSystemProvider access$getFileSystemProvider$p(LazyJarResolver $this) {
        return $this.fileSystemProvider;
    }

    public static final /* synthetic */ Jar access$getJar(LazyJarResolver $this) {
        return $this.getJar();
    }
}

