/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.kotlin;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.module.kotlin.RegexDeserializer;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/fasterxml/jackson/module/kotlin/RegexDeserializer;", "Lcom/fasterxml/jackson/databind/deser/std/StdDeserializer;", "Lkotlin/text/Regex;", "()V", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "readResolve", "", "jackson-module-kotlin"})
public final class RegexDeserializer
extends StdDeserializer<Regex> {
    @NotNull
    public static final RegexDeserializer INSTANCE = new RegexDeserializer();

    private RegexDeserializer() {
        super(Regex.class);
    }

    private final Object readResolve() {
        return INSTANCE;
    }

    @Override
    @NotNull
    public Regex deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
        Intrinsics.checkNotNullParameter(p, "p");
        Intrinsics.checkNotNullParameter(ctxt, "ctxt");
        JsonNode node = ctxt.readTree(p);
        if (node.isTextual()) {
            String string = node.asText();
            Intrinsics.checkNotNullExpressionValue(string, "node.asText()");
            return new Regex(string);
        }
        if (node.isObject()) {
            Set<Object> set;
            String pattern = node.get("pattern").asText();
            if (node.has("options")) {
                JsonNode optionsNode = node.get("options");
                if (!optionsNode.isArray()) {
                    throw new IllegalStateException("Expected an array of strings for RegexOptions, but type was " + (Object)((Object)node.getNodeType()));
                }
                Iterator<JsonNode> iterator2 = optionsNode.elements();
                Intrinsics.checkNotNullExpressionValue(iterator2, "optionsNode.elements()");
                set = SequencesKt.toSet(SequencesKt.map(SequencesKt.asSequence(iterator2), deserialize.options.1.INSTANCE));
            } else {
                set = SetsKt.emptySet();
            }
            Set options2 = set;
            Intrinsics.checkNotNullExpressionValue(pattern, "pattern");
            return new Regex(pattern, options2);
        }
        throw new IllegalStateException("Expected a string or an object to deserialize a Regex, but type was " + (Object)((Object)node.getNodeType()));
    }
}

