/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.verifiers.resolution;

import com.jetbrains.plugin.structure.classes.resolvers.CacheResolver;
import com.jetbrains.plugin.structure.classes.resolvers.ResolutionResult;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.pluginverifier.results.problems.ClassNotFoundProblem;
import com.jetbrains.pluginverifier.results.problems.FailedToReadClassFileProblem;
import com.jetbrains.pluginverifier.results.problems.IllegalClassAccessProblem;
import com.jetbrains.pluginverifier.results.problems.InvalidClassFileProblem;
import com.jetbrains.pluginverifier.results.reference.ClassReference;
import com.jetbrains.pluginverifier.usages.ApiUsageProcessor;
import com.jetbrains.pluginverifier.verifiers.VerificationContext;
import com.jetbrains.pluginverifier.verifiers.resolution.AccessibilityUtilKt;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassFile;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassFileAsm;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassFileMember;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassUsageType;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0001\u001a.\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a\u0014\u0010\f\u001a\u0004\u0018\u00010\u0003*\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\r"}, d2={"caching", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "resolveClassChecked", "Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFile;", "className", "", "referrer", "Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFileMember;", "context", "Lcom/jetbrains/pluginverifier/verifiers/VerificationContext;", "classUsageType", "Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassUsageType;", "resolveClassOrNull", "verifier-core"})
@SourceDebugExtension(value={"SMAP\nResolutionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolutionUtil.kt\ncom/jetbrains/pluginverifier/verifiers/resolution/ResolutionUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1855#2,2:69\n*S KotlinDebug\n*F\n+ 1 ResolutionUtil.kt\ncom/jetbrains/pluginverifier/verifiers/resolution/ResolutionUtilKt\n*L\n59#1:69,2\n*E\n"})
public final class ResolutionUtilKt {
    @NotNull
    public static final Resolver caching(@NotNull Resolver $this$caching) {
        Intrinsics.checkNotNullParameter($this$caching, "<this>");
        return new CacheResolver($this$caching, 0, 2, null);
    }

    @Nullable
    public static final ClassFile resolveClassOrNull(@NotNull Resolver $this$resolveClassOrNull, @NotNull String className) {
        Intrinsics.checkNotNullParameter($this$resolveClassOrNull, "<this>");
        Intrinsics.checkNotNullParameter(className, "className");
        ResolutionResult<ClassNode> resolutionResult = $this$resolveClassOrNull.resolveClass(className);
        ResolutionResult.Found found = resolutionResult instanceof ResolutionResult.Found ? (ResolutionResult.Found)resolutionResult : null;
        if (found == null) {
            return null;
        }
        ResolutionResult.Found resolutionResult2 = found;
        return new ClassFileAsm((ClassNode)resolutionResult2.getValue(), resolutionResult2.getFileOrigin());
    }

    @Nullable
    public static final ClassFile resolveClassChecked(@NotNull Resolver $this$resolveClassChecked, @NotNull String className, @NotNull ClassFileMember referrer, @NotNull VerificationContext context, @NotNull ClassUsageType classUsageType) {
        ClassFile classFile;
        Intrinsics.checkNotNullParameter($this$resolveClassChecked, "<this>");
        Intrinsics.checkNotNullParameter(className, "className");
        Intrinsics.checkNotNullParameter(referrer, "referrer");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter((Object)classUsageType, "classUsageType");
        ResolutionResult<ClassNode> resolutionResult = $this$resolveClassChecked.resolveClass(className);
        if (Intrinsics.areEqual(resolutionResult, ResolutionResult.NotFound.INSTANCE)) {
            if (!context.getExternalClassesPackageFilter().acceptPackageOfClass(className)) {
                context.getProblemRegistrar().registerProblem(new ClassNotFoundProblem(new ClassReference(className), referrer.getLocation()));
            }
            classFile = null;
        } else if (resolutionResult instanceof ResolutionResult.Invalid) {
            context.getProblemRegistrar().registerProblem(new InvalidClassFileProblem(new ClassReference(className), referrer.getLocation(), ((ResolutionResult.Invalid)resolutionResult).getMessage()));
            classFile = null;
        } else if (resolutionResult instanceof ResolutionResult.FailedToRead) {
            context.getProblemRegistrar().registerProblem(new FailedToReadClassFileProblem(new ClassReference(className), referrer.getLocation(), ((ResolutionResult.FailedToRead)resolutionResult).getReason()));
            classFile = null;
        } else if (resolutionResult instanceof ResolutionResult.Found) {
            ClassFileAsm classFile2 = new ClassFileAsm((ClassNode)((ResolutionResult.Found)resolutionResult).getValue(), ((ResolutionResult.Found)resolutionResult).getFileOrigin());
            if (!AccessibilityUtilKt.isClassAccessibleToOtherClass(classFile2, referrer.getContainingClassFile())) {
                context.getProblemRegistrar().registerProblem(new IllegalClassAccessProblem(classFile2.getLocation(), classFile2.getAccessType(), referrer.getLocation()));
            }
            ClassReference classReference = new ClassReference(className);
            Iterable $this$forEach$iv = context.getApiUsageProcessors();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ApiUsageProcessor it = (ApiUsageProcessor)element$iv;
                boolean bl = false;
                it.processClassReference(classReference, classFile2, context, referrer, classUsageType);
            }
            classFile = classFile2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return classFile;
    }

    public static /* synthetic */ ClassFile resolveClassChecked$default(Resolver resolver, String string, ClassFileMember classFileMember, VerificationContext verificationContext, ClassUsageType classUsageType, int n, Object object) {
        if ((n & 8) != 0) {
            classUsageType = ClassUsageType.DEFAULT;
        }
        return ResolutionUtilKt.resolveClassChecked(resolver, string, classFileMember, verificationContext, classUsageType);
    }
}

