/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.output;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.pluginverifier.PluginVerificationTarget;
import com.jetbrains.pluginverifier.output.OutputFormat;
import com.jetbrains.pluginverifier.output.OutputFormatKt;
import com.jetbrains.pluginverifier.output.teamcity.TeamCityHistory;
import com.jetbrains.pluginverifier.output.teamcity.TeamCityLog;
import com.jetbrains.pluginverifier.output.teamcity.TeamCityResultPrinter;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0016\u001a\u00020\u0003H\u00c2\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0003JE\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\tJ\t\u0010'\u001a\u00020(H\u00d6\u0001R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/jetbrains/pluginverifier/output/OutputOptions;", "", "verificationReportsDirectory", "Ljava/nio/file/Path;", "teamCityLog", "Lcom/jetbrains/pluginverifier/output/teamcity/TeamCityLog;", "teamCityGroupType", "Lcom/jetbrains/pluginverifier/output/teamcity/TeamCityResultPrinter$GroupBy;", "previousTcHistory", "Lcom/jetbrains/pluginverifier/output/teamcity/TeamCityHistory;", "outputFormats", "", "Lcom/jetbrains/pluginverifier/output/OutputFormat;", "(Ljava/nio/file/Path;Lcom/jetbrains/pluginverifier/output/teamcity/TeamCityLog;Lcom/jetbrains/pluginverifier/output/teamcity/TeamCityResultPrinter$GroupBy;Lcom/jetbrains/pluginverifier/output/teamcity/TeamCityHistory;Ljava/util/List;)V", "getOutputFormats", "()Ljava/util/List;", "getPreviousTcHistory", "()Lcom/jetbrains/pluginverifier/output/teamcity/TeamCityHistory;", "getTeamCityGroupType", "()Lcom/jetbrains/pluginverifier/output/teamcity/TeamCityResultPrinter$GroupBy;", "getTeamCityLog", "()Lcom/jetbrains/pluginverifier/output/teamcity/TeamCityLog;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "getTargetReportDirectory", "verificationTarget", "Lcom/jetbrains/pluginverifier/PluginVerificationTarget;", "hashCode", "", "postProcessTeamCityTests", "", "newTcHistory", "toString", "", "verifier-cli"})
public final class OutputOptions {
    @NotNull
    private final Path verificationReportsDirectory;
    @Nullable
    private final TeamCityLog teamCityLog;
    @NotNull
    private final TeamCityResultPrinter.GroupBy teamCityGroupType;
    @Nullable
    private final TeamCityHistory previousTcHistory;
    @NotNull
    private final List<OutputFormat> outputFormats;

    public OutputOptions(@NotNull Path verificationReportsDirectory, @Nullable TeamCityLog teamCityLog, @NotNull TeamCityResultPrinter.GroupBy teamCityGroupType, @Nullable TeamCityHistory previousTcHistory, @NotNull List<? extends OutputFormat> outputFormats) {
        Intrinsics.checkNotNullParameter(verificationReportsDirectory, "verificationReportsDirectory");
        Intrinsics.checkNotNullParameter((Object)teamCityGroupType, "teamCityGroupType");
        Intrinsics.checkNotNullParameter(outputFormats, "outputFormats");
        this.verificationReportsDirectory = verificationReportsDirectory;
        this.teamCityLog = teamCityLog;
        this.teamCityGroupType = teamCityGroupType;
        this.previousTcHistory = previousTcHistory;
        this.outputFormats = outputFormats;
    }

    public /* synthetic */ OutputOptions(Path path, TeamCityLog teamCityLog, TeamCityResultPrinter.GroupBy groupBy, TeamCityHistory teamCityHistory, List list, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 0x10) != 0) {
            list = OutputFormatKt.getDEFAULT_OUTPUT_FORMATS();
        }
        this(path, teamCityLog, groupBy, teamCityHistory, list);
    }

    @Nullable
    public final TeamCityLog getTeamCityLog() {
        return this.teamCityLog;
    }

    @NotNull
    public final TeamCityResultPrinter.GroupBy getTeamCityGroupType() {
        return this.teamCityGroupType;
    }

    @Nullable
    public final TeamCityHistory getPreviousTcHistory() {
        return this.previousTcHistory;
    }

    @NotNull
    public final List<OutputFormat> getOutputFormats() {
        return this.outputFormats;
    }

    @NotNull
    public final Path getTargetReportDirectory(@NotNull PluginVerificationTarget verificationTarget) {
        Path path;
        Intrinsics.checkNotNullParameter(verificationTarget, "verificationTarget");
        PluginVerificationTarget pluginVerificationTarget = verificationTarget;
        if (pluginVerificationTarget instanceof PluginVerificationTarget.IDE) {
            String string = ((PluginVerificationTarget.IDE)verificationTarget).getIdeVersion().asString();
            Intrinsics.checkNotNullExpressionValue(string, "verificationTarget.ideVersion.asString()");
            Path path2 = this.verificationReportsDirectory.resolve(FileUtilKt.replaceInvalidFileNameCharacters(string));
            path = path2;
            Intrinsics.checkNotNullExpressionValue(path2, "verificationReportsDirec\u2026alidFileNameCharacters())");
        } else if (pluginVerificationTarget instanceof PluginVerificationTarget.Plugin) {
            Path path3 = this.verificationReportsDirectory.resolve(FileUtilKt.replaceInvalidFileNameCharacters(((PluginVerificationTarget.Plugin)verificationTarget).getPlugin().getPluginId() + " " + ((PluginVerificationTarget.Plugin)verificationTarget).getPlugin().getVersion()));
            path = path3;
            Intrinsics.checkNotNullExpressionValue(path3, "verificationReportsDirec\u2026alidFileNameCharacters())");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return path;
    }

    public final void postProcessTeamCityTests(@NotNull TeamCityHistory newTcHistory) {
        Intrinsics.checkNotNullParameter(newTcHistory, "newTcHistory");
        if (this.teamCityLog != null) {
            Path path = this.verificationReportsDirectory.resolve("tc-tests.json");
            Intrinsics.checkNotNullExpressionValue(path, "verificationReportsDirec\u2026.resolve(\"tc-tests.json\")");
            newTcHistory.writeToFile(path);
            if (this.previousTcHistory != null) {
                newTcHistory.reportOldSkippedTestsSuccessful(this.previousTcHistory, this.teamCityLog);
            }
        }
    }

    private final Path component1() {
        return this.verificationReportsDirectory;
    }

    @Nullable
    public final TeamCityLog component2() {
        return this.teamCityLog;
    }

    @NotNull
    public final TeamCityResultPrinter.GroupBy component3() {
        return this.teamCityGroupType;
    }

    @Nullable
    public final TeamCityHistory component4() {
        return this.previousTcHistory;
    }

    @NotNull
    public final List<OutputFormat> component5() {
        return this.outputFormats;
    }

    @NotNull
    public final OutputOptions copy(@NotNull Path verificationReportsDirectory, @Nullable TeamCityLog teamCityLog, @NotNull TeamCityResultPrinter.GroupBy teamCityGroupType, @Nullable TeamCityHistory previousTcHistory, @NotNull List<? extends OutputFormat> outputFormats) {
        Intrinsics.checkNotNullParameter(verificationReportsDirectory, "verificationReportsDirectory");
        Intrinsics.checkNotNullParameter((Object)teamCityGroupType, "teamCityGroupType");
        Intrinsics.checkNotNullParameter(outputFormats, "outputFormats");
        return new OutputOptions(verificationReportsDirectory, teamCityLog, teamCityGroupType, previousTcHistory, outputFormats);
    }

    public static /* synthetic */ OutputOptions copy$default(OutputOptions outputOptions, Path path, TeamCityLog teamCityLog, TeamCityResultPrinter.GroupBy groupBy, TeamCityHistory teamCityHistory, List list, int n, Object object) {
        if ((n & 1) != 0) {
            path = outputOptions.verificationReportsDirectory;
        }
        if ((n & 2) != 0) {
            teamCityLog = outputOptions.teamCityLog;
        }
        if ((n & 4) != 0) {
            groupBy = outputOptions.teamCityGroupType;
        }
        if ((n & 8) != 0) {
            teamCityHistory = outputOptions.previousTcHistory;
        }
        if ((n & 0x10) != 0) {
            list = outputOptions.outputFormats;
        }
        return outputOptions.copy(path, teamCityLog, groupBy, teamCityHistory, list);
    }

    @NotNull
    public String toString() {
        return "OutputOptions(verificationReportsDirectory=" + this.verificationReportsDirectory + ", teamCityLog=" + this.teamCityLog + ", teamCityGroupType=" + this.teamCityGroupType + ", previousTcHistory=" + this.previousTcHistory + ", outputFormats=" + this.outputFormats + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.verificationReportsDirectory).hashCode();
        result2 = result2 * 31 + (this.teamCityLog == null ? 0 : this.teamCityLog.hashCode());
        result2 = result2 * 31 + this.teamCityGroupType.hashCode();
        result2 = result2 * 31 + (this.previousTcHistory == null ? 0 : this.previousTcHistory.hashCode());
        result2 = result2 * 31 + ((Object)this.outputFormats).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OutputOptions)) {
            return false;
        }
        OutputOptions outputOptions = (OutputOptions)other;
        if (!Intrinsics.areEqual(this.verificationReportsDirectory, outputOptions.verificationReportsDirectory)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.teamCityLog, outputOptions.teamCityLog)) {
            return false;
        }
        if (this.teamCityGroupType != outputOptions.teamCityGroupType) {
            return false;
        }
        if (!Intrinsics.areEqual(this.previousTcHistory, outputOptions.previousTcHistory)) {
            return false;
        }
        return Intrinsics.areEqual(this.outputFormats, outputOptions.outputFormats);
    }
}

