/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.repository;

import com.jetbrains.plugin.structure.intellij.repository.CustomPluginRepositoryListingType;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import java.io.ByteArrayInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J&\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\"\u0010\u0012\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u000fH\u0002J\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0007*\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u000f*\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u0007H\u0002\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/plugin/structure/intellij/repository/CustomPluginRepositoryListingParser;", "", "()V", "parseListOfPlugins", "", "Lcom/jetbrains/plugin/structure/intellij/repository/CustomPluginRepositoryListingParser$PluginInfo;", "pluginsListXmlContent", "", "pluginsListXmlUrl", "Ljava/net/URL;", "repositoryUrl", "listingType", "Lcom/jetbrains/plugin/structure/intellij/repository/CustomPluginRepositoryListingType;", "parsePluginRepositoryList", "root", "Lorg/w3c/dom/Element;", "xmlUrl", "parseSimpleList", "parseSinceAndUntil", "Lkotlin/Pair;", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "ideaVersionElement", "getAttributeOrNull", "attributeName", "getSingleChild", "tagName", "PluginInfo", "structure-intellij"})
@SourceDebugExtension(value={"SMAP\nCustomPluginRepositoryListingParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomPluginRepositoryListingParser.kt\ncom/jetbrains/plugin/structure/intellij/repository/CustomPluginRepositoryListingParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n1#2:156\n*E\n"})
public final class CustomPluginRepositoryListingParser {
    @NotNull
    public static final CustomPluginRepositoryListingParser INSTANCE = new CustomPluginRepositoryListingParser();

    private CustomPluginRepositoryListingParser() {
    }

    @NotNull
    public final List<PluginInfo> parseListOfPlugins(@NotNull String pluginsListXmlContent, @NotNull URL pluginsListXmlUrl, @NotNull URL repositoryUrl, @NotNull CustomPluginRepositoryListingType listingType) {
        List<PluginInfo> list;
        Intrinsics.checkNotNullParameter(pluginsListXmlContent, "pluginsListXmlContent");
        Intrinsics.checkNotNullParameter(pluginsListXmlUrl, "pluginsListXmlUrl");
        Intrinsics.checkNotNullParameter(repositoryUrl, "repositoryUrl");
        Intrinsics.checkNotNullParameter((Object)listingType, "listingType");
        Object object = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        DocumentBuilder $this$parseListOfPlugins_u24lambda_u240 = object;
        boolean bl = false;
        $this$parseListOfPlugins_u24lambda_u240.setErrorHandler(new DefaultHandler(){

            public void error(@NotNull SAXParseException e) {
                Intrinsics.checkNotNullParameter(e, "e");
                throw e;
            }
        });
        DocumentBuilder documentBuilder = object;
        object = pluginsListXmlContent;
        byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        object = byArray;
        Document document2 = documentBuilder.parse(new ByteArrayInputStream((byte[])object));
        Element root = document2.getDocumentElement();
        if (listingType == CustomPluginRepositoryListingType.SIMPLE) {
            Intrinsics.checkNotNullExpressionValue(root, "root");
            list = this.parseSimpleList(root, pluginsListXmlUrl, repositoryUrl);
        } else {
            Intrinsics.checkNotNullExpressionValue(root, "root");
            list = this.parsePluginRepositoryList(root, pluginsListXmlUrl, repositoryUrl);
        }
        return list;
    }

    private final List<PluginInfo> parseSimpleList(Element root, URL xmlUrl, URL repositoryUrl) {
        if (!Intrinsics.areEqual(root.getTagName(), "plugins")) {
            return CollectionsKt.emptyList();
        }
        NodeList pluginsList = root.getElementsByTagName("plugin");
        ArrayList result2 = new ArrayList();
        int n = pluginsList.getLength();
        for (int i = 0; i < n; ++i) {
            String url;
            String version;
            String id;
            Element pluginElement;
            Node node = pluginsList.item(i);
            Element element = node instanceof Element ? (Element)node : null;
            if (element == null || !Intrinsics.areEqual((pluginElement = element).getTagName(), "plugin") || this.getAttributeOrNull(pluginElement, "id") == null || this.getAttributeOrNull(pluginElement, "url") == null || this.getAttributeOrNull(pluginElement, "version") == null || !(((CharSequence)id).length() > 0) || !(((CharSequence)version).length() > 0) || !(((CharSequence)url).length() > 0)) continue;
            String string = this.getAttributeOrNull(pluginElement, "name");
            if (string == null) {
                string = id;
            }
            String pluginName = string;
            String vendor = this.getAttributeOrNull(pluginElement, "vendor");
            URL downloadUrl = new URL(xmlUrl, url);
            Element ideaVersionElement = this.getSingleChild(pluginElement, "idea-version");
            Pair<IdeVersion, IdeVersion> pair = this.parseSinceAndUntil(ideaVersionElement);
            IdeVersion sinceBuild = pair.component1();
            IdeVersion untilBuild = pair.component2();
            ((Collection)result2).add(new PluginInfo(id, pluginName, version, vendor, repositoryUrl, downloadUrl, repositoryUrl, null, sinceBuild, untilBuild));
        }
        return result2;
    }

    private final List<PluginInfo> parsePluginRepositoryList(Element root, URL xmlUrl, URL repositoryUrl) {
        if (!Intrinsics.areEqual(root.getTagName(), "plugin-repository")) {
            return CollectionsKt.emptyList();
        }
        NodeList ideaPluginElements = root.getElementsByTagName("idea-plugin");
        ArrayList result2 = new ArrayList();
        int n = ideaPluginElements.getLength();
        for (int i = 0; i < n; ++i) {
            String downloadUrlRelative;
            String vendor;
            String version;
            String id;
            String name;
            Element ideaPlugin;
            Node node = ideaPluginElements.item(i);
            Element element = node instanceof Element ? (Element)node : null;
            if (element == null || !Intrinsics.areEqual((ideaPlugin = element).getTagName(), "idea-plugin")) continue;
            Element element2 = this.getSingleChild(ideaPlugin, "name");
            if ((element2 != null ? element2.getTextContent() : null) == null) continue;
            name = name;
            Element element3 = this.getSingleChild(ideaPlugin, "id");
            if ((element3 != null ? element3.getTextContent() : null) == null) continue;
            id = id;
            Element element4 = this.getSingleChild(ideaPlugin, "version");
            if ((element4 != null ? element4.getTextContent() : null) == null) continue;
            version = version;
            Element element5 = this.getSingleChild(ideaPlugin, "vendor");
            if ((element5 != null ? element5.getTextContent() : null) == null) continue;
            vendor = vendor;
            Element element6 = this.getSingleChild(ideaPlugin, "download-url");
            if ((element6 != null ? element6.getTextContent() : null) == null) continue;
            downloadUrlRelative = downloadUrlRelative;
            Element ideaVersionElement = this.getSingleChild(ideaPlugin, "idea-version");
            Pair<IdeVersion, IdeVersion> pair = this.parseSinceAndUntil(ideaVersionElement);
            IdeVersion sinceBuild = pair.component1();
            IdeVersion untilBuild = pair.component2();
            URL downloadUrl = new URL(xmlUrl, downloadUrlRelative);
            ((Collection)result2).add(new PluginInfo(id, name, version, vendor, repositoryUrl, downloadUrl, repositoryUrl, null, sinceBuild, untilBuild));
        }
        return result2;
    }

    private final Pair<IdeVersion, IdeVersion> parseSinceAndUntil(Element ideaVersionElement) {
        IdeVersion ideVersion;
        Object object;
        IdeVersion sinceBuild;
        IdeVersion ideVersion2;
        Object object2 = ideaVersionElement;
        if (object2 != null && (object2 = this.getAttributeOrNull((Element)object2, "since-build")) != null) {
            Object it = object2;
            boolean bl = false;
            ideVersion2 = IdeVersion.createIdeVersionIfValid((String)it);
        } else {
            ideVersion2 = sinceBuild = null;
        }
        if ((object = ideaVersionElement) != null && (object = this.getAttributeOrNull((Element)object, "until-build")) != null) {
            Object it = object;
            boolean bl = false;
            ideVersion = IdeVersion.createIdeVersionIfValid((String)it);
        } else {
            ideVersion = null;
        }
        IdeVersion untilBuild = ideVersion;
        return TuplesKt.to(sinceBuild, untilBuild);
    }

    private final String getAttributeOrNull(Element $this$getAttributeOrNull, String attributeName) {
        if ($this$getAttributeOrNull.hasAttribute(attributeName)) {
            return $this$getAttributeOrNull.getAttribute(attributeName);
        }
        return null;
    }

    private final Element getSingleChild(Element $this$getSingleChild, String tagName) {
        NodeList elements = $this$getSingleChild.getElementsByTagName(tagName);
        if (elements.getLength() != 1) {
            return null;
        }
        Node node = elements.item(0);
        return node instanceof Element ? (Element)node : null;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\rH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\bH\u00c6\u0003J\t\u0010#\u001a\u00020\bH\u00c6\u0003J\t\u0010$\u001a\u00020\bH\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u0010&\u001a\u0004\u0018\u00010\rH\u00c6\u0003Ju\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\rH\u00c6\u0001J\u0013\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010+\u001a\u00020,H\u00d6\u0001J\t\u0010-\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0014R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0014\u00a8\u0006."}, d2={"Lcom/jetbrains/plugin/structure/intellij/repository/CustomPluginRepositoryListingParser$PluginInfo;", "", "pluginId", "", "pluginName", "version", "vendor", "repositoryUrl", "Ljava/net/URL;", "downloadUrl", "browserUrl", "sourceCodeUrl", "sinceBuild", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "untilBuild", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/net/URL;Ljava/net/URL;Ljava/net/URL;Ljava/net/URL;Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;)V", "getBrowserUrl", "()Ljava/net/URL;", "getDownloadUrl", "getPluginId", "()Ljava/lang/String;", "getPluginName", "getRepositoryUrl", "getSinceBuild", "()Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "getSourceCodeUrl", "getUntilBuild", "getVendor", "getVersion", "component1", "component10", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "", "toString", "structure-intellij"})
    public static final class PluginInfo {
        @NotNull
        private final String pluginId;
        @NotNull
        private final String pluginName;
        @NotNull
        private final String version;
        @Nullable
        private final String vendor;
        @NotNull
        private final URL repositoryUrl;
        @NotNull
        private final URL downloadUrl;
        @NotNull
        private final URL browserUrl;
        @Nullable
        private final URL sourceCodeUrl;
        @Nullable
        private final IdeVersion sinceBuild;
        @Nullable
        private final IdeVersion untilBuild;

        public PluginInfo(@NotNull String pluginId, @NotNull String pluginName, @NotNull String version, @Nullable String vendor, @NotNull URL repositoryUrl, @NotNull URL downloadUrl, @NotNull URL browserUrl, @Nullable URL sourceCodeUrl, @Nullable IdeVersion sinceBuild, @Nullable IdeVersion untilBuild) {
            Intrinsics.checkNotNullParameter(pluginId, "pluginId");
            Intrinsics.checkNotNullParameter(pluginName, "pluginName");
            Intrinsics.checkNotNullParameter(version, "version");
            Intrinsics.checkNotNullParameter(repositoryUrl, "repositoryUrl");
            Intrinsics.checkNotNullParameter(downloadUrl, "downloadUrl");
            Intrinsics.checkNotNullParameter(browserUrl, "browserUrl");
            this.pluginId = pluginId;
            this.pluginName = pluginName;
            this.version = version;
            this.vendor = vendor;
            this.repositoryUrl = repositoryUrl;
            this.downloadUrl = downloadUrl;
            this.browserUrl = browserUrl;
            this.sourceCodeUrl = sourceCodeUrl;
            this.sinceBuild = sinceBuild;
            this.untilBuild = untilBuild;
        }

        @NotNull
        public final String getPluginId() {
            return this.pluginId;
        }

        @NotNull
        public final String getPluginName() {
            return this.pluginName;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        @Nullable
        public final String getVendor() {
            return this.vendor;
        }

        @NotNull
        public final URL getRepositoryUrl() {
            return this.repositoryUrl;
        }

        @NotNull
        public final URL getDownloadUrl() {
            return this.downloadUrl;
        }

        @NotNull
        public final URL getBrowserUrl() {
            return this.browserUrl;
        }

        @Nullable
        public final URL getSourceCodeUrl() {
            return this.sourceCodeUrl;
        }

        @Nullable
        public final IdeVersion getSinceBuild() {
            return this.sinceBuild;
        }

        @Nullable
        public final IdeVersion getUntilBuild() {
            return this.untilBuild;
        }

        @NotNull
        public final String component1() {
            return this.pluginId;
        }

        @NotNull
        public final String component2() {
            return this.pluginName;
        }

        @NotNull
        public final String component3() {
            return this.version;
        }

        @Nullable
        public final String component4() {
            return this.vendor;
        }

        @NotNull
        public final URL component5() {
            return this.repositoryUrl;
        }

        @NotNull
        public final URL component6() {
            return this.downloadUrl;
        }

        @NotNull
        public final URL component7() {
            return this.browserUrl;
        }

        @Nullable
        public final URL component8() {
            return this.sourceCodeUrl;
        }

        @Nullable
        public final IdeVersion component9() {
            return this.sinceBuild;
        }

        @Nullable
        public final IdeVersion component10() {
            return this.untilBuild;
        }

        @NotNull
        public final PluginInfo copy(@NotNull String pluginId, @NotNull String pluginName, @NotNull String version, @Nullable String vendor, @NotNull URL repositoryUrl, @NotNull URL downloadUrl, @NotNull URL browserUrl, @Nullable URL sourceCodeUrl, @Nullable IdeVersion sinceBuild, @Nullable IdeVersion untilBuild) {
            Intrinsics.checkNotNullParameter(pluginId, "pluginId");
            Intrinsics.checkNotNullParameter(pluginName, "pluginName");
            Intrinsics.checkNotNullParameter(version, "version");
            Intrinsics.checkNotNullParameter(repositoryUrl, "repositoryUrl");
            Intrinsics.checkNotNullParameter(downloadUrl, "downloadUrl");
            Intrinsics.checkNotNullParameter(browserUrl, "browserUrl");
            return new PluginInfo(pluginId, pluginName, version, vendor, repositoryUrl, downloadUrl, browserUrl, sourceCodeUrl, sinceBuild, untilBuild);
        }

        public static /* synthetic */ PluginInfo copy$default(PluginInfo pluginInfo, String string, String string2, String string3, String string4, URL uRL, URL uRL2, URL uRL3, URL uRL4, IdeVersion ideVersion, IdeVersion ideVersion2, int n, Object object) {
            if ((n & 1) != 0) {
                string = pluginInfo.pluginId;
            }
            if ((n & 2) != 0) {
                string2 = pluginInfo.pluginName;
            }
            if ((n & 4) != 0) {
                string3 = pluginInfo.version;
            }
            if ((n & 8) != 0) {
                string4 = pluginInfo.vendor;
            }
            if ((n & 0x10) != 0) {
                uRL = pluginInfo.repositoryUrl;
            }
            if ((n & 0x20) != 0) {
                uRL2 = pluginInfo.downloadUrl;
            }
            if ((n & 0x40) != 0) {
                uRL3 = pluginInfo.browserUrl;
            }
            if ((n & 0x80) != 0) {
                uRL4 = pluginInfo.sourceCodeUrl;
            }
            if ((n & 0x100) != 0) {
                ideVersion = pluginInfo.sinceBuild;
            }
            if ((n & 0x200) != 0) {
                ideVersion2 = pluginInfo.untilBuild;
            }
            return pluginInfo.copy(string, string2, string3, string4, uRL, uRL2, uRL3, uRL4, ideVersion, ideVersion2);
        }

        @NotNull
        public String toString() {
            return "PluginInfo(pluginId=" + this.pluginId + ", pluginName=" + this.pluginName + ", version=" + this.version + ", vendor=" + this.vendor + ", repositoryUrl=" + this.repositoryUrl + ", downloadUrl=" + this.downloadUrl + ", browserUrl=" + this.browserUrl + ", sourceCodeUrl=" + this.sourceCodeUrl + ", sinceBuild=" + this.sinceBuild + ", untilBuild=" + this.untilBuild + ")";
        }

        public int hashCode() {
            int result2 = this.pluginId.hashCode();
            result2 = result2 * 31 + this.pluginName.hashCode();
            result2 = result2 * 31 + this.version.hashCode();
            result2 = result2 * 31 + (this.vendor == null ? 0 : this.vendor.hashCode());
            result2 = result2 * 31 + this.repositoryUrl.hashCode();
            result2 = result2 * 31 + this.downloadUrl.hashCode();
            result2 = result2 * 31 + this.browserUrl.hashCode();
            result2 = result2 * 31 + (this.sourceCodeUrl == null ? 0 : this.sourceCodeUrl.hashCode());
            result2 = result2 * 31 + (this.sinceBuild == null ? 0 : this.sinceBuild.hashCode());
            result2 = result2 * 31 + (this.untilBuild == null ? 0 : this.untilBuild.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PluginInfo)) {
                return false;
            }
            PluginInfo pluginInfo = (PluginInfo)other;
            if (!Intrinsics.areEqual(this.pluginId, pluginInfo.pluginId)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.pluginName, pluginInfo.pluginName)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.version, pluginInfo.version)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.vendor, pluginInfo.vendor)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.repositoryUrl, pluginInfo.repositoryUrl)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.downloadUrl, pluginInfo.downloadUrl)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.browserUrl, pluginInfo.browserUrl)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.sourceCodeUrl, pluginInfo.sourceCodeUrl)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.sinceBuild, pluginInfo.sinceBuild)) {
                return false;
            }
            return Intrinsics.areEqual(this.untilBuild, pluginInfo.untilBuild);
        }
    }
}

