/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.reporting.ignoring;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.pluginverifier.PluginVerificationTarget;
import com.jetbrains.pluginverifier.reporting.Reporter;
import com.jetbrains.pluginverifier.reporting.common.CollectingReporter;
import com.jetbrains.pluginverifier.reporting.ignoring.AllIgnoredProblemsReporter;
import com.jetbrains.pluginverifier.reporting.ignoring.ProblemIgnoredEvent;
import java.io.Closeable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/pluginverifier/reporting/ignoring/IgnoredProblemsReporter;", "Lcom/jetbrains/pluginverifier/reporting/Reporter;", "Lcom/jetbrains/pluginverifier/reporting/ignoring/ProblemIgnoredEvent;", "pluginVerificationDirectory", "Ljava/nio/file/Path;", "verificationTarget", "Lcom/jetbrains/pluginverifier/PluginVerificationTarget;", "(Ljava/nio/file/Path;Lcom/jetbrains/pluginverifier/PluginVerificationTarget;)V", "collectingReporter", "Lcom/jetbrains/pluginverifier/reporting/common/CollectingReporter;", "close", "", "report", "t", "saveIgnoredProblems", "verifier-intellij"})
public final class IgnoredProblemsReporter
implements Reporter<ProblemIgnoredEvent> {
    @NotNull
    private final Path pluginVerificationDirectory;
    @NotNull
    private final PluginVerificationTarget verificationTarget;
    @NotNull
    private final CollectingReporter<ProblemIgnoredEvent> collectingReporter;

    public IgnoredProblemsReporter(@NotNull Path pluginVerificationDirectory, @NotNull PluginVerificationTarget verificationTarget) {
        Intrinsics.checkNotNullParameter(pluginVerificationDirectory, "pluginVerificationDirectory");
        Intrinsics.checkNotNullParameter(verificationTarget, "verificationTarget");
        this.pluginVerificationDirectory = pluginVerificationDirectory;
        this.verificationTarget = verificationTarget;
        this.collectingReporter = new CollectingReporter();
    }

    @Override
    public void report(@NotNull ProblemIgnoredEvent t2) {
        Intrinsics.checkNotNullParameter(t2, "t");
        this.collectingReporter.report(t2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.saveIgnoredProblems();
        }
        finally {
            LanguageUtilsKt.closeLogged((Closeable)this.collectingReporter);
        }
    }

    private final void saveIgnoredProblems() {
        List<ProblemIgnoredEvent> allIgnoredProblems = this.collectingReporter.getAllReported();
        if (!((Collection)allIgnoredProblems).isEmpty()) {
            Path ignoredProblemsFile = this.pluginVerificationDirectory.resolve("ignored-problems.txt");
            Intrinsics.checkNotNullExpressionValue(ignoredProblemsFile, "ignoredProblemsFile");
            FileUtilKt.writeText$default(ignoredProblemsFile, AllIgnoredProblemsReporter.Companion.formatManyIgnoredProblems(this.verificationTarget, allIgnoredProblems), null, 2, null);
        }
    }
}

