/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.FormatUtilsKt;
import com.jetbrains.plugin.structure.intellij.plugin.caches.SimplePluginResourceCache;
import com.jetbrains.pluginverifier.PluginVerificationTarget;
import com.jetbrains.pluginverifier.PluginVerifierMain;
import com.jetbrains.pluginverifier.options.CmdOpts;
import com.jetbrains.pluginverifier.options.OptionsParser;
import com.jetbrains.pluginverifier.output.OutputOptions;
import com.jetbrains.pluginverifier.plugin.DefaultPluginDetailsProvider;
import com.jetbrains.pluginverifier.plugin.PluginFilesBank;
import com.jetbrains.pluginverifier.plugin.SizeLimitedPluginDetailsCache;
import com.jetbrains.pluginverifier.reporting.DirectoryBasedPluginVerificationReportage;
import com.jetbrains.pluginverifier.reporting.LoggingPluginVerificationReportageAggregator;
import com.jetbrains.pluginverifier.reporting.PluginVerificationReportage;
import com.jetbrains.pluginverifier.repository.PluginRepository;
import com.jetbrains.pluginverifier.repository.cleanup.DiskSpaceSetting;
import com.jetbrains.pluginverifier.repository.cleanup.SpaceAmount;
import com.jetbrains.pluginverifier.repository.cleanup.SpaceUnit;
import com.jetbrains.pluginverifier.repository.downloader.DownloadStatistics;
import com.jetbrains.pluginverifier.repository.files.AvailableFile;
import com.jetbrains.pluginverifier.repository.files.SpaceWeight;
import com.jetbrains.pluginverifier.repository.repositories.local.LocalPluginRepositoryFactory;
import com.jetbrains.pluginverifier.repository.repositories.marketplace.MarketplaceRepository;
import com.jetbrains.pluginverifier.tasks.CommandRunner;
import com.jetbrains.pluginverifier.tasks.TaskParameters;
import com.jetbrains.pluginverifier.tasks.TaskParametersBuilder;
import com.jetbrains.pluginverifier.tasks.TaskResult;
import com.jetbrains.pluginverifier.tasks.TaskResultPrinter;
import com.jetbrains.pluginverifier.tasks.checkIde.CheckIdeRunner;
import com.jetbrains.pluginverifier.tasks.checkPlugin.CheckPluginRunner;
import com.jetbrains.pluginverifier.tasks.checkPluginApi.CheckPluginApiRunner;
import com.jetbrains.pluginverifier.tasks.checkTrunkApi.CheckTrunkApiRunner;
import com.jetbrains.pluginverifier.tasks.processAllPlugins.ProcessAllPluginsCommand;
import com.jetbrains.pluginverifier.tasks.profiling.MeasuredResult;
import com.jetbrains.pluginverifier.tasks.profiling.PluginVerificationProfilingsKt;
import com.sampullara.cli.Args;
import java.io.Closeable;
import java.net.URL;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0016\u001a\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\nH\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0007H\u0002J\u001b\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0!H\u0007\u00a2\u0006\u0002\u0010\"J\u001c\u0010#\u001a\u00020\u001f*\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0014\u0010)\u001a\u00020\u001f*\u00020$2\u0006\u0010*\u001a\u00020+H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000f\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u000e\u001a\u0004\b\u0010\u0010\fR\u001b\u0010\u0012\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u000e\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006,"}, d2={"Lcom/jetbrains/pluginverifier/PluginVerifierMain;", "", "()V", "commandRunners", "", "Lcom/jetbrains/pluginverifier/tasks/CommandRunner;", "downloadDirectory", "Ljava/nio/file/Path;", "ideDownloadDirectory", "pluginRepositoryUrl", "", "getPluginRepositoryUrl", "()Ljava/lang/String;", "pluginRepositoryUrl$delegate", "Lkotlin/Lazy;", "pluginVerifierVersion", "getPluginVerifierVersion", "pluginVerifierVersion$delegate", "verifierHomeDirectory", "getVerifierHomeDirectory", "()Ljava/nio/file/Path;", "verifierHomeDirectory$delegate", "findTaskRunner", "command", "getDiskSpaceSetting", "Lcom/jetbrains/pluginverifier/repository/cleanup/DiskSpaceSetting;", "propertyName", "defaultAmount", "", "getPluginsExtractDirectory", "main", "", "args", "", "([Ljava/lang/String;)V", "reportDownloadStatistics", "Lcom/jetbrains/pluginverifier/reporting/PluginVerificationReportage;", "outputOptions", "Lcom/jetbrains/pluginverifier/output/OutputOptions;", "pluginFilesBank", "Lcom/jetbrains/pluginverifier/plugin/PluginFilesBank;", "reportVerificationDuration", "measuredResult", "Lcom/jetbrains/pluginverifier/tasks/profiling/MeasuredResult;", "verifier-cli"})
@SourceDebugExtension(value={"SMAP\nPluginVerifierMain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginVerifierMain.kt\ncom/jetbrains/pluginverifier/PluginVerifierMain\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,202:1\n1789#2,3:203\n1549#2:207\n1620#2,3:208\n1#3:206\n*S KotlinDebug\n*F\n+ 1 PluginVerifierMain.kt\ncom/jetbrains/pluginverifier/PluginVerifierMain\n*L\n162#1:203,3\n199#1:207\n199#1:208,3\n*E\n"})
public final class PluginVerifierMain {
    @NotNull
    public static final PluginVerifierMain INSTANCE = new PluginVerifierMain();
    @NotNull
    private static final List<CommandRunner> commandRunners;
    @NotNull
    private static final Lazy pluginVerifierVersion$delegate;
    @NotNull
    private static final Lazy verifierHomeDirectory$delegate;
    @NotNull
    private static final Lazy pluginRepositoryUrl$delegate;
    @NotNull
    private static final Path downloadDirectory;
    @NotNull
    private static final Path ideDownloadDirectory;

    private PluginVerifierMain() {
    }

    private final String getPluginVerifierVersion() {
        Lazy lazy = pluginVerifierVersion$delegate;
        return (String)lazy.getValue();
    }

    private final Path getVerifierHomeDirectory() {
        Lazy lazy = verifierHomeDirectory$delegate;
        Object t2 = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue(t2, "<get-verifierHomeDirectory>(...)");
        return (Path)t2;
    }

    private final String getPluginRepositoryUrl() {
        Lazy lazy = pluginRepositoryUrl$delegate;
        return (String)lazy.getValue();
    }

    private final Path getPluginsExtractDirectory() {
        Path path = this.getVerifierHomeDirectory().resolve("extracted-plugins");
        Intrinsics.checkNotNullExpressionValue(path, "verifierHomeDirectory.resolve(\"extracted-plugins\")");
        Path extractDirectory = FileUtilKt.createDir(path);
        FileUtilKt.forceDeleteIfExists(extractDirectory);
        return extractDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void main(@NotNull String[] args2) {
        Intrinsics.checkNotNullParameter(args2, "args");
        System.out.println((Object)("Starting the IntelliJ Plugin Verifier " + INSTANCE.getPluginVerifierVersion()));
        CmdOpts opts = new CmdOpts(null, null, null, null, false, false, null, null, null, null, null, null, false, null, null, null, null, null, null, 524287, null);
        Ref.ObjectRef<List<String>> freeArgs = new Ref.ObjectRef<List<String>>();
        freeArgs.element = Args.parse(opts, args2, false);
        if (((List)freeArgs.element).isEmpty()) {
            System.err.println("The command is not specified. Should be one of: " + CollectionsKt.joinToString$default(commandRunners, null, null, null, 0, null, main.1.INSTANCE, 31, null));
            Args.usage(System.err, new CmdOpts(null, null, null, null, false, false, null, null, null, null, null, null, false, null, null, null, null, null, null, 524287, null));
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        String command = (String)((List)freeArgs.element).get(0);
        Object t2 = freeArgs.element;
        Intrinsics.checkNotNullExpressionValue(t2, "freeArgs");
        freeArgs.element = CollectionsKt.drop((Iterable)t2, 1);
        CommandRunner runner = INSTANCE.findTaskRunner(command);
        OutputOptions outputOptions = OptionsParser.INSTANCE.parseOutputOptions(opts);
        PluginRepository pluginRepository = opts.getOfflineMode() ? LocalPluginRepositoryFactory.INSTANCE.createLocalPluginRepository(downloadDirectory) : (PluginRepository)new MarketplaceRepository(new URL(INSTANCE.getPluginRepositoryUrl()));
        DiskSpaceSetting pluginDownloadDirDiskSpaceSetting = INSTANCE.getDiskSpaceSetting("plugin.verifier.cache.dir.max.space", 5120L);
        PluginFilesBank pluginFilesBank = PluginFilesBank.Companion.create(pluginRepository, downloadDirectory, pluginDownloadDirDiskSpaceSetting);
        Closeable closeable = new SimplePluginResourceCache();
        Throwable throwable = null;
        try {
            SimplePluginResourceCache extractedPluginCache = (SimplePluginResourceCache)closeable;
            boolean bl = false;
            AutoCloseable autoCloseable = new DefaultPluginDetailsProvider(INSTANCE.getPluginsExtractDirectory(), extractedPluginCache);
            Throwable throwable2 = null;
            try {
                DefaultPluginDetailsProvider pluginDetailsProvider = (DefaultPluginDetailsProvider)autoCloseable;
                boolean bl2 = false;
                LoggingPluginVerificationReportageAggregator reportageAggregator = new LoggingPluginVerificationReportageAggregator(null, 1, null);
                Closeable closeable2 = new DirectoryBasedPluginVerificationReportage(reportageAggregator, null, new Function1<PluginVerificationTarget, Path>(outputOptions){
                    final /* synthetic */ OutputOptions $outputOptions;
                    {
                        this.$outputOptions = $outputOptions;
                        super(1);
                    }

                    @NotNull
                    public final Path invoke(@NotNull PluginVerificationTarget it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return this.$outputOptions.getTargetReportDirectory(it);
                    }
                }, 2, null);
                Throwable throwable3 = null;
                try {
                    DirectoryBasedPluginVerificationReportage reportage = (DirectoryBasedPluginVerificationReportage)closeable2;
                    boolean bl3 = false;
                    MeasuredResult $this$main_u24lambda_u243_u24lambda_u242_u24lambda_u241_u24lambda_u240 = PluginVerificationProfilingsKt.measurePluginVerification((Function1<? super Unit, ? extends TaskResult>)new Function1<Unit, TaskResult>(pluginFilesBank, pluginDetailsProvider, runner, pluginRepository, extractedPluginCache, reportage, opts, freeArgs){
                        final /* synthetic */ PluginFilesBank $pluginFilesBank;
                        final /* synthetic */ DefaultPluginDetailsProvider $pluginDetailsProvider;
                        final /* synthetic */ CommandRunner $runner;
                        final /* synthetic */ PluginRepository $pluginRepository;
                        final /* synthetic */ SimplePluginResourceCache $extractedPluginCache;
                        final /* synthetic */ DirectoryBasedPluginVerificationReportage $reportage;
                        final /* synthetic */ CmdOpts $opts;
                        final /* synthetic */ Ref.ObjectRef<List<String>> $freeArgs;
                        {
                            this.$pluginFilesBank = $pluginFilesBank;
                            this.$pluginDetailsProvider = $pluginDetailsProvider;
                            this.$runner = $runner;
                            this.$pluginRepository = $pluginRepository;
                            this.$extractedPluginCache = $extractedPluginCache;
                            this.$reportage = $reportage;
                            this.$opts = $opts;
                            this.$freeArgs = $freeArgs;
                            super(1);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @NotNull
                        public final TaskResult invoke(@NotNull Unit it) {
                            TaskResult taskResult;
                            Intrinsics.checkNotNullParameter(it, "it");
                            Object object = System.getProperty("plugin.verifier.plugin.details.cache.size");
                            int detailsCacheSize = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 32;
                            Closeable closeable = new SizeLimitedPluginDetailsCache(detailsCacheSize, this.$pluginFilesBank, this.$pluginDetailsProvider);
                            CommandRunner commandRunner = this.$runner;
                            PluginRepository pluginRepository = this.$pluginRepository;
                            SimplePluginResourceCache simplePluginResourceCache = this.$extractedPluginCache;
                            DirectoryBasedPluginVerificationReportage directoryBasedPluginVerificationReportage = this.$reportage;
                            CmdOpts cmdOpts = this.$opts;
                            Ref.ObjectRef<List<String>> objectRef = this.$freeArgs;
                            Throwable throwable = null;
                            try {
                                TaskResult taskResult2;
                                SizeLimitedPluginDetailsCache pluginDetailsCache = (SizeLimitedPluginDetailsCache)closeable;
                                boolean bl = false;
                                TaskParametersBuilder taskParametersBuilder = commandRunner.getParametersBuilder(pluginRepository, pluginDetailsCache, simplePluginResourceCache, directoryBasedPluginVerificationReportage);
                                T t2 = objectRef.element;
                                Intrinsics.checkNotNullExpressionValue(t2, "freeArgs");
                                Closeable closeable2 = taskParametersBuilder.build(cmdOpts, (List)t2);
                                Throwable throwable2 = null;
                                try {
                                    TaskParameters parameters2 = (TaskParameters)closeable2;
                                    boolean bl2 = false;
                                    directoryBasedPluginVerificationReportage.logVerificationStage("Task " + commandRunner.getCommandName() + " parameters:\n" + parameters2.getPresentableText());
                                    taskResult2 = parameters2.createTask().execute(directoryBasedPluginVerificationReportage, pluginDetailsCache);
                                }
                                catch (Throwable throwable3) {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    CloseableKt.closeFinally(closeable2, throwable2);
                                }
                                taskResult = taskResult2;
                            }
                            catch (Throwable throwable4) {
                                throwable = throwable4;
                                throw throwable4;
                            }
                            finally {
                                CloseableKt.closeFinally(closeable, throwable);
                            }
                            TaskResult taskResult3 = taskResult;
                            return taskResult3;
                        }
                    });
                    boolean bl4 = false;
                    TaskResultPrinter taskResultsPrinter = $this$main_u24lambda_u243_u24lambda_u242_u24lambda_u241_u24lambda_u240.getTaskResult().createTaskResultsPrinter(pluginRepository);
                    taskResultsPrinter.printResults($this$main_u24lambda_u243_u24lambda_u242_u24lambda_u241_u24lambda_u240.getTaskResult(), outputOptions);
                    INSTANCE.reportDownloadStatistics(reportage, outputOptions, pluginFilesBank);
                    reportageAggregator.handleAggregatedReportage();
                    INSTANCE.reportVerificationDuration(reportage, $this$main_u24lambda_u243_u24lambda_u242_u24lambda_u241_u24lambda_u240);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable3 = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally(closeable2, throwable3);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable, throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportDownloadStatistics(PluginVerificationReportage $this$reportDownloadStatistics, OutputOptions outputOptions, PluginFilesBank pluginFilesBank) {
        void $this$fold$iv;
        DownloadStatistics downloadStatistics = pluginFilesBank.getDownloadStatistics();
        Iterable iterable = pluginFilesBank.getAvailablePluginFiles();
        SpaceAmount initial$iv = SpaceAmount.Companion.getZERO_SPACE();
        boolean $i$f$fold = false;
        SpaceAmount accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void availableFile;
            AvailableFile availableFile2 = (AvailableFile)element$iv;
            SpaceAmount acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc.plus(((SpaceWeight)availableFile.getResourceInfo().getWeight()).getSpaceAmount());
        }
        SpaceAmount totalSpaceUsed = accumulator$iv;
        SpaceAmount totalDownloadedAmount = downloadStatistics.getTotalDownloadedAmount();
        Duration totalDownloadDuration = downloadStatistics.getTotalAstronomicalDownloadDuration();
        $this$reportDownloadStatistics.logVerificationStage("Total time spent downloading plugins and their dependencies: " + FormatUtilsKt.formatDuration(totalDownloadDuration));
        $this$reportDownloadStatistics.logVerificationStage("Total amount of plugins and dependencies downloaded: " + totalDownloadedAmount.presentableAmount());
        $this$reportDownloadStatistics.logVerificationStage("Total amount of space used for plugins and dependencies: " + totalSpaceUsed.presentableAmount());
        if (outputOptions.getTeamCityLog() != null) {
            outputOptions.getTeamCityLog().buildStatisticValue("intellij.plugin.verifier.downloading.time.ms", totalDownloadDuration.toMillis());
            outputOptions.getTeamCityLog().buildStatisticValue("intellij.plugin.verifier.downloading.amount.bytes", (long)totalDownloadedAmount.to(SpaceUnit.BYTE));
            outputOptions.getTeamCityLog().buildStatisticValue("intellij.plugin.verifier.total.space.used", (long)totalSpaceUsed.to(SpaceUnit.BYTE));
        }
    }

    private final void reportVerificationDuration(PluginVerificationReportage $this$reportVerificationDuration, MeasuredResult measuredResult) {
        $this$reportVerificationDuration.logVerificationStage("Total time spent in plugin verification: " + FormatUtilsKt.formatDuration(measuredResult.getDuration()));
    }

    private final DiskSpaceSetting getDiskSpaceSetting(String propertyName, long defaultAmount) {
        String string = System.getProperty(propertyName);
        long property = string != null ? Long.parseLong(string) : defaultAmount;
        SpaceAmount megabytes = SpaceAmount.Companion.ofMegabytes(property);
        return new DiskSpaceSetting(megabytes, null, null, 6, null);
    }

    /*
     * WARNING - void declaration
     */
    private final CommandRunner findTaskRunner(String command) {
        Object v0;
        block3: {
            Iterable iterable = commandRunners;
            for (Object t2 : iterable) {
                CommandRunner it = (CommandRunner)t2;
                boolean bl = false;
                if (!Intrinsics.areEqual(command, it.getCommandName())) continue;
                v0 = t2;
                break block3;
            }
            v0 = null;
        }
        CommandRunner commandRunner = v0;
        if (commandRunner == null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = commandRunners;
            String string = command;
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CommandRunner commandRunner2 = (CommandRunner)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getCommandName());
            }
            String string2 = "Unsupported command: " + string + ". Supported commands: " + (List)destination$iv$iv;
            throw new IllegalArgumentException(string2);
        }
        return commandRunner;
    }

    static {
        CommandRunner[] commandRunnerArray = new CommandRunner[]{new CheckPluginRunner(), new CheckIdeRunner(), new CheckTrunkApiRunner(), new CheckPluginApiRunner(), new ProcessAllPluginsCommand()};
        commandRunners = CollectionsKt.listOf(commandRunnerArray);
        pluginVerifierVersion$delegate = LazyKt.lazy(pluginVerifierVersion.2.INSTANCE);
        verifierHomeDirectory$delegate = LazyKt.lazy(verifierHomeDirectory.2.INSTANCE);
        pluginRepositoryUrl$delegate = LazyKt.lazy(pluginRepositoryUrl.2.INSTANCE);
        Path path = INSTANCE.getVerifierHomeDirectory().resolve("loaded-plugins");
        Intrinsics.checkNotNullExpressionValue(path, "verifierHomeDirectory.resolve(\"loaded-plugins\")");
        downloadDirectory = FileUtilKt.createDir(path);
        Path path2 = INSTANCE.getVerifierHomeDirectory().resolve("ides");
        Intrinsics.checkNotNullExpressionValue(path2, "verifierHomeDirectory.resolve(\"ides\")");
        ideDownloadDirectory = FileUtilKt.createDir(path2);
    }
}

