/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin.loaders;

import com.jetbrains.plugin.structure.base.plugin.PluginIcon;
import com.jetbrains.plugin.structure.base.plugin.ThirdPartyDependency;
import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.UnableToReadDescriptor;
import com.jetbrains.plugin.structure.base.problems.UnexpectedDescriptorElements;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.intellij.plugin.PluginCreator;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.LibDirectoryPluginLoader;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginDirectoryLoaderKt;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginIconLoader;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginLoader;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginLoaderProvider;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginLoadingContext;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.ThirdPartyDependencyLoader;
import com.jetbrains.plugin.structure.intellij.problems.PluginCreationResultResolver;
import com.jetbrains.plugin.structure.intellij.resources.ResourceResolver;
import com.jetbrains.plugin.structure.intellij.utils.JDOMUtil;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom2.Document;
import org.jdom2.input.JDOMParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginDirectoryLoader;", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginLoader;", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginDirectoryLoader$Context;", "pluginLoaderRegistry", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginLoaderProvider;", "(Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginLoaderProvider;)V", "libDirectoryLoader", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/LibDirectoryPluginLoader;", "getLibDirectoryLoader", "()Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/LibDirectoryPluginLoader;", "pluginIconLoader", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginIconLoader;", "thirdPartyDependencyLoader", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/ThirdPartyDependencyLoader;", "loadPlugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;", "pluginLoadingContext", "Context", "structure-intellij"})
@SourceDebugExtension(value={"SMAP\nPluginDirectoryLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginDirectoryLoader.kt\ncom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginDirectoryLoader\n+ 2 PluginLoaderProvider.kt\ncom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginLoaderProvider\n*L\n1#1,83:1\n21#2:84\n*E\n*S KotlinDebug\n*F\n+ 1 PluginDirectoryLoader.kt\ncom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginDirectoryLoader\n*L\n29#1:84\n*E\n"})
public final class PluginDirectoryLoader
implements PluginLoader<Context> {
    private final PluginIconLoader pluginIconLoader;
    private final ThirdPartyDependencyLoader thirdPartyDependencyLoader;
    private final PluginLoaderProvider pluginLoaderRegistry;

    private final LibDirectoryPluginLoader getLibDirectoryLoader() {
        PluginLoaderProvider this_$iv = this.pluginLoaderRegistry;
        boolean $i$f$get$structure_intellij = false;
        PluginLoader<LibDirectoryPluginLoader.Context> pluginLoader = this_$iv.get$structure_intellij(LibDirectoryPluginLoader.Context.class);
        if (pluginLoader == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.plugin.structure.intellij.plugin.loaders.LibDirectoryPluginLoader");
        }
        return (LibDirectoryPluginLoader)((PluginLoader)((LibDirectoryPluginLoader)pluginLoader));
    }

    @Override
    @NotNull
    public PluginCreator loadPlugin(@NotNull Context pluginLoadingContext) {
        PluginCreator pluginCreator;
        Path descriptorFile;
        Intrinsics.checkNotNullParameter(pluginLoadingContext, "pluginLoadingContext");
        Context $this$with = pluginLoadingContext;
        boolean bl = false;
        Path path = descriptorFile = $this$with.getPluginDirectory().resolve("META-INF").resolve(FileUtilKt.withPathSeparatorOf($this$with.getDescriptorPath(), $this$with.getPluginDirectory()));
        Intrinsics.checkNotNullExpressionValue(path, "descriptorFile");
        if (!FileUtilKt.exists(path)) {
            pluginCreator = this.getLibDirectoryLoader().loadPlugin(new LibDirectoryPluginLoader.Context($this$with.getPluginDirectory(), $this$with.getDescriptorPath(), $this$with.getValidateDescriptor(), $this$with.getResourceResolver(), $this$with.getParentPlugin(), $this$with.getProblemResolver(), false, 64, null));
        } else {
            PluginCreator pluginCreator2;
            try {
                PluginCreator pluginCreator3;
                Document document2 = JDOMUtil.loadDocument(Files.newInputStream(descriptorFile, new OpenOption[0]));
                Intrinsics.checkNotNullExpressionValue(document2, "JDOMUtil.loadDocument(Fi\u2026utStream(descriptorFile))");
                Document document3 = document2;
                List<PluginIcon> icons = this.pluginIconLoader.load($this$with.getPluginDirectory());
                List<ThirdPartyDependency> dependencies = this.thirdPartyDependencyLoader.load($this$with.getPluginDirectory());
                PluginCreator $this$apply = pluginCreator3 = PluginCreator.Companion.createPlugin(FileUtilKt.getSimpleName($this$with.getPluginDirectory()), $this$with.getDescriptorPath(), $this$with.getParentPlugin(), $this$with.getValidateDescriptor(), document3, descriptorFile, $this$with.getResourceResolver(), $this$with.getProblemResolver());
                boolean bl2 = false;
                $this$apply.setIcons(icons);
                $this$apply.setThirdPartyDependencies(dependencies);
                $this$apply.setHasDotNetPart($this$with.getHasDotNetDirectory());
                pluginCreator2 = pluginCreator3;
            }
            catch (JDOMParseException e) {
                PluginDirectoryLoaderKt.access$getLOG$p().info("Unable to parse plugin descriptor " + $this$with.getDescriptorPath() + " of plugin " + descriptorFile, e);
                pluginCreator2 = PluginCreator.Companion.createInvalidPlugin($this$with.getPluginDirectory(), $this$with.getDescriptorPath(), (PluginProblem)new UnexpectedDescriptorElements(e.getLineNumber(), $this$with.getDescriptorPath()));
            }
            catch (Exception e) {
                PluginDirectoryLoaderKt.access$getLOG$p().info("Unable to read plugin descriptor " + $this$with.getDescriptorPath() + " of plugin " + descriptorFile, e);
                pluginCreator2 = PluginCreator.Companion.createInvalidPlugin($this$with.getPluginDirectory(), $this$with.getDescriptorPath(), (PluginProblem)new UnableToReadDescriptor($this$with.getDescriptorPath(), $this$with.getDescriptorPath()));
            }
            pluginCreator = pluginCreator2;
        }
        return pluginCreator;
    }

    public PluginDirectoryLoader(@NotNull PluginLoaderProvider pluginLoaderRegistry) {
        Intrinsics.checkNotNullParameter(pluginLoaderRegistry, "pluginLoaderRegistry");
        this.pluginLoaderRegistry = pluginLoaderRegistry;
        this.pluginIconLoader = new PluginIconLoader();
        this.thirdPartyDependencyLoader = new ThirdPartyDependencyLoader();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00c6\u0003J\t\u0010 \u001a\u00020\tH\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\t\u0010\"\u001a\u00020\rH\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003JQ\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010%\u001a\u00020\u00072\b\u0010&\u001a\u0004\u0018\u00010'H\u00d6\u0003J\t\u0010(\u001a\u00020)H\u00d6\u0001J\t\u0010*\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013\u00a8\u0006+"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginDirectoryLoader$Context;", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginLoadingContext;", "pluginDirectory", "Ljava/nio/file/Path;", "descriptorPath", "", "validateDescriptor", "", "resourceResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "parentPlugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;", "problemResolver", "Lcom/jetbrains/plugin/structure/intellij/problems/PluginCreationResultResolver;", "hasDotNetDirectory", "(Ljava/nio/file/Path;Ljava/lang/String;ZLcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;Lcom/jetbrains/plugin/structure/intellij/problems/PluginCreationResultResolver;Z)V", "getDescriptorPath", "()Ljava/lang/String;", "getHasDotNetDirectory", "()Z", "getParentPlugin", "()Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;", "getPluginDirectory", "()Ljava/nio/file/Path;", "getProblemResolver", "()Lcom/jetbrains/plugin/structure/intellij/problems/PluginCreationResultResolver;", "getResourceResolver", "()Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "getValidateDescriptor", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "", "hashCode", "", "toString", "structure-intellij"})
    public static final class Context
    extends PluginLoadingContext {
        @NotNull
        private final Path pluginDirectory;
        @NotNull
        private final String descriptorPath;
        private final boolean validateDescriptor;
        @NotNull
        private final ResourceResolver resourceResolver;
        @Nullable
        private final PluginCreator parentPlugin;
        @NotNull
        private final PluginCreationResultResolver problemResolver;
        private final boolean hasDotNetDirectory;

        @NotNull
        public final Path getPluginDirectory() {
            return this.pluginDirectory;
        }

        @NotNull
        public final String getDescriptorPath() {
            return this.descriptorPath;
        }

        public final boolean getValidateDescriptor() {
            return this.validateDescriptor;
        }

        @Override
        @NotNull
        public ResourceResolver getResourceResolver() {
            return this.resourceResolver;
        }

        @Nullable
        public final PluginCreator getParentPlugin() {
            return this.parentPlugin;
        }

        @Override
        @NotNull
        public PluginCreationResultResolver getProblemResolver() {
            return this.problemResolver;
        }

        public final boolean getHasDotNetDirectory() {
            return this.hasDotNetDirectory;
        }

        public Context(@NotNull Path pluginDirectory, @NotNull String descriptorPath, boolean validateDescriptor, @NotNull ResourceResolver resourceResolver, @Nullable PluginCreator parentPlugin, @NotNull PluginCreationResultResolver problemResolver, boolean hasDotNetDirectory) {
            Intrinsics.checkNotNullParameter(pluginDirectory, "pluginDirectory");
            Intrinsics.checkNotNullParameter(descriptorPath, "descriptorPath");
            Intrinsics.checkNotNullParameter(resourceResolver, "resourceResolver");
            Intrinsics.checkNotNullParameter(problemResolver, "problemResolver");
            super(resourceResolver, problemResolver);
            this.pluginDirectory = pluginDirectory;
            this.descriptorPath = descriptorPath;
            this.validateDescriptor = validateDescriptor;
            this.resourceResolver = resourceResolver;
            this.parentPlugin = parentPlugin;
            this.problemResolver = problemResolver;
            this.hasDotNetDirectory = hasDotNetDirectory;
        }

        public /* synthetic */ Context(Path path, String string, boolean bl, ResourceResolver resourceResolver, PluginCreator pluginCreator, PluginCreationResultResolver pluginCreationResultResolver, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker2) {
            if ((n & 0x40) != 0) {
                bl2 = false;
            }
            this(path, string, bl, resourceResolver, pluginCreator, pluginCreationResultResolver, bl2);
        }

        @NotNull
        public final Path component1() {
            return this.pluginDirectory;
        }

        @NotNull
        public final String component2() {
            return this.descriptorPath;
        }

        public final boolean component3() {
            return this.validateDescriptor;
        }

        @NotNull
        public final ResourceResolver component4() {
            return this.getResourceResolver();
        }

        @Nullable
        public final PluginCreator component5() {
            return this.parentPlugin;
        }

        @NotNull
        public final PluginCreationResultResolver component6() {
            return this.getProblemResolver();
        }

        public final boolean component7() {
            return this.hasDotNetDirectory;
        }

        @NotNull
        public final Context copy(@NotNull Path pluginDirectory, @NotNull String descriptorPath, boolean validateDescriptor, @NotNull ResourceResolver resourceResolver, @Nullable PluginCreator parentPlugin, @NotNull PluginCreationResultResolver problemResolver, boolean hasDotNetDirectory) {
            Intrinsics.checkNotNullParameter(pluginDirectory, "pluginDirectory");
            Intrinsics.checkNotNullParameter(descriptorPath, "descriptorPath");
            Intrinsics.checkNotNullParameter(resourceResolver, "resourceResolver");
            Intrinsics.checkNotNullParameter(problemResolver, "problemResolver");
            return new Context(pluginDirectory, descriptorPath, validateDescriptor, resourceResolver, parentPlugin, problemResolver, hasDotNetDirectory);
        }

        public static /* synthetic */ Context copy$default(Context context, Path path, String string, boolean bl, ResourceResolver resourceResolver, PluginCreator pluginCreator, PluginCreationResultResolver pluginCreationResultResolver, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                path = context.pluginDirectory;
            }
            if ((n & 2) != 0) {
                string = context.descriptorPath;
            }
            if ((n & 4) != 0) {
                bl = context.validateDescriptor;
            }
            if ((n & 8) != 0) {
                resourceResolver = context.getResourceResolver();
            }
            if ((n & 0x10) != 0) {
                pluginCreator = context.parentPlugin;
            }
            if ((n & 0x20) != 0) {
                pluginCreationResultResolver = context.getProblemResolver();
            }
            if ((n & 0x40) != 0) {
                bl2 = context.hasDotNetDirectory;
            }
            return context.copy(path, string, bl, resourceResolver, pluginCreator, pluginCreationResultResolver, bl2);
        }

        @NotNull
        public String toString() {
            return "Context(pluginDirectory=" + this.pluginDirectory + ", descriptorPath=" + this.descriptorPath + ", validateDescriptor=" + this.validateDescriptor + ", resourceResolver=" + this.getResourceResolver() + ", parentPlugin=" + this.parentPlugin + ", problemResolver=" + this.getProblemResolver() + ", hasDotNetDirectory=" + this.hasDotNetDirectory + ")";
        }

        public int hashCode() {
            Path path = this.pluginDirectory;
            String string = this.descriptorPath;
            int n = ((path != null ? ((Object)path).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31;
            int n2 = this.validateDescriptor ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            ResourceResolver resourceResolver = this.getResourceResolver();
            PluginCreator pluginCreator = this.parentPlugin;
            PluginCreationResultResolver pluginCreationResultResolver = this.getProblemResolver();
            int n3 = ((((n + n2) * 31 + (resourceResolver != null ? resourceResolver.hashCode() : 0)) * 31 + (pluginCreator != null ? pluginCreator.hashCode() : 0)) * 31 + (pluginCreationResultResolver != null ? pluginCreationResultResolver.hashCode() : 0)) * 31;
            int n4 = this.hasDotNetDirectory ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            return n3 + n4;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Context)) break block3;
                    Context context = (Context)object;
                    if (!Intrinsics.areEqual(this.pluginDirectory, context.pluginDirectory) || !Intrinsics.areEqual(this.descriptorPath, context.descriptorPath) || this.validateDescriptor != context.validateDescriptor || !Intrinsics.areEqual(this.getResourceResolver(), context.getResourceResolver()) || !Intrinsics.areEqual(this.parentPlugin, context.parentPlugin) || !Intrinsics.areEqual(this.getProblemResolver(), context.getProblemResolver()) || this.hasDotNetDirectory != context.hasDotNetDirectory) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

