/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin.loaders;

import com.jetbrains.plugin.structure.base.problems.PluginDescriptorIsNotFound;
import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.UnableToExtractZip;
import com.jetbrains.plugin.structure.base.problems.UnableToReadDescriptor;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.intellij.plugin.PluginCreator;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.JarPluginLoaderKt;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginLoader;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginLoadersKt;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginLoadingContext;
import com.jetbrains.plugin.structure.intellij.problems.PluginCreationResultResolver;
import com.jetbrains.plugin.structure.intellij.resources.ResourceResolver;
import com.jetbrains.plugin.structure.jar.JarArchiveCannotBeOpenException;
import com.jetbrains.plugin.structure.jar.JarFileSystemProvider;
import com.jetbrains.plugin.structure.jar.PluginDescriptorResult;
import com.jetbrains.plugin.structure.jar.PluginJar;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom2.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/JarPluginLoader;", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginLoader;", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/JarPluginLoader$Context;", "fileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "(Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;)V", "loadPlugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;", "pluginLoadingContext", "Context", "structure-intellij"})
public final class JarPluginLoader
implements PluginLoader<Context> {
    private final JarFileSystemProvider fileSystemProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public PluginCreator loadPlugin(@NotNull Context pluginLoadingContext) {
        Object object;
        Intrinsics.checkNotNullParameter(pluginLoadingContext, "pluginLoadingContext");
        Context $this$with = pluginLoadingContext;
        boolean bl = false;
        try {
            PluginCreator pluginCreator;
            object = new PluginJar($this$with.getJarPath(), this.fileSystemProvider);
            Throwable throwable = null;
            try {
                PluginCreator pluginCreator2;
                PluginCreator pluginCreator3;
                PluginJar jar2 = (PluginJar)object;
                boolean bl2 = false;
                PluginDescriptorResult descriptor2 = jar2.getPluginDescriptor("META-INF/" + $this$with.getDescriptorPath());
                if (descriptor2 instanceof PluginDescriptorResult.Found) {
                    try {
                        PluginCreator pluginCreator4;
                        Document descriptorXml = PluginLoadersKt.loadXml((PluginDescriptorResult.Found)descriptor2);
                        PluginCreator $this$apply = pluginCreator4 = PluginCreator.Companion.createPlugin(FileUtilKt.getSimpleName($this$with.getJarPath()), $this$with.getDescriptorPath(), $this$with.getParentPlugin(), $this$with.getValidateDescriptor(), descriptorXml, ((PluginDescriptorResult.Found)descriptor2).getPath(), $this$with.getResourceResolver(), $this$with.getProblemResolver());
                        boolean bl3 = false;
                        $this$apply.setIcons(jar2.getIcons());
                        $this$apply.setThirdPartyDependencies(jar2.getThirdPartyDependencies());
                        $this$apply.setHasDotNetPart($this$with.getHasDotNetDirectory());
                        pluginCreator3 = pluginCreator4;
                    }
                    catch (Exception e) {
                        JarPluginLoaderKt.access$getLOG$p().warn("Unable to read descriptor [" + $this$with.getDescriptorPath() + "] from [" + $this$with.getJarPath() + "]", e);
                        String message2 = e.getLocalizedMessage();
                        pluginCreator3 = PluginCreator.Companion.createInvalidPlugin($this$with.getJarPath(), $this$with.getDescriptorPath(), (PluginProblem)new UnableToReadDescriptor($this$with.getDescriptorPath(), message2));
                    }
                    pluginCreator2 = pluginCreator3;
                } else {
                    PluginCreator it = pluginCreator3 = PluginCreator.Companion.createInvalidPlugin($this$with.getJarPath(), $this$with.getDescriptorPath(), (PluginProblem)new PluginDescriptorIsNotFound($this$with.getDescriptorPath()));
                    boolean bl4 = false;
                    JarPluginLoaderKt.access$getLOG$p().debug("Unable to resolve descriptor [{}] from [{}] ({})", $this$with.getDescriptorPath(), $this$with.getJarPath(), descriptor2);
                    pluginCreator2 = pluginCreator3;
                }
                pluginCreator = pluginCreator2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, throwable);
            }
            object = pluginCreator;
        }
        catch (JarArchiveCannotBeOpenException e) {
            JarPluginLoaderKt.access$getLOG$p().warn("Unable to extract {} (searching for {}): {}", $this$with.getJarPath(), $this$with.getDescriptorPath(), LanguageUtilsKt.getShortExceptionMessage(e));
            object = PluginCreator.Companion.createInvalidPlugin($this$with.getJarPath(), $this$with.getDescriptorPath(), (PluginProblem)new UnableToExtractZip());
        }
        return object;
    }

    public JarPluginLoader(@NotNull JarFileSystemProvider fileSystemProvider) {
        Intrinsics.checkNotNullParameter(fileSystemProvider, "fileSystemProvider");
        this.fileSystemProvider = fileSystemProvider;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00c6\u0003J\t\u0010 \u001a\u00020\tH\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\t\u0010\"\u001a\u00020\rH\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003JQ\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010%\u001a\u00020\u00072\b\u0010&\u001a\u0004\u0018\u00010'H\u00d6\u0003J\t\u0010(\u001a\u00020)H\u00d6\u0001J\t\u0010*\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013\u00a8\u0006+"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/JarPluginLoader$Context;", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginLoadingContext;", "jarPath", "Ljava/nio/file/Path;", "descriptorPath", "", "validateDescriptor", "", "resourceResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "parentPlugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;", "problemResolver", "Lcom/jetbrains/plugin/structure/intellij/problems/PluginCreationResultResolver;", "hasDotNetDirectory", "(Ljava/nio/file/Path;Ljava/lang/String;ZLcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;Lcom/jetbrains/plugin/structure/intellij/problems/PluginCreationResultResolver;Z)V", "getDescriptorPath", "()Ljava/lang/String;", "getHasDotNetDirectory", "()Z", "getJarPath", "()Ljava/nio/file/Path;", "getParentPlugin", "()Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;", "getProblemResolver", "()Lcom/jetbrains/plugin/structure/intellij/problems/PluginCreationResultResolver;", "getResourceResolver", "()Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "getValidateDescriptor", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "", "hashCode", "", "toString", "structure-intellij"})
    public static final class Context
    extends PluginLoadingContext {
        @NotNull
        private final Path jarPath;
        @NotNull
        private final String descriptorPath;
        private final boolean validateDescriptor;
        @NotNull
        private final ResourceResolver resourceResolver;
        @Nullable
        private final PluginCreator parentPlugin;
        @NotNull
        private final PluginCreationResultResolver problemResolver;
        private final boolean hasDotNetDirectory;

        @NotNull
        public final Path getJarPath() {
            return this.jarPath;
        }

        @NotNull
        public final String getDescriptorPath() {
            return this.descriptorPath;
        }

        public final boolean getValidateDescriptor() {
            return this.validateDescriptor;
        }

        @Override
        @NotNull
        public ResourceResolver getResourceResolver() {
            return this.resourceResolver;
        }

        @Nullable
        public final PluginCreator getParentPlugin() {
            return this.parentPlugin;
        }

        @Override
        @NotNull
        public PluginCreationResultResolver getProblemResolver() {
            return this.problemResolver;
        }

        public final boolean getHasDotNetDirectory() {
            return this.hasDotNetDirectory;
        }

        public Context(@NotNull Path jarPath, @NotNull String descriptorPath, boolean validateDescriptor, @NotNull ResourceResolver resourceResolver, @Nullable PluginCreator parentPlugin, @NotNull PluginCreationResultResolver problemResolver, boolean hasDotNetDirectory) {
            Intrinsics.checkNotNullParameter(jarPath, "jarPath");
            Intrinsics.checkNotNullParameter(descriptorPath, "descriptorPath");
            Intrinsics.checkNotNullParameter(resourceResolver, "resourceResolver");
            Intrinsics.checkNotNullParameter(problemResolver, "problemResolver");
            super(resourceResolver, problemResolver);
            this.jarPath = jarPath;
            this.descriptorPath = descriptorPath;
            this.validateDescriptor = validateDescriptor;
            this.resourceResolver = resourceResolver;
            this.parentPlugin = parentPlugin;
            this.problemResolver = problemResolver;
            this.hasDotNetDirectory = hasDotNetDirectory;
        }

        public /* synthetic */ Context(Path path, String string, boolean bl, ResourceResolver resourceResolver, PluginCreator pluginCreator, PluginCreationResultResolver pluginCreationResultResolver, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker2) {
            if ((n & 0x40) != 0) {
                bl2 = false;
            }
            this(path, string, bl, resourceResolver, pluginCreator, pluginCreationResultResolver, bl2);
        }

        @NotNull
        public final Path component1() {
            return this.jarPath;
        }

        @NotNull
        public final String component2() {
            return this.descriptorPath;
        }

        public final boolean component3() {
            return this.validateDescriptor;
        }

        @NotNull
        public final ResourceResolver component4() {
            return this.getResourceResolver();
        }

        @Nullable
        public final PluginCreator component5() {
            return this.parentPlugin;
        }

        @NotNull
        public final PluginCreationResultResolver component6() {
            return this.getProblemResolver();
        }

        public final boolean component7() {
            return this.hasDotNetDirectory;
        }

        @NotNull
        public final Context copy(@NotNull Path jarPath, @NotNull String descriptorPath, boolean validateDescriptor, @NotNull ResourceResolver resourceResolver, @Nullable PluginCreator parentPlugin, @NotNull PluginCreationResultResolver problemResolver, boolean hasDotNetDirectory) {
            Intrinsics.checkNotNullParameter(jarPath, "jarPath");
            Intrinsics.checkNotNullParameter(descriptorPath, "descriptorPath");
            Intrinsics.checkNotNullParameter(resourceResolver, "resourceResolver");
            Intrinsics.checkNotNullParameter(problemResolver, "problemResolver");
            return new Context(jarPath, descriptorPath, validateDescriptor, resourceResolver, parentPlugin, problemResolver, hasDotNetDirectory);
        }

        public static /* synthetic */ Context copy$default(Context context, Path path, String string, boolean bl, ResourceResolver resourceResolver, PluginCreator pluginCreator, PluginCreationResultResolver pluginCreationResultResolver, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                path = context.jarPath;
            }
            if ((n & 2) != 0) {
                string = context.descriptorPath;
            }
            if ((n & 4) != 0) {
                bl = context.validateDescriptor;
            }
            if ((n & 8) != 0) {
                resourceResolver = context.getResourceResolver();
            }
            if ((n & 0x10) != 0) {
                pluginCreator = context.parentPlugin;
            }
            if ((n & 0x20) != 0) {
                pluginCreationResultResolver = context.getProblemResolver();
            }
            if ((n & 0x40) != 0) {
                bl2 = context.hasDotNetDirectory;
            }
            return context.copy(path, string, bl, resourceResolver, pluginCreator, pluginCreationResultResolver, bl2);
        }

        @NotNull
        public String toString() {
            return "Context(jarPath=" + this.jarPath + ", descriptorPath=" + this.descriptorPath + ", validateDescriptor=" + this.validateDescriptor + ", resourceResolver=" + this.getResourceResolver() + ", parentPlugin=" + this.parentPlugin + ", problemResolver=" + this.getProblemResolver() + ", hasDotNetDirectory=" + this.hasDotNetDirectory + ")";
        }

        public int hashCode() {
            Path path = this.jarPath;
            String string = this.descriptorPath;
            int n = ((path != null ? ((Object)path).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31;
            int n2 = this.validateDescriptor ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            ResourceResolver resourceResolver = this.getResourceResolver();
            PluginCreator pluginCreator = this.parentPlugin;
            PluginCreationResultResolver pluginCreationResultResolver = this.getProblemResolver();
            int n3 = ((((n + n2) * 31 + (resourceResolver != null ? resourceResolver.hashCode() : 0)) * 31 + (pluginCreator != null ? pluginCreator.hashCode() : 0)) * 31 + (pluginCreationResultResolver != null ? pluginCreationResultResolver.hashCode() : 0)) * 31;
            int n4 = this.hasDotNetDirectory ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            return n3 + n4;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Context)) break block3;
                    Context context = (Context)object;
                    if (!Intrinsics.areEqual(this.jarPath, context.jarPath) || !Intrinsics.areEqual(this.descriptorPath, context.descriptorPath) || this.validateDescriptor != context.validateDescriptor || !Intrinsics.areEqual(this.getResourceResolver(), context.getResourceResolver()) || !Intrinsics.areEqual(this.parentPlugin, context.parentPlugin) || !Intrinsics.areEqual(this.getProblemResolver(), context.getProblemResolver()) || this.hasDotNetDirectory != context.hasDotNetDirectory) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

