/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin;

import com.jetbrains.plugin.structure.base.problems.NotBoolean;
import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.PropertyNotSpecified;
import com.jetbrains.plugin.structure.base.problems.TooLongPropertyValue;
import com.jetbrains.plugin.structure.base.problems.VendorCannotBeEmpty;
import com.jetbrains.plugin.structure.intellij.beans.IdeaVersionBean;
import com.jetbrains.plugin.structure.intellij.beans.PluginBean;
import com.jetbrains.plugin.structure.intellij.beans.PluginDependencyBean;
import com.jetbrains.plugin.structure.intellij.beans.PluginVendorBean;
import com.jetbrains.plugin.structure.intellij.beans.ProductDescriptorBean;
import com.jetbrains.plugin.structure.intellij.plugin.PluginBeanValidatorKt;
import com.jetbrains.plugin.structure.intellij.plugin.ValidationContext;
import com.jetbrains.plugin.structure.intellij.problems.DefaultChangeNotes;
import com.jetbrains.plugin.structure.intellij.problems.DescriptionNotStartingWithLatinCharacters;
import com.jetbrains.plugin.structure.intellij.problems.ErroneousSinceBuild;
import com.jetbrains.plugin.structure.intellij.problems.HttpLinkInDescription;
import com.jetbrains.plugin.structure.intellij.problems.InvalidDependencyId;
import com.jetbrains.plugin.structure.intellij.problems.InvalidModuleBean;
import com.jetbrains.plugin.structure.intellij.problems.InvalidSinceBuild;
import com.jetbrains.plugin.structure.intellij.problems.OptionalDependencyConfigFileIsEmpty;
import com.jetbrains.plugin.structure.intellij.problems.OptionalDependencyConfigFileNotSpecified;
import com.jetbrains.plugin.structure.intellij.problems.ProductCodePrefixInBuild;
import com.jetbrains.plugin.structure.intellij.problems.PropertyWithDefaultValue;
import com.jetbrains.plugin.structure.intellij.problems.ReleaseDateInFuture;
import com.jetbrains.plugin.structure.intellij.problems.ReleaseDateWrongFormat;
import com.jetbrains.plugin.structure.intellij.problems.SinceBuildCannotContainWildcard;
import com.jetbrains.plugin.structure.intellij.problems.SinceBuildNotSpecified;
import com.jetbrains.plugin.structure.intellij.problems.SuperfluousNonOptionalDependencyDeclaration;
import com.jetbrains.plugin.structure.intellij.problems.TemplateWordInPluginName;
import com.jetbrains.plugin.structure.intellij.verifiers.PluginIdVerifier;
import com.jetbrains.plugin.structure.intellij.verifiers.PluginUntilBuildVerifier;
import com.jetbrains.plugin.structure.intellij.verifiers.ProblemRegistrar;
import com.jetbrains.plugin.structure.intellij.verifiers.ProductReleaseVersionVerifier;
import com.jetbrains.plugin.structure.intellij.verifiers.ReusedDescriptorVerifier;
import com.jetbrains.plugin.structure.intellij.verifiers.SimpleVerifiersKt;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001c\u0010\t\u001a\u00020\n*\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0012\u001a\u00020\n*\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u001c\u0010\u0015\u001a\u00020\n*\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0002J\u0016\u0010\u0018\u001a\u00020\n*\u00020\u000e2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0014H\u0002J\u001a\u0010\u001a\u001a\u00020\n*\u00020\u000e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u0016\u0010\u001e\u001a\u00020\n*\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0014H\u0002J\u0014\u0010 \u001a\u00020\n*\u00020\u000e2\u0006\u0010!\u001a\u00020\u0014H\u0002J\u0014\u0010\"\u001a\u00020\n*\u00020\u000e2\u0006\u0010#\u001a\u00020\fH\u0002J\u0016\u0010$\u001a\u00020\n*\u00020\u000e2\b\u0010%\u001a\u0004\u0018\u00010&H\u0002J\u0014\u0010'\u001a\u00020\n*\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u0016\u0010(\u001a\u00020\n*\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0014H\u0002J\u0014\u0010)\u001a\u00020\n*\u00020\u000e2\u0006\u0010*\u001a\u00020\u0014H\u0002J\u0016\u0010+\u001a\u00020\n*\u00020\u000e2\b\u0010,\u001a\u0004\u0018\u00010\u0014H\u0002J\u001e\u0010-\u001a\u00020\n*\u00020\u000e2\u0006\u0010#\u001a\u00020\f2\b\u0010.\u001a\u0004\u0018\u00010/H\u0002J$\u00100\u001a\u00020\n*\u00020\u000e2\u0006\u00101\u001a\u00020\u00142\u0006\u00102\u001a\u00020\u00142\u0006\u00103\u001a\u000204H\u0002J\u0016\u00105\u001a\u00020\n*\u00020\u000e2\b\u00106\u001a\u0004\u0018\u00010\u0014H\u0002J\u0016\u00107\u001a\u00020\n*\u00020\u000e2\b\u00108\u001a\u0004\u0018\u00010\u0014H\u0002J\u0016\u00109\u001a\u00020\n*\u00020\u000e2\b\u0010:\u001a\u0004\u0018\u00010;H\u0002J\u0016\u0010<\u001a\u00020\n*\u00020\u000e2\b\u0010=\u001a\u0004\u0018\u00010\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/PluginBeanValidator;", "", "()V", "pluginIdVerifier", "Lcom/jetbrains/plugin/structure/intellij/verifiers/PluginIdVerifier;", "pluginProductReleaseVersionVerifier", "Lcom/jetbrains/plugin/structure/intellij/verifiers/ProductReleaseVersionVerifier;", "pluginUntilBuildVerifier", "Lcom/jetbrains/plugin/structure/intellij/verifiers/PluginUntilBuildVerifier;", "validate", "", "pluginBean", "Lcom/jetbrains/plugin/structure/intellij/beans/PluginBean;", "validationContext", "Lcom/jetbrains/plugin/structure/intellij/plugin/ValidationContext;", "validateDescriptor", "", "bean", "validateBeanUrl", "beanUrl", "", "validateBooleanFlag", "flag", "name", "validateChangeNotes", "changeNotes", "validateDependencies", "dependencies", "", "Lcom/jetbrains/plugin/structure/intellij/beans/PluginDependencyBean;", "validateDescription", "htmlDescription", "validateEapFlag", "eapFlag", "validateId", "plugin", "validateIdeaVersion", "versionBean", "Lcom/jetbrains/plugin/structure/intellij/beans/IdeaVersionBean;", "validateModules", "validateName", "validateOptionalFlag", "optionalFlag", "validateProductCode", "productCode", "validateProductDescriptor", "productDescriptor", "Lcom/jetbrains/plugin/structure/intellij/beans/ProductDescriptorBean;", "validatePropertyLength", "propertyName", "propertyValue", "maxLength", "", "validateReleaseDate", "releaseDate", "validateSinceBuild", "sinceBuild", "validateVendor", "vendorBean", "Lcom/jetbrains/plugin/structure/intellij/beans/PluginVendorBean;", "validateVersion", "pluginVersion", "structure-intellij"})
@SourceDebugExtension(value={"SMAP\nPluginBeanValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginBeanValidator.kt\ncom/jetbrains/plugin/structure/intellij/plugin/PluginBeanValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,287:1\n1747#2,3:288\n1747#2,3:292\n1855#2,2:295\n1747#2,3:297\n1#3:291\n*E\n*S KotlinDebug\n*F\n+ 1 PluginBeanValidator.kt\ncom/jetbrains/plugin/structure/intellij/plugin/PluginBeanValidator\n*L\n88#1,3:288\n126#1,3:292\n136#1,2:295\n283#1,3:297\n*E\n"})
public final class PluginBeanValidator {
    private final PluginIdVerifier pluginIdVerifier = new PluginIdVerifier();
    private final PluginUntilBuildVerifier pluginUntilBuildVerifier = new PluginUntilBuildVerifier();
    private final ProductReleaseVersionVerifier pluginProductReleaseVersionVerifier = new ProductReleaseVersionVerifier();

    public final void validate(@NotNull PluginBean pluginBean, @NotNull ValidationContext validationContext, boolean validateDescriptor) {
        Intrinsics.checkNotNullParameter(pluginBean, "pluginBean");
        Intrinsics.checkNotNullParameter(validationContext, "validationContext");
        this.validate(validationContext, pluginBean, validateDescriptor);
    }

    private final void validate(ValidationContext $this$validate, PluginBean bean, boolean validateDescriptor) {
        if (validateDescriptor) {
            this.validateBeanUrl($this$validate, bean.url);
            this.validateId($this$validate, bean);
            this.validateName($this$validate, bean.name);
            this.validateVersion($this$validate, bean.pluginVersion);
            this.validateDescription($this$validate, bean.description);
            this.validateChangeNotes($this$validate, bean.changeNotes);
            this.validateVendor($this$validate, bean.vendor);
            this.validateIdeaVersion($this$validate, bean.ideaVersion);
            Function1 function1 = new Function1<PluginProblem, Unit>($this$validate){

                public final void invoke(@NotNull PluginProblem p1) {
                    Intrinsics.checkNotNullParameter(p1, "p1");
                    ((ValidationContext)this.receiver).registerProblem(p1);
                }
            };
            this.pluginUntilBuildVerifier.verify(bean, $this$validate.getDescriptorPath(), new ProblemRegistrar(function1){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function1;
                }

                public final /* synthetic */ void registerProblem(PluginProblem problem) {
                    Intrinsics.checkNotNullParameter(problem, "problem");
                    Intrinsics.checkNotNullExpressionValue(this.function.invoke(problem), "invoke(...)");
                }

                public Function getFunctionDelegate() {
                    return this.function;
                }

                public boolean equals(Object object) {
                    return object instanceof ProblemRegistrar && object instanceof FunctionAdapter && Intrinsics.areEqual(this.function, ((FunctionAdapter)object).getFunctionDelegate());
                }

                public int hashCode() {
                    return this.function.hashCode();
                }
            });
            this.validateProductDescriptor($this$validate, bean, bean.productDescriptor);
        }
        List<PluginDependencyBean> list = bean.dependencies;
        Intrinsics.checkNotNullExpressionValue(list, "bean.dependencies");
        this.validateDependencies($this$validate, list);
        this.validateModules($this$validate, bean);
    }

    private final void validatePropertyLength(ValidationContext $this$validatePropertyLength, String propertyName, String propertyValue, int maxLength) {
        if (propertyValue.length() > maxLength) {
            $this$validatePropertyLength.registerProblem(new TooLongPropertyValue($this$validatePropertyLength.getDescriptorPath(), propertyName, propertyValue.length(), maxLength));
        }
    }

    private final void validateId(ValidationContext $this$validateId, PluginBean plugin) {
        Function1 function1 = new Function1<PluginProblem, Unit>($this$validateId){

            public final void invoke(@NotNull PluginProblem p1) {
                Intrinsics.checkNotNullParameter(p1, "p1");
                ((ValidationContext)this.receiver).registerProblem(p1);
            }
        };
        this.pluginIdVerifier.verify(plugin, $this$validateId.getDescriptorPath(), new /* invalid duplicate definition of identical inner class */);
    }

    private final void validateName(ValidationContext $this$validateName, String name) {
        CharSequence charSequence = name;
        if (charSequence == null || StringsKt.isBlank(charSequence)) {
            $this$validateName.registerProblem(new PropertyNotSpecified("name", $this$validateName.getDescriptorPath()));
        } else {
            boolean bl;
            block9: {
                Iterable $this$any$iv = PluginBeanValidatorKt.access$getDEFAULT_TEMPLATE_NAMES$p();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.equals(it, name, true)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (bl) {
                $this$validateName.registerProblem(new PropertyWithDefaultValue($this$validateName.getDescriptorPath(), PropertyWithDefaultValue.DefaultProperty.NAME, name));
            } else {
                Object v1;
                Object object;
                block10: {
                    Object object2 = object = (Iterable)PluginBeanValidatorKt.access$getPLUGIN_NAME_RESTRICTED_WORDS$p();
                    Iterator iterator2 = object2.iterator();
                    while (iterator2.hasNext()) {
                        Object t2 = iterator2.next();
                        String it = (String)t2;
                        boolean bl3 = false;
                        if (!StringsKt.contains((CharSequence)name, it, true)) continue;
                        v1 = t2;
                        break block10;
                    }
                    v1 = null;
                }
                String templateWord = v1;
                if (templateWord != null) {
                    $this$validateName.registerProblem(new TemplateWordInPluginName($this$validateName.getDescriptorPath(), name, templateWord));
                }
                this.validatePropertyLength($this$validateName, "name", name, 64);
                object = new Function1<PluginProblem, Unit>($this$validateName){

                    public final void invoke(@NotNull PluginProblem p1) {
                        Intrinsics.checkNotNullParameter(p1, "p1");
                        ((ValidationContext)this.receiver).registerProblem(p1);
                    }
                };
                SimpleVerifiersKt.verifyNewlines("name", name, $this$validateName.getDescriptorPath(), new /* invalid duplicate definition of identical inner class */);
            }
        }
    }

    private final void validateBeanUrl(ValidationContext $this$validateBeanUrl, String beanUrl) {
        if (beanUrl != null) {
            this.validatePropertyLength($this$validateBeanUrl, "plugin url", beanUrl, 255);
        }
    }

    private final void validateVersion(ValidationContext $this$validateVersion, String pluginVersion) {
        CharSequence charSequence = pluginVersion;
        if (charSequence == null || charSequence.length() == 0) {
            $this$validateVersion.registerProblem(new PropertyNotSpecified("version", $this$validateVersion.getDescriptorPath()));
        } else {
            this.validatePropertyLength($this$validateVersion, "version", pluginVersion, 64);
        }
    }

    private final void validateDescription(ValidationContext $this$validateDescription, String htmlDescription) {
        Elements links;
        String latinDescriptionPart;
        boolean bl;
        String textDescription;
        Document html;
        block8: {
            CharSequence charSequence = htmlDescription;
            if (charSequence == null || charSequence.length() == 0) {
                $this$validateDescription.registerProblem(new PropertyNotSpecified("description", $this$validateDescription.getDescriptorPath()));
                return;
            }
            this.validatePropertyLength($this$validateDescription, "description", htmlDescription, 65535);
            html = Jsoup.parseBodyFragment(htmlDescription);
            textDescription = html.text();
            Iterable $this$any$iv = PluginBeanValidatorKt.access$getDEFAULT_TEMPLATE_DESCRIPTIONS$p();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    String string = textDescription;
                    Intrinsics.checkNotNullExpressionValue(string, "textDescription");
                    if (!StringsKt.contains$default((CharSequence)string, it, false, 2, null)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            String string = $this$validateDescription.getDescriptorPath();
            String string2 = textDescription;
            Intrinsics.checkNotNullExpressionValue(string2, "textDescription");
            $this$validateDescription.registerProblem(new PropertyWithDefaultValue(string, PropertyWithDefaultValue.DefaultProperty.DESCRIPTION, string2));
            return;
        }
        Regex regex = PluginBeanValidatorKt.access$getSTARTS_WITH_LATIN_SYMBOLS_REGEX$p();
        String string = textDescription;
        Intrinsics.checkNotNullExpressionValue(string, "textDescription");
        MatchResult matchResult = Regex.find$default(regex, string, 0, 2, null);
        String string3 = latinDescriptionPart = matchResult != null ? matchResult.getValue() : null;
        if (latinDescriptionPart == null) {
            $this$validateDescription.registerProblem(new DescriptionNotStartingWithLatinCharacters());
        }
        Elements elements = links = html.select("[href],img[src]");
        Intrinsics.checkNotNullExpressionValue(elements, "links");
        Iterable $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element link = (Element)element$iv;
            boolean bl3 = false;
            String href = link.attr("abs:href");
            String src = link.attr("abs:src");
            String string4 = href;
            Intrinsics.checkNotNullExpressionValue(string4, "href");
            if (StringsKt.startsWith$default(string4, "http://", false, 2, null)) {
                $this$validateDescription.registerProblem(new HttpLinkInDescription(href));
            }
            String string5 = src;
            Intrinsics.checkNotNullExpressionValue(string5, "src");
            if (!StringsKt.startsWith$default(string5, "http://", false, 2, null)) continue;
            $this$validateDescription.registerProblem(new HttpLinkInDescription(src));
        }
    }

    private final void validateChangeNotes(ValidationContext $this$validateChangeNotes, String changeNotes) {
        CharSequence charSequence = changeNotes;
        if (charSequence == null || StringsKt.isBlank(charSequence)) {
            return;
        }
        if (StringsKt.contains$default((CharSequence)changeNotes, "Add change notes here", false, 2, null) || StringsKt.contains$default((CharSequence)changeNotes, "most HTML tags may be used", false, 2, null)) {
            $this$validateChangeNotes.registerProblem(new DefaultChangeNotes($this$validateChangeNotes.getDescriptorPath()));
        }
        this.validatePropertyLength($this$validateChangeNotes, "<change-notes>", changeNotes, 65535);
    }

    private final void validateVendor(ValidationContext $this$validateVendor, PluginVendorBean vendorBean) {
        if (vendorBean == null) {
            $this$validateVendor.registerProblem(new PropertyNotSpecified("vendor", $this$validateVendor.getDescriptorPath()));
            return;
        }
        CharSequence charSequence = vendorBean.name;
        if (charSequence == null || StringsKt.isBlank(charSequence)) {
            $this$validateVendor.registerProblem(new VendorCannotBeEmpty($this$validateVendor.getDescriptorPath()));
            return;
        }
        if (Intrinsics.areEqual("YourCompany", vendorBean.name)) {
            String string = $this$validateVendor.getDescriptorPath();
            String string2 = vendorBean.name;
            Intrinsics.checkNotNullExpressionValue(string2, "vendorBean.name");
            $this$validateVendor.registerProblem(new PropertyWithDefaultValue(string, PropertyWithDefaultValue.DefaultProperty.VENDOR, string2));
        }
        String string = vendorBean.name;
        Intrinsics.checkNotNullExpressionValue(string, "vendorBean.name");
        this.validatePropertyLength($this$validateVendor, "vendor", string, 255);
        if (Intrinsics.areEqual("https://www.yourcompany.com", vendorBean.url)) {
            String string3 = $this$validateVendor.getDescriptorPath();
            String string4 = vendorBean.url;
            Intrinsics.checkNotNullExpressionValue(string4, "vendorBean.url");
            $this$validateVendor.registerProblem(new PropertyWithDefaultValue(string3, PropertyWithDefaultValue.DefaultProperty.VENDOR_URL, string4));
        }
        String string5 = vendorBean.url;
        Intrinsics.checkNotNullExpressionValue(string5, "vendorBean.url");
        this.validatePropertyLength($this$validateVendor, "vendor url", string5, 255);
        if (Intrinsics.areEqual("support@yourcompany.com", vendorBean.email)) {
            String string6 = $this$validateVendor.getDescriptorPath();
            String string7 = vendorBean.email;
            Intrinsics.checkNotNullExpressionValue(string7, "vendorBean.email");
            $this$validateVendor.registerProblem(new PropertyWithDefaultValue(string6, PropertyWithDefaultValue.DefaultProperty.VENDOR_EMAIL, string7));
        }
        String string8 = vendorBean.email;
        Intrinsics.checkNotNullExpressionValue(string8, "vendorBean.email");
        this.validatePropertyLength($this$validateVendor, "vendor email", string8, 255);
    }

    private final void validateIdeaVersion(ValidationContext $this$validateIdeaVersion, IdeaVersionBean versionBean) {
        if (versionBean == null) {
            $this$validateIdeaVersion.registerProblem(new PropertyNotSpecified("idea-version", $this$validateIdeaVersion.getDescriptorPath()));
            return;
        }
        String sinceBuild = versionBean.sinceBuild;
        this.validateSinceBuild($this$validateIdeaVersion, sinceBuild);
    }

    private final void validateSinceBuild(ValidationContext $this$validateSinceBuild, String sinceBuild) {
        if (sinceBuild == null) {
            $this$validateSinceBuild.registerProblem(new SinceBuildNotSpecified($this$validateSinceBuild.getDescriptorPath()));
        } else {
            IdeVersion sinceBuildParsed = IdeVersion.createIdeVersionIfValid(sinceBuild);
            if (sinceBuildParsed == null) {
                $this$validateSinceBuild.registerProblem(new InvalidSinceBuild($this$validateSinceBuild.getDescriptorPath(), sinceBuild));
            } else {
                CharSequence charSequence;
                if (StringsKt.endsWith$default(sinceBuild, ".*", false, 2, null)) {
                    $this$validateSinceBuild.registerProblem(new SinceBuildCannotContainWildcard($this$validateSinceBuild.getDescriptorPath(), sinceBuildParsed));
                }
                if (sinceBuildParsed.getBaselineVersion() < 130) {
                    $this$validateSinceBuild.registerProblem(new InvalidSinceBuild($this$validateSinceBuild.getDescriptorPath(), sinceBuild));
                }
                if (sinceBuildParsed.getBaselineVersion() > 999) {
                    $this$validateSinceBuild.registerProblem(new ErroneousSinceBuild($this$validateSinceBuild.getDescriptorPath(), sinceBuildParsed));
                }
                if ((charSequence = (CharSequence)sinceBuildParsed.getProductCode()).length() > 0) {
                    $this$validateSinceBuild.registerProblem(new ProductCodePrefixInBuild($this$validateSinceBuild.getDescriptorPath()));
                }
            }
        }
    }

    private final void validateProductDescriptor(ValidationContext $this$validateProductDescriptor, PluginBean plugin, ProductDescriptorBean productDescriptor) {
        block2: {
            Object it;
            if (productDescriptor == null) break block2;
            this.validateProductCode($this$validateProductDescriptor, productDescriptor.code);
            this.validateReleaseDate($this$validateProductDescriptor, productDescriptor.releaseDate);
            Object object = new Function1<PluginProblem, Unit>($this$validateProductDescriptor){

                public final void invoke(@NotNull PluginProblem p1) {
                    Intrinsics.checkNotNullParameter(p1, "p1");
                    ((ValidationContext)this.receiver).registerProblem(p1);
                }
            };
            this.pluginProductReleaseVersionVerifier.verify(plugin, $this$validateProductDescriptor.getDescriptorPath(), new /* invalid duplicate definition of identical inner class */);
            String string = productDescriptor.eap;
            if (string != null) {
                it = object = string;
                boolean bl = false;
                this.validateEapFlag($this$validateProductDescriptor, (String)it);
            }
            String string2 = productDescriptor.optional;
            if (string2 != null) {
                it = object = string2;
                boolean bl = false;
                this.validateOptionalFlag($this$validateProductDescriptor, (String)it);
            }
        }
    }

    private final void validateProductCode(ValidationContext $this$validateProductCode, String productCode) {
        CharSequence charSequence = productCode;
        if (charSequence == null || charSequence.length() == 0) {
            $this$validateProductCode.registerProblem(new PropertyNotSpecified("code", $this$validateProductCode.getDescriptorPath()));
        } else {
            this.validatePropertyLength($this$validateProductCode, "Product code", productCode, 15);
        }
    }

    private final void validateReleaseDate(ValidationContext $this$validateReleaseDate, String releaseDate) {
        CharSequence charSequence = releaseDate;
        if (charSequence == null || charSequence.length() == 0) {
            $this$validateReleaseDate.registerProblem(new PropertyNotSpecified("release-date", $this$validateReleaseDate.getDescriptorPath()));
        } else {
            try {
                LocalDate date = LocalDate.parse(releaseDate, PluginBeanValidatorKt.access$getRELEASE_DATE_FORMATTER$p());
                if (date.compareTo(LocalDate.now().plusDays(5L)) > 0) {
                    $this$validateReleaseDate.registerProblem(new ReleaseDateInFuture($this$validateReleaseDate.getDescriptorPath()));
                }
            }
            catch (DateTimeParseException e) {
                $this$validateReleaseDate.registerProblem(new ReleaseDateWrongFormat($this$validateReleaseDate.getDescriptorPath()));
            }
        }
    }

    private final void validateEapFlag(ValidationContext $this$validateEapFlag, String eapFlag) {
        this.validateBooleanFlag($this$validateEapFlag, eapFlag, "eap");
    }

    private final void validateOptionalFlag(ValidationContext $this$validateOptionalFlag, String optionalFlag) {
        this.validateBooleanFlag($this$validateOptionalFlag, optionalFlag, "optional");
    }

    private final void validateBooleanFlag(ValidationContext $this$validateBooleanFlag, String flag, String name) {
        if (Intrinsics.areEqual(flag, "true") ^ true && Intrinsics.areEqual(flag, "false") ^ true) {
            $this$validateBooleanFlag.registerProblem(new NotBoolean(name, $this$validateBooleanFlag.getDescriptorPath()));
        }
    }

    private final void validateDependencies(ValidationContext $this$validateDependencies, List<? extends PluginDependencyBean> dependencies) {
        for (PluginDependencyBean pluginDependencyBean : dependencies) {
            block7: {
                block6: {
                    CharSequence charSequence = pluginDependencyBean.dependencyId;
                    if (charSequence == null || StringsKt.isBlank(charSequence)) break block6;
                    String string = pluginDependencyBean.dependencyId;
                    Intrinsics.checkNotNullExpressionValue(string, "dependencyBean.dependencyId");
                    if (!StringsKt.contains$default((CharSequence)string, "\n", false, 2, null)) break block7;
                }
                String string = $this$validateDependencies.getDescriptorPath();
                String string2 = pluginDependencyBean.dependencyId;
                Intrinsics.checkNotNullExpressionValue(string2, "dependencyBean.dependencyId");
                $this$validateDependencies.registerProblem(new InvalidDependencyId(string, string2));
                continue;
            }
            if (Intrinsics.areEqual(pluginDependencyBean.optional, true)) {
                if (pluginDependencyBean.configFile == null) {
                    String string = pluginDependencyBean.dependencyId;
                    Intrinsics.checkNotNullExpressionValue(string, "dependencyBean.dependencyId");
                    $this$validateDependencies.registerProblem(new OptionalDependencyConfigFileNotSpecified(string));
                    continue;
                }
                String string = pluginDependencyBean.configFile;
                Intrinsics.checkNotNullExpressionValue(string, "dependencyBean.configFile");
                if (!StringsKt.isBlank(string)) continue;
                String string3 = pluginDependencyBean.dependencyId;
                Intrinsics.checkNotNullExpressionValue(string3, "dependencyBean.dependencyId");
                $this$validateDependencies.registerProblem(new OptionalDependencyConfigFileIsEmpty(string3, $this$validateDependencies.getDescriptorPath()));
                continue;
            }
            if (!Intrinsics.areEqual(pluginDependencyBean.optional, false)) continue;
            String string = pluginDependencyBean.dependencyId;
            Intrinsics.checkNotNullExpressionValue(string, "dependencyBean.dependencyId");
            $this$validateDependencies.registerProblem(new SuperfluousNonOptionalDependencyDeclaration(string));
        }
        new ReusedDescriptorVerifier($this$validateDependencies.getDescriptorPath()).verify((Collection<? extends PluginDependencyBean>)dependencies, (Function1<? super PluginProblem, Unit>)new Function1<PluginProblem, Unit>($this$validateDependencies){

            public final void invoke(@NotNull PluginProblem p1) {
                Intrinsics.checkNotNullParameter(p1, "p1");
                ((ValidationContext)this.receiver).registerProblem(p1);
            }
        });
    }

    private final void validateModules(ValidationContext $this$validateModules, PluginBean bean) {
        List<String> list = bean.modules;
        if (list != null) {
            boolean bl;
            block5: {
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        String string = it;
                        Intrinsics.checkNotNullExpressionValue(string, "it");
                        CharSequence charSequence = string;
                        boolean bl3 = charSequence.length() == 0;
                        if (!bl3) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                $this$validateModules.registerProblem(new InvalidModuleBean($this$validateModules.getDescriptorPath()));
            }
        }
    }
}

