/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.utils.charseq;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0096\u0002J\u0018\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/plugin/structure/base/utils/charseq/ConcatenatedCharSequence;", "", "first", "second", "(Ljava/lang/CharSequence;Ljava/lang/CharSequence;)V", "length", "", "getLength", "()I", "get", "", "index", "subSequence", "startIndex", "endIndex", "toString", "", "structure-base"})
public final class ConcatenatedCharSequence
implements CharSequence {
    private final CharSequence first;
    private final CharSequence second;

    public int getLength() {
        return this.first.length() + this.second.length();
    }

    public char get(int index) {
        if (index < 0 || index >= this.length()) {
            throw (Throwable)new IndexOutOfBoundsException("Index: " + index + ", Length: " + this.length());
        }
        return index < this.first.length() ? this.first.charAt(index) : this.second.charAt(index - this.first.length());
    }

    @Override
    @NotNull
    public CharSequence subSequence(int startIndex, int endIndex) {
        CharSequence charSequence;
        if (startIndex < 0 || endIndex > this.length() || startIndex > endIndex) {
            throw (Throwable)new IndexOutOfBoundsException("startIndex: " + startIndex + ", endIndex: " + endIndex + ", Length: " + this.length());
        }
        int firstLen = this.first.length();
        if (endIndex <= firstLen) {
            charSequence = this.first.subSequence(startIndex, endIndex);
        } else if (startIndex >= firstLen) {
            charSequence = this.second.subSequence(startIndex - firstLen, endIndex - firstLen);
        } else {
            CharSequence firstPart = this.first.subSequence(startIndex, firstLen);
            CharSequence secondPart = this.second.subSequence(0, endIndex - firstLen);
            charSequence = new ConcatenatedCharSequence(firstPart, secondPart);
        }
        return charSequence;
    }

    @Override
    @NotNull
    public String toString() {
        return ((Object)this.first).toString() + ((Object)this.second).toString();
    }

    public ConcatenatedCharSequence(@NotNull CharSequence first, @NotNull CharSequence second) {
        Intrinsics.checkNotNullParameter(first, "first");
        Intrinsics.checkNotNullParameter(second, "second");
        this.first = first;
        this.second = second;
    }
}

