/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.repository.cleanup;

import com.jetbrains.pluginverifier.repository.cleanup.SizeWeight;
import com.jetbrains.pluginverifier.repository.resources.AvailableResource;
import com.jetbrains.pluginverifier.repository.resources.EvictionInfo;
import com.jetbrains.pluginverifier.repository.resources.EvictionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00040\u0003B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\"\u0010\b\u001a\u00020\u00062\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00040\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0016J:\u0010\u000e\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00040\u00100\u000f2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00040\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/pluginverifier/repository/cleanup/SizeEvictionPolicy;", "R", "K", "Lcom/jetbrains/pluginverifier/repository/resources/EvictionPolicy;", "Lcom/jetbrains/pluginverifier/repository/cleanup/SizeWeight;", "maximumSize", "", "(I)V", "howManyToRemove", "evictionInfo", "Lcom/jetbrains/pluginverifier/repository/resources/EvictionInfo;", "isNecessary", "", "totalWeight", "selectResourcesForEviction", "", "Lcom/jetbrains/pluginverifier/repository/resources/AvailableResource;", "verifier-repository"})
@SourceDebugExtension(value={"SMAP\nSizeEvictionPolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SizeEvictionPolicy.kt\ncom/jetbrains/pluginverifier/repository/cleanup/SizeEvictionPolicy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,47:1\n827#2:48\n855#2,2:49\n*S KotlinDebug\n*F\n+ 1 SizeEvictionPolicy.kt\ncom/jetbrains/pluginverifier/repository/cleanup/SizeEvictionPolicy\n*L\n24#1:48\n24#1:49,2\n*E\n"})
public final class SizeEvictionPolicy<R, K>
implements EvictionPolicy<R, K, SizeWeight> {
    private final int maximumSize;

    public SizeEvictionPolicy(int maximumSize) {
        this.maximumSize = maximumSize;
    }

    @Override
    public boolean isNecessary(@NotNull SizeWeight totalWeight) {
        Intrinsics.checkNotNullParameter(totalWeight, "totalWeight");
        return totalWeight.getSize() > (long)this.maximumSize;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AvailableResource<R, K, SizeWeight>> selectResourcesForEviction(@NotNull EvictionInfo<? extends R, ? extends K, SizeWeight> evictionInfo) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter(evictionInfo, "evictionInfo");
        Iterable $this$filterNot$iv = evictionInfo.getAvailableResources();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            AvailableResource it = (AvailableResource)element$iv$iv;
            boolean bl = false;
            if (it.isLocked()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Comparator comparator = new Comparator(){

            public final int compare(T a, T b) {
                AvailableResource it = (AvailableResource)a;
                boolean bl = false;
                Comparable comparable = it.getUsageStatistic().getLastAccessTime();
                it = (AvailableResource)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)it.getUsageStatistic().getLastAccessTime());
            }
        };
        comparator = new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    AvailableResource it = (AvailableResource)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getUsageStatistic().getTimesAccessed());
                    it = (AvailableResource)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues(comparable2, it.getUsageStatistic().getTimesAccessed());
                }
                return n;
            }
        };
        return CollectionsKt.take(CollectionsKt.sortedWith((List)destination$iv$iv, new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    AvailableResource it = (AvailableResource)a;
                    boolean bl = false;
                    Comparable comparable = it.getKey() instanceof Comparable ? (Comparable)it.getKey() : (Comparable)((Object)it.toString());
                    it = (AvailableResource)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues(comparable2, it.getKey() instanceof Comparable ? (Comparable)it.getKey() : (Comparable)((Object)it.toString()));
                }
                return n;
            }
        }), this.howManyToRemove(evictionInfo));
    }

    private final int howManyToRemove(EvictionInfo<? extends R, ? extends K, SizeWeight> evictionInfo) {
        long size = evictionInfo.getTotalWeight().getSize();
        return (int)RangesKt.coerceAtLeast(size - (long)this.maximumSize, 0L);
    }
}

