/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.dependencies.resolution;

import com.jetbrains.plugin.structure.ide.Ide;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.ModuleV2Dependency;
import com.jetbrains.plugin.structure.intellij.plugin.PluginDependency;
import com.jetbrains.plugin.structure.intellij.plugin.PluginV2Dependency;
import com.jetbrains.pluginverifier.dependencies.resolution.DependencyFinder;
import com.jetbrains.pluginverifier.dependencies.resolution.DependencyOrigin;
import com.jetbrains.pluginverifier.plugin.PluginDetailsCache;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u00032\u0006\u0010\u0011\u001a\u00020\nH\u0002J\u0016\u0010\u0016\u001a\u00020\u000e*\u0004\u0018\u00010\u00152\u0006\u0010\u0011\u001a\u00020\nH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/pluginverifier/dependencies/resolution/BundledPluginDependencyFinder;", "Lcom/jetbrains/pluginverifier/dependencies/resolution/DependencyFinder;", "ide", "Lcom/jetbrains/plugin/structure/ide/Ide;", "pluginDetailsCache", "Lcom/jetbrains/pluginverifier/plugin/PluginDetailsCache;", "(Lcom/jetbrains/plugin/structure/ide/Ide;Lcom/jetbrains/pluginverifier/plugin/PluginDetailsCache;)V", "getIde", "()Lcom/jetbrains/plugin/structure/ide/Ide;", "presentableName", "", "getPresentableName", "()Ljava/lang/String;", "findPluginDependency", "Lcom/jetbrains/pluginverifier/dependencies/resolution/DependencyFinder$Result;", "dependency", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDependency;", "dependencyId", "isModule", "", "findPluginOrModuleById", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "toResult", "verifier-intellij"})
public final class BundledPluginDependencyFinder
implements DependencyFinder {
    @NotNull
    private final Ide ide;
    @NotNull
    private final PluginDetailsCache pluginDetailsCache;

    public BundledPluginDependencyFinder(@NotNull Ide ide2, @NotNull PluginDetailsCache pluginDetailsCache) {
        Intrinsics.checkNotNullParameter(ide2, "ide");
        Intrinsics.checkNotNullParameter(pluginDetailsCache, "pluginDetailsCache");
        this.ide = ide2;
        this.pluginDetailsCache = pluginDetailsCache;
    }

    @NotNull
    public final Ide getIde() {
        return this.ide;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return "Bundled plugins of " + this.ide.getVersion().asString();
    }

    @Override
    @NotNull
    public DependencyFinder.Result findPluginDependency(@NotNull String dependencyId, boolean isModule) {
        Intrinsics.checkNotNullParameter(dependencyId, "dependencyId");
        IdePlugin bundledPluginInfo = isModule ? this.findPluginOrModuleById(this.ide, dependencyId) : this.ide.findPluginById(dependencyId);
        return this.toResult(bundledPluginInfo, dependencyId);
    }

    @Override
    @NotNull
    public DependencyFinder.Result findPluginDependency(@NotNull PluginDependency dependency) {
        Intrinsics.checkNotNullParameter(dependency, "dependency");
        PluginDependency pluginDependency = dependency;
        return (pluginDependency instanceof ModuleV2Dependency ? true : pluginDependency instanceof PluginV2Dependency) ? this.toResult(this.findPluginOrModuleById(this.ide, dependency.getId()), dependency.getId()) : this.findPluginDependency(dependency.getId(), dependency.isModule());
    }

    private final DependencyFinder.Result toResult(IdePlugin $this$toResult, String dependencyId) {
        return $this$toResult != null ? (DependencyFinder.Result)new DependencyFinder.Result.FoundPlugin($this$toResult, DependencyOrigin.Bundled.INSTANCE) : (DependencyFinder.Result)new DependencyFinder.Result.NotFound("Dependency " + dependencyId + " is not found among the bundled plugins of " + this.ide);
    }

    private final IdePlugin findPluginOrModuleById(Ide $this$findPluginOrModuleById, String dependencyId) {
        IdePlugin idePlugin = $this$findPluginOrModuleById.findPluginById(dependencyId);
        if (idePlugin == null) {
            idePlugin = $this$findPluginOrModuleById.findPluginByModule(dependencyId);
        }
        return idePlugin;
    }
}

