/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.problems;

import com.jetbrains.plugin.structure.base.plugin.Plugin;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationFail;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationSuccess;
import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.PluginProblemsKt;
import com.jetbrains.plugin.structure.base.problems.ReclassifiedPluginProblem;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.problems.IgnoredLevel;
import com.jetbrains.plugin.structure.intellij.problems.PluginCreationResultResolver;
import com.jetbrains.plugin.structure.intellij.problems.RemappedLevel;
import com.jetbrains.plugin.structure.intellij.problems.StandardLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0018\b\u0002\u0010\u0003\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0016J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0016H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0019H\u0002J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002J\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002J$\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0016J\u0012\u0010\u001f\u001a\u00020\b*\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002J\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\r*\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002J\u0018\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\r*\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0003\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/plugin/structure/intellij/problems/LevelRemappingPluginCreationResultResolver;", "Lcom/jetbrains/plugin/structure/intellij/problems/PluginCreationResultResolver;", "delegatedResolver", "remappedLevel", "", "Lkotlin/reflect/KClass;", "Lcom/jetbrains/plugin/structure/intellij/problems/RemappedLevel;", "unwrapRemappedProblems", "", "(Lcom/jetbrains/plugin/structure/intellij/problems/PluginCreationResultResolver;Ljava/util/Map;Z)V", "classify", "Lcom/jetbrains/plugin/structure/base/problems/PluginProblem;", "pluginProblem", "", "plugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "problems", "remapErrorsAndWarnings", "errorsAndWarnings", "remapFailure", "Lcom/jetbrains/plugin/structure/base/plugin/PluginCreationResult;", "pluginCreationResult", "Lcom/jetbrains/plugin/structure/base/plugin/PluginCreationFail;", "remapPluginProblemLevel", "remapSuccess", "Lcom/jetbrains/plugin/structure/base/plugin/PluginCreationSuccess;", "remapUnacceptableWarnings", "unacceptableWarnings", "remapWarnings", "warnings", "resolve", "hasNoErrors", "structure-intellij"})
@SourceDebugExtension(value={"SMAP\nLevelRemappingPluginCreationResultResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LevelRemappingPluginCreationResultResolver.kt\ncom/jetbrains/plugin/structure/intellij/problems/LevelRemappingPluginCreationResultResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1603#2,9:90\n1855#2:99\n1856#2:101\n1612#2:102\n1603#2,9:103\n1855#2:112\n1856#2:114\n1612#2:115\n1603#2,9:116\n1855#2:125\n1856#2:127\n1612#2:128\n1603#2,9:129\n1855#2:138\n1856#2:140\n1612#2:141\n2624#2,3:142\n766#2:145\n857#2,2:146\n766#2:148\n857#2,2:149\n1#3:100\n1#3:113\n1#3:126\n1#3:139\n*E\n*S KotlinDebug\n*F\n+ 1 LevelRemappingPluginCreationResultResolver.kt\ncom/jetbrains/plugin/structure/intellij/problems/LevelRemappingPluginCreationResultResolver\n*L\n49#1,9:90\n49#1:99\n49#1:101\n49#1:102\n53#1,9:103\n53#1:112\n53#1:114\n53#1:115\n57#1,9:116\n57#1:125\n57#1:127\n57#1:128\n65#1,9:129\n65#1:138\n65#1:140\n65#1:141\n83#1,3:142\n87#1:145\n87#1,2:146\n88#1:148\n88#1,2:149\n49#1:100\n53#1:113\n57#1:126\n65#1:139\n*E\n"})
public final class LevelRemappingPluginCreationResultResolver
implements PluginCreationResultResolver {
    private final PluginCreationResultResolver delegatedResolver;
    private final Map<KClass<?>, RemappedLevel> remappedLevel;
    private final boolean unwrapRemappedProblems;

    @Override
    @NotNull
    public PluginCreationResult<IdePlugin> resolve(@NotNull IdePlugin plugin, @NotNull List<? extends PluginProblem> problems) {
        PluginCreationResult<IdePlugin> pluginCreationResult;
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(problems, "problems");
        PluginCreationResult<IdePlugin> pluginCreationResult2 = this.delegatedResolver.resolve(plugin, problems);
        if (pluginCreationResult2 instanceof PluginCreationSuccess) {
            pluginCreationResult = this.remapSuccess((PluginCreationSuccess)pluginCreationResult2);
        } else if (pluginCreationResult2 instanceof PluginCreationFail) {
            pluginCreationResult = this.remapFailure(plugin, (PluginCreationFail)pluginCreationResult2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return pluginCreationResult;
    }

    private final PluginCreationResult<IdePlugin> remapSuccess(PluginCreationSuccess<? extends IdePlugin> pluginCreationResult) {
        PluginCreationSuccess<? extends IdePlugin> $this$with = pluginCreationResult;
        boolean bl = false;
        List allRemappedProblems = CollectionsKt.plus((Collection)this.remapWarnings($this$with.getWarnings()), (Iterable)this.remapUnacceptableWarnings($this$with.getUnacceptableWarnings()));
        return this.hasNoErrors(allRemappedProblems) ? (PluginCreationResult)PluginCreationSuccess.copy$default($this$with, null, this.warnings(allRemappedProblems), this.unacceptableWarnings(allRemappedProblems), null, 9, null) : (PluginCreationResult)new PluginCreationFail(allRemappedProblems);
    }

    private final PluginCreationResult<IdePlugin> remapFailure(IdePlugin plugin, PluginCreationFail<? extends IdePlugin> pluginCreationResult) {
        PluginCreationFail<? extends IdePlugin> $this$with = pluginCreationResult;
        boolean bl = false;
        List<PluginProblem> remappedErrorsAndWarnings = this.remapErrorsAndWarnings($this$with.getErrorsAndWarnings());
        if (this.hasNoErrors(remappedErrorsAndWarnings)) {
            return new PluginCreationSuccess<Plugin>(plugin, remappedErrorsAndWarnings);
        }
        return $this$with.copy(this.remapErrorsAndWarnings($this$with.getErrorsAndWarnings()));
    }

    /*
     * WARNING - void declaration
     */
    private final List<PluginProblem> remapWarnings(List<? extends PluginProblem> warnings) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Iterable iterable = warnings;
        LevelRemappingPluginCreationResultResolver levelRemappingPluginCreationResultResolver = this;
        boolean $i$f$mapNotNull = false;
        void var5_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PluginProblem pluginProblem;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            PluginProblem p1 = (PluginProblem)element$iv$iv;
            boolean bl2 = false;
            if (levelRemappingPluginCreationResultResolver.remapPluginProblemLevel(p1) == null) continue;
            PluginProblem it$iv$iv = pluginProblem;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PluginProblem> remapUnacceptableWarnings(List<? extends PluginProblem> unacceptableWarnings) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Iterable iterable = unacceptableWarnings;
        LevelRemappingPluginCreationResultResolver levelRemappingPluginCreationResultResolver = this;
        boolean $i$f$mapNotNull = false;
        void var5_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PluginProblem pluginProblem;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            PluginProblem p1 = (PluginProblem)element$iv$iv;
            boolean bl2 = false;
            if (levelRemappingPluginCreationResultResolver.remapPluginProblemLevel(p1) == null) continue;
            PluginProblem it$iv$iv = pluginProblem;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PluginProblem> remapErrorsAndWarnings(List<? extends PluginProblem> errorsAndWarnings) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Iterable iterable = errorsAndWarnings;
        LevelRemappingPluginCreationResultResolver levelRemappingPluginCreationResultResolver = this;
        boolean $i$f$mapNotNull = false;
        void var5_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PluginProblem pluginProblem;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            PluginProblem p1 = (PluginProblem)element$iv$iv;
            boolean bl2 = false;
            if (levelRemappingPluginCreationResultResolver.remapPluginProblemLevel(p1) == null) continue;
            PluginProblem it$iv$iv = pluginProblem;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final PluginProblem remapPluginProblemLevel(PluginProblem pluginProblem) {
        return this.classify(pluginProblem);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<PluginProblem> classify(@NotNull IdePlugin plugin, @NotNull List<? extends PluginProblem> problems) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(problems, "problems");
        Iterable $this$mapNotNull$iv = this.delegatedResolver.classify(plugin, problems);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PluginProblem pluginProblem;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            PluginProblem it = (PluginProblem)element$iv$iv;
            boolean bl2 = false;
            if (this.classify(it) == null) continue;
            PluginProblem it$iv$iv = pluginProblem;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final PluginProblem classify(PluginProblem pluginProblem) {
        PluginProblem pluginProblem2;
        PluginProblem problem = this.unwrapRemappedProblems ? PluginProblemsKt.getUnwrapped(pluginProblem) : pluginProblem;
        RemappedLevel remappedLevel = this.remappedLevel.get(Reflection.getOrCreateKotlinClass(problem.getClass()));
        if (remappedLevel instanceof StandardLevel) {
            pluginProblem2 = new ReclassifiedPluginProblem(((StandardLevel)remappedLevel).getOriginalLevel(), problem);
        } else if (remappedLevel instanceof IgnoredLevel) {
            pluginProblem2 = null;
        } else if (remappedLevel == null) {
            pluginProblem2 = pluginProblem;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return pluginProblem2;
    }

    private final boolean hasNoErrors(List<? extends PluginProblem> $this$hasNoErrors) {
        boolean bl;
        block3: {
            Iterable $this$none$iv = $this$hasNoErrors;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    PluginProblem it = (PluginProblem)element$iv;
                    boolean bl2 = false;
                    if (!(it.getLevel() == PluginProblem.Level.ERROR)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PluginProblem> warnings(List<? extends PluginProblem> $this$warnings) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$warnings;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PluginProblem it = (PluginProblem)element$iv$iv;
            boolean bl = false;
            if (!(it.getLevel() == PluginProblem.Level.WARNING)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PluginProblem> unacceptableWarnings(List<? extends PluginProblem> $this$unacceptableWarnings) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$unacceptableWarnings;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PluginProblem it = (PluginProblem)element$iv$iv;
            boolean bl = false;
            if (!(it.getLevel() == PluginProblem.Level.UNACCEPTABLE_WARNING)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public LevelRemappingPluginCreationResultResolver(@NotNull PluginCreationResultResolver delegatedResolver, @NotNull Map<KClass<?>, ? extends RemappedLevel> remappedLevel, boolean unwrapRemappedProblems) {
        Intrinsics.checkNotNullParameter(delegatedResolver, "delegatedResolver");
        Intrinsics.checkNotNullParameter(remappedLevel, "remappedLevel");
        this.delegatedResolver = delegatedResolver;
        this.remappedLevel = remappedLevel;
        this.unwrapRemappedProblems = unwrapRemappedProblems;
    }

    public /* synthetic */ LevelRemappingPluginCreationResultResolver(PluginCreationResultResolver pluginCreationResultResolver, Map map, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        this(pluginCreationResultResolver, map, bl);
    }

    @Override
    public boolean isError(@NotNull PluginProblem problem) {
        Intrinsics.checkNotNullParameter(problem, "problem");
        return PluginCreationResultResolver.DefaultImpls.isError(this, problem);
    }
}

