/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.ide;

import com.jetbrains.plugin.structure.ide.Ide;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class IdeImpl
extends Ide {
    private final List<IdePlugin> myBundledPlugins;
    private final IdeVersion myVersion;
    private final Path myIdePath;

    IdeImpl(@NotNull Path idePath, @NotNull IdeVersion version, @NotNull List<IdePlugin> bundledPlugins) {
        this.myIdePath = idePath;
        this.myBundledPlugins = bundledPlugins;
        this.myVersion = version;
    }

    @Override
    @NotNull
    public IdeVersion getVersion() {
        return this.myVersion;
    }

    @Override
    @NotNull
    public List<IdePlugin> getBundledPlugins() {
        return Collections.unmodifiableList(this.myBundledPlugins);
    }

    @Override
    @NotNull
    public Path getIdePath() {
        return this.myIdePath;
    }

    public String toString() {
        return this.myVersion.asString();
    }
}

