/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.warnings;

import com.jetbrains.pluginverifier.dependencies.DependencyNode;
import com.jetbrains.pluginverifier.warnings.CompatibilityWarning;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\u0011\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/pluginverifier/warnings/DependenciesCycleWarning;", "Lcom/jetbrains/pluginverifier/warnings/CompatibilityWarning;", "cycle", "", "Lcom/jetbrains/pluginverifier/dependencies/DependencyNode;", "(Ljava/util/List;)V", "getCycle", "()Ljava/util/List;", "fullDescription", "", "getFullDescription", "()Ljava/lang/String;", "problemType", "getProblemType", "shortDescription", "getShortDescription", "component1", "copy", "equals", "", "other", "", "hashCode", "", "verifier-intellij"})
public final class DependenciesCycleWarning
extends CompatibilityWarning {
    @NotNull
    private final List<DependencyNode> cycle;

    public DependenciesCycleWarning(@NotNull List<DependencyNode> cycle) {
        Intrinsics.checkNotNullParameter(cycle, "cycle");
        this.cycle = cycle;
    }

    @NotNull
    public final List<DependencyNode> getCycle() {
        return this.cycle;
    }

    @Override
    @NotNull
    public String getProblemType() {
        return this.getShortDescription();
    }

    @Override
    @NotNull
    public String getShortDescription() {
        return "Plugin dependencies are cyclic";
    }

    @Override
    @NotNull
    public String getFullDescription() {
        return "The plugin is on a dependencies cycle: " + CollectionsKt.joinToString$default(this.cycle, " -> ", null, null, 0, null, null, 62, null) + " -> " + this.cycle.get(0);
    }

    @NotNull
    public final List<DependencyNode> component1() {
        return this.cycle;
    }

    @NotNull
    public final DependenciesCycleWarning copy(@NotNull List<DependencyNode> cycle) {
        Intrinsics.checkNotNullParameter(cycle, "cycle");
        return new DependenciesCycleWarning(cycle);
    }

    public static /* synthetic */ DependenciesCycleWarning copy$default(DependenciesCycleWarning dependenciesCycleWarning, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = dependenciesCycleWarning.cycle;
        }
        return dependenciesCycleWarning.copy(list);
    }

    public int hashCode() {
        return ((Object)this.cycle).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DependenciesCycleWarning)) {
            return false;
        }
        DependenciesCycleWarning dependenciesCycleWarning = (DependenciesCycleWarning)other;
        return Intrinsics.areEqual(this.cycle, dependenciesCycleWarning.cycle);
    }
}

