/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.verifiers.instruction;

import com.jetbrains.pluginverifier.results.instruction.Instruction;
import com.jetbrains.pluginverifier.results.reference.FieldReference;
import com.jetbrains.pluginverifier.results.reference.MethodReference;
import com.jetbrains.pluginverifier.verifiers.BytecodeUtilKt;
import com.jetbrains.pluginverifier.verifiers.VerificationContext;
import com.jetbrains.pluginverifier.verifiers.instruction.FieldAccessInstructionVerifier;
import com.jetbrains.pluginverifier.verifiers.instruction.InstructionVerifier;
import com.jetbrains.pluginverifier.verifiers.instruction.MethodInvokeInstructionVerifier;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassFile;
import com.jetbrains.pluginverifier.verifiers.resolution.Method;
import com.jetbrains.pluginverifier.verifiers.resolution.ResolutionUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Handle;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0016J@\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/pluginverifier/verifiers/instruction/MemberAccessVerifier;", "Lcom/jetbrains/pluginverifier/verifiers/instruction/InstructionVerifier;", "()V", "processInvokeDynamic", "", "callerMethod", "Lcom/jetbrains/pluginverifier/verifiers/resolution/Method;", "instructionNode", "Lorg/objectweb/asm/tree/InvokeDynamicInsnNode;", "context", "Lcom/jetbrains/pluginverifier/verifiers/VerificationContext;", "verify", "method", "Lorg/objectweb/asm/tree/AbstractInsnNode;", "verifyMemberAccess", "memberOwner", "", "memberName", "memberDesc", "instruction", "Lcom/jetbrains/pluginverifier/results/instruction/Instruction;", "verifier-core"})
public final class MemberAccessVerifier
implements InstructionVerifier {
    @Override
    public void verify(@NotNull Method method, @NotNull AbstractInsnNode instructionNode, @NotNull VerificationContext context) {
        Instruction instruction;
        Intrinsics.checkNotNullParameter(method, "method");
        Intrinsics.checkNotNullParameter(instructionNode, "instructionNode");
        Intrinsics.checkNotNullParameter(context, "context");
        if (instructionNode instanceof MethodInsnNode) {
            Instruction instruction2;
            switch (((MethodInsnNode)instructionNode).getOpcode()) {
                case 182: {
                    instruction2 = Instruction.INVOKE_VIRTUAL;
                    break;
                }
                case 183: {
                    instruction2 = Instruction.INVOKE_SPECIAL;
                    break;
                }
                case 185: {
                    instruction2 = Instruction.INVOKE_INTERFACE;
                    break;
                }
                case 184: {
                    instruction2 = Instruction.INVOKE_STATIC;
                    break;
                }
                default: {
                    return;
                }
            }
            instruction = instruction2;
            String string = ((MethodInsnNode)instructionNode).owner;
            Intrinsics.checkNotNullExpressionValue(string, "instructionNode.owner");
            String string2 = ((MethodInsnNode)instructionNode).name;
            Intrinsics.checkNotNullExpressionValue(string2, "instructionNode.name");
            String string3 = ((MethodInsnNode)instructionNode).desc;
            Intrinsics.checkNotNullExpressionValue(string3, "instructionNode.desc");
            this.verifyMemberAccess(method, string, string2, string3, instructionNode, instruction, context);
        }
        if (instructionNode instanceof FieldInsnNode) {
            Instruction instruction3;
            switch (((FieldInsnNode)instructionNode).getOpcode()) {
                case 181: {
                    instruction3 = Instruction.PUT_FIELD;
                    break;
                }
                case 180: {
                    instruction3 = Instruction.GET_FIELD;
                    break;
                }
                case 179: {
                    instruction3 = Instruction.PUT_STATIC;
                    break;
                }
                case 178: {
                    instruction3 = Instruction.GET_STATIC;
                    break;
                }
                default: {
                    return;
                }
            }
            instruction = instruction3;
            String string = ((FieldInsnNode)instructionNode).owner;
            Intrinsics.checkNotNullExpressionValue(string, "instructionNode.owner");
            String string4 = ((FieldInsnNode)instructionNode).name;
            Intrinsics.checkNotNullExpressionValue(string4, "instructionNode.name");
            String string5 = ((FieldInsnNode)instructionNode).desc;
            Intrinsics.checkNotNullExpressionValue(string5, "instructionNode.desc");
            this.verifyMemberAccess(method, string, string4, string5, instructionNode, instruction, context);
        }
        if (instructionNode instanceof InvokeDynamicInsnNode) {
            this.processInvokeDynamic(method, (InvokeDynamicInsnNode)instructionNode, context);
        }
    }

    private final void processInvokeDynamic(Method callerMethod, InvokeDynamicInsnNode instructionNode, VerificationContext context) {
        Intrinsics.checkNotNullExpressionValue(instructionNode.bsmArgs, "instructionNode.bsmArgs");
        for (Object bsmArg : instructionNode.bsmArgs) {
            Instruction instruction;
            if (!(bsmArg instanceof Handle)) continue;
            switch (((Handle)bsmArg).getTag()) {
                case 5: {
                    instruction = Instruction.INVOKE_VIRTUAL;
                    break;
                }
                case 7: {
                    instruction = Instruction.INVOKE_SPECIAL;
                    break;
                }
                case 9: {
                    instruction = Instruction.INVOKE_INTERFACE;
                    break;
                }
                case 6: {
                    instruction = Instruction.INVOKE_STATIC;
                    break;
                }
                case 3: {
                    instruction = Instruction.PUT_FIELD;
                    break;
                }
                case 1: {
                    instruction = Instruction.GET_FIELD;
                    break;
                }
                case 4: {
                    instruction = Instruction.PUT_STATIC;
                    break;
                }
                case 2: {
                    instruction = Instruction.GET_STATIC;
                    break;
                }
                default: {
                    instruction = null;
                }
            }
            if (instruction == null) continue;
            Instruction instruction2 = instruction;
            String string = ((Handle)bsmArg).getOwner();
            Intrinsics.checkNotNullExpressionValue(string, "bsmArg.owner");
            String string2 = ((Handle)bsmArg).getName();
            Intrinsics.checkNotNullExpressionValue(string2, "bsmArg.name");
            String string3 = ((Handle)bsmArg).getDesc();
            Intrinsics.checkNotNullExpressionValue(string3, "bsmArg.desc");
            this.verifyMemberAccess(callerMethod, string, string2, string3, instructionNode, instruction2, context);
        }
    }

    private final void verifyMemberAccess(Method callerMethod, String memberOwner, String memberName, String memberDesc, AbstractInsnNode instructionNode, Instruction instruction, VerificationContext context) {
        if (StringsKt.startsWith$default(memberOwner, "[", false, 2, null)) {
            String arrayType = BytecodeUtilKt.extractClassNameFromDescriptor(memberOwner);
            if (arrayType != null) {
                ResolutionUtilKt.resolveClassChecked$default(context.getClassResolver(), arrayType, callerMethod, context, null, 8, null);
            }
            return;
        }
        ClassFile ownerClassFile = ResolutionUtilKt.resolveClassChecked$default(context.getClassResolver(), memberOwner, callerMethod, context, null, 8, null);
        if (ownerClassFile != null) {
            switch (WhenMappings.$EnumSwitchMapping$0[instruction.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    MethodReference methodReference = new MethodReference(memberOwner, memberName, memberDesc);
                    new MethodInvokeInstructionVerifier(callerMethod, ownerClassFile, methodReference, context, instruction, instructionNode).verify();
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    FieldReference fieldReference = new FieldReference(memberOwner, memberName, memberDesc);
                    new FieldAccessInstructionVerifier(callerMethod, ownerClassFile, fieldReference, context, instruction).verify();
                }
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Instruction.values().length];
            try {
                nArray[Instruction.INVOKE_VIRTUAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Instruction.INVOKE_INTERFACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Instruction.INVOKE_STATIC.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Instruction.INVOKE_SPECIAL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Instruction.GET_STATIC.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Instruction.PUT_STATIC.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Instruction.PUT_FIELD.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Instruction.GET_FIELD.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

