/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.tasks.checkIde;

import com.jetbrains.plugin.structure.base.utils.FormatUtilsKt;
import com.jetbrains.pluginverifier.PluginVerificationResult;
import com.jetbrains.pluginverifier.output.OutputOptions;
import com.jetbrains.pluginverifier.output.OutputOptionsKt;
import com.jetbrains.pluginverifier.output.html.HtmlResultPrinter;
import com.jetbrains.pluginverifier.output.markdown.MarkdownResultPrinter;
import com.jetbrains.pluginverifier.output.stream.WriterResultPrinter;
import com.jetbrains.pluginverifier.output.teamcity.TeamCityHistory;
import com.jetbrains.pluginverifier.output.teamcity.TeamCityLog;
import com.jetbrains.pluginverifier.output.teamcity.TeamCityResultPrinter;
import com.jetbrains.pluginverifier.repository.PluginRepository;
import com.jetbrains.pluginverifier.results.problems.CompatibilityProblem;
import com.jetbrains.pluginverifier.tasks.TaskResult;
import com.jetbrains.pluginverifier.tasks.TaskResultPrinter;
import com.jetbrains.pluginverifier.tasks.checkIde.CheckIdeResult;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/pluginverifier/tasks/checkIde/CheckIdeResultPrinter;", "Lcom/jetbrains/pluginverifier/tasks/TaskResultPrinter;", "pluginRepository", "Lcom/jetbrains/pluginverifier/repository/PluginRepository;", "(Lcom/jetbrains/pluginverifier/repository/PluginRepository;)V", "getPluginRepository", "()Lcom/jetbrains/pluginverifier/repository/PluginRepository;", "printOnStdOut", "", "checkIdeResult", "Lcom/jetbrains/pluginverifier/tasks/checkIde/CheckIdeResult;", "printResults", "taskResult", "Lcom/jetbrains/pluginverifier/tasks/TaskResult;", "outputOptions", "Lcom/jetbrains/pluginverifier/output/OutputOptions;", "printTcLog", "Lcom/jetbrains/pluginverifier/output/teamcity/TeamCityHistory;", "groupBy", "Lcom/jetbrains/pluginverifier/output/teamcity/TeamCityResultPrinter$GroupBy;", "tcLog", "Lcom/jetbrains/pluginverifier/output/teamcity/TeamCityLog;", "verifier-cli"})
@SourceDebugExtension(value={"SMAP\nCheckIdeResultPrinter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckIdeResultPrinter.kt\ncom/jetbrains/pluginverifier/tasks/checkIde/CheckIdeResultPrinter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1655#2,8:81\n*S KotlinDebug\n*F\n+ 1 CheckIdeResultPrinter.kt\ncom/jetbrains/pluginverifier/tasks/checkIde/CheckIdeResultPrinter\n*L\n63#1:81,8\n*E\n"})
public final class CheckIdeResultPrinter
implements TaskResultPrinter {
    @NotNull
    private final PluginRepository pluginRepository;

    public CheckIdeResultPrinter(@NotNull PluginRepository pluginRepository) {
        Intrinsics.checkNotNullParameter(pluginRepository, "pluginRepository");
        this.pluginRepository = pluginRepository;
    }

    @NotNull
    public final PluginRepository getPluginRepository() {
        return this.pluginRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printResults(@NotNull TaskResult taskResult, @NotNull OutputOptions outputOptions) {
        Intrinsics.checkNotNullParameter(taskResult, "taskResult");
        Intrinsics.checkNotNullParameter(outputOptions, "outputOptions");
        CheckIdeResult $this$printResults_u24lambda_u241 = (CheckIdeResult)taskResult;
        boolean bl = false;
        if (outputOptions.getTeamCityLog() != null) {
            TeamCityHistory teamCityHistory = this.printTcLog(outputOptions.getTeamCityGroupType(), $this$printResults_u24lambda_u241, outputOptions.getTeamCityLog());
            outputOptions.postProcessTeamCityTests(teamCityHistory);
        } else if (OutputOptionsKt.usePlainOutput(outputOptions)) {
            this.printOnStdOut($this$printResults_u24lambda_u241);
        }
        if (OutputOptionsKt.useHtml(outputOptions)) {
            new HtmlResultPrinter($this$printResults_u24lambda_u241.getIde(), outputOptions).printResults($this$printResults_u24lambda_u241.getResults());
        }
        if (OutputOptionsKt.useMarkdown(outputOptions)) {
            AutoCloseable autoCloseable = MarkdownResultPrinter.Companion.create($this$printResults_u24lambda_u241.getIde(), outputOptions);
            Throwable throwable = null;
            try {
                MarkdownResultPrinter it = (MarkdownResultPrinter)autoCloseable;
                boolean bl2 = false;
                it.printResults($this$printResults_u24lambda_u241.getResults());
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable, throwable);
            }
        }
    }

    private final TeamCityHistory printTcLog(TeamCityResultPrinter.GroupBy groupBy, CheckIdeResult checkIdeResult, TeamCityLog tcLog) {
        CheckIdeResult $this$printTcLog_u24lambda_u243 = checkIdeResult;
        boolean bl = false;
        TeamCityResultPrinter resultPrinter = new TeamCityResultPrinter(tcLog, groupBy, this.pluginRepository);
        TeamCityHistory resultsHistory = resultPrinter.printResults($this$printTcLog_u24lambda_u243.getResults());
        TeamCityHistory versionsHistory = resultPrinter.printNoCompatibleVersionsProblems($this$printTcLog_u24lambda_u243.getMissingCompatibleVersionsProblems());
        HashSet problems = new HashSet();
        HashSet brokenPlugins = new HashSet();
        for (PluginVerificationResult result2 : $this$printTcLog_u24lambda_u243.getResults()) {
            if (!(result2 instanceof PluginVerificationResult.Verified) || !((PluginVerificationResult.Verified)result2).getHasCompatibilityProblems() && !((PluginVerificationResult.Verified)result2).getHasDirectMissingMandatoryDependencies()) continue;
            CollectionsKt.addAll((Collection)problems, (Iterable)((PluginVerificationResult.Verified)result2).getCompatibilityProblems());
            ((Collection)brokenPlugins).add(result2.getPlugin());
        }
        Iterable $this$distinctBy$iv = problems;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            CompatibilityProblem it = (CompatibilityProblem)e$iv;
            boolean bl2 = false;
            String key$iv = it.getShortDescription();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        int problemsNumber = ((List)list$iv).size();
        if (problemsNumber > 0) {
            tcLog.buildStatusFailure("IDE " + $this$printTcLog_u24lambda_u243.getIde().getIdeVersion() + " has " + FormatUtilsKt.pluralizeWithNumber("problem", problemsNumber) + " affecting " + FormatUtilsKt.pluralizeWithNumber("plugin", brokenPlugins.size()));
        } else {
            tcLog.buildStatusSuccess("IDE " + $this$printTcLog_u24lambda_u243.getIde().getIdeVersion() + " doesn't have broken API problems");
        }
        return new TeamCityHistory(CollectionsKt.plus((Collection)resultsHistory.getTests(), (Iterable)versionsHistory.getTests()));
    }

    private final void printOnStdOut(CheckIdeResult checkIdeResult) {
        PrintWriter printWriter = new PrintWriter(System.out);
        WriterResultPrinter resultPrinter = new WriterResultPrinter(printWriter);
        resultPrinter.printResults(checkIdeResult.getResults());
        printWriter.flush();
    }
}

