/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.filtering.documented;

import com.jetbrains.pluginverifier.filtering.documented.DocumentedProblem;
import com.jetbrains.pluginverifier.filtering.documented.DocumentedProblemKt;
import com.jetbrains.pluginverifier.results.problems.ClassNotFoundProblem;
import com.jetbrains.pluginverifier.results.problems.CompatibilityProblem;
import com.jetbrains.pluginverifier.results.problems.FieldNotFoundProblem;
import com.jetbrains.pluginverifier.results.problems.MethodNotFoundProblem;
import com.jetbrains.pluginverifier.results.problems.PackageNotFoundProblem;
import com.jetbrains.pluginverifier.verifiers.VerificationContext;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\f\u0010\u0015\u001a\u00020\n*\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/pluginverifier/filtering/documented/DocPackageRemoved;", "Lcom/jetbrains/pluginverifier/filtering/documented/DocumentedProblem;", "packageName", "", "(Ljava/lang/String;)V", "getPackageName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "isDocumenting", "problem", "Lcom/jetbrains/pluginverifier/results/problems/CompatibilityProblem;", "context", "Lcom/jetbrains/pluginverifier/verifiers/VerificationContext;", "toString", "belongsToPackage", "verifier-intellij"})
@SourceDebugExtension(value={"SMAP\nDocumentedProblem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentedProblem.kt\ncom/jetbrains/pluginverifier/filtering/documented/DocPackageRemoved\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,278:1\n1726#2,3:279\n*S KotlinDebug\n*F\n+ 1 DocumentedProblem.kt\ncom/jetbrains/pluginverifier/filtering/documented/DocPackageRemoved\n*L\n171#1:279,3\n*E\n"})
public final class DocPackageRemoved
implements DocumentedProblem {
    @NotNull
    private final String packageName;

    public DocPackageRemoved(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        this.packageName = packageName;
    }

    @NotNull
    public final String getPackageName() {
        return this.packageName;
    }

    private final boolean belongsToPackage(String $this$belongsToPackage) {
        return StringsKt.startsWith$default($this$belongsToPackage, this.packageName + "/", false, 2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isDocumenting(@NotNull CompatibilityProblem problem, @NotNull VerificationContext context) {
        boolean bl;
        Intrinsics.checkNotNullParameter(problem, "problem");
        Intrinsics.checkNotNullParameter(context, "context");
        CompatibilityProblem compatibilityProblem = problem;
        if (compatibilityProblem instanceof PackageNotFoundProblem) {
            ClassNotFoundProblem it;
            if (Intrinsics.areEqual(((PackageNotFoundProblem)problem).getPackageName(), this.packageName)) return true;
            if (this.belongsToPackage(((PackageNotFoundProblem)problem).getPackageName())) return true;
            Iterable $this$all$iv = ((PackageNotFoundProblem)problem).getClassNotFoundProblems();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            Iterator iterator2 = $this$all$iv.iterator();
            do {
                if (!iterator2.hasNext()) return true;
                Object element$iv = iterator2.next();
                it = (ClassNotFoundProblem)element$iv;
                boolean bl2 = false;
            } while (this.belongsToPackage(it.getUnresolved().getClassName()));
            return false;
        }
        if (compatibilityProblem instanceof ClassNotFoundProblem) {
            bl = this.belongsToPackage(((ClassNotFoundProblem)problem).getUnresolved().getClassName());
            return bl;
        } else if (compatibilityProblem instanceof MethodNotFoundProblem) {
            bl = DocumentedProblemKt.access$doesMethodDependOnClass(((MethodNotFoundProblem)problem).getUnresolvedMethod(), new Function1<String, Boolean>(this){
                final /* synthetic */ DocPackageRemoved this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return DocPackageRemoved.access$belongsToPackage(this.this$0, it);
                }
            });
            return bl;
        } else {
            if (!(compatibilityProblem instanceof FieldNotFoundProblem)) return false;
            bl = DocumentedProblemKt.access$doesFieldDependOnClass(((FieldNotFoundProblem)problem).getUnresolvedField(), new Function1<String, Boolean>(this){
                final /* synthetic */ DocPackageRemoved this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return DocPackageRemoved.access$belongsToPackage(this.this$0, it);
                }
            });
        }
        return bl;
    }

    @NotNull
    public final String component1() {
        return this.packageName;
    }

    @NotNull
    public final DocPackageRemoved copy(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        return new DocPackageRemoved(packageName);
    }

    public static /* synthetic */ DocPackageRemoved copy$default(DocPackageRemoved docPackageRemoved, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = docPackageRemoved.packageName;
        }
        return docPackageRemoved.copy(string);
    }

    @NotNull
    public String toString() {
        return "DocPackageRemoved(packageName=" + this.packageName + ")";
    }

    public int hashCode() {
        return this.packageName.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DocPackageRemoved)) {
            return false;
        }
        DocPackageRemoved docPackageRemoved = (DocPackageRemoved)other;
        return Intrinsics.areEqual(this.packageName, docPackageRemoved.packageName);
    }

    public static final /* synthetic */ boolean access$belongsToPackage(DocPackageRemoved $this, String $receiver) {
        return $this.belongsToPackage($receiver);
    }
}

