/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin;

import com.jetbrains.plugin.structure.base.problems.PluginDescriptorIsNotFound;
import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.intellij.plugin.BundledPluginManagerKt;
import com.jetbrains.plugin.structure.intellij.plugin.PluginArtifactPath;
import com.jetbrains.plugin.structure.intellij.plugin.PluginIdProvider;
import com.jetbrains.plugin.structure.intellij.plugin.jar.PluginDescriptorProvider;
import com.jetbrains.plugin.structure.intellij.problems.PluginLibDirectoryIsEmpty;
import com.jetbrains.plugin.structure.jar.PluginDescriptorResult;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\u000bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/BundledPluginManager;", "", "pluginIdProvider", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginIdProvider;", "(Lcom/jetbrains/plugin/structure/intellij/plugin/PluginIdProvider;)V", "descriptorProvider", "Lcom/jetbrains/plugin/structure/intellij/plugin/jar/PluginDescriptorProvider;", "getBundledPluginIds", "", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginArtifactPath;", "idePath", "Ljava/nio/file/Path;", "getPluginJars", "", "pluginPath", "loadPluginIdFromDirectory", "", "loadPluginIdFromJar", "jarPath", "readBundledPluginsIds", "resolveBundledPluginId", "pluginDirectory", "BundledPluginException", "structure-intellij"})
@SourceDebugExtension(value={"SMAP\nBundledPluginManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BundledPluginManager.kt\ncom/jetbrains/plugin/structure/intellij/plugin/BundledPluginManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n766#2:89\n857#2,2:90\n1603#2,9:92\n1855#2:101\n1856#2:103\n1612#2:104\n1#3:102\n*E\n*S KotlinDebug\n*F\n+ 1 BundledPluginManager.kt\ncom/jetbrains/plugin/structure/intellij/plugin/BundledPluginManager\n*L\n36#1:89\n36#1,2:90\n37#1,9:92\n37#1:101\n37#1:103\n37#1:104\n37#1:102\n*E\n"})
public final class BundledPluginManager {
    private final PluginDescriptorProvider descriptorProvider;
    private final PluginIdProvider pluginIdProvider;

    @NotNull
    public final Set<PluginArtifactPath> getBundledPluginIds(@NotNull Path idePath) {
        Intrinsics.checkNotNullParameter(idePath, "idePath");
        return this.readBundledPluginsIds(idePath);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<PluginArtifactPath> readBundledPluginsIds(Path idePath) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Path path = idePath.resolve("plugins");
        Intrinsics.checkNotNullExpressionValue(path, "idePath\n      .resolve(PLUGINS_DIRECTORY)");
        Iterable $this$filter$iv = FileUtilKt.listFiles(path);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Path it = (Path)element$iv$iv;
            boolean bl = false;
            if (!FileUtilKt.isDirectory(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PluginArtifactPath pluginArtifactPath;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Path it = (Path)element$iv$iv;
            boolean bl2 = false;
            if (this.resolveBundledPluginId(it) == null) continue;
            PluginArtifactPath it$iv$iv = pluginArtifactPath;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    private final PluginArtifactPath resolveBundledPluginId(Path pluginDirectory) {
        String string;
        try {
            PluginArtifactPath pluginArtifactPath;
            String string2 = this.loadPluginIdFromDirectory(pluginDirectory);
            if (string2 != null) {
                String it = string = string2;
                boolean bl = false;
                pluginArtifactPath = new PluginArtifactPath(it, pluginDirectory);
            } else {
                pluginArtifactPath = null;
            }
            string = pluginArtifactPath;
        }
        catch (BundledPluginException e) {
            BundledPluginManagerKt.access$getLOG$p().debug("Plugin [{}] has invalid descriptor: {}", (Object)pluginDirectory, (Object)e.getMessage());
            string = null;
        }
        return string;
    }

    private final String loadPluginIdFromDirectory(Path pluginPath) throws BundledPluginException {
        List<Path> jars = this.getPluginJars(pluginPath);
        for (Path jarPath : jars) {
            String pluginId = this.loadPluginIdFromJar(jarPath);
            if (pluginId == null) continue;
            return pluginId;
        }
        return null;
    }

    private final String loadPluginIdFromJar(Path jarPath) throws BundledPluginException {
        return (String)this.descriptorProvider.resolveFromJar(jarPath, (Function1)new Function1<PluginDescriptorResult.Found, String>(this){
            final /* synthetic */ BundledPluginManager this$0;

            @NotNull
            public final String invoke(@NotNull PluginDescriptorResult.Found $dstr$_u24__u24$inputStream) {
                Intrinsics.checkNotNullParameter($dstr$_u24__u24$inputStream, "<name for destructuring parameter 0>");
                InputStream inputStream2 = $dstr$_u24__u24$inputStream.component2();
                return BundledPluginManager.access$getPluginIdProvider$p(this.this$0).getPluginId(inputStream2);
            }
            {
                this.this$0 = bundledPluginManager;
                super(1);
            }
        });
    }

    private final List<Path> getPluginJars(Path pluginPath) throws BundledPluginException {
        Path path = pluginPath.resolve("lib");
        Intrinsics.checkNotNullExpressionValue(path, "pluginPath.resolve(LIB_DIRECTORY)");
        Path libDir = path;
        if (!FileUtilKt.isDirectory(libDir)) {
            throw (Throwable)new BundledPluginException(new PluginDescriptorIsNotFound("plugin.xml"));
        }
        List<Path> jars = FileUtilKt.listJars(libDir);
        if (jars.isEmpty()) {
            throw (Throwable)new BundledPluginException(new PluginLibDirectoryIsEmpty());
        }
        return jars;
    }

    public BundledPluginManager(@NotNull PluginIdProvider pluginIdProvider) {
        Intrinsics.checkNotNullParameter(pluginIdProvider, "pluginIdProvider");
        this.pluginIdProvider = pluginIdProvider;
        this.descriptorProvider = new PluginDescriptorProvider(null, 1, null);
    }

    public static final /* synthetic */ PluginIdProvider access$getPluginIdProvider$p(BundledPluginManager $this) {
        return $this.pluginIdProvider;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/BundledPluginManager$BundledPluginException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "problem", "Lcom/jetbrains/plugin/structure/base/problems/PluginProblem;", "(Lcom/jetbrains/plugin/structure/base/problems/PluginProblem;)V", "message", "", "getMessage", "()Ljava/lang/String;", "getProblem", "()Lcom/jetbrains/plugin/structure/base/problems/PluginProblem;", "structure-intellij"})
    private static final class BundledPluginException
    extends RuntimeException {
        @NotNull
        private final PluginProblem problem;

        @Override
        @NotNull
        public String getMessage() {
            return this.problem.getMessage();
        }

        @NotNull
        public final PluginProblem getProblem() {
            return this.problem;
        }

        public BundledPluginException(@NotNull PluginProblem problem) {
            Intrinsics.checkNotNullParameter(problem, "problem");
            this.problem = problem;
        }
    }
}

