/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.ide;

import com.jetbrains.plugin.structure.base.plugin.PluginCreationFail;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationSuccess;
import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.ide.AbstractIdeManager;
import com.jetbrains.plugin.structure.ide.IdeManager;
import com.jetbrains.plugin.structure.ide.InvalidIdeException;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.IdePluginManager;
import com.jetbrains.plugin.structure.intellij.resources.ResourceResolver;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0004J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0006H\u0004J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0004J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0004\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/plugin/structure/ide/AbstractIdeManager;", "Lcom/jetbrains/plugin/structure/ide/IdeManager;", "()V", "createBundledPluginExceptionally", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "idePath", "Ljava/nio/file/Path;", "pluginFile", "pathResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "descriptorPath", "", "ideVersion", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "readBuildNumber", "versionFile", "readIdeVersionFromBuildNumberFile", "resolveProductSpecificVersion", "structure-ide"})
@SourceDebugExtension(value={"SMAP\nAbstractIdeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractIdeManager.kt\ncom/jetbrains/plugin/structure/ide/AbstractIdeManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n766#2:66\n857#2,2:67\n*E\n*S KotlinDebug\n*F\n+ 1 AbstractIdeManager.kt\ncom/jetbrains/plugin/structure/ide/AbstractIdeManager\n*L\n62#1:66\n62#1,2:67\n*E\n"})
public abstract class AbstractIdeManager
extends IdeManager {
    @NotNull
    protected final IdeVersion readBuildNumber(@NotNull Path versionFile) {
        Intrinsics.checkNotNullParameter(versionFile, "versionFile");
        String string = FileUtilKt.readText$default(versionFile, null, 1, null);
        String buildNumberString = ((Object)StringsKt.trim((CharSequence)string)).toString();
        IdeVersion ideVersion = IdeVersion.createIdeVersion(buildNumberString);
        Intrinsics.checkNotNullExpressionValue(ideVersion, "IdeVersion.createIdeVersion(buildNumberString)");
        return ideVersion;
    }

    @NotNull
    protected final IdeVersion resolveProductSpecificVersion(@NotNull Path idePath, @NotNull IdeVersion ideVersion) {
        IdeVersion ideVersion2;
        Intrinsics.checkNotNullParameter(idePath, "idePath");
        Intrinsics.checkNotNullParameter(ideVersion, "ideVersion");
        CharSequence charSequence = ideVersion.getProductCode();
        if (charSequence.length() > 0) {
            ideVersion2 = ideVersion;
        } else {
            ideVersion2 = this.readIdeVersionFromBuildNumberFile(idePath);
            if (ideVersion2 == null) {
                ideVersion2 = ideVersion;
            }
        }
        return ideVersion2;
    }

    @Nullable
    protected final IdeVersion readIdeVersionFromBuildNumberFile(@NotNull Path idePath) {
        Path buildNumberFile;
        Intrinsics.checkNotNullParameter(idePath, "idePath");
        Path path = buildNumberFile = idePath.resolve("build.number");
        Intrinsics.checkNotNullExpressionValue(path, "buildNumberFile");
        if (FileUtilKt.exists(path)) {
            List lines = FileUtilKt.readLines$default(buildNumberFile, null, 1, null);
            for (String line : lines) {
                if (!StringsKt.startsWith$default(line, "build.number=", false, 2, null)) continue;
                return IdeVersion.createIdeVersionIfValid(StringsKt.substringAfter$default(line, "build.number=", null, 2, null));
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final IdePlugin createBundledPluginExceptionally(@NotNull Path idePath, @NotNull Path pluginFile, @NotNull ResourceResolver pathResolver, @NotNull String descriptorPath, @NotNull IdeVersion ideVersion) {
        Intrinsics.checkNotNullParameter(idePath, "idePath");
        Intrinsics.checkNotNullParameter(pluginFile, "pluginFile");
        Intrinsics.checkNotNullParameter(pathResolver, "pathResolver");
        Intrinsics.checkNotNullParameter(descriptorPath, "descriptorPath");
        Intrinsics.checkNotNullParameter(ideVersion, "ideVersion");
        PluginCreationResult creationResult = IdePluginManager.createBundledPlugin$default(IdePluginManager.Companion.createManager(pathResolver), pluginFile, ideVersion, descriptorPath, null, null, 24, null);
        if (!(creationResult instanceof PluginCreationSuccess)) {
            if (creationResult instanceof PluginCreationFail) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Iterable iterable = ((PluginCreationFail)creationResult).getErrorsAndWarnings();
                Path path = idePath.relativize(pluginFile);
                Path path2 = idePath;
                boolean $i$f$filter = false;
                void var9_11 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    PluginProblem it = (PluginProblem)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getLevel() == PluginProblem.Level.ERROR)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list = (List)destination$iv$iv;
                String string = "Plugin '" + path + "' is invalid: " + CollectionsKt.joinToString$default(list, null, null, null, 0, null, createBundledPluginExceptionally.2.INSTANCE, 31, null);
                Path path3 = path2;
                throw (Throwable)new InvalidIdeException(path3, string);
            }
            throw new NoWhenBranchMatchedException();
        }
        return (IdePlugin)((PluginCreationSuccess)creationResult).getPlugin();
    }
}

