/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.decompress;

import com.jetbrains.plugin.structure.base.decompress.Decompressor$WhenMappings;
import com.jetbrains.plugin.structure.base.decompress.DecompressorKt;
import com.jetbrains.plugin.structure.base.decompress.DecompressorSizeLimitExceededException;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.input.BoundedInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 \u00122\u00020\u0001:\u0003\u0012\u0013\u0014B\u0011\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\b\u0010\n\u001a\u00020\u0007H&J\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rJ\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH&J\n\u0010\u0010\u001a\u0004\u0018\u00010\tH&J\b\u0010\u0011\u001a\u00020\u0007H&R\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005\u0082\u0001\u0002\u0015\u0016\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/plugin/structure/base/decompress/Decompressor;", "", "outputSizeLimit", "", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "closeNextEntryStream", "", "entryStream", "Ljava/io/InputStream;", "closeStream", "extract", "outputDir", "Ljava/nio/file/Path;", "nextEntry", "Lcom/jetbrains/plugin/structure/base/decompress/Decompressor$Entry;", "nextEntryStream", "openStream", "Companion", "Entry", "Type", "Lcom/jetbrains/plugin/structure/base/decompress/TarDecompressor;", "Lcom/jetbrains/plugin/structure/base/decompress/ZipDecompressor;", "structure-base"})
public abstract class Decompressor {
    private final Long outputSizeLimit;
    public static final int FILE_NAME_LENGTH_LIMIT = 255;
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void extract(@NotNull Path outputDir) {
        Intrinsics.checkNotNullParameter(outputDir, "outputDir");
        this.openStream();
        try {
            long actualSizeLimit;
            Long l = this.outputSizeLimit;
            long remainingSize = actualSizeLimit = l != null ? l : Long.MAX_VALUE;
            block11: while (this.nextEntry() != null) {
                Entry entry;
                Path outputFile = DecompressorKt.access$getEntryFile(outputDir, entry);
                switch (Decompressor$WhenMappings.$EnumSwitchMapping$0[entry.getType().ordinal()]) {
                    case 1: {
                        FileUtilKt.createDir(outputFile);
                        break;
                    }
                    case 2: {
                        InputStream entryStream;
                        if (this.nextEntryStream() == null) continue block11;
                        try {
                            BoundedInputStream countingStream = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream(entryStream)).setMaxCount(remainingSize + 1L)).setPropagateClose(false)).get();
                            FileUtilKt.createParentDirs(outputFile);
                            Files.copy(countingStream, outputFile, new CopyOption[0]);
                            BoundedInputStream boundedInputStream = countingStream;
                            Intrinsics.checkNotNullExpressionValue(boundedInputStream, "countingStream");
                            if ((remainingSize -= boundedInputStream.getCount()) >= 0L) continue block11;
                            throw (Throwable)new DecompressorSizeLimitExceededException(actualSizeLimit);
                        }
                        finally {
                            this.closeNextEntryStream(entryStream);
                            continue block11;
                        }
                    }
                    case 3: {
                        throw (Throwable)new IOException("Symlinks are not allowed");
                    }
                }
            }
        }
        finally {
            this.closeStream();
        }
    }

    public abstract void openStream();

    @Nullable
    public abstract Entry nextEntry();

    @Nullable
    public abstract InputStream nextEntryStream();

    public abstract void closeNextEntryStream(@NotNull InputStream var1);

    public abstract void closeStream();

    private Decompressor(Long outputSizeLimit) {
        this.outputSizeLimit = outputSizeLimit;
    }

    public /* synthetic */ Decompressor(Long outputSizeLimit, DefaultConstructorMarker $constructor_marker) {
        this(outputSizeLimit);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/plugin/structure/base/decompress/Decompressor$Type;", "", "(Ljava/lang/String;I)V", "FILE", "DIR", "SYMLINK", "structure-base"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type FILE;
        public static final /* enum */ Type DIR;
        public static final /* enum */ Type SYMLINK;
        private static final /* synthetic */ Type[] $VALUES;

        static {
            Type[] typeArray = new Type[3];
            Type[] typeArray2 = typeArray;
            typeArray[0] = FILE = new Type();
            typeArray[1] = DIR = new Type();
            typeArray[2] = SYMLINK = new Type();
            $VALUES = typeArray;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/plugin/structure/base/decompress/Decompressor$Entry;", "", "name", "", "type", "Lcom/jetbrains/plugin/structure/base/decompress/Decompressor$Type;", "(Ljava/lang/String;Lcom/jetbrains/plugin/structure/base/decompress/Decompressor$Type;)V", "getName", "()Ljava/lang/String;", "getType", "()Lcom/jetbrains/plugin/structure/base/decompress/Decompressor$Type;", "structure-base"})
    public static final class Entry {
        @NotNull
        private final String name;
        @NotNull
        private final Type type;

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final Type getType() {
            return this.type;
        }

        public Entry(@NotNull String name, @NotNull Type type2) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter((Object)type2, "type");
            this.name = name;
            this.type = type2;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/plugin/structure/base/decompress/Decompressor$Companion;", "", "()V", "FILE_NAME_LENGTH_LIMIT", "", "structure-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

