/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.pluginRepository.internal.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jetbrains.plugin.blockmap.core.BlockMap;
import com.jetbrains.plugin.blockmap.core.Chunk;
import com.jetbrains.plugin.blockmap.core.ChunkMerger;
import com.jetbrains.plugin.blockmap.core.FileHash;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.MediaType;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.pluginRepository.PluginRepositoryException;
import org.jetbrains.intellij.pluginRepository.internal.Messages;
import org.jetbrains.intellij.pluginRepository.internal.api.BlockMapService;
import org.jetbrains.intellij.pluginRepository.internal.api.PluginRepositoryInstanceKt;
import org.jetbrains.intellij.pluginRepository.internal.blockmap.PluginChunkDataSource;
import org.jetbrains.intellij.pluginRepository.internal.utils.RequestHelperKt;
import org.slf4j.Logger;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a \u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\rH\u0000\u001a(\u0010\u0012\u001a\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rH\u0000\u001a \u0010\u0014\u001a\u0004\u0018\u00010\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u00162\u0006\u0010\u0011\u001a\u00020\rH\u0002\u001a(\u0010\u0017\u001a\u0004\u0018\u00010\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u00162\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rH\u0002\u001a\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\u001a\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u001a&\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u00162\u0006\u0010 \u001a\u00020\u0007H\u0002\u001a\u0016\u0010!\u001a\u00020\u00072\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016H\u0002\u001a\u0018\u0010#\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020$2\u0006\u0010 \u001a\u00020\u0007H\u0002\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "objectMapper$delegate", "Lkotlin/Lazy;", "BLOCKMAP_ZIP_SUFFIX", "", "BLOCKMAP_FILENAME", "HASH_FILENAME_SUFFIX", "MAXIMUM_DOWNLOAD_PERCENT", "", "downloadPlugin", "Ljava/io/File;", "callable", "Lretrofit2/Call;", "Lokhttp3/ResponseBody;", "targetPath", "downloadPluginViaBlockMap", "oldFile", "downloadFile", "executed", "Lretrofit2/Response;", "downloadFileViaBlockMap", "downloadPercent", "oldBlockMap", "Lcom/jetbrains/plugin/blockmap/core/BlockMap;", "newBlockMap", "getBlockMapFromZip", "input", "Ljava/io/InputStream;", "getTargetFile", "url", "getResponseErrorMessage", "response", "guessFileName", "Lokhttp3/Response;", "rest"})
@SourceDebugExtension(value={"SMAP\nDownloadPluginHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DownloadPluginHelper.kt\norg/jetbrains/intellij/pluginRepository/internal/utils/DownloadPluginHelperKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,178:1\n1#2:179\n774#3:180\n865#3,2:181\n*S KotlinDebug\n*F\n+ 1 DownloadPluginHelper.kt\norg/jetbrains/intellij/pluginRepository/internal/utils/DownloadPluginHelperKt\n*L\n124#1:180\n124#1:181,2\n*E\n"})
public final class DownloadPluginHelperKt {
    @NotNull
    private static final Lazy objectMapper$delegate = LazyKt.lazy(DownloadPluginHelperKt::objectMapper_delegate$lambda$0);
    @NotNull
    public static final String BLOCKMAP_ZIP_SUFFIX = ".blockmap.zip";
    @NotNull
    public static final String BLOCKMAP_FILENAME = "blockmap.json";
    @NotNull
    public static final String HASH_FILENAME_SUFFIX = ".hash.json";
    private static final double MAXIMUM_DOWNLOAD_PERCENT = 0.65;

    private static final ObjectMapper getObjectMapper() {
        Lazy lazy = objectMapper$delegate;
        return (ObjectMapper)lazy.getValue();
    }

    @Nullable
    public static final File downloadPlugin(@NotNull Call<ResponseBody> callable, @NotNull File targetPath) {
        Intrinsics.checkNotNullParameter(callable, "callable");
        Intrinsics.checkNotNullParameter(targetPath, "targetPath");
        retrofit2.Response<ResponseBody> response = RequestHelperKt.executeExceptionally(callable);
        if (response.isSuccessful()) {
            File file2;
            try {
                file2 = DownloadPluginHelperKt.downloadFile(response, targetPath);
            }
            catch (Exception e) {
                Object[] objectArray = new Object[]{response.code()};
                throw new PluginRepositoryException(Messages.INSTANCE.getMessage("downloading.failed", objectArray), e);
            }
            return file2;
        }
        if (response.code() == 404) {
            return null;
        }
        Object[] objectArray = new Object[]{response.code()};
        throw new PluginRepositoryException(Messages.INSTANCE.getMessage("downloading.failed", objectArray) + DownloadPluginHelperKt.getResponseErrorMessage(response));
    }

    @Nullable
    public static final File downloadPluginViaBlockMap(@NotNull Call<ResponseBody> callable, @NotNull File targetPath, @NotNull File oldFile) {
        Intrinsics.checkNotNullParameter(callable, "callable");
        Intrinsics.checkNotNullParameter(targetPath, "targetPath");
        Intrinsics.checkNotNullParameter(oldFile, "oldFile");
        retrofit2.Response<ResponseBody> response = RequestHelperKt.executeExceptionally(callable);
        if (response.isSuccessful()) {
            File file2;
            try {
                file2 = DownloadPluginHelperKt.downloadFileViaBlockMap(response, targetPath, oldFile);
            }
            catch (Exception e) {
                Object[] objectArray = new Object[]{response.code()};
                throw new PluginRepositoryException(Messages.INSTANCE.getMessage("downloading.failed", objectArray), e);
            }
            return file2;
        }
        if (response.code() == 404) {
            return null;
        }
        Object[] objectArray = new Object[]{response.code()};
        throw new PluginRepositoryException(Messages.INSTANCE.getMessage("downloading.failed", objectArray) + DownloadPluginHelperKt.getResponseErrorMessage(response));
    }

    private static final File downloadFile(retrofit2.Response<ResponseBody> executed, File targetPath) {
        String mimeType;
        String url = executed.raw().request().url().url().toExternalForm();
        ResponseBody responseBody = executed.body();
        if (responseBody == null) {
            return null;
        }
        ResponseBody response = responseBody;
        MediaType mediaType = response.contentType();
        String string2 = mimeType = mediaType != null ? mediaType.toString() : null;
        if (!Intrinsics.areEqual(mimeType, "application/zip") && !Intrinsics.areEqual(mimeType, "application/java-archive")) {
            return null;
        }
        Intrinsics.checkNotNull(url);
        File targetFile = DownloadPluginHelperKt.getTargetFile(targetPath, executed, url);
        Files.copy(response.byteStream(), targetFile.toPath(), new CopyOption[0]);
        return targetFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final File downloadFileViaBlockMap(retrofit2.Response<ResponseBody> executed, File targetPath, File oldFile) {
        if (!oldFile.exists()) {
            Object[] objectArray = new Object[]{oldFile.toString()};
            PluginRepositoryInstanceKt.getLOG().info(Messages.INSTANCE.getMessage("file.not.found", objectArray));
            return DownloadPluginHelperKt.downloadFile(executed, targetPath);
        }
        String url = executed.raw().request().url().url().toExternalForm();
        Intrinsics.checkNotNull(url);
        String fileName = StringsKt.removeSuffix(StringsKt.removePrefix(url, (CharSequence)StringsKt.replaceAfterLast$default(url, "/", "", null, 4, null)), (CharSequence)StringsKt.replaceBefore$default(url, "?", "", null, 4, null));
        String baseUrl = StringsKt.replaceAfterLast$default(url, "/", "", null, 4, null);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory(JacksonConverterFactory.create()).build();
        BlockMapService service = retrofit.create(BlockMapService.class);
        String blockMapFileName = fileName + BLOCKMAP_ZIP_SUFFIX;
        String hashFileName = fileName + HASH_FILENAME_SUFFIX;
        try {
            FileHash fileHash;
            Object object;
            Object input2;
            ResponseBody responseBody = RequestHelperKt.executeExceptionally(service.getBlockMapZip(blockMapFileName)).body();
            if (responseBody == null) {
                throw new IOException(Messages.INSTANCE.getMessage("block.map.file.doesnt.exist", new Object[0]));
            }
            ResponseBody blockMapZip = responseBody;
            BlockMap newBlockMap = DownloadPluginHelperKt.getBlockMapFromZip(blockMapZip.byteStream());
            FileHash fileHash2 = RequestHelperKt.executeExceptionally(service.getHash(hashFileName)).body();
            if (fileHash2 == null) {
                throw new IOException(Messages.INSTANCE.getMessage("hash.file.does.not.exist", new Object[0]));
            }
            FileHash newPluginHash = fileHash2;
            Closeable closeable = new FileInputStream(oldFile);
            Throwable throwable = null;
            try {
                input2 = (FileInputStream)closeable;
                boolean bl = false;
                input2 = new BlockMap((InputStream)input2, newBlockMap.getAlgorithm(), newBlockMap.getMinSize(), newBlockMap.getMaxSize(), newBlockMap.getNormalSize());
            }
            catch (Throwable input2) {
                throwable = input2;
                throw input2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            Object oldBlockMap = input2;
            double downloadPercent = DownloadPluginHelperKt.downloadPercent((BlockMap)oldBlockMap, newBlockMap);
            Logger logger = PluginRepositoryInstanceKt.getLOG();
            input2 = "Plugin's download percent is = %.2f";
            Object[] bl = new Object[]{downloadPercent * (double)100};
            String string2 = String.format((String)input2, Arrays.copyOf(bl, bl.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            logger.info(string2);
            if (downloadPercent > 0.65) {
                throw new IOException(Messages.INSTANCE.getMessage("too.large.download.size", new Object[0]));
            }
            ChunkMerger merger = new ChunkMerger(oldFile, (BlockMap)oldBlockMap, newBlockMap, 0, 8, null);
            File targetFile = DownloadPluginHelperKt.getTargetFile(targetPath, executed, url);
            Closeable closeable2 = new FileOutputStream(targetFile);
            Object object2 = null;
            try {
                FileOutputStream output = (FileOutputStream)closeable2;
                boolean bl2 = false;
                OutputStream outputStream2 = output;
                Intrinsics.checkNotNull(service);
                merger.merge(outputStream2, new PluginChunkDataSource((BlockMap)oldBlockMap, newBlockMap, service, fileName));
                object = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                object2 = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable2, (Throwable)object2);
            }
            object2 = new FileInputStream(targetFile);
            object = null;
            try {
                FileInputStream input3 = (FileInputStream)object2;
                boolean bl3 = false;
                fileHash = new FileHash(input3, newPluginHash.getAlgorithm());
            }
            catch (Throwable throwable3) {
                object = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
            }
            FileHash curFileHash = fileHash;
            if (!Intrinsics.areEqual(curFileHash, newPluginHash)) {
                throw new IOException(Messages.INSTANCE.getMessage("hashes.doesnt.match", new Object[0]));
            }
            return targetFile;
        }
        catch (Exception e) {
            PluginRepositoryInstanceKt.getLOG().info("Unable to download plugin via blockmap: " + e.getMessage());
            return DownloadPluginHelperKt.downloadPlugin(service.getPluginFile(fileName, ""), targetPath);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final double downloadPercent(BlockMap oldBlockMap, BlockMap newBlockMap) {
        int n;
        void $this$filterTo$iv$iv;
        Set oldSet = CollectionsKt.toSet((Iterable)oldBlockMap.getChunks());
        Iterable $this$filter$iv = newBlockMap.getChunks();
        boolean $i$f$filter = false;
        Iterator iterator2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Chunk chunk = (Chunk)element$iv$iv;
            boolean bl = false;
            if (!(!oldSet.contains(chunk))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List newChunks = (List)destination$iv$iv;
        Iterable iterable = newChunks;
        int n2 = 0;
        for (Object object : iterable) {
            void chunk;
            Chunk $i$f$filterTo2 = (Chunk)object;
            int n3 = n2;
            boolean bl = false;
            int n4 = chunk.getLength();
            n2 = n3 + n4;
        }
        iterable = newBlockMap.getChunks();
        double d = n2;
        n2 = 0;
        for (Object object : iterable) {
            Chunk chunk = (Chunk)object;
            n = n2;
            boolean bl = false;
            int n5 = chunk.getLength();
            n2 = n + n5;
        }
        n = n2;
        return d / (double)n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final BlockMap getBlockMapFromZip(InputStream input) {
        BlockMap blockMap;
        Closeable closeable = input;
        int n = 8192;
        closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
        Throwable throwable = null;
        try {
            BlockMap blockMap2;
            BufferedInputStream source2 = (BufferedInputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new ZipInputStream(source2);
            Throwable throwable2 = null;
            try {
                ZipInputStream zip2 = (ZipInputStream)closeable2;
                boolean bl2 = false;
                ZipEntry entry = zip2.getNextEntry();
                while (!Intrinsics.areEqual(entry.getName(), BLOCKMAP_FILENAME) && entry.getName() != null) {
                    entry = zip2.getNextEntry();
                }
                if (!Intrinsics.areEqual(entry.getName(), BLOCKMAP_FILENAME)) {
                    throw new IOException(Messages.INSTANCE.getMessage("block.map.file.doesnt.exist", new Object[0]));
                }
                blockMap2 = DownloadPluginHelperKt.getObjectMapper().readValue(ByteStreamsKt.readBytes(zip2), BlockMap.class);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally(closeable2, throwable2);
            }
            BlockMap blockMap3 = blockMap2;
            blockMap = blockMap3;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        Intrinsics.checkNotNullExpressionValue(blockMap, "use(...)");
        return blockMap;
    }

    private static final File getTargetFile(File targetPath, retrofit2.Response<ResponseBody> executed, String url) {
        File targetFile = targetPath;
        if (targetFile.isDirectory()) {
            Response response = executed.raw();
            Intrinsics.checkNotNullExpressionValue(response, "raw(...)");
            String guessFileName = DownloadPluginHelperKt.guessFileName(response, url);
            if (StringsKt.contains$default((CharSequence)guessFileName, File.separatorChar, false, 2, null)) {
                throw new IOException(Messages.INSTANCE.getMessage("invalid.filename", new Object[0]));
            }
            File file2 = new File(targetFile, guessFileName);
            if (!Intrinsics.areEqual(file2.getParentFile(), targetFile)) {
                throw new IOException(Messages.INSTANCE.getMessage("invalid.filename", new Object[0]));
            }
            targetFile = file2;
        }
        return targetFile;
    }

    private static final String getResponseErrorMessage(retrofit2.Response<ResponseBody> response) {
        Object object = response.errorBody();
        if ((object == null || (object = ((ResponseBody)object).string()) == null) && (object = response.message()) == null) {
            object = "";
        }
        Object it = object;
        boolean bl = false;
        return ((CharSequence)it).length() > 0 ? ": " + (String)it : "";
    }

    private static final String guessFileName(Response response, String url) {
        String contentDispositionHeader;
        String string2;
        String contentDisposition;
        Object v0;
        String filenameMarker;
        block4: {
            filenameMarker = "filename=";
            Iterable iterable = response.headers().names();
            for (Object t2 : iterable) {
                String it = (String)t2;
                boolean bl = false;
                if (!StringsKt.equals(it, "Content-Disposition", true)) continue;
                v0 = t2;
                break block4;
            }
            v0 = null;
        }
        String string3 = contentDisposition = (String)v0;
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            string2 = response.headers().get(contentDisposition);
        } else {
            string2 = contentDispositionHeader = null;
        }
        if (contentDispositionHeader == null || !StringsKt.contains$default((CharSequence)contentDispositionHeader, filenameMarker, false, 2, null)) {
            String fileName = StringsKt.substringAfterLast$default(url, '/', null, 2, null);
            return ((CharSequence)fileName).length() > 0 ? fileName : url;
        }
        return StringsKt.removeSurrounding(StringsKt.substringBefore$default(StringsKt.substringAfter(contentDispositionHeader, filenameMarker, ""), ';', null, 2, null), (CharSequence)"\"");
    }

    private static final ObjectMapper objectMapper_delegate$lambda$0() {
        return new ObjectMapper();
    }
}

