/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TByteHashingStrategy;
import gnu.trove.TByteObjectIterator;
import gnu.trove.TByteObjectProcedure;
import gnu.trove.TByteProcedure;
import gnu.trove.THash;
import gnu.trove.TObjectFunction;
import gnu.trove.TObjectHash;
import gnu.trove.TObjectProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TByteObjectHashMap<V>
extends THash
implements TByteHashingStrategy {
    protected transient V[] _values;
    protected transient byte[] _set;
    protected final TByteHashingStrategy _hashingStrategy;

    public TByteObjectHashMap() {
        this._hashingStrategy = this;
    }

    public TByteObjectHashMap(int initialCapacity) {
        super(initialCapacity);
        this._hashingStrategy = this;
    }

    public TByteObjectHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = this;
    }

    public TByteObjectHashMap(TByteHashingStrategy strategy) {
        this._hashingStrategy = strategy;
    }

    public TByteObjectHashMap(int initialCapacity, TByteHashingStrategy strategy) {
        super(initialCapacity);
        this._hashingStrategy = strategy;
    }

    public TByteObjectHashMap(int initialCapacity, float loadFactor, TByteHashingStrategy strategy) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = strategy;
    }

    @Override
    public TByteObjectHashMap<V> clone() {
        TByteObjectHashMap m4 = (TByteObjectHashMap)super.clone();
        m4._values = this._values == EMPTY_OBJECT_ARRAY ? EMPTY_OBJECT_ARRAY : (Object[])this._values.clone();
        m4._set = this._values == EMPTY_OBJECT_ARRAY ? null : (byte[])this._set.clone();
        return m4;
    }

    public TByteObjectIterator<V> iterator() {
        return new TByteObjectIterator(this);
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = initialCapacity == -1 ? EMPTY_OBJECT_ARRAY : new Object[capacity];
        this._set = initialCapacity == -1 ? null : new byte[capacity];
        return capacity;
    }

    public boolean contains(byte val) {
        return this.index(val) >= 0;
    }

    @Override
    protected int capacity() {
        return this._values.length;
    }

    public boolean forEach(TByteProcedure procedure) {
        byte[] set = this._set;
        Object[] values2 = this._values;
        int i = values2.length;
        while (i-- > 0) {
            if (!TByteObjectHashMap.isFull(values2, i) || procedure.execute(set[i])) continue;
            return false;
        }
        return true;
    }

    public V put(byte key, V value) {
        boolean wasFree = false;
        V previous = null;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = TByteObjectHashMap.unwrapNull(this._values[index]);
            isNewMapping = false;
        } else {
            wasFree = TByteObjectHashMap.isFree(this._values, index);
        }
        this._set[index] = key;
        this._values[index] = TByteObjectHashMap.wrapNull(value);
        if (isNewMapping) {
            this.postInsertHook(wasFree);
        }
        return previous;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        byte[] oldKeys = this._set;
        Object[] oldVals = this._values;
        this._set = new byte[newCapacity];
        this._values = new Object[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (!TByteObjectHashMap.isFull(oldVals, i)) continue;
            byte o = oldKeys[i];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._values[index] = oldVals[i];
        }
    }

    public V get(byte key) {
        int index = this.index(key);
        return index < 0 ? null : (V)TByteObjectHashMap.unwrapNull(this._values[index]);
    }

    private static <V> V unwrapNull(V value) {
        return value == TObjectHash.NULL ? null : (V)value;
    }

    private static <V> V wrapNull(V value) {
        return (V)(value == null ? TObjectHash.NULL : value);
    }

    @Override
    public void clear() {
        super.clear();
        byte[] keys2 = this._set;
        V[] values2 = this._values;
        int i = values2.length;
        while (i-- > 0) {
            keys2[i] = 0;
            values2[i] = null;
        }
    }

    public V remove(byte key) {
        V prev = null;
        int index = this.index(key);
        if (index >= 0) {
            prev = TByteObjectHashMap.unwrapNull(this._values[index]);
            this.removeAt(index);
        }
        return prev;
    }

    protected int index(byte val) {
        byte[] set = this._set;
        Object[] values2 = this._values;
        if (values2 == EMPTY_OBJECT_ARRAY) {
            return -1;
        }
        int length = set.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (!TByteObjectHashMap.isFree(values2, index) && (TByteObjectHashMap.isRemoved(values2, index) || set[index] != val)) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while (!TByteObjectHashMap.isFree(values2, index) && (TByteObjectHashMap.isRemoved(values2, index) || set[index] != val));
        }
        return TByteObjectHashMap.isFree(values2, index) ? -1 : index;
    }

    protected int insertionIndex(byte val) {
        int firstRemoved;
        if (this._values == EMPTY_OBJECT_ARRAY) {
            this.setUp(6);
        }
        Object[] values2 = this._values;
        byte[] set = this._set;
        int length = set.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (TByteObjectHashMap.isFree(values2, index)) {
            return index;
        }
        if (TByteObjectHashMap.isFull(values2, index) && set[index] == val) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        int n = firstRemoved = TByteObjectHashMap.isRemoved(values2, index) ? index : -1;
        do {
            if ((index -= probe) < 0) {
                index += length;
            }
            if (firstRemoved != -1 || !TByteObjectHashMap.isRemoved(values2, index)) continue;
            firstRemoved = index;
        } while (TByteObjectHashMap.isFull(values2, index) && set[index] != val);
        if (TByteObjectHashMap.isRemoved(values2, index)) {
            while (!TByteObjectHashMap.isFree(values2, index) && (TByteObjectHashMap.isRemoved(values2, index) || set[index] != val)) {
                if ((index -= probe) >= 0) continue;
                index += length;
            }
        }
        if (TByteObjectHashMap.isFull(values2, index)) {
            return -index - 1;
        }
        return firstRemoved == -1 ? index : firstRemoved;
    }

    static boolean isFull(Object[] values2, int index) {
        Object value = values2[index];
        return value != null && value != TObjectHash.REMOVED;
    }

    private static boolean isRemoved(Object[] values2, int index) {
        return values2[index] == TObjectHash.REMOVED;
    }

    private static boolean isFree(Object[] values2, int index) {
        return values2[index] == null;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TByteObjectHashMap)) {
            return false;
        }
        TByteObjectHashMap that = (TByteObjectHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    @Override
    protected void removeAt(int index) {
        this._values[index] = TObjectHash.REMOVED;
        super.removeAt(index);
    }

    public Object[] getValues() {
        Object[] vals = new Object[this.size()];
        Object[] values2 = this._values;
        int i = values2.length;
        int j = 0;
        while (i-- > 0) {
            if (!TByteObjectHashMap.isFull(values2, i)) continue;
            vals[j++] = TByteObjectHashMap.unwrapNull(values2[i]);
        }
        return vals;
    }

    public byte[] keys() {
        byte[] keys2 = new byte[this.size()];
        byte[] k = this._set;
        Object[] values2 = this._values;
        int i = values2.length;
        int j = 0;
        while (i-- > 0) {
            if (!TByteObjectHashMap.isFull(values2, i)) continue;
            keys2[j++] = k[i];
        }
        return keys2;
    }

    public boolean containsValue(V val) {
        Object[] values2 = this._values;
        if (null == val) {
            int i = values2.length;
            while (i-- > 0) {
                if (TObjectHash.NULL != values2[i]) continue;
                return true;
            }
        } else {
            int i = values2.length;
            while (i-- > 0) {
                V value = TByteObjectHashMap.unwrapNull(values2[i]);
                if (!TByteObjectHashMap.isFull(values2, i) || val != value && !val.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(byte key) {
        return this.contains(key);
    }

    public boolean forEachKey(TByteProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TObjectProcedure<V> procedure) {
        Object[] values2 = this._values;
        int i = values2.length;
        while (i-- > 0) {
            if (!TByteObjectHashMap.isFull(values2, i) || procedure.execute(TByteObjectHashMap.unwrapNull(values2[i]))) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TByteObjectProcedure<V> procedure) {
        byte[] keys2 = this._set;
        Object[] values2 = this._values;
        int i = values2.length;
        while (i-- > 0) {
            if (!TByteObjectHashMap.isFull(values2, i) || procedure.execute(keys2[i], TByteObjectHashMap.unwrapNull(values2[i]))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainEntries(TByteObjectProcedure<V> procedure) {
        boolean modified = false;
        byte[] keys2 = this._set;
        Object[] values2 = this._values;
        this.stopCompactingOnRemove();
        try {
            int i = values2.length;
            while (i-- > 0) {
                if (!TByteObjectHashMap.isFull(values2, i) || procedure.execute(keys2[i], TByteObjectHashMap.unwrapNull(values2[i]))) continue;
                this.removeAt(i);
                modified = true;
            }
        }
        finally {
            this.startCompactingOnRemove(modified);
        }
        return modified;
    }

    public void transformValues(TObjectFunction<V, V> function) {
        Object[] values2 = this._values;
        int i = values2.length;
        while (i-- > 0) {
            if (!TByteObjectHashMap.isFull(values2, i)) continue;
            values2[i] = TByteObjectHashMap.wrapNull(function.execute(TByteObjectHashMap.unwrapNull(values2[i])));
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            byte key = stream.readByte();
            Object val = stream.readObject();
            this.put(key, val);
        }
    }

    @Override
    public final int computeHashCode(byte val) {
        return HashFunctions.hash(val);
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        this.forEachEntry(new TByteObjectProcedure<V>(){

            @Override
            public boolean execute(byte key, V value) {
                if (sb.length() != 0) {
                    sb.append(',').append(' ');
                }
                sb.append(key);
                sb.append('=');
                sb.append((Object)(value == this ? "(this Map)" : value));
                return true;
            }
        });
        sb.append('}');
        sb.insert(0, '{');
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EqProcedure<V>
    implements TByteObjectProcedure<V> {
        private final TByteObjectHashMap<V> _otherMap;

        EqProcedure(TByteObjectHashMap<V> otherMap) {
            this._otherMap = otherMap;
        }

        @Override
        public final boolean execute(byte key, V value) {
            int index = this._otherMap.index(key);
            return index >= 0 && EqProcedure.eq(value, this._otherMap.get(key));
        }

        private static boolean eq(Object o1, Object o2) {
            return o1 == o2 || o1 != null && o1.equals(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class HashProcedure
    implements TByteObjectProcedure<V> {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        @Override
        public final boolean execute(byte key, V value) {
            this.h += TByteObjectHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value);
            return true;
        }
    }
}

