/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.verifiers.resolution;

import com.jetbrains.pluginverifier.results.access.AccessType;
import com.jetbrains.pluginverifier.verifiers.InheritanceUtilKt;
import com.jetbrains.pluginverifier.verifiers.VerificationContext;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassFile;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassFileMember;
import com.jetbrains.pluginverifier.verifiers.resolution.Field;
import com.jetbrains.pluginverifier.verifiers.resolution.Method;
import com.jetbrains.pluginverifier.verifiers.resolution.ResolutionUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u001a \u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u001a \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001a\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0016\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n\u001a\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\nH\u0002\u00a8\u0006\u0012"}, d2={"detectAccessProblem", "Lcom/jetbrains/pluginverifier/results/access/AccessType;", "callee", "Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFileMember;", "caller", "context", "Lcom/jetbrains/pluginverifier/verifiers/VerificationContext;", "doClassesBelongToTheSameNestHost", "", "one", "Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFile;", "two", "getClassNestHost", "classFile", "isClassAccessibleToOtherClass", "me", "other", "isKotlinDefaultConstructorMarker", "verifier-core"})
public final class AccessibilityUtilKt {
    public static final boolean isClassAccessibleToOtherClass(@NotNull ClassFile me, @NotNull ClassFile other) {
        Intrinsics.checkNotNullParameter(me, "me");
        Intrinsics.checkNotNullParameter(other, "other");
        return me.isPublic() || me.isPrivate() && Intrinsics.areEqual(me.getName(), other.getName()) || Intrinsics.areEqual(me.getJavaPackageName(), other.getJavaPackageName()) || AccessibilityUtilKt.isKotlinDefaultConstructorMarker(me);
    }

    private static final boolean isKotlinDefaultConstructorMarker(ClassFile classFile) {
        return Intrinsics.areEqual(classFile.getName(), "kotlin/jvm/internal/DefaultConstructorMarker");
    }

    @Nullable
    public static final AccessType detectAccessProblem(@NotNull ClassFileMember callee, @NotNull ClassFileMember caller2, @NotNull VerificationContext context) {
        Intrinsics.checkNotNullParameter(callee, "callee");
        Intrinsics.checkNotNullParameter(caller2, "caller");
        Intrinsics.checkNotNullParameter(context, "context");
        if (callee.isPrivate()) {
            if (callee instanceof Method || callee instanceof Field) {
                ClassFile callerClass = caller2 instanceof ClassFile ? (ClassFile)caller2 : caller2.getContainingClassFile();
                ClassFile calleeClass = callee.getContainingClassFile();
                return AccessibilityUtilKt.doClassesBelongToTheSameNestHost(callerClass, calleeClass, context) ? null : AccessType.PRIVATE;
            }
            if (!Intrinsics.areEqual(caller2.getContainingClassFile().getName(), callee.getContainingClassFile().getName())) {
                return AccessType.PRIVATE;
            }
        } else if (callee.isProtected()) {
            if (!Intrinsics.areEqual(caller2.getContainingClassFile().getPackageName(), callee.getContainingClassFile().getPackageName()) && !InheritanceUtilKt.isSubclassOf(context.getClassResolver(), caller2.getContainingClassFile(), callee.getContainingClassFile().getName())) {
                return AccessType.PROTECTED;
            }
        } else if (callee.isPackagePrivate() && !Intrinsics.areEqual(caller2.getContainingClassFile().getPackageName(), callee.getContainingClassFile().getPackageName())) {
            return AccessType.PACKAGE_PRIVATE;
        }
        return null;
    }

    private static final ClassFile getClassNestHost(ClassFile classFile, VerificationContext context) {
        String string2 = classFile.getNestHostClass();
        if (string2 == null) {
            return classFile;
        }
        String nestHostClassName = string2;
        return ResolutionUtilKt.resolveClassOrNull(context.getClassResolver(), nestHostClassName);
    }

    private static final boolean doClassesBelongToTheSameNestHost(ClassFile one, ClassFile two, VerificationContext context) {
        if (Intrinsics.areEqual(one.getName(), two.getName())) {
            return true;
        }
        ClassFile oneNestHost = AccessibilityUtilKt.getClassNestHost(one, context);
        ClassFile twoNestHost = AccessibilityUtilKt.getClassNestHost(two, context);
        return oneNestHost != null && twoNestHost != null && Intrinsics.areEqual(oneNestHost.getName(), twoNestHost.getName());
    }
}

