/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.verifiers;

import com.jetbrains.pluginverifier.verifiers.CodeAnalysis;
import com.jetbrains.pluginverifier.verifiers.CodeAnalysisUtilKt;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassFile;
import com.jetbrains.pluginverifier.verifiers.resolution.Field;
import com.jetbrains.pluginverifier.verifiers.resolution.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.SourceValue;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\b\u001a\u0004\u0018\u00010\t2\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000bH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\u0007J \u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017J.\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u00072\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\rJ.\u0010\u001a\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u00072\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000bH\u0002J8\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001d0\u000b0\u000b\"\u0004\b\u0000\u0010\u001d*\b\u0012\u0004\u0012\u0002H\u001d0\u000b2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u00020 0\u001fH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/pluginverifier/verifiers/CodeAnalysis;", "", "()V", "inVisitFields", "Ljava/util/Deque;", "Lcom/jetbrains/pluginverifier/verifiers/resolution/Field;", "inVisitMethods", "Lcom/jetbrains/pluginverifier/verifiers/resolution/Method;", "evaluateConcatenatedStringValue", "", "frames", "", "Lorg/objectweb/asm/tree/analysis/Frame;", "Lorg/objectweb/asm/tree/analysis/SourceValue;", "analyzedMethod", "stringBuildingInstructions", "Lorg/objectweb/asm/tree/AbstractInsnNode;", "evaluateConstantFieldValue", "field", "evaluateConstantFunctionValue", "method", "evaluateConstantString", "instructionIndex", "", "onStackIndex", "sourceValue", "evaluateInstructionConstantString", "instruction", "splitByPredicate", "T", "predicate", "Lkotlin/Function1;", "", "verifier-core"})
@SourceDebugExtension(value={"SMAP\nCodeAnalysisUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeAnalysisUtil.kt\ncom/jetbrains/pluginverifier/verifiers/CodeAnalysis\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,247:1\n378#2,7:248\n1747#2,3:255\n731#2,9:258\n1774#2,4:267\n1747#2,3:271\n1774#2,4:275\n378#2,7:279\n1#3:274\n*S KotlinDebug\n*F\n+ 1 CodeAnalysisUtil.kt\ncom/jetbrains/pluginverifier/verifiers/CodeAnalysis\n*L\n77#1:248,7\n114#1:255,3\n119#1:258,9\n127#1:267,4\n145#1:271,3\n162#1:275,4\n165#1:279,7\n*E\n"})
public final class CodeAnalysis {
    @NotNull
    private final Deque<Method> inVisitMethods = new LinkedList();
    @NotNull
    private final Deque<Field> inVisitFields = new LinkedList();

    @Nullable
    public final String evaluateConstantString(@NotNull Method analyzedMethod, int instructionIndex, int onStackIndex) {
        Intrinsics.checkNotNullParameter(analyzedMethod, "analyzedMethod");
        List<Frame<SourceValue>> list = CodeAnalysisUtilKt.analyzeMethodFrames(analyzedMethod);
        if (list == null) {
            return null;
        }
        List<Frame<SourceValue>> frames = list;
        Frame<SourceValue> frame = CollectionsKt.getOrNull(frames, instructionIndex);
        if (frame == null) {
            return null;
        }
        Frame<SourceValue> frame2 = frame;
        SourceValue sourceValue = CodeAnalysisUtilKt.getOnStack(frame2, onStackIndex);
        if (sourceValue == null) {
            return null;
        }
        SourceValue sourceValue2 = sourceValue;
        return this.evaluateConstantString(analyzedMethod, frames, sourceValue2);
    }

    @Nullable
    public final String evaluateConstantString(@NotNull Method analyzedMethod, @NotNull List<? extends Frame<SourceValue>> frames, @Nullable SourceValue sourceValue) {
        Intrinsics.checkNotNullParameter(analyzedMethod, "analyzedMethod");
        Intrinsics.checkNotNullParameter(frames, "frames");
        SourceValue sourceValue2 = sourceValue;
        Set<AbstractInsnNode> set = sourceValue2 != null ? sourceValue2.insns : null;
        if (set == null) {
            return null;
        }
        Set<AbstractInsnNode> sourceInstructions = set;
        if (sourceInstructions.size() == 1) {
            AbstractInsnNode producer = (AbstractInsnNode)CollectionsKt.first((Iterable)sourceInstructions);
            Intrinsics.checkNotNullExpressionValue(producer, "producer");
            return this.evaluateInstructionConstantString(producer, analyzedMethod, frames);
        }
        return null;
    }

    private final String evaluateInstructionConstantString(AbstractInsnNode instruction, Method analyzedMethod, List<? extends Frame<SourceValue>> frames) {
        AbstractInsnNode abstractInsnNode = instruction;
        if (abstractInsnNode instanceof LdcInsnNode) {
            if (((LdcInsnNode)instruction).cst instanceof String) {
                Object object = ((LdcInsnNode)instruction).cst;
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.String");
                return (String)object;
            }
        } else if (abstractInsnNode instanceof MethodInsnNode) {
            if (Intrinsics.areEqual(((MethodInsnNode)instruction).owner, "java/lang/StringBuilder") && Intrinsics.areEqual(((MethodInsnNode)instruction).name, "toString")) {
                int initIndex;
                int toStringIndex;
                List<AbstractInsnNode> instructions;
                block16: {
                    int n;
                    instructions = analyzedMethod.getInstructions();
                    toStringIndex = instructions.indexOf(instruction);
                    if (toStringIndex == -1) {
                        return null;
                    }
                    List $this$indexOfLast$iv = CollectionsKt.take((Iterable)instructions, toStringIndex);
                    boolean $i$f$indexOfLast = false;
                    ListIterator iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        AbstractInsnNode it = (AbstractInsnNode)iterator$iv.previous();
                        boolean bl = false;
                        if (!(it instanceof MethodInsnNode && Intrinsics.areEqual(((MethodInsnNode)it).name, "<init>") && Intrinsics.areEqual(((MethodInsnNode)it).owner, "java/lang/StringBuilder"))) continue;
                        n = iterator$iv.nextIndex();
                        break block16;
                    }
                    n = initIndex = -1;
                }
                if (initIndex == -1) {
                    return null;
                }
                List<AbstractInsnNode> stringBuildingInstructions = instructions.subList(initIndex + 1, toStringIndex);
                return this.evaluateConcatenatedStringValue(frames, analyzedMethod, stringBuildingInstructions);
            }
            if (Intrinsics.areEqual(((MethodInsnNode)instruction).owner, analyzedMethod.getContainingClassFile().getName())) {
                Method method;
                block17: {
                    Sequence<Method> sequence2 = analyzedMethod.getContainingClassFile().getMethods();
                    Iterator<Method> iterator2 = sequence2.iterator();
                    while (iterator2.hasNext()) {
                        Method method2;
                        Method it = method2 = iterator2.next();
                        boolean bl = false;
                        if (!(Intrinsics.areEqual(it.getName(), ((MethodInsnNode)instruction).name) && Intrinsics.areEqual(it.getDescriptor(), ((MethodInsnNode)instruction).desc))) continue;
                        method = method2;
                        break block17;
                    }
                    method = null;
                }
                Method selfMethod = method;
                if (selfMethod != null) {
                    boolean cantBeOverridden;
                    boolean bl = cantBeOverridden = selfMethod.isStatic() || selfMethod.isPrivate() || selfMethod.isFinal();
                    if (cantBeOverridden) {
                        return this.evaluateConstantFunctionValue(selfMethod);
                    }
                }
            }
        } else if (abstractInsnNode instanceof FieldInsnNode && Intrinsics.areEqual(((FieldInsnNode)instruction).owner, analyzedMethod.getContainingClassFile().getName())) {
            Field field;
            block18: {
                Sequence<Field> sequence3 = analyzedMethod.getContainingClassFile().getFields();
                Iterator<Field> iterator3 = sequence3.iterator();
                while (iterator3.hasNext()) {
                    Field field2;
                    Field it = field2 = iterator3.next();
                    boolean bl = false;
                    if (!(Intrinsics.areEqual(it.getName(), ((FieldInsnNode)instruction).name) && Intrinsics.areEqual(it.getDescriptor(), ((FieldInsnNode)instruction).desc))) continue;
                    field = field2;
                    break block18;
                }
                field = null;
            }
            Field field3 = field;
            if (field3 == null) {
                return null;
            }
            Field fieldNode = field3;
            return this.evaluateConstantFieldValue(fieldNode);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String evaluateConstantFunctionValue(@NotNull Method method) {
        Object it;
        boolean bl;
        block20: {
            Intrinsics.checkNotNullParameter(method, "method");
            if (method.isAbstract() || !Intrinsics.areEqual(method.getDescriptor(), "()Ljava/lang/String;")) {
                return null;
            }
            Iterable $this$any$iv = this.inVisitMethods;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (Method)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual(it.getName(), method.getName()) && Intrinsics.areEqual(it.getDescriptor(), method.getDescriptor()) && Intrinsics.areEqual(it.getContainingClassFile().getName(), method.getContainingClassFile().getName()))) continue;
                    bl = true;
                    break block20;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        this.inVisitMethods.addLast(method);
        try {
            String string2;
            int n;
            List instructions;
            List list;
            List<AbstractInsnNode> $this$dropLastWhile$iv = method.getInstructions();
            boolean $i$f$dropLastWhile2 = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator<AbstractInsnNode> iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    it = iterator$iv.previous();
                    boolean bl3 = false;
                    if (it instanceof LabelNode || it instanceof LineNumberNode) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                    break;
                }
            } else {
                list = instructions = CollectionsKt.emptyList();
            }
            if (instructions.isEmpty()) {
                $this$dropLastWhile$iv = null;
                return $this$dropLastWhile$iv;
            }
            AbstractInsnNode lastInstruction = (AbstractInsnNode)CollectionsKt.last(instructions);
            if (!(lastInstruction instanceof InsnNode) || ((InsnNode)lastInstruction).getOpcode() != 176) {
                String $i$f$dropLastWhile2 = null;
                return $i$f$dropLastWhile2;
            }
            Iterable $this$count$iv = instructions;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    AbstractInsnNode it2 = (AbstractInsnNode)element$iv;
                    boolean bl4 = false;
                    if (!(it2 instanceof InsnNode && 172 <= ((InsnNode)it2).getOpcode() && ((InsnNode)it2).getOpcode() <= 177) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            if (n > 1) {
                string2 = null;
                return string2;
            }
            string2 = this.evaluateConstantString(method, instructions.size() - 1, 0);
            return string2;
        }
        finally {
            this.inVisitMethods.removeLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String evaluateConstantFieldValue(Field field) {
        Object it;
        boolean bl;
        block22: {
            if (!(field.isStatic() && field.isFinal() && Intrinsics.areEqual(field.getDescriptor(), "Ljava/lang/String;"))) {
                return null;
            }
            if (field.getInitialValue() instanceof String) {
                Object object = field.getInitialValue();
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.String");
                return (String)object;
            }
            Iterable $this$any$iv = this.inVisitFields;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (Field)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual(it.getName(), field.getName()) && Intrinsics.areEqual(it.getDescriptor(), field.getDescriptor()) && Intrinsics.areEqual(it.getContainingClassFile().getName(), field.getContainingClassFile().getName()))) continue;
                    bl = true;
                    break block22;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        this.inVisitFields.addLast(field);
        try {
            Frame<SourceValue> frame;
            int putStaticInstructionIndex;
            List<Frame<SourceValue>> frames;
            Method classInitializer;
            block24: {
                int n;
                int n2;
                List<Frame<SourceValue>> list;
                Method method;
                Object v2;
                ClassFile classFile;
                block23: {
                    classFile = field.getContainingClassFile();
                    it = classFile.getMethods();
                    Iterator bl2 = it.iterator();
                    while (bl2.hasNext()) {
                        Object t2 = bl2.next();
                        Method it2 = (Method)t2;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual(it2.getName(), "<clinit>")) continue;
                        v2 = t2;
                        break block23;
                    }
                    v2 = null;
                }
                if ((Method)v2 == null) {
                    Object element$iv;
                    element$iv = null;
                    return element$iv;
                }
                classInitializer = method;
                if (CodeAnalysisUtilKt.analyzeMethodFrames(classInitializer) == null) {
                    it = null;
                    return it;
                }
                frames = list;
                List<AbstractInsnNode> instructions = classInitializer.getInstructions();
                Function1 predicate2 = new Function1<AbstractInsnNode, Boolean>(classFile, field){
                    final /* synthetic */ ClassFile $classFile;
                    final /* synthetic */ Field $field;
                    {
                        this.$classFile = $classFile;
                        this.$field = $field;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull AbstractInsnNode it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return it instanceof FieldInsnNode && ((FieldInsnNode)it).getOpcode() == 179 && Intrinsics.areEqual(((FieldInsnNode)it).owner, this.$classFile.getName()) && Intrinsics.areEqual(((FieldInsnNode)it).name, this.$field.getName()) && Intrinsics.areEqual(((FieldInsnNode)it).desc, this.$field.getDescriptor());
                    }
                };
                Iterable $this$count$iv = instructions;
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n2 = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        if (!((Boolean)predicate2.invoke(element$iv)).booleanValue() || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n2 = count$iv;
                }
                if (n2 != 1) {
                    $this$count$iv = null;
                    return $this$count$iv;
                }
                List<AbstractInsnNode> $this$indexOfLast$iv = instructions;
                boolean $i$f$indexOfLast = false;
                ListIterator<AbstractInsnNode> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
                while (iterator$iv.hasPrevious()) {
                    if (!((Boolean)predicate2.invoke(iterator$iv.previous())).booleanValue()) continue;
                    n = iterator$iv.nextIndex();
                    break block24;
                }
                n = putStaticInstructionIndex = -1;
            }
            if (CollectionsKt.getOrNull(frames, putStaticInstructionIndex) == null) {
                String string2 = null;
                return string2;
            }
            Frame<SourceValue> frame2 = frame;
            String string3 = this.evaluateConstantString(classInitializer, frames, CodeAnalysisUtilKt.getOnStack(frame2, 0));
            return string3;
        }
        finally {
            this.inVisitFields.removeLast();
        }
    }

    private final String evaluateConcatenatedStringValue(List<? extends Frame<SourceValue>> frames, Method analyzedMethod, List<? extends AbstractInsnNode> stringBuildingInstructions) {
        Function1 isAppendInstruction2 = evaluateConcatenatedStringValue.isAppendInstruction.1.INSTANCE;
        StringBuilder stringResult = new StringBuilder();
        List<List<? extends AbstractInsnNode>> nonAppendInstructionParts = this.splitByPredicate(stringBuildingInstructions, isAppendInstruction2);
        for (List<? extends AbstractInsnNode> appendInstructionsPart : nonAppendInstructionParts) {
            String string2;
            if (CodeAnalysis.evaluateConcatenatedStringValue$evaluateAppendInstructions(this, analyzedMethod, frames, appendInstructionsPart) == null) {
                return null;
            }
            stringResult.append(string2);
        }
        return stringResult.toString();
    }

    private final <T> List<List<T>> splitByPredicate(List<? extends T> $this$splitByPredicate, Function1<? super T, Boolean> predicate2) {
        ArrayList result2 = new ArrayList();
        ArrayList current = new ArrayList();
        for (T t2 : $this$splitByPredicate) {
            if (predicate2.invoke(t2).booleanValue()) {
                ((Collection)result2).add(CollectionsKt.toList(current));
                current.clear();
                continue;
            }
            ((Collection)current).add(t2);
        }
        return result2;
    }

    private static final String evaluateConcatenatedStringValue$evaluateAppendInstructions(CodeAnalysis this$0, Method $analyzedMethod, List<? extends Frame<SourceValue>> $frames, List<? extends AbstractInsnNode> instructions) {
        if (instructions.isEmpty()) {
            return null;
        }
        if (instructions.size() == 1) {
            AbstractInsnNode single2 = CollectionsKt.single(instructions);
            return this$0.evaluateInstructionConstantString(single2, $analyzedMethod, $frames);
        }
        if (instructions.size() == 2) {
            AbstractInsnNode first2 = CollectionsKt.first(instructions);
            AbstractInsnNode second2 = CollectionsKt.last(instructions);
            if (first2 instanceof VarInsnNode && ((VarInsnNode)first2).var == 0 && !$analyzedMethod.isStatic()) {
                return this$0.evaluateInstructionConstantString(second2, $analyzedMethod, $frames);
            }
        }
        return null;
    }
}

