/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.usages.properties;

import com.jetbrains.pluginverifier.results.reference.MethodReference;
import com.jetbrains.pluginverifier.usages.properties.AbstractPropertyUsageProcessor;
import com.jetbrains.pluginverifier.usages.properties.EnumPropertyUsageProcessor;
import com.jetbrains.pluginverifier.verifiers.BytecodeUtilKt;
import com.jetbrains.pluginverifier.verifiers.CodeAnalysis;
import com.jetbrains.pluginverifier.verifiers.VerificationContext;
import com.jetbrains.pluginverifier.verifiers.resolution.Method;
import com.jetbrains.pluginverifier.verifiers.resolution.MethodParameter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/pluginverifier/usages/properties/PropertyUsageProcessor;", "Lcom/jetbrains/pluginverifier/usages/properties/AbstractPropertyUsageProcessor;", "()V", "enumPropertyUsageProcessor", "Lcom/jetbrains/pluginverifier/usages/properties/EnumPropertyUsageProcessor;", "processMethodInvocation", "", "methodReference", "Lcom/jetbrains/pluginverifier/results/reference/MethodReference;", "resolvedMethod", "Lcom/jetbrains/pluginverifier/verifiers/resolution/Method;", "instructionNode", "Lorg/objectweb/asm/tree/AbstractInsnNode;", "callerMethod", "context", "Lcom/jetbrains/pluginverifier/verifiers/VerificationContext;", "verifier-intellij"})
@SourceDebugExtension(value={"SMAP\nPropertyUsageProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertyUsageProcessor.kt\ncom/jetbrains/pluginverifier/usages/properties/PropertyUsageProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n1747#2,3:55\n*S KotlinDebug\n*F\n+ 1 PropertyUsageProcessor.kt\ncom/jetbrains/pluginverifier/usages/properties/PropertyUsageProcessor\n*L\n31#1:55,3\n*E\n"})
public final class PropertyUsageProcessor
extends AbstractPropertyUsageProcessor {
    @NotNull
    private final EnumPropertyUsageProcessor enumPropertyUsageProcessor = new EnumPropertyUsageProcessor();

    @Override
    public void processMethodInvocation(@NotNull MethodReference methodReference, @NotNull Method resolvedMethod, @NotNull AbstractInsnNode instructionNode, @NotNull Method callerMethod, @NotNull VerificationContext context) {
        boolean bl;
        List<MethodParameter> methodParameters;
        block6: {
            Intrinsics.checkNotNullParameter(methodReference, "methodReference");
            Intrinsics.checkNotNullParameter(resolvedMethod, "resolvedMethod");
            Intrinsics.checkNotNullParameter(instructionNode, "instructionNode");
            Intrinsics.checkNotNullParameter(callerMethod, "callerMethod");
            Intrinsics.checkNotNullParameter(context, "context");
            if (this.enumPropertyUsageProcessor.supports(resolvedMethod)) {
                this.enumPropertyUsageProcessor.processMethodInvocation(methodReference, resolvedMethod, instructionNode, callerMethod, context);
                return;
            }
            methodParameters = resolvedMethod.getMethodParameters();
            Iterable $this$any$iv = methodParameters;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    MethodParameter it = (MethodParameter)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.contains((CharSequence)it.getName(), "default", true)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        Iterator<MethodParameter> iterator2 = methodParameters.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int onStackIndex;
            String resourceBundleName;
            AnnotationNode propertyKeyAnnotation;
            Object object;
            int parameterIndex = n++;
            MethodParameter methodParameter = iterator2.next();
            if (BytecodeUtilKt.findAnnotation(methodParameter.getAnnotations(), "org/jetbrains/annotations/PropertyKey") == null || ((object = BytecodeUtilKt.getAnnotationValue(propertyKeyAnnotation, "resourceBundle")) instanceof String ? (String)object : null) == null) continue;
            resourceBundleName = resourceBundleName;
            List<AbstractInsnNode> instructions = callerMethod.getInstructions();
            int instructionIndex = instructions.indexOf(instructionNode);
            String propertyKey = new CodeAnalysis().evaluateConstantString(callerMethod, instructionIndex, onStackIndex = methodParameters.size() - 1 - parameterIndex);
            if (propertyKey == null) continue;
            this.checkProperty(resourceBundleName, propertyKey, context, callerMethod.getLocation());
        }
    }
}

