/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.tasks.checkPlugin;

import com.jetbrains.pluginverifier.PluginVerificationDescriptor;
import com.jetbrains.pluginverifier.PluginVerificationTarget;
import com.jetbrains.pluginverifier.dependencies.resolution.CompositeDependencyFinder;
import com.jetbrains.pluginverifier.dependencies.resolution.DependencyFinder;
import com.jetbrains.pluginverifier.dependencies.resolution.IdeDependencyFinderKt;
import com.jetbrains.pluginverifier.dependencies.resolution.LastVersionSelector;
import com.jetbrains.pluginverifier.dependencies.resolution.RepositoryDependencyFinder;
import com.jetbrains.pluginverifier.filtering.ProblemsFilter;
import com.jetbrains.pluginverifier.ide.IdeDescriptor;
import com.jetbrains.pluginverifier.options.CmdOpts;
import com.jetbrains.pluginverifier.options.OptionsParser;
import com.jetbrains.pluginverifier.options.PluginParsingConfiguration;
import com.jetbrains.pluginverifier.options.PluginsParsing;
import com.jetbrains.pluginverifier.options.PluginsSet;
import com.jetbrains.pluginverifier.plugin.PluginDetailsCache;
import com.jetbrains.pluginverifier.reporting.PluginVerificationReportage;
import com.jetbrains.pluginverifier.repository.PluginInfo;
import com.jetbrains.pluginverifier.repository.PluginRepository;
import com.jetbrains.pluginverifier.repository.repositories.local.LocalPluginRepository;
import com.jetbrains.pluginverifier.resolution.DefaultClassResolverProvider;
import com.jetbrains.pluginverifier.tasks.TaskParametersBuilder;
import com.jetbrains.pluginverifier.tasks.checkPlugin.CheckPluginParams;
import com.jetbrains.pluginverifier.tasks.checkPlugin.DefaultIdeDescriptorParser;
import com.jetbrains.pluginverifier.tasks.checkPlugin.IdeDescriptorParser;
import com.jetbrains.pluginverifier.tasks.checkPlugin.InternalApiVerificationMode;
import com.jetbrains.pluginverifier.verifiers.packages.PackageFilter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/pluginverifier/tasks/checkPlugin/CheckPluginParamsBuilder;", "Lcom/jetbrains/pluginverifier/tasks/TaskParametersBuilder;", "pluginRepository", "Lcom/jetbrains/pluginverifier/repository/PluginRepository;", "reportage", "Lcom/jetbrains/pluginverifier/reporting/PluginVerificationReportage;", "pluginDetailsCache", "Lcom/jetbrains/pluginverifier/plugin/PluginDetailsCache;", "ideDescriptorParser", "Lcom/jetbrains/pluginverifier/tasks/checkPlugin/IdeDescriptorParser;", "(Lcom/jetbrains/pluginverifier/repository/PluginRepository;Lcom/jetbrains/pluginverifier/reporting/PluginVerificationReportage;Lcom/jetbrains/pluginverifier/plugin/PluginDetailsCache;Lcom/jetbrains/pluginverifier/tasks/checkPlugin/IdeDescriptorParser;)V", "getPluginDetailsCache", "()Lcom/jetbrains/pluginverifier/plugin/PluginDetailsCache;", "getPluginRepository", "()Lcom/jetbrains/pluginverifier/repository/PluginRepository;", "getReportage", "()Lcom/jetbrains/pluginverifier/reporting/PluginVerificationReportage;", "build", "Lcom/jetbrains/pluginverifier/tasks/checkPlugin/CheckPluginParams;", "opts", "Lcom/jetbrains/pluginverifier/options/CmdOpts;", "freeArgs", "", "", "createDependencyFinder", "Lcom/jetbrains/pluginverifier/dependencies/resolution/DependencyFinder;", "localRepository", "Lcom/jetbrains/pluginverifier/repository/repositories/local/LocalPluginRepository;", "ideDescriptor", "Lcom/jetbrains/pluginverifier/ide/IdeDescriptor;", "verifier-cli"})
@SourceDebugExtension(value={"SMAP\nCheckPluginParamsBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckPluginParamsBuilder.kt\ncom/jetbrains/pluginverifier/tasks/checkPlugin/CheckPluginParamsBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,127:1\n1549#2:128\n1620#2,3:129\n1360#2:132\n1446#2,2:133\n1549#2:135\n1620#2,3:136\n1448#2,3:139\n1549#2:142\n1620#2,3:143\n1855#2,2:147\n215#3:146\n216#3:149\n*S KotlinDebug\n*F\n+ 1 CheckPluginParamsBuilder.kt\ncom/jetbrains/pluginverifier/tasks/checkPlugin/CheckPluginParamsBuilder\n*L\n46#1:128\n46#1:129,3\n68#1:132\n68#1:133,2\n76#1:135\n76#1:136,3\n68#1:139,3\n81#1:142\n81#1:143,3\n86#1:147,2\n85#1:146\n85#1:149\n*E\n"})
public final class CheckPluginParamsBuilder
implements TaskParametersBuilder {
    @NotNull
    private final PluginRepository pluginRepository;
    @NotNull
    private final PluginVerificationReportage reportage;
    @NotNull
    private final PluginDetailsCache pluginDetailsCache;
    @NotNull
    private final IdeDescriptorParser ideDescriptorParser;

    public CheckPluginParamsBuilder(@NotNull PluginRepository pluginRepository, @NotNull PluginVerificationReportage reportage, @NotNull PluginDetailsCache pluginDetailsCache, @NotNull IdeDescriptorParser ideDescriptorParser) {
        Intrinsics.checkNotNullParameter(pluginRepository, "pluginRepository");
        Intrinsics.checkNotNullParameter(reportage, "reportage");
        Intrinsics.checkNotNullParameter(pluginDetailsCache, "pluginDetailsCache");
        Intrinsics.checkNotNullParameter(ideDescriptorParser, "ideDescriptorParser");
        this.pluginRepository = pluginRepository;
        this.reportage = reportage;
        this.pluginDetailsCache = pluginDetailsCache;
        this.ideDescriptorParser = ideDescriptorParser;
    }

    public /* synthetic */ CheckPluginParamsBuilder(PluginRepository pluginRepository, PluginVerificationReportage pluginVerificationReportage, PluginDetailsCache pluginDetailsCache, IdeDescriptorParser ideDescriptorParser, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 8) != 0) {
            ideDescriptorParser = new DefaultIdeDescriptorParser(pluginVerificationReportage);
        }
        this(pluginRepository, pluginVerificationReportage, pluginDetailsCache, ideDescriptorParser);
    }

    @NotNull
    public final PluginRepository getPluginRepository() {
        return this.pluginRepository;
    }

    @NotNull
    public final PluginVerificationReportage getReportage() {
        return this.reportage;
    }

    @NotNull
    public final PluginDetailsCache getPluginDetailsCache() {
        return this.pluginDetailsCache;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CheckPluginParams build(@NotNull CmdOpts opts, @NotNull List<String> freeArgs) {
        void $this$mapTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(opts, "opts");
        Intrinsics.checkNotNullParameter(freeArgs, "freeArgs");
        InternalApiVerificationMode internalApiVerificationMode = OptionsParser.INSTANCE.parseInternalApiVerificationMode(opts);
        if (!(freeArgs.size() > 1)) {
            boolean $i$a$-require-CheckPluginParamsBuilder$build$22 = false;
            String $i$a$-require-CheckPluginParamsBuilder$build$22 = "You must specify plugin to check and IDE(s), example:\njava -jar verifier.jar check-plugin ~/work/myPlugin/myPlugin.zip ~/EAPs/idea-IU-117.963\njava -jar verifier.jar check-plugin #14986 ~/EAPs/idea-IU-117.963";
            throw new IllegalArgumentException($i$a$-require-CheckPluginParamsBuilder$build$22.toString());
        }
        List<IdeDescriptor> ideDescriptors = this.ideDescriptorParser.parseIdeDescriptors(opts, freeArgs);
        Iterable $this$map$iv = ideDescriptors;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            IdeDescriptor ideDescriptor = (IdeDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getIdeVersion());
        }
        List ideVersions = (List)destination$iv$iv;
        PluginParsingConfiguration pluginParsingConfiguration = OptionsParser.INSTANCE.createPluginParsingConfiguration(opts);
        PluginsSet pluginsSet = new PluginsSet(null, null, 3, null);
        PluginsParsing pluginsParsing = new PluginsParsing(this.pluginRepository, this.reportage, pluginsSet, pluginParsingConfiguration);
        String pluginToTestArg = freeArgs.get(0);
        if (StringsKt.startsWith$default(pluginToTestArg, "@", false, 2, null)) {
            Path path = Paths.get(StringsKt.substringAfter$default(pluginToTestArg, "@", null, 2, null), new String[0]);
            Intrinsics.checkNotNullExpressionValue(path, "get(pluginToTestArg.substringAfter(\"@\"))");
            pluginsParsing.addPluginsListedInFile(path, ideVersions);
        } else {
            Path path = Paths.get("", new String[0]);
            Intrinsics.checkNotNullExpressionValue(path, "get(\"\")");
            pluginsParsing.addPluginBySpec(pluginToTestArg, path, ideVersions);
        }
        PackageFilter externalClassesPackageFilter = OptionsParser.INSTANCE.getExternalClassesPackageFilter(opts);
        List<ProblemsFilter> problemsFilters = OptionsParser.INSTANCE.getProblemsFilters(opts);
        Iterable $this$flatMap$iv = ideDescriptors;
        boolean $i$f$flatMap = false;
        Iterable iterable2 = $this$flatMap$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv3;
            IdeDescriptor ideDescriptor = (IdeDescriptor)element$iv$iv;
            boolean bl = false;
            DependencyFinder dependencyFinder = this.createDependencyFinder(pluginsSet.getLocalRepository(), ideDescriptor, this.pluginDetailsCache);
            DefaultClassResolverProvider classResolverProvider = new DefaultClassResolverProvider(dependencyFinder, ideDescriptor, externalClassesPackageFilter, null, null, 24, null);
            Iterable $this$map$iv2 = pluginsSet.getPluginsToCheck();
            boolean $i$f$map2 = false;
            Iterable iterable3 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it;
                PluginInfo pluginInfo = (PluginInfo)item$iv$iv;
                Collection collection2 = destination$iv$iv3;
                boolean bl2 = false;
                collection2.add(new PluginVerificationDescriptor.IDE(ideDescriptor, classResolverProvider, (PluginInfo)it));
            }
            Iterable list$iv$iv = (List)destination$iv$iv3;
            CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
        }
        List verificationDescriptors = (List)destination$iv$iv2;
        Iterable $this$map$iv3 = ideDescriptors;
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IdeDescriptor bl = (IdeDescriptor)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl3 = false;
            collection.add(new PluginVerificationTarget.IDE(it.getIdeVersion(), it.getJdkVersion()));
        }
        List verificationTargets = (List)destination$iv$iv4;
        Map<PluginInfo, String> $this$forEach$iv = pluginsSet.getIgnoredPlugins();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<PluginInfo, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<PluginInfo, String> element$iv;
            Map.Entry<PluginInfo, String> entry = element$iv = iterator2.next();
            boolean bl = false;
            PluginInfo plugin = entry.getKey();
            String reason = entry.getValue();
            Iterable $this$forEach$iv2 = verificationTargets;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                PluginVerificationTarget.IDE verificationTarget = (PluginVerificationTarget.IDE)element$iv2;
                boolean bl4 = false;
                this.reportage.logPluginVerificationIgnored(plugin, verificationTarget, reason);
            }
        }
        return new CheckPluginParams(ideDescriptors, problemsFilters, verificationDescriptors, pluginsSet.getInvalidPluginFiles(), opts.getExcludeExternalBuildClassesSelector(), internalApiVerificationMode, null, 64, null);
    }

    private final DependencyFinder createDependencyFinder(LocalPluginRepository localRepository, IdeDescriptor ideDescriptor, PluginDetailsCache pluginDetailsCache) {
        RepositoryDependencyFinder localFinder = new RepositoryDependencyFinder(localRepository, new LastVersionSelector(), pluginDetailsCache);
        DependencyFinder ideDependencyFinder = IdeDependencyFinderKt.createIdeBundledOrPluginRepositoryDependencyFinder(ideDescriptor.getIde(), this.pluginRepository, pluginDetailsCache);
        DependencyFinder[] dependencyFinderArray = new DependencyFinder[]{localFinder, ideDependencyFinder};
        return new CompositeDependencyFinder(CollectionsKt.listOf(dependencyFinderArray));
    }
}

