/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.results.reference;

import com.jetbrains.pluginverifier.results.presentation.FieldTypeOption;
import com.jetbrains.pluginverifier.results.presentation.HostClassOption;
import com.jetbrains.pluginverifier.results.presentation.ReferencesPresentationKt;
import com.jetbrains.pluginverifier.results.reference.ClassReference;
import com.jetbrains.pluginverifier.results.reference.SymbolicReference;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0010\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00072\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/pluginverifier/results/reference/FieldReference;", "Lcom/jetbrains/pluginverifier/results/reference/SymbolicReference;", "hostClass", "", "fieldName", "fieldDescriptor", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "Lcom/jetbrains/pluginverifier/results/reference/ClassReference;", "(Lcom/jetbrains/pluginverifier/results/reference/ClassReference;Ljava/lang/String;Ljava/lang/String;)V", "getFieldDescriptor", "()Ljava/lang/String;", "getFieldName", "getHostClass", "()Lcom/jetbrains/pluginverifier/results/reference/ClassReference;", "presentableLocation", "getPresentableLocation", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "verifier-core"})
public final class FieldReference
extends SymbolicReference {
    @NotNull
    private final ClassReference hostClass;
    @NotNull
    private final String fieldName;
    @NotNull
    private final String fieldDescriptor;

    public FieldReference(@NotNull ClassReference hostClass, @NotNull String fieldName, @NotNull String fieldDescriptor) {
        Intrinsics.checkNotNullParameter(hostClass, "hostClass");
        Intrinsics.checkNotNullParameter(fieldName, "fieldName");
        Intrinsics.checkNotNullParameter(fieldDescriptor, "fieldDescriptor");
        super(null);
        this.hostClass = hostClass;
        this.fieldName = fieldName;
        this.fieldDescriptor = fieldDescriptor;
    }

    @NotNull
    public final ClassReference getHostClass() {
        return this.hostClass;
    }

    @NotNull
    public final String getFieldName() {
        return this.fieldName;
    }

    @NotNull
    public final String getFieldDescriptor() {
        return this.fieldDescriptor;
    }

    public FieldReference(@NotNull String hostClass, @NotNull String fieldName, @NotNull String fieldDescriptor) {
        Intrinsics.checkNotNullParameter(hostClass, "hostClass");
        Intrinsics.checkNotNullParameter(fieldName, "fieldName");
        Intrinsics.checkNotNullParameter(fieldDescriptor, "fieldDescriptor");
        this(new ClassReference(hostClass), fieldName, fieldDescriptor);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof FieldReference && Intrinsics.areEqual(this.fieldName, ((FieldReference)other).fieldName) && Intrinsics.areEqual(this.fieldDescriptor, ((FieldReference)other).fieldDescriptor);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.hostClass, this.fieldName, this.fieldDescriptor};
        return Objects.hash(objectArray);
    }

    @Override
    @NotNull
    public String getPresentableLocation() {
        return ReferencesPresentationKt.formatFieldReference(this, HostClassOption.FULL_HOST_NAME, FieldTypeOption.SIMPLE_TYPE);
    }

    @NotNull
    public final ClassReference component1() {
        return this.hostClass;
    }

    @NotNull
    public final String component2() {
        return this.fieldName;
    }

    @NotNull
    public final String component3() {
        return this.fieldDescriptor;
    }

    @NotNull
    public final FieldReference copy(@NotNull ClassReference hostClass, @NotNull String fieldName, @NotNull String fieldDescriptor) {
        Intrinsics.checkNotNullParameter(hostClass, "hostClass");
        Intrinsics.checkNotNullParameter(fieldName, "fieldName");
        Intrinsics.checkNotNullParameter(fieldDescriptor, "fieldDescriptor");
        return new FieldReference(hostClass, fieldName, fieldDescriptor);
    }

    public static /* synthetic */ FieldReference copy$default(FieldReference fieldReference, ClassReference classReference, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            classReference = fieldReference.hostClass;
        }
        if ((n & 2) != 0) {
            string2 = fieldReference.fieldName;
        }
        if ((n & 4) != 0) {
            string3 = fieldReference.fieldDescriptor;
        }
        return fieldReference.copy(classReference, string2, string3);
    }
}

