/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.results.problems;

import com.jetbrains.plugin.structure.base.utils.FormatUtilsKt;
import com.jetbrains.pluginverifier.results.access.AccessType;
import com.jetbrains.pluginverifier.results.location.ClassLocation;
import com.jetbrains.pluginverifier.results.location.Location;
import com.jetbrains.pluginverifier.results.modifiers.Modifiers;
import com.jetbrains.pluginverifier.results.problems.CompatibilityProblem;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/pluginverifier/results/problems/IllegalClassAccessProblem;", "Lcom/jetbrains/pluginverifier/results/problems/CompatibilityProblem;", "unavailableClass", "Lcom/jetbrains/pluginverifier/results/location/ClassLocation;", "access", "Lcom/jetbrains/pluginverifier/results/access/AccessType;", "usage", "Lcom/jetbrains/pluginverifier/results/location/Location;", "(Lcom/jetbrains/pluginverifier/results/location/ClassLocation;Lcom/jetbrains/pluginverifier/results/access/AccessType;Lcom/jetbrains/pluginverifier/results/location/Location;)V", "getAccess", "()Lcom/jetbrains/pluginverifier/results/access/AccessType;", "fullDescription", "", "getFullDescription", "()Ljava/lang/String;", "problemType", "getProblemType", "shortDescription", "getShortDescription", "getUnavailableClass", "()Lcom/jetbrains/pluginverifier/results/location/ClassLocation;", "getUsage", "()Lcom/jetbrains/pluginverifier/results/location/Location;", "equals", "", "other", "", "hashCode", "", "verifier-core"})
public final class IllegalClassAccessProblem
extends CompatibilityProblem {
    @NotNull
    private final ClassLocation unavailableClass;
    @NotNull
    private final AccessType access;
    @NotNull
    private final Location usage;

    public IllegalClassAccessProblem(@NotNull ClassLocation unavailableClass, @NotNull AccessType access, @NotNull Location usage2) {
        Intrinsics.checkNotNullParameter(unavailableClass, "unavailableClass");
        Intrinsics.checkNotNullParameter((Object)access, "access");
        Intrinsics.checkNotNullParameter(usage2, "usage");
        this.unavailableClass = unavailableClass;
        this.access = access;
        this.usage = usage2;
    }

    @NotNull
    public final ClassLocation getUnavailableClass() {
        return this.unavailableClass;
    }

    @NotNull
    public final AccessType getAccess() {
        return this.access;
    }

    @NotNull
    public final Location getUsage() {
        return this.usage;
    }

    @Override
    @NotNull
    public String getProblemType() {
        return "Illegal class access";
    }

    @Override
    @NotNull
    public String getShortDescription() {
        Object[] objectArray = new Object[]{this.access, this.unavailableClass};
        return FormatUtilsKt.formatMessage("Illegal access to {0} class {1}", objectArray);
    }

    @Override
    @NotNull
    public String getFullDescription() {
        String type2 = this.unavailableClass.getModifiers().contains(Modifiers.Modifier.INTERFACE) ? "interface" : "class";
        Object[] objectArray = new Object[]{StringsKt.capitalize(this.access.toString()), type2, this.unavailableClass, this.usage};
        return FormatUtilsKt.formatMessage("{0} {1} {2} is not available at {3}. This can lead to **IllegalAccessError** exception at runtime.", objectArray);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof IllegalClassAccessProblem && Intrinsics.areEqual(this.unavailableClass, ((IllegalClassAccessProblem)other).unavailableClass) && this.access == ((IllegalClassAccessProblem)other).access && Intrinsics.areEqual(this.usage, ((IllegalClassAccessProblem)other).usage);
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{this.unavailableClass, this.access, this.usage};
        return Objects.hash(objectArray);
    }
}

