/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.resolution;

import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.classes.resolvers.CompositeResolver;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.plugin.structure.ide.ProductInfoBasedIde;
import com.jetbrains.plugin.structure.ide.classes.resolver.PluginDependencyFilteredResolver;
import com.jetbrains.plugin.structure.ide.classes.resolver.ProductInfoClassResolver;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.pluginverifier.PluginVerifierKt;
import com.jetbrains.pluginverifier.analysis.LegacyPluginAnalysis;
import com.jetbrains.pluginverifier.dependencies.DependenciesGraph;
import com.jetbrains.pluginverifier.dependencies.DependenciesGraphBuilder;
import com.jetbrains.pluginverifier.dependencies.resolution.DependencyFinder;
import com.jetbrains.pluginverifier.ide.IdeDescriptor;
import com.jetbrains.pluginverifier.plugin.PluginDetails;
import com.jetbrains.pluginverifier.plugin.PluginDetailsCache;
import com.jetbrains.pluginverifier.repository.repositories.bundled.BundledPluginInfo;
import com.jetbrains.pluginverifier.resolution.BundledPluginClassResolverProvider;
import com.jetbrains.pluginverifier.resolution.ClassResolverProvider;
import com.jetbrains.pluginverifier.resolution.DefaultPluginDetailsBasedResolverProvider;
import com.jetbrains.pluginverifier.resolution.PluginDetailsBasedResolverProvider;
import com.jetbrains.pluginverifier.verifiers.packages.PackageFilter;
import com.jetbrains.pluginverifier.verifiers.resolution.ResolutionUtilKt;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\tH\u0002J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u0014H\u0016J\b\u0010\u001f\u001a\u00020\u0007H\u0016J9\u0010 \u001a\b\u0012\u0004\u0012\u0002H!0\t\"\u0004\b\u0000\u0010\"\"\u0004\b\u0001\u0010!*\b\u0012\u0004\u0012\u0002H\"0#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u0002H\"\u0012\u0004\u0012\u0002H!0%H\u0082\bR\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/jetbrains/pluginverifier/resolution/DefaultClassResolverProvider;", "Lcom/jetbrains/pluginverifier/resolution/ClassResolverProvider;", "dependencyFinder", "Lcom/jetbrains/pluginverifier/dependencies/resolution/DependencyFinder;", "ideDescriptor", "Lcom/jetbrains/pluginverifier/ide/IdeDescriptor;", "externalClassesPackageFilter", "Lcom/jetbrains/pluginverifier/verifiers/packages/PackageFilter;", "additionalClassResolvers", "", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "pluginDetailsBasedResolverProvider", "Lcom/jetbrains/pluginverifier/resolution/PluginDetailsBasedResolverProvider;", "(Lcom/jetbrains/pluginverifier/dependencies/resolution/DependencyFinder;Lcom/jetbrains/pluginverifier/ide/IdeDescriptor;Lcom/jetbrains/pluginverifier/verifiers/packages/PackageFilter;Ljava/util/List;Lcom/jetbrains/pluginverifier/resolution/PluginDetailsBasedResolverProvider;)V", "bundledPluginClassResolverProvider", "Lcom/jetbrains/pluginverifier/resolution/BundledPluginClassResolverProvider;", "legacyPluginAnalysis", "Lcom/jetbrains/pluginverifier/analysis/LegacyPluginAnalysis;", "createBundledPluginResolver", "pluginDependency", "Lcom/jetbrains/pluginverifier/plugin/PluginDetails;", "createDependenciesClassResolver", "checkedPluginDetails", "dependencies", "Lcom/jetbrains/pluginverifier/dependencies/resolution/DependencyFinder$Result;", "createPluginResolver", "getIdeResolver", "plugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "provide", "Lcom/jetbrains/pluginverifier/resolution/ClassResolverProvider$Result;", "provideExternalClassesPackageFilter", "mapNotNullInterruptible", "R", "T", "", "transform", "Lkotlin/Function1;", "verifier-intellij"})
@SourceDebugExtension(value={"SMAP\nDefaultClassResolverProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultClassResolverProvider.kt\ncom/jetbrains/pluginverifier/resolution/DefaultClassResolverProvider\n+ 2 LanguageUtils.kt\ncom/jetbrains/plugin/structure/base/utils/LanguageUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n106#1:155\n107#1,5:166\n79#2,4:116\n83#2:122\n79#2,2:123\n81#2,2:174\n83#2:178\n1855#3,2:120\n800#3,11:125\n1549#3:136\n1620#3,3:137\n800#3,11:140\n1549#3:151\n1620#3,3:152\n1603#3,9:156\n1855#3:165\n1856#3:172\n1612#3:173\n1855#3,2:176\n1603#3,9:179\n1855#3:188\n1856#3:190\n1612#3:191\n1#4:171\n1#4:189\n*S KotlinDebug\n*F\n+ 1 DefaultClassResolverProvider.kt\ncom/jetbrains/pluginverifier/resolution/DefaultClassResolverProvider\n*L\n99#1:155\n99#1:166,5\n41#1:116,4\n41#1:122\n92#1:123,2\n92#1:174,2\n92#1:178\n41#1:120,2\n94#1:125,11\n95#1:136\n95#1:137,3\n96#1:140,11\n97#1:151\n97#1:152,3\n99#1:156,9\n99#1:165\n99#1:172\n99#1:173\n92#1:176,2\n106#1:179,9\n106#1:188\n106#1:190\n106#1:191\n99#1:171\n106#1:189\n*E\n"})
public final class DefaultClassResolverProvider
implements ClassResolverProvider {
    @NotNull
    private final DependencyFinder dependencyFinder;
    @NotNull
    private final IdeDescriptor ideDescriptor;
    @NotNull
    private final PackageFilter externalClassesPackageFilter;
    @NotNull
    private final List<Resolver> additionalClassResolvers;
    @NotNull
    private final PluginDetailsBasedResolverProvider pluginDetailsBasedResolverProvider;
    @NotNull
    private final BundledPluginClassResolverProvider bundledPluginClassResolverProvider;
    @NotNull
    private final LegacyPluginAnalysis legacyPluginAnalysis;

    public DefaultClassResolverProvider(@NotNull DependencyFinder dependencyFinder, @NotNull IdeDescriptor ideDescriptor, @NotNull PackageFilter externalClassesPackageFilter, @NotNull List<? extends Resolver> additionalClassResolvers, @NotNull PluginDetailsBasedResolverProvider pluginDetailsBasedResolverProvider) {
        Intrinsics.checkNotNullParameter(dependencyFinder, "dependencyFinder");
        Intrinsics.checkNotNullParameter(ideDescriptor, "ideDescriptor");
        Intrinsics.checkNotNullParameter(externalClassesPackageFilter, "externalClassesPackageFilter");
        Intrinsics.checkNotNullParameter(additionalClassResolvers, "additionalClassResolvers");
        Intrinsics.checkNotNullParameter(pluginDetailsBasedResolverProvider, "pluginDetailsBasedResolverProvider");
        this.dependencyFinder = dependencyFinder;
        this.ideDescriptor = ideDescriptor;
        this.externalClassesPackageFilter = externalClassesPackageFilter;
        this.additionalClassResolvers = additionalClassResolvers;
        this.pluginDetailsBasedResolverProvider = pluginDetailsBasedResolverProvider;
        this.bundledPluginClassResolverProvider = new BundledPluginClassResolverProvider();
        this.legacyPluginAnalysis = new LegacyPluginAnalysis();
    }

    public /* synthetic */ DefaultClassResolverProvider(DependencyFinder dependencyFinder, IdeDescriptor ideDescriptor, PackageFilter packageFilter, List list, PluginDetailsBasedResolverProvider pluginDetailsBasedResolverProvider, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            pluginDetailsBasedResolverProvider = new DefaultPluginDetailsBasedResolverProvider();
        }
        this(dependencyFinder, ideDescriptor, packageFilter, list, pluginDetailsBasedResolverProvider);
    }

    @Override
    @NotNull
    public ClassResolverProvider.Result provide(@NotNull PluginDetails checkedPluginDetails) {
        Intrinsics.checkNotNullParameter(checkedPluginDetails, "checkedPluginDetails");
        ArrayList closeableResources = new ArrayList();
        List $this$closeOnException$iv = closeableResources;
        boolean $i$f$closeOnException = false;
        try {
            List it = $this$closeOnException$iv;
            boolean bl = false;
            Resolver pluginResolver = PluginVerifierKt.createPluginResolver(checkedPluginDetails.getPluginClassesLocations());
            Pair<DependenciesGraph, List<DependencyFinder.Result>> pair = new DependenciesGraphBuilder(this.dependencyFinder).buildDependenciesGraph(checkedPluginDetails.getIdePlugin(), this.ideDescriptor.getIde());
            DependenciesGraph dependenciesGraph = pair.component1();
            List<DependencyFinder.Result> dependenciesResults = pair.component2();
            CollectionsKt.addAll((Collection)closeableResources, (Iterable)dependenciesResults);
            Resolver dependenciesClassResolver = this.createDependenciesClassResolver(checkedPluginDetails, dependenciesResults);
            Resolver[] resolverArray = new Resolver[]{pluginResolver, this.ideDescriptor.getJdkDescriptor().getJdkResolver(), this.getIdeResolver(checkedPluginDetails.getIdePlugin(), this.ideDescriptor), dependenciesClassResolver};
            List resolvers = CollectionsKt.plus((Collection)CollectionsKt.listOf(resolverArray), (Iterable)this.additionalClassResolvers);
            Resolver resolver = ResolutionUtilKt.caching(CompositeResolver.Companion.create(resolvers));
            return new ClassResolverProvider.Result(pluginResolver, resolver, dependenciesGraph, closeableResources);
        }
        catch (Throwable e$iv) {
            Iterable $this$forEach$iv$iv = $this$closeOnException$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                Closeable t$iv = (Closeable)element$iv$iv;
                boolean bl = false;
                Closeable closeable = t$iv;
                if (closeable == null) continue;
                LanguageUtilsKt.closeLogged(closeable);
            }
            throw e$iv;
        }
    }

    @Override
    @NotNull
    public PackageFilter provideExternalClassesPackageFilter() {
        return this.externalClassesPackageFilter;
    }

    private final Resolver getIdeResolver(IdePlugin plugin, IdeDescriptor ideDescriptor) {
        return ideDescriptor.getIde() instanceof ProductInfoBasedIde && ideDescriptor.getIdeResolver() instanceof ProductInfoClassResolver && !this.legacyPluginAnalysis.isLegacyPlugin(plugin) ? (Resolver)new PluginDependencyFilteredResolver(plugin, (ProductInfoClassResolver)ideDescriptor.getIdeResolver(), null, 4, null) : ideDescriptor.getIdeResolver();
    }

    private final Resolver createPluginResolver(PluginDetails pluginDependency) {
        Resolver resolver;
        if (pluginDependency.getPluginInfo() instanceof BundledPluginInfo) {
            resolver = this.createBundledPluginResolver(pluginDependency);
            if (resolver == null) {
                resolver = this.bundledPluginClassResolverProvider.getResolver(pluginDependency);
            }
        } else {
            resolver = this.pluginDetailsBasedResolverProvider.getPluginResolver(pluginDependency);
        }
        return resolver;
    }

    private final Resolver createBundledPluginResolver(PluginDetails pluginDependency) {
        return this.ideDescriptor.getIde() instanceof ProductInfoBasedIde && this.ideDescriptor.getIdeResolver() instanceof ProductInfoClassResolver ? (Resolver)((ProductInfoClassResolver)this.ideDescriptor.getIdeResolver()).getLayoutComponentResolver(pluginDependency.getPluginInfo().getPluginId()) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final Resolver createDependenciesClassResolver(PluginDetails checkedPluginDetails, List<? extends DependencyFinder.Result> dependencies) {
        List resolvers;
        List $this$closeOnException$iv = resolvers = (List)new ArrayList();
        boolean $i$f$closeOnException = false;
        try {
            void $this$mapNotNullTo$iv$iv$iv;
            PluginDetailsCache.Result.Provided it;
            Collection collection;
            Object item$iv$iv2;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            List it2 = $this$closeOnException$iv;
            boolean bl = false;
            Iterable iterable = dependencies;
            boolean $i$f$filterIsInstance = false;
            void var10_11 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof DependencyFinder.Result.DetailsProvided)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                DependencyFinder.Result.DetailsProvided detailsProvided = (DependencyFinder.Result.DetailsProvided)item$iv$iv2;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(((DependencyFinder.Result.DetailsProvided)((Object)it)).getPluginDetailsCacheResult());
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$filterIsInstance = false;
            $this$mapTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof PluginDetailsCache.Result.Provided)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                it = (PluginDetailsCache.Result.Provided)item$iv$iv2;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(it.getPluginDetails());
            }
            List pluginDetails = (List)destination$iv$iv;
            iterable = resolvers;
            DefaultClassResolverProvider $i$f$map2 = this;
            Iterable $this$mapNotNullInterruptible$iv = pluginDetails;
            boolean $i$f$mapNotNullInterruptible = false;
            Iterable $this$mapNotNull$iv$iv = $this$mapNotNullInterruptible$iv;
            boolean $i$f$mapNotNull = false;
            item$iv$iv2 = $this$mapNotNull$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv$iv = $this$mapNotNullTo$iv$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Resolver it$iv$iv$iv;
                Resolver resolver;
                Object element$iv$iv$iv$iv;
                Object element$iv$iv$iv = element$iv$iv$iv$iv = iterator2.next();
                boolean bl4 = false;
                Object it$iv = element$iv$iv$iv;
                boolean bl5 = false;
                try {
                    PluginDetails it3 = (PluginDetails)it$iv;
                    boolean bl6 = false;
                    resolver = this.createPluginResolver(it3);
                }
                catch (Exception e$iv) {
                    LanguageUtilsKt.rethrowIfInterrupted(e$iv);
                    resolver = null;
                }
                if (resolver == null) continue;
                boolean bl7 = false;
                destination$iv$iv$iv.add(it$iv$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv$iv;
            CollectionsKt.addAll(iterable, iterable2);
        }
        catch (Throwable e$iv) {
            Iterable $this$forEach$iv$iv = $this$closeOnException$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                Closeable t$iv = (Closeable)element$iv$iv;
                boolean bl = false;
                Closeable closeable = t$iv;
                if (closeable == null) continue;
                LanguageUtilsKt.closeLogged(closeable);
            }
            throw e$iv;
        }
        String pluginId = checkedPluginDetails.getPluginInfo().getPluginId();
        return CompositeResolver.Companion.create(resolvers, "Plugin Dependency Composite Resolver for '" + pluginId + "'");
    }

    /*
     * WARNING - void declaration
     */
    private final <T, R> List<R> mapNotNullInterruptible(Iterable<? extends T> $this$mapNotNullInterruptible, Function1<? super T, ? extends R> transform2) {
        void $this$mapNotNullTo$iv$iv;
        boolean $i$f$mapNotNullInterruptible = false;
        Iterable<? extends T> $this$mapNotNull$iv = $this$mapNotNullInterruptible;
        boolean $i$f$mapNotNull = false;
        Iterable<? extends T> iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            R it$iv$iv;
            R r;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Object it = element$iv$iv;
            boolean bl2 = false;
            try {
                r = transform2.invoke(it);
            }
            catch (Exception e) {
                LanguageUtilsKt.rethrowIfInterrupted(e);
                r = null;
            }
            if (r == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

