/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.repository.repositories.bundled;

import com.jetbrains.plugin.structure.ide.Ide;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import com.jetbrains.pluginverifier.repository.PluginInfo;
import com.jetbrains.pluginverifier.repository.PluginRepository;
import com.jetbrains.pluginverifier.repository.repositories.VersionComparatorKt;
import com.jetbrains.pluginverifier.repository.repositories.bundled.BundledPluginInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\bJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\bJ\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u0011H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\u0006\u0010\r\u001a\u00020\bH\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\bH\u0016J \u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00112\u0006\u0010\u000f\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u0019\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/pluginverifier/repository/repositories/bundled/BundledPluginsRepository;", "Lcom/jetbrains/pluginverifier/repository/PluginRepository;", "ide", "Lcom/jetbrains/plugin/structure/ide/Ide;", "(Lcom/jetbrains/plugin/structure/ide/Ide;)V", "getIde", "()Lcom/jetbrains/plugin/structure/ide/Ide;", "presentableName", "", "getPresentableName", "()Ljava/lang/String;", "findPluginById", "Lcom/jetbrains/pluginverifier/repository/repositories/bundled/BundledPluginInfo;", "pluginId", "findPluginByModule", "moduleId", "getAllPlugins", "", "getAllVersionsOfPlugin", "getLastCompatiblePlugins", "ideVersion", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "getLastCompatibleVersionOfPlugin", "getPluginsDeclaringModule", "Lcom/jetbrains/pluginverifier/repository/PluginInfo;", "toString", "verifier-repository"})
@SourceDebugExtension(value={"SMAP\nBundledPluginsRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BundledPluginsRepository.kt\ncom/jetbrains/pluginverifier/repository/repositories/bundled/BundledPluginsRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1557#2:52\n1628#2,3:53\n774#2:56\n865#2,2:57\n1485#2:59\n1510#2,3:60\n1513#2,3:70\n1246#2,4:75\n774#2:79\n865#2,2:80\n774#2:82\n865#2,2:83\n381#3,7:63\n462#3:73\n412#3:74\n1#4:85\n*S KotlinDebug\n*F\n+ 1 BundledPluginsRepository.kt\ncom/jetbrains/pluginverifier/repository/repositories/bundled/BundledPluginsRepository\n*L\n19#1:52\n19#1:53,3\n25#1:56\n25#1:57,2\n26#1:59\n26#1:60,3\n26#1:70,3\n27#1:75,4\n31#1:79\n31#1:80,2\n34#1:82\n34#1:83,2\n26#1:63,7\n27#1:73\n27#1:74\n*E\n"})
public final class BundledPluginsRepository
implements PluginRepository {
    @NotNull
    private final Ide ide;

    public BundledPluginsRepository(@NotNull Ide ide2) {
        Intrinsics.checkNotNullParameter(ide2, "ide");
        this.ide = ide2;
    }

    @NotNull
    public final Ide getIde() {
        return this.ide;
    }

    /*
     * WARNING - void declaration
     */
    private final List<BundledPluginInfo> getAllPlugins() {
        void $this$mapTo$iv$iv;
        List<IdePlugin> list = this.ide.getBundledPlugins();
        Intrinsics.checkNotNullExpressionValue(list, "ide.bundledPlugins");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IdePlugin idePlugin = (IdePlugin)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IdeVersion ideVersion = this.ide.getVersion();
            Intrinsics.checkNotNullExpressionValue(ideVersion, "ide.version");
            Intrinsics.checkNotNullExpressionValue(it, "it");
            collection.add(new BundledPluginInfo(ideVersion, (IdePlugin)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<BundledPluginInfo> getLastCompatiblePlugins(@NotNull IdeVersion ideVersion) {
        void $this$mapValuesTo$iv$iv;
        Object value$iv$iv$iv;
        Object key$iv$iv;
        Object $this$groupByTo$iv$iv;
        BundledPluginInfo it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(ideVersion, "ideVersion");
        Iterable $this$filter$iv = this.getAllPlugins();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (BundledPluginInfo)element$iv$iv;
            boolean bl = false;
            if (!it.isCompatibleWith(ideVersion)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object element$iv$iv;
            element$iv$iv = iterator2.next();
            it = (BundledPluginInfo)element$iv$iv;
            boolean bl = false;
            key$iv$iv = it.getPluginId();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it2;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Object object2 = object;
            boolean bl3 = false;
            PluginInfo pluginInfo = CollectionsKt.maxWithOrNull((Iterable)it2.getValue(), VersionComparatorKt.getVERSION_COMPARATOR());
            Intrinsics.checkNotNull(pluginInfo);
            BundledPluginInfo bundledPluginInfo = (BundledPluginInfo)pluginInfo;
            object2.put(k, bundledPluginInfo);
        }
        return CollectionsKt.toList(destination$iv$iv.values());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public BundledPluginInfo getLastCompatibleVersionOfPlugin(@NotNull IdeVersion ideVersion, @NotNull String pluginId) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(ideVersion, "ideVersion");
        Intrinsics.checkNotNullParameter(pluginId, "pluginId");
        Iterable $this$filter$iv = this.getAllVersionsOfPlugin(pluginId);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BundledPluginInfo it = (BundledPluginInfo)element$iv$iv;
            boolean bl = false;
            if (!it.isCompatibleWith(ideVersion)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (BundledPluginInfo)CollectionsKt.maxWithOrNull((List)destination$iv$iv, VersionComparatorKt.getVERSION_COMPARATOR());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<BundledPluginInfo> getAllVersionsOfPlugin(@NotNull String pluginId) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(pluginId, "pluginId");
        Iterable $this$filter$iv = this.getAllPlugins();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BundledPluginInfo it = (BundledPluginInfo)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getPluginId(), pluginId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public List<PluginInfo> getPluginsDeclaringModule(@NotNull String moduleId, @Nullable IdeVersion ideVersion) {
        BundledPluginInfo bundledPluginInfo;
        BundledPluginInfo pluginInfo;
        Intrinsics.checkNotNullParameter(moduleId, "moduleId");
        BundledPluginInfo bundledPluginInfo2 = pluginInfo = this.findPluginByModule(moduleId);
        if (bundledPluginInfo2 != null) {
            BundledPluginInfo bundledPluginInfo3;
            BundledPluginInfo it = bundledPluginInfo3 = bundledPluginInfo2;
            boolean bl = false;
            bundledPluginInfo = ideVersion == null || pluginInfo.isCompatibleWith(ideVersion) ? bundledPluginInfo3 : null;
        } else {
            bundledPluginInfo = null;
        }
        return CollectionsKt.listOfNotNull(bundledPluginInfo);
    }

    @Nullable
    public final BundledPluginInfo findPluginById(@NotNull String pluginId) {
        Intrinsics.checkNotNullParameter(pluginId, "pluginId");
        return CollectionsKt.firstOrNull(this.getAllVersionsOfPlugin(pluginId));
    }

    @Nullable
    public final BundledPluginInfo findPluginByModule(@NotNull String moduleId) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(moduleId, "moduleId");
            Iterable iterable = this.getAllPlugins();
            for (Object t2 : iterable) {
                BundledPluginInfo it = (BundledPluginInfo)t2;
                boolean bl = false;
                if (!it.getIdePlugin().getDefinedModules().contains(moduleId)) continue;
                v0 = t2;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return "Bundled plugins of " + this.ide.getVersion();
    }

    @NotNull
    public String toString() {
        return this.getPresentableName();
    }
}

