/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.misc;

import com.jetbrains.pluginverifier.misc.HtmlEscaperKt;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007J\u0018\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/pluginverifier/misc/HtmlEscaper;", "", "()V", "longest", "", "lookupMap", "", "", "prefixSet", "Ljava/util/BitSet;", "shortest", "escape", "", "input", "", "writer", "Ljava/io/Writer;", "index", "verifier-repository"})
public final class HtmlEscaper {
    @NotNull
    private final Map<CharSequence, CharSequence> lookupMap = new LinkedHashMap();
    @NotNull
    private final BitSet prefixSet = new BitSet();
    private final int shortest;
    private final int longest;

    public HtmlEscaper() {
        int currentShortest = Integer.MAX_VALUE;
        int currentLongest = 0;
        for (Map.Entry entry : HtmlEscaperKt.access$getEscapeLookup$p().entrySet()) {
            CharSequence key = (CharSequence)entry.getKey();
            CharSequence value = (CharSequence)entry.getValue();
            this.lookupMap.put(((Object)key).toString(), ((Object)value).toString());
            this.prefixSet.set(key.charAt(0));
            int sz = key.length();
            if (sz < currentShortest) {
                currentShortest = sz;
            }
            if (sz <= currentLongest) continue;
            currentLongest = sz;
        }
        this.shortest = currentShortest;
        this.longest = currentLongest;
    }

    @NotNull
    public final String escape(@NotNull CharSequence input) {
        Intrinsics.checkNotNullParameter(input, "input");
        StringWriter $this$escape_u24lambda_u240 = new StringWriter(input.length() * 2);
        boolean bl = false;
        this.escape(input, $this$escape_u24lambda_u240);
        String string2 = $this$escape_u24lambda_u240.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringWriter(input.lengt\u2026this.toString()\n        }");
        return string2;
    }

    private final int escape(CharSequence input, int index, Writer writer) throws IOException {
        int i;
        int n;
        if (!this.prefixSet.get(input.charAt(index))) {
            return 0;
        }
        int max = this.longest;
        if (index + this.longest > input.length()) {
            max = input.length() - index;
        }
        if ((n = this.shortest) <= (i = max)) {
            while (true) {
                CharSequence subSeq;
                CharSequence result2;
                if ((result2 = this.lookupMap.get(((Object)(subSeq = input.subSequence(index, index + i))).toString())) != null) {
                    writer.write(((Object)result2).toString());
                    return Character.codePointCount(subSeq, 0, subSeq.length());
                }
                if (i == n) break;
                --i;
            }
        }
        return 0;
    }

    private final void escape(CharSequence input, Writer writer) throws IOException {
        int pos = 0;
        int len = input.length();
        while (pos < len) {
            int consumed = this.escape(input, pos, writer);
            if (consumed == 0) {
                char c2;
                char c1 = input.charAt(pos);
                writer.write(c1);
                int n = pos;
                pos = n + 1;
                if (!Character.isHighSurrogate(c1) || pos >= len || !Character.isLowSurrogate(c2 = input.charAt(pos))) continue;
                writer.write(c2);
                int n2 = pos;
                pos = n2 + 1;
                continue;
            }
            int n = 0;
            while (n < consumed) {
                int it = n++;
                boolean bl = false;
                pos += Character.charCount(Character.codePointAt(input, pos));
            }
        }
    }
}

