/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.jdk;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.classes.resolvers.CompositeResolver;
import com.jetbrains.plugin.structure.classes.resolvers.JarFileResolverKt;
import com.jetbrains.plugin.structure.classes.resolvers.JdkFileOrigin;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.plugin.structure.ide.Ide;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import com.jetbrains.pluginverifier.jdk.JdkDescriptor;
import com.jetbrains.pluginverifier.jdk.JdkJImageResolver;
import com.jetbrains.pluginverifier.jdk.JdkVersion;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bJ \u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u0007\u001a\u00020\bJ\"\u0010\u000e\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J \u0010\u0011\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/pluginverifier/jdk/JdkDescriptorCreator;", "", "()V", "createBundledJdkDescriptor", "Lcom/jetbrains/pluginverifier/jdk/JdkDescriptor;", "ide", "Lcom/jetbrains/plugin/structure/ide/Ide;", "readMode", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "createJava9Plus", "jdkPath", "Ljava/nio/file/Path;", "jdkVersion", "Lcom/jetbrains/pluginverifier/jdk/JdkVersion;", "createJdkDescriptor", "bundledTo", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "createPreJava9", "guessJdkVersionFromFileName", "", "jdkHomeName", "readFullVersion", "verifier-intellij"})
@SourceDebugExtension(value={"SMAP\nJdkDescriptorCreator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkDescriptorCreator.kt\ncom/jetbrains/pluginverifier/jdk/JdkDescriptorCreator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n1#2:109\n1179#3,2:110\n1253#3,4:112\n766#3:116\n857#3,2:117\n1549#3:119\n1620#3,3:120\n*S KotlinDebug\n*F\n+ 1 JdkDescriptorCreator.kt\ncom/jetbrains/pluginverifier/jdk/JdkDescriptorCreator\n*L\n65#1:110,2\n65#1:112,4\n93#1:116\n93#1:117,2\n98#1:119\n98#1:120,3\n*E\n"})
public final class JdkDescriptorCreator {
    @NotNull
    public static final JdkDescriptorCreator INSTANCE = new JdkDescriptorCreator();

    private JdkDescriptorCreator() {
    }

    @Nullable
    public final JdkDescriptor createBundledJdkDescriptor(@NotNull Ide ide2, @NotNull Resolver.ReadMode readMode) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(ide2, "ide");
            Intrinsics.checkNotNullParameter((Object)readMode, "readMode");
            Path[] pathArray = new Path[]{ide2.getIdePath().resolve("jbr").resolve("Contents").resolve("Home"), ide2.getIdePath().resolve("jbr"), ide2.getIdePath().resolve("jre64")};
            Iterable iterable = CollectionsKt.listOf(pathArray);
            for (Object t2 : iterable) {
                Path it = (Path)t2;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(it, "it");
                if (!FileUtilKt.isDirectory(it)) continue;
                v0 = t2;
                break block2;
            }
            v0 = null;
        }
        Path path = v0;
        if (path == null) {
            return null;
        }
        Path bundledJdkPath = path;
        return this.createJdkDescriptor(bundledJdkPath, readMode, ide2.getVersion());
    }

    public static /* synthetic */ JdkDescriptor createBundledJdkDescriptor$default(JdkDescriptorCreator jdkDescriptorCreator, Ide ide2, Resolver.ReadMode readMode, int n, Object object) {
        if ((n & 2) != 0) {
            readMode = Resolver.ReadMode.FULL;
        }
        return jdkDescriptorCreator.createBundledJdkDescriptor(ide2, readMode);
    }

    @NotNull
    public final JdkDescriptor createJdkDescriptor(@NotNull Path jdkPath, @NotNull Resolver.ReadMode readMode) {
        Intrinsics.checkNotNullParameter(jdkPath, "jdkPath");
        Intrinsics.checkNotNullParameter((Object)readMode, "readMode");
        return this.createJdkDescriptor(jdkPath, readMode, null);
    }

    public static /* synthetic */ JdkDescriptor createJdkDescriptor$default(JdkDescriptorCreator jdkDescriptorCreator, Path path, Resolver.ReadMode readMode, int n, Object object) {
        if ((n & 2) != 0) {
            readMode = Resolver.ReadMode.FULL;
        }
        return jdkDescriptorCreator.createJdkDescriptor(path, readMode);
    }

    private final JdkDescriptor createJdkDescriptor(Path jdkPath, Resolver.ReadMode readMode, IdeVersion bundledTo) {
        String string2 = this.readFullVersion(jdkPath);
        if (string2 == null && (string2 = this.guessJdkVersionFromFileName(FileUtilKt.getSimpleName(jdkPath))) == null) {
            throw new IllegalArgumentException("JDK at " + jdkPath + " does not have any indication of the JDK build number. Please create a file <JDK home>/version.txt that contains a string of JDK version such as 1.8.0 or 11");
        }
        String fullJavaVersion = string2;
        JdkVersion jdkVersion = new JdkVersion(fullJavaVersion, bundledTo);
        return jdkVersion.getMajorVersion() < 9 ? this.createPreJava9(jdkPath, readMode, jdkVersion) : this.createJava9Plus(jdkPath, readMode, jdkVersion);
    }

    private final String guessJdkVersionFromFileName(String jdkHomeName) {
        if (StringsKt.startsWith$default(jdkHomeName, "java-", false, 2, null) && StringsKt.contains$default((CharSequence)jdkHomeName, "-openjdk-", false, 2, null)) {
            String string2;
            String it = string2 = StringsKt.substringBefore(StringsKt.substringAfter(jdkHomeName, "java-", ""), "-", "");
            boolean bl = false;
            return ((CharSequence)it).length() > 0 ? string2 : null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final String readFullVersion(Path jdkPath) {
        Path linuxOrWindowsRelease = jdkPath.resolve("release");
        Path macOsRelease = jdkPath.resolve("Contents").resolve("Home").resolve("release");
        Path[] pathArray = new Path[]{linuxOrWindowsRelease, macOsRelease};
        for (Path releasePath : CollectionsKt.listOf(pathArray)) {
            void $this$associateTo$iv$iv;
            Intrinsics.checkNotNullExpressionValue(releasePath, "releasePath");
            if (!FileUtilKt.exists(releasePath)) continue;
            Iterable $this$associate$iv = FileUtilKt.readLines$default(releasePath, null, 1, null);
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                String it = (String)element$iv$iv;
                boolean bl = false;
                Object[] objectArray = new String[]{"="};
                List list = StringsKt.split$default((CharSequence)it, objectArray, false, 0, 6, null);
                objectArray = new char[1];
                objectArray[0] = (String)34;
                Pair pair = TuplesKt.to(list.get(0), StringsKt.trim((String)list.get(1), (char[])objectArray));
                map2.put(pair.getFirst(), pair.getSecond());
            }
            Map properties2 = destination$iv$iv;
            String javaVersion = (String)properties2.get("JAVA_VERSION");
            if (javaVersion == null) {
                boolean bl = false;
                String string2 = "JAVA_VERSION is not specified in " + releasePath;
                throw new IllegalStateException(string2.toString());
            }
            return javaVersion;
        }
        Path versionPath = jdkPath.resolve("version.txt");
        Intrinsics.checkNotNullExpressionValue(versionPath, "versionPath");
        if (FileUtilKt.exists(versionPath)) {
            return FileUtilKt.readText$default(versionPath, null, 1, null);
        }
        return null;
    }

    private final JdkDescriptor createJava9Plus(Path jdkPath, Resolver.ReadMode readMode, JdkVersion jdkVersion) {
        JdkJImageResolver resolver = new JdkJImageResolver(jdkPath, readMode);
        return new JdkDescriptor(jdkPath, resolver, jdkVersion);
    }

    /*
     * WARNING - void declaration
     */
    private final JdkDescriptor createPreJava9(Path jdkPath, Resolver.ReadMode readMode, JdkVersion jdkVersion) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Set<String> mandatoryJars = SetsKt.setOf("rt.jar");
        String[] stringArray = new String[]{"tools.jar", "classes.jar", "jsse.jar", "javaws.jar", "jce.jar", "jfxrt.jar", "plugin.jar"};
        Set<String> optionalJars = SetsKt.setOf(stringArray);
        Iterable $this$filter$iv = FileUtilKt.listRecursivelyAllFilesWithExtension(jdkPath, "jar");
        boolean $i$f$filter22 = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String fileName;
            Path file2 = (Path)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(file2, "file");
            String string2 = FileUtilKt.getSimpleName(file2);
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault()");
            Intrinsics.checkNotNullExpressionValue(string2.toLowerCase(locale), "toLowerCase(...)");
            if (!(mandatoryJars.contains(fileName) || optionalJars.contains(fileName))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List jars = (List)destination$iv$iv;
        Iterable $i$f$filter22 = jars;
        Set<String> set = mandatoryJars;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path bl = (Path)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            String string3 = FileUtilKt.getSimpleName((Path)it);
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault()");
            String string4 = string3.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
            collection.add(string4);
        }
        Set<String> missingJars = SetsKt.minus(set, (List)destination$iv$iv2);
        if (!missingJars.isEmpty()) {
            boolean bl = false;
            String string5 = "JDK " + jdkPath + " misses mandatory jars: " + CollectionsKt.joinToString$default(missingJars, null, null, null, 0, null, null, 63, null);
            throw new IllegalArgumentException(string5.toString());
        }
        Resolver jarResolver = CompositeResolver.Companion.create((Iterable<? extends Resolver>)JarFileResolverKt.buildJarOrZipFileResolvers(jars, readMode, new JdkFileOrigin(jdkPath)));
        return new JdkDescriptor(jdkPath, jarResolver, jdkVersion);
    }
}

