/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.jar;

import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.jar.JarFileSystemProvider;
import com.jetbrains.plugin.structure.jar.JarsKt;
import com.jetbrains.plugin.structure.jar.SingletonCachingJarFileSystemProvider;
import com.jetbrains.plugin.structure.jar.UriJarFileSystemProvider;
import java.io.Closeable;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u001cB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0011H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/plugin/structure/jar/SingletonCachingJarFileSystemProvider;", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "Ljava/lang/AutoCloseable;", "()V", "LOG", "Lorg/slf4j/Logger;", "MAX_OPEN_JAR_FILE_SYSTEMS", "", "UNUSED_JAR_FILE_SYSTEMS_TO_CLOSE", "clock", "Ljava/time/Clock;", "kotlin.jvm.PlatformType", "delegateJarFileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/UriJarFileSystemProvider;", "fsCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/net/URI;", "Lcom/jetbrains/plugin/structure/jar/SingletonCachingJarFileSystemProvider$FSHandle;", "cleanup", "", "close", "jarPath", "Ljava/nio/file/Path;", "expire", "fsHandle", "getFileSystem", "Ljava/nio/file/FileSystem;", "getOrOpenFsHandler", "FSHandle", "structure-base"})
@SourceDebugExtension(value={"SMAP\nSingletonCachingJarFileSystemProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SingletonCachingJarFileSystemProvider.kt\ncom/jetbrains/plugin/structure/jar/SingletonCachingJarFileSystemProvider\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n73#2,2:107\n1#3:109\n1#3:114\n766#4:110\n857#4,2:111\n1045#4:113\n1855#4,2:115\n1855#4,2:117\n*E\n*S KotlinDebug\n*F\n+ 1 SingletonCachingJarFileSystemProvider.kt\ncom/jetbrains/plugin/structure/jar/SingletonCachingJarFileSystemProvider\n*L\n43#1,2:107\n43#1:109\n61#1:110\n61#1,2:111\n62#1:113\n66#1,2:115\n102#1,2:117\n*E\n"})
public final class SingletonCachingJarFileSystemProvider
implements JarFileSystemProvider,
AutoCloseable {
    private static final Logger LOG;
    private static final int MAX_OPEN_JAR_FILE_SYSTEMS = 256;
    private static final int UNUSED_JAR_FILE_SYSTEMS_TO_CLOSE = 64;
    private static final ConcurrentHashMap<URI, FSHandle> fsCache;
    private static final Clock clock;
    private static final UriJarFileSystemProvider delegateJarFileSystemProvider;
    @NotNull
    public static final SingletonCachingJarFileSystemProvider INSTANCE;

    @Override
    @NotNull
    public FileSystem getFileSystem(@NotNull Path jarPath) {
        Intrinsics.checkNotNullParameter(jarPath, "jarPath");
        return this.getOrOpenFsHandler(jarPath).getFs();
    }

    private final synchronized FSHandle getOrOpenFsHandler(Path jarPath) {
        FSHandle fsHandle;
        URI jarUri = JarsKt.toJarFileUri(jarPath);
        ConcurrentMap $this$getOrPut$iv = fsCache;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(jarUri);
        if (object == null) {
            FSHandle fSHandle;
            FileSystem fileSystem;
            boolean bl = false;
            FileSystem it = fileSystem = delegateJarFileSystemProvider.getFileSystem(jarPath);
            boolean bl2 = false;
            LOG.debug("Opening a filesystem handler via delegate for <{}> (Cache size: {})", (Object)jarUri, (Object)fsCache.size());
            FileSystem jarFs = fileSystem;
            Instant instant = clock.instant();
            Intrinsics.checkNotNullExpressionValue(instant, "clock.instant()");
            FSHandle default$iv = fSHandle = new FSHandle(jarFs, jarUri, instant, 0);
            boolean bl3 = false;
            object = $this$getOrPut$iv.putIfAbsent(jarUri, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        FSHandle fSHandle = fsHandle = (FSHandle)object;
        int n = fSHandle.getUsers();
        fSHandle.setUsers(n + 1);
        Instant instant = clock.instant();
        Intrinsics.checkNotNullExpressionValue(instant, "clock.instant()");
        fsHandle.setLastAccessTime(instant);
        this.cleanup();
        FSHandle fSHandle2 = fsHandle;
        Intrinsics.checkNotNullExpressionValue(fSHandle2, "fsHandle");
        return fSHandle2;
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized void cleanup() {
        void $this$filterTo$iv$iv;
        if (fsCache.size() <= 256) {
            return;
        }
        Collection<FSHandle> collection = fsCache.values();
        Intrinsics.checkNotNullExpressionValue(collection, "fsCache.values");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FSHandle it = (FSHandle)element$iv$iv;
            boolean bl = false;
            if (!(it.getUsers() == 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List it = $this$sortedBy$iv = CollectionsKt.take(CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                FSHandle it = (FSHandle)a;
                boolean bl = false;
                Comparable comparable = it.getLastAccessTime();
                it = (FSHandle)b;
                Comparable comparable2 = comparable;
                bl = false;
                Instant instant = it.getLastAccessTime();
                return ComparisonsKt.compareValues(comparable2, (Comparable)instant);
            }
        }), 64);
        boolean bl = false;
        LOG.debug("Will expire {} cached FS entries", (Object)it.size());
        List handlesToExpire = $this$sortedBy$iv;
        Iterable $this$forEach$iv = handlesToExpire;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FSHandle it2 = (FSHandle)element$iv;
            boolean bl2 = false;
            FSHandle fSHandle = it2;
            Intrinsics.checkNotNullExpressionValue(fSHandle, "it");
            INSTANCE.expire(fSHandle);
        }
    }

    private final void expire(FSHandle fsHandle) {
        fsHandle.close();
        fsCache.remove(fsHandle.getUri());
        LOG.debug("Expiring filesystem handler for <{}>", (Object)fsHandle.getUri());
    }

    @Override
    public synchronized void close(@NotNull Path jarPath) {
        FSHandle fsHandle;
        Intrinsics.checkNotNullParameter(jarPath, "jarPath");
        URI jarUri = JarsKt.toJarFileUri(jarPath);
        FSHandle fSHandle = fsCache.get(jarUri);
        if (fSHandle == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue(fSHandle, "fsCache[jarUri] ?: return");
        FSHandle $this$with = fsHandle = fSHandle;
        boolean bl = false;
        FSHandle fSHandle2 = $this$with;
        int n = fSHandle2.getUsers();
        fSHandle2.setUsers(n + -1);
        if ($this$with.getUsers() == 0) {
            INSTANCE.expire($this$with);
        }
    }

    @Override
    public synchronized void close() {
        Collection<FSHandle> collection = fsCache.values();
        Intrinsics.checkNotNullExpressionValue(collection, "fsCache.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FSHandle fsHandle = (FSHandle)element$iv;
            boolean bl = false;
            FSHandle fSHandle = fsHandle;
            Intrinsics.checkNotNullExpressionValue(fSHandle, "fsHandle");
            INSTANCE.expire(fSHandle);
        }
    }

    private SingletonCachingJarFileSystemProvider() {
    }

    static {
        SingletonCachingJarFileSystemProvider singletonCachingJarFileSystemProvider;
        INSTANCE = singletonCachingJarFileSystemProvider = new SingletonCachingJarFileSystemProvider();
        Logger logger = LoggerFactory.getLogger(singletonCachingJarFileSystemProvider.getClass());
        Intrinsics.checkNotNullExpressionValue(logger, "LoggerFactory.getLogger(javaClass)");
        LOG = logger;
        fsCache = new ConcurrentHashMap();
        clock = Clock.systemUTC();
        delegateJarFileSystemProvider = new UriJarFileSystemProvider(delegateJarFileSystemProvider.1.INSTANCE);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00c6\u0003J1\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u00d6\u0003J\t\u0010\"\u001a\u00020\tH\u00d6\u0001J\t\u0010#\u001a\u00020$H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006%"}, d2={"Lcom/jetbrains/plugin/structure/jar/SingletonCachingJarFileSystemProvider$FSHandle;", "Ljava/io/Closeable;", "fs", "Ljava/nio/file/FileSystem;", "uri", "Ljava/net/URI;", "lastAccessTime", "Ljava/time/Instant;", "users", "", "(Ljava/nio/file/FileSystem;Ljava/net/URI;Ljava/time/Instant;I)V", "getFs", "()Ljava/nio/file/FileSystem;", "getLastAccessTime", "()Ljava/time/Instant;", "setLastAccessTime", "(Ljava/time/Instant;)V", "getUri", "()Ljava/net/URI;", "getUsers", "()I", "setUsers", "(I)V", "close", "", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "toString", "", "structure-base"})
    private static final class FSHandle
    implements Closeable {
        @NotNull
        private final FileSystem fs;
        @NotNull
        private final URI uri;
        @NotNull
        private Instant lastAccessTime;
        private int users;

        @Override
        public void close() {
            LanguageUtilsKt.closeLogged((Closeable)this.fs);
        }

        @NotNull
        public final FileSystem getFs() {
            return this.fs;
        }

        @NotNull
        public final URI getUri() {
            return this.uri;
        }

        @NotNull
        public final Instant getLastAccessTime() {
            return this.lastAccessTime;
        }

        public final void setLastAccessTime(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter(instant, "<set-?>");
            this.lastAccessTime = instant;
        }

        public final int getUsers() {
            return this.users;
        }

        public final void setUsers(int n) {
            this.users = n;
        }

        public FSHandle(@NotNull FileSystem fs, @NotNull URI uri, @NotNull Instant lastAccessTime, int users) {
            Intrinsics.checkNotNullParameter(fs, "fs");
            Intrinsics.checkNotNullParameter(uri, "uri");
            Intrinsics.checkNotNullParameter(lastAccessTime, "lastAccessTime");
            this.fs = fs;
            this.uri = uri;
            this.lastAccessTime = lastAccessTime;
            this.users = users;
        }

        public /* synthetic */ FSHandle(FileSystem fileSystem, URI uRI, Instant instant, int n, int n2, DefaultConstructorMarker defaultConstructorMarker2) {
            if ((n2 & 8) != 0) {
                n = 0;
            }
            this(fileSystem, uRI, instant, n);
        }

        @NotNull
        public final FileSystem component1() {
            return this.fs;
        }

        @NotNull
        public final URI component2() {
            return this.uri;
        }

        @NotNull
        public final Instant component3() {
            return this.lastAccessTime;
        }

        public final int component4() {
            return this.users;
        }

        @NotNull
        public final FSHandle copy(@NotNull FileSystem fs, @NotNull URI uri, @NotNull Instant lastAccessTime, int users) {
            Intrinsics.checkNotNullParameter(fs, "fs");
            Intrinsics.checkNotNullParameter(uri, "uri");
            Intrinsics.checkNotNullParameter(lastAccessTime, "lastAccessTime");
            return new FSHandle(fs, uri, lastAccessTime, users);
        }

        public static /* synthetic */ FSHandle copy$default(FSHandle fSHandle, FileSystem fileSystem, URI uRI, Instant instant, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                fileSystem = fSHandle.fs;
            }
            if ((n2 & 2) != 0) {
                uRI = fSHandle.uri;
            }
            if ((n2 & 4) != 0) {
                instant = fSHandle.lastAccessTime;
            }
            if ((n2 & 8) != 0) {
                n = fSHandle.users;
            }
            return fSHandle.copy(fileSystem, uRI, instant, n);
        }

        @NotNull
        public String toString() {
            return "FSHandle(fs=" + this.fs + ", uri=" + this.uri + ", lastAccessTime=" + this.lastAccessTime + ", users=" + this.users + ")";
        }

        public int hashCode() {
            FileSystem fileSystem = this.fs;
            URI uRI = this.uri;
            Instant instant = this.lastAccessTime;
            return (((fileSystem != null ? fileSystem.hashCode() : 0) * 31 + (uRI != null ? ((Object)uRI).hashCode() : 0)) * 31 + (instant != null ? ((Object)instant).hashCode() : 0)) * 31 + Integer.hashCode(this.users);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof FSHandle)) break block3;
                    FSHandle fSHandle = (FSHandle)object;
                    if (!Intrinsics.areEqual(this.fs, fSHandle.fs) || !Intrinsics.areEqual(this.uri, fSHandle.uri) || !Intrinsics.areEqual(this.lastAccessTime, fSHandle.lastAccessTime) || this.users != fSHandle.users) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

