/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.jar;

import com.jetbrains.plugin.structure.base.plugin.IconTheme;
import com.jetbrains.plugin.structure.base.plugin.PluginIcon;
import com.jetbrains.plugin.structure.base.plugin.ThirdPartyDependency;
import com.jetbrains.plugin.structure.base.plugin.ThirdPartyDependencyKt;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.jar.DefaultJarFileSystemProvider;
import com.jetbrains.plugin.structure.jar.JarFileSystemProvider;
import com.jetbrains.plugin.structure.jar.PluginDescriptorResult;
import com.jetbrains.plugin.structure.jar.PluginJar;
import com.jetbrains.plugin.structure.jar.PluginJar$WhenMappings;
import com.jetbrains.plugin.structure.jar.PluginJarKt;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\"#B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0013J\u001f\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0017\"\u00020\u0010\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0019\u001a\u00020\u0010J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0013J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u001d\u001a\u00020\u0010J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\b\b\u0002\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0010H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetbrains/plugin/structure/jar/PluginJar;", "Ljava/lang/AutoCloseable;", "jarPath", "Ljava/nio/file/Path;", "jarFileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "(Ljava/nio/file/Path;Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;)V", "jarFileSystem", "Ljava/nio/file/FileSystem;", "close", "", "findPluginIcon", "Lcom/jetbrains/plugin/structure/base/plugin/PluginIcon;", "theme", "Lcom/jetbrains/plugin/structure/base/plugin/IconTheme;", "getIconFileName", "", "iconTheme", "getIcons", "", "getPluginDescriptor", "Lcom/jetbrains/plugin/structure/jar/PluginDescriptorResult;", "possibleDescriptorPaths", "", "([Ljava/lang/String;)Lcom/jetbrains/plugin/structure/jar/PluginDescriptorResult;", "descriptorPathValue", "getThirdPartyDependencies", "Lcom/jetbrains/plugin/structure/base/plugin/ThirdPartyDependency;", "resolveDescriptorPath", "descriptorPath", "resolveDescriptors", "descriptorFilter", "Lcom/jetbrains/plugin/structure/jar/PluginJar$PluginDescriptorFilter;", "toCanonicalPath", "AcceptAnyXmlFileAsDescriptor", "PluginDescriptorFilter", "structure-base"})
@SourceDebugExtension(value={"SMAP\nPluginJar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginJar.kt\ncom/jetbrains/plugin/structure/jar/PluginJar\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n766#2:122\n857#2,2:123\n1360#2:125\n1446#2,5:126\n179#3,2:131\n11653#4,9:133\n13579#4:142\n13580#4:144\n11662#4:145\n1#5:143\n*E\n*S KotlinDebug\n*F\n+ 1 PluginJar.kt\ncom/jetbrains/plugin/structure/jar/PluginJar\n*L\n47#1:122\n47#1,2:123\n49#1:125\n49#1,5:126\n70#1,2:131\n80#1,9:133\n80#1:142\n80#1:144\n80#1:145\n80#1:143\n*E\n"})
public final class PluginJar
implements AutoCloseable {
    private final FileSystem jarFileSystem;
    private final Path jarPath;
    private final JarFileSystemProvider jarFileSystemProvider;

    @Nullable
    public final Path resolveDescriptorPath(@NotNull String descriptorPath) {
        Intrinsics.checkNotNullParameter(descriptorPath, "descriptorPath");
        Path descriptor2 = this.jarFileSystem.getPath(this.toCanonicalPath(descriptorPath), new String[0]);
        return Files.exists(descriptor2, new LinkOption[0]) ? descriptor2 : null;
    }

    public static /* synthetic */ Path resolveDescriptorPath$default(PluginJar pluginJar, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = PluginJarKt.getPLUGIN_XML_RESOURCE_PATH();
        }
        return pluginJar.resolveDescriptorPath(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<Path> resolveDescriptors(@NotNull PluginDescriptorFilter descriptorFilter) {
        void $this$flatMapTo$iv$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(descriptorFilter, "descriptorFilter");
        Iterable $this$filter$iv = CollectionsKt.listOfNotNull(this.resolveDescriptorPath(PluginJarKt.getPLUGIN_XML_RESOURCE_PATH()));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable<Object> destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Path p1 = (Path)element$iv$iv;
            boolean bl = false;
            if (!descriptorFilter.accept(p1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List metaInfPluginXmlPaths = (List)destination$iv$iv;
        Iterable<Path> iterable2 = this.jarFileSystem.getRootDirectories();
        Intrinsics.checkNotNullExpressionValue(iterable2, "jarFileSystem.rootDirectories");
        Iterable<Path> $this$flatMap$iv = iterable2;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            Path root = (Path)element$iv$iv;
            boolean bl = false;
            Object object = new Function1<Path, Boolean>(descriptorFilter){

                public final boolean invoke(@NotNull Path p1) {
                    Intrinsics.checkNotNullParameter(p1, "p1");
                    return ((PluginDescriptorFilter)this.receiver).accept(p1);
                }
            };
            object = Files.list(root).filter(resolveDescriptors.xmlInRoots.1.1.INSTANCE).filter(new Predicate((Function1)object){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function1;
                }

                public final /* synthetic */ boolean test(Object p0) {
                    R r = this.function.invoke(p0);
                    Intrinsics.checkNotNullExpressionValue(r, "invoke(...)");
                    return (Boolean)r;
                }
            });
            Throwable throwable = null;
            try {
                Stream it = (Stream)object;
                boolean bl2 = false;
                Stream stream = it;
                Intrinsics.checkNotNullExpressionValue(stream, "it");
                list = StreamsKt.toList(stream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, throwable);
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
        }
        List xmlInRoots2 = (List)destination$iv$iv2;
        return CollectionsKt.plus((Collection)metaInfPluginXmlPaths, (Iterable)xmlInRoots2);
    }

    public static /* synthetic */ List resolveDescriptors$default(PluginJar pluginJar, PluginDescriptorFilter pluginDescriptorFilter, int n, Object object) {
        if ((n & 1) != 0) {
            pluginDescriptorFilter = AcceptAnyXmlFileAsDescriptor.INSTANCE;
        }
        return pluginJar.resolveDescriptors(pluginDescriptorFilter);
    }

    @NotNull
    public final PluginDescriptorResult getPluginDescriptor(@NotNull String descriptorPathValue) {
        Intrinsics.checkNotNullParameter(descriptorPathValue, "descriptorPathValue");
        Path path = this.resolveDescriptorPath(descriptorPathValue);
        if (path == null) {
            return PluginDescriptorResult.NotFound.INSTANCE;
        }
        Path descriptorPath = path;
        InputStream inputStream2 = FileUtilKt.inputStream(descriptorPath);
        int n = 8192;
        return new PluginDescriptorResult.Found(descriptorPath, inputStream2 instanceof BufferedInputStream ? (BufferedInputStream)inputStream2 : new BufferedInputStream(inputStream2, n));
    }

    public static /* synthetic */ PluginDescriptorResult getPluginDescriptor$default(PluginJar pluginJar, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = PluginJarKt.getPLUGIN_XML_RESOURCE_PATH();
        }
        return pluginJar.getPluginDescriptor(string2);
    }

    @NotNull
    public final PluginDescriptorResult getPluginDescriptor(String ... possibleDescriptorPaths) {
        PluginDescriptorResult pluginDescriptorResult;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(possibleDescriptorPaths, "possibleDescriptorPaths");
            Sequence $this$firstOrNull$iv = SequencesKt.map(ArraysKt.asSequence(possibleDescriptorPaths), (Function1)new Function1<String, PluginDescriptorResult>(this){
                final /* synthetic */ PluginJar this$0;

                @NotNull
                public final PluginDescriptorResult invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return this.this$0.getPluginDescriptor(it);
                }
                {
                    this.this$0 = pluginJar;
                    super(1);
                }
            });
            boolean $i$f$firstOrNull = false;
            Iterator iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                PluginDescriptorResult it = (PluginDescriptorResult)element$iv;
                boolean bl = false;
                if (!(it instanceof PluginDescriptorResult.Found)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((pluginDescriptorResult = (PluginDescriptorResult)v0) == null) {
            pluginDescriptorResult = PluginDescriptorResult.NotFound.INSTANCE;
        }
        return pluginDescriptorResult;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PluginIcon> getIcons() {
        void $this$mapNotNullTo$iv$iv;
        PluginIcon defaultIcon = this.findPluginIcon(IconTheme.DEFAULT);
        if (defaultIcon == null) {
            PluginJarKt.access$getLOG$p().debug("Default plugin icon not found (plugin archive {})", (Object)this.jarPath);
            return CollectionsKt.emptyList();
        }
        IconTheme[] $this$mapNotNull$iv = IconTheme.values();
        boolean $i$f$mapNotNull = false;
        IconTheme[] iconThemeArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            PluginIcon pluginIcon;
            PluginIcon pluginIcon2;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            switch (PluginJar$WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
                case 1: {
                    pluginIcon2 = defaultIcon;
                    break;
                }
                case 2: {
                    pluginIcon2 = this.findPluginIcon((IconTheme)it);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            if (pluginIcon2 == null) continue;
            PluginIcon it$iv$iv = pluginIcon = pluginIcon2;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final PluginIcon findPluginIcon(IconTheme theme) {
        Path iconPath;
        String iconEntryName = "META-INF/" + this.getIconFileName(theme);
        Path path = iconPath = this.jarFileSystem.getPath("META-INF", this.getIconFileName(theme));
        Intrinsics.checkNotNullExpressionValue(path, "iconPath");
        return FileUtilKt.exists(path) ? new PluginIcon(theme, FileUtilKt.readBytes(iconPath), iconEntryName) : null;
    }

    @NotNull
    public final List<ThirdPartyDependency> getThirdPartyDependencies() {
        Path path;
        Path path2 = path = this.jarFileSystem.getPath("META-INF", PluginJarKt.access$getTHIRD_PARTY_LIBRARIES_FILE_NAME$p());
        Intrinsics.checkNotNullExpressionValue(path2, "path");
        return ThirdPartyDependencyKt.parseThirdPartyDependenciesByPath(path2);
    }

    private final String toCanonicalPath(String descriptorPath) {
        return ((Object)Paths.get(FileUtilKt.toSystemIndependentName(descriptorPath), new String[0]).normalize()).toString();
    }

    private final String getIconFileName(IconTheme iconTheme) {
        return "pluginIcon" + iconTheme.getSuffix() + ".svg";
    }

    @Override
    public void close() {
        this.jarFileSystemProvider.close(this.jarPath);
    }

    public PluginJar(@NotNull Path jarPath, @NotNull JarFileSystemProvider jarFileSystemProvider) {
        FileSystem fileSystem;
        Intrinsics.checkNotNullParameter(jarPath, "jarPath");
        Intrinsics.checkNotNullParameter(jarFileSystemProvider, "jarFileSystemProvider");
        this.jarPath = jarPath;
        this.jarFileSystemProvider = jarFileSystemProvider;
        FileSystem fileSystem2 = fileSystem = this.jarFileSystemProvider.getFileSystem(this.jarPath);
        PluginJar pluginJar = this;
        boolean bl = false;
        PluginJarKt.access$getLOG$p().debug("Provider '{}' created file system for [{}]", (Object)this.jarFileSystemProvider.getClass().getName(), (Object)this.jarPath);
        Unit unit = Unit.INSTANCE;
        pluginJar.jarFileSystem = fileSystem;
    }

    public /* synthetic */ PluginJar(Path path, JarFileSystemProvider jarFileSystemProvider, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 2) != 0) {
            jarFileSystemProvider = new DefaultJarFileSystemProvider();
        }
        this(path, jarFileSystemProvider);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/plugin/structure/jar/PluginJar$PluginDescriptorFilter;", "", "accept", "", "descriptorPath", "Ljava/nio/file/Path;", "structure-base"})
    public static interface PluginDescriptorFilter {
        public boolean accept(@NotNull Path var1);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/plugin/structure/jar/PluginJar$AcceptAnyXmlFileAsDescriptor;", "Lcom/jetbrains/plugin/structure/jar/PluginJar$PluginDescriptorFilter;", "()V", "accept", "", "descriptorPath", "Ljava/nio/file/Path;", "structure-base"})
    public static final class AcceptAnyXmlFileAsDescriptor
    implements PluginDescriptorFilter {
        @NotNull
        public static final AcceptAnyXmlFileAsDescriptor INSTANCE;

        @Override
        public boolean accept(@NotNull Path descriptorPath) {
            Intrinsics.checkNotNullParameter(descriptorPath, "descriptorPath");
            return true;
        }

        private AcceptAnyXmlFileAsDescriptor() {
        }

        static {
            AcceptAnyXmlFileAsDescriptor acceptAnyXmlFileAsDescriptor;
            INSTANCE = acceptAnyXmlFileAsDescriptor = new AcceptAnyXmlFileAsDescriptor();
        }
    }
}

