/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.jar;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import java.net.URI;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"FILE_SCHEMA", "", "JAR_FILE_SCHEMA", "JAR_SCHEME", "toJarFileUri", "Ljava/net/URI;", "Ljava/nio/file/Path;", "structure-base"})
public final class JarsKt {
    @NotNull
    public static final String JAR_FILE_SCHEMA = "jar:file";
    @NotNull
    public static final String FILE_SCHEMA = "file";
    @NotNull
    public static final String JAR_SCHEME = "jar";

    @NotNull
    public static final URI toJarFileUri(@NotNull Path $this$toJarFileUri) {
        URI uRI;
        Intrinsics.checkNotNullParameter($this$toJarFileUri, "$this$toJarFileUri");
        URI uRI2 = $this$toJarFileUri.toUri();
        Intrinsics.checkNotNullExpressionValue(uRI2, "toUri()");
        if (Intrinsics.areEqual(uRI2.getScheme(), FILE_SCHEMA)) {
            Path absoluteJarPath;
            Path path = absoluteJarPath = $this$toJarFileUri.isAbsolute() ? $this$toJarFileUri : $this$toJarFileUri.toAbsolutePath();
            Intrinsics.checkNotNullExpressionValue(path, "absoluteJarPath");
            uRI = FileUtilKt.exists(path) ? new URI("jar:file:" + absoluteJarPath.toRealPath(new LinkOption[0]).toUri()) : new URI("jar:file:" + absoluteJarPath.normalize().toUri());
        } else {
            URI uRI3 = $this$toJarFileUri.toUri();
            uRI = uRI3;
            Intrinsics.checkNotNullExpressionValue(uRI3, "toUri()");
        }
        return uRI;
    }
}

